/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbbvScheduleByCourseReport
extends PdfLegacyExamReport {
    public AbbvScheduleByCourseReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, "SCHEDULE BY COURSE", session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        TreeSet<ExamInfo.ExamSectionInfo> sections = new TreeSet<ExamInfo.ExamSectionInfo>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (!this.hasSubjectArea(section)) continue;
                sections.add(section);
            }
        }
        Vector<String> lines = new Vector<String>();
        String separator = null;
        int split = 9;
        int n = this.iNrLines - 2 - (this.iNrLines - 2) / (split + 1);
        if (!this.iDispRooms) {
            ExamInfo.ExamSectionInfo last = null;
            int lx = 0;
            for (ExamInfo.ExamSectionInfo section : sections) {
                boolean sameSubj = false;
                boolean sameCrs = false;
                boolean sameSct = false;
                boolean sameItype = false;
                if (lx % n != 0 && lx % n % split != 0 && last != null && last.getSubject().equals(section.getSubject())) {
                    sameSubj = true;
                    if (last.getCourseNbr().equals(section.getCourseNbr())) {
                        sameCrs = true;
                        if (last.getSection().equals(section.getSection())) {
                            sameSct = true;
                        }
                        if (last.getItype().equals(section.getItype())) {
                            sameItype = true;
                        }
                    }
                }
                last = section;
                ++lx;
                if (this.iItype) {
                    lines.add(this.rpad(sameSubj ? "" : section.getSubject(), 7) + " " + this.rpad(sameCrs ? "" : section.getCourseNbr(), 8) + " " + this.rpad(sameItype ? "" : (section.getItype().length() == 0 ? "ALL" : section.getItype()), 5) + " " + this.lpad(sameSct ? "" : section.getSection(), 9) + "  " + this.formatPeriod(section.getExamAssignment()));
                    continue;
                }
                lines.add(this.rpad(sameSubj ? "" : section.getSubject(), 7) + " " + this.rpad(sameCrs ? "" : section.getCourseNbr(), 8) + " " + this.lpad(sameSct ? "" : (section.getSection().length() == 0 ? "ALL" : section.getSection()), 9) + "  " + this.formatShortPeriodNoEndTime(section.getExamAssignment()));
            }
            if (this.iItype) {
                if (this.iExternal) {
                    this.setHeader(new String[]{"Subject Course   ExtID Section    Date      Time            | Subject Course   ExtID Section    Date      Time           ", "------- -------- ----- ---------  --------- --------------- | ------- -------- ----- ---------  --------- ---------------"});
                    separator = "------- -------- ----- ---------  --------- --------------- | ------- -------- ----- ---------  --------- ---------------";
                } else {
                    this.setHeader(new String[]{"Subject Course   Type  Section    Date      Time            | Subject Course   Type  Section    Date      Time           ", "------- -------- ----- ---------  --------- --------------- | ------- -------- ----- ---------  --------- ---------------"});
                    separator = "------- -------- ----- ---------  --------- --------------- | ------- -------- ----- ---------  --------- ---------------";
                }
            } else {
                this.setHeader(new String[]{"Subject Course   Section    Date    Time   | Subject Course   Section    Date    Time   | Subject Course   Section    Date    Time  ", "------- -------- ---------  ------- ------ | ------- -------- ---------  ------- ------ | ------- -------- ---------  ------- ------"});
                separator = "------- -------- ---------  ------- ------ | ------- -------- ---------  ------- ------ | ------- -------- ---------  ------- ------";
            }
            this.printHeader();
            if (this.iItype) {
                for (int idx = 0; idx < lines.size(); idx += 2 * n) {
                    for (int i = 0; i < n; ++i) {
                        String a = i + idx + 0 * n < lines.size() ? (String)lines.elementAt(i + idx + 0 * n) : "";
                        String b = i + idx + 1 * n < lines.size() ? (String)lines.elementAt(i + idx + 1 * n) : "";
                        this.println(this.rpad(a, 60) + "| " + b);
                        if (i % split != split - 1) continue;
                        this.println(separator);
                    }
                }
            } else {
                for (int idx = 0; idx < lines.size(); idx += 3 * n) {
                    for (int i = 0; i < n; ++i) {
                        String a = i + idx + 0 * n < lines.size() ? (String)lines.elementAt(i + idx + 0 * n) : "";
                        String b = i + idx + 1 * n < lines.size() ? (String)lines.elementAt(i + idx + 1 * n) : "";
                        String c = i + idx + 2 * n < lines.size() ? (String)lines.elementAt(i + idx + 2 * n) : "";
                        this.println(this.rpad(a, 43) + "| " + this.rpad(b, 43) + "| " + c);
                        if (i % split != split - 1) continue;
                        this.println(separator);
                    }
                }
            }
        } else {
            ExamInfo.ExamSectionInfo last = null;
            int lx = 0;
            for (ExamInfo.ExamSectionInfo section : sections) {
                boolean sameSubj = false;
                boolean sameCrs = false;
                boolean sameSct = false;
                boolean sameItype = false;
                if (lx % n != 0 && lx % n % split != 0 && last != null && last.getSubject().equals(section.getSubject())) {
                    sameSubj = true;
                    if (last.getCourseNbr().equals(section.getCourseNbr())) {
                        sameCrs = true;
                        if (last.getSection().equals(section.getSection())) {
                            sameSct = true;
                        }
                        if (last.getItype().equals(section.getItype())) {
                            sameItype = true;
                        }
                    }
                }
                last = section;
                ++lx;
                if (section.getExamAssignment().getRooms() == null || section.getExamAssignment().getRooms().isEmpty()) {
                    if (this.iItype) {
                        lines.add(this.rpad(sameSubj ? "" : section.getSubject(), 7) + " " + this.rpad(sameCrs ? "" : section.getCourseNbr(), 8) + " " + this.rpad(sameItype ? "" : (section.getItype().length() == 0 ? "ALL" : section.getItype()), 5) + " " + this.lpad(sameSct ? "" : section.getSection(), 9) + " " + this.formatShortPeriod(section.getExamAssignment()) + " " + this.rpad(this.iNoRoom, 23));
                        continue;
                    }
                    lines.add(this.rpad(sameSubj ? "" : section.getSubject(), 7) + " " + this.rpad(sameCrs ? "" : section.getCourseNbr(), 8) + " " + this.rpad(sameSct ? "" : (section.getSection().length() == 0 ? "ALL" : section.getSection()), 9) + "  " + this.formatPeriod(section.getExamAssignment()) + " " + this.rpad(this.iNoRoom, 23));
                    continue;
                }
                Vector<ExamRoomInfo> rooms = new Vector<ExamRoomInfo>(section.getExamAssignment().getRooms());
                for (int i = 0; i < rooms.size(); ++i) {
                    ExamRoomInfo a = rooms.elementAt(i);
                    if (i == 0) {
                        if (this.iItype) {
                            lines.add(this.rpad(sameSubj ? "" : section.getSubject(), 7) + " " + this.rpad(sameCrs ? "" : section.getCourseNbr(), 8) + " " + this.rpad(sameItype ? "" : (section.getItype().length() == 0 ? "ALL" : section.getItype()), 5) + " " + this.lpad(sameSct ? "" : section.getSection(), 9) + " " + this.formatShortPeriod(section.getExamAssignment()) + " " + this.formatRoom(a));
                            continue;
                        }
                        lines.add(this.rpad(sameSubj ? "" : section.getSubject(), 7) + " " + this.rpad(sameCrs ? "" : section.getCourseNbr(), 8) + " " + this.rpad(sameSct ? "" : (section.getSection().length() == 0 ? "ALL" : section.getSection()), 9) + " " + this.formatPeriod(section.getExamAssignment()) + " " + this.formatRoom(a));
                        continue;
                    }
                    lines.add(this.rpad("", this.iItype ? 55 : 53) + this.formatRoom(a));
                    ++lx;
                }
            }
            if (this.iItype) {
                if (this.iExternal) {
                    this.setHeader(new String[]{"Subject Course   ExtID Section   Date    Time          Bldg  Room |Subject Course   ExtID Section   Date    Time          Bldg  Room", "------- -------- ----- --------- ------- ------------- ----- -----|------- -------- ----- --------- ------- ------------- ----- -----"});
                    separator = "------- -------- ----- --------- ------- ------------- ----- -----|------- -------- ----- --------- ------- ------------- ----- -----";
                } else {
                    this.setHeader(new String[]{"Subject Course   Type  Section   Date    Time          Bldg  Room |Subject Course   Type  Section   Date    Time          Bldg  Room", "------- -------- ----- --------- ------- ------------- ----- -----|------- -------- ----- --------- ------- ------------- ----- -----"});
                    separator = "------- -------- ----- --------- ------- ------------- ----- -----|------- -------- ----- --------- ------- ------------- ----- -----";
                }
            } else {
                this.setHeader(new String[]{"Subject Course   Section   Date      Time            Bldg  Room  | Subject Course   Section   Date      Time            Bldg  Room ", "------- -------- --------- --------- --------------- ----- ----- | ------- -------- --------- --------- --------------- ----- -----"});
                separator = "------- -------- --------- --------- --------------- ----- ----- | ------- -------- --------- --------- --------------- ----- -----";
            }
            this.printHeader();
            for (int idx = 0; idx < lines.size(); idx += 2 * n) {
                for (int i = 0; i < n; ++i) {
                    String b;
                    String a = i + idx + 0 * n < lines.size() ? (String)lines.elementAt(i + idx + 0 * n) : "";
                    String string = b = i + idx + 1 * n < lines.size() ? (String)lines.elementAt(i + idx + 1 * n) : "";
                    if (this.iItype) {
                        this.println(this.rpad(a, 66) + "|" + this.rpad(b, 66));
                    } else {
                        this.println(this.rpad(a, 65) + "| " + this.rpad(b, 64));
                    }
                    if (i % split != split - 1) continue;
                    this.println(separator);
                }
            }
        }
    }
}

