/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.test;

import com.google.protobuf.CodedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningTestFwk;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.basic.GetRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.solver.ComputeSuggestionsAction;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.updates.EnrollStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayLogTest
extends OnlineSectioningTestFwk {
    private File iLogFile = null;
    private Map<String, Long> iStudentIds = null;
    private Map<String, Long> iCourseIds = null;
    private Map<String, Long> iClassIds = null;
    private String[] sOkErrors = new String[]{"Unable to enroll into .*, the class is no longer available\\.", "No courses requested\\."};

    private ReplayLogTest(File logFile) {
        this.iLogFile = logFile;
    }

    private OnlineSectioningLog.ExportedLog readLog(CodedInputStream cin) throws IOException {
        if (cin.isAtEnd()) {
            return null;
        }
        int size = cin.readInt32();
        int limit = cin.pushLimit(size);
        OnlineSectioningLog.ExportedLog ret = OnlineSectioningLog.ExportedLog.parseFrom(cin);
        cin.popLimit(limit);
        cin.resetSizeCounter();
        return ret;
    }

    private Long toStudentId(OnlineSectioningLog.Entity student) {
        if (this.iStudentIds == null) {
            return student.getUniqueId();
        }
        Long id = this.iStudentIds.get(student.getExternalId());
        return id == null ? student.getUniqueId() : id.longValue();
    }

    private Long toCourseId(OnlineSectioningLog.Entity course) {
        if (this.iCourseIds == null) {
            return course.getUniqueId();
        }
        return this.iCourseIds.get(course.getName());
    }

    private Long toClassId(OnlineSectioningLog.Section section) {
        if (this.iClassIds == null) {
            return section.getClazz().getUniqueId();
        }
        return this.iClassIds.get(section.getCourse().getName() + " " + section.getSubpart().getName() + " " + section.getClazz().getName());
    }

    private CourseRequestInterface.Request toRequest(OnlineSectioningLog.Request request) {
        CourseRequestInterface.Request ret = new CourseRequestInterface.Request();
        for (OnlineSectioningLog.Time time : request.getFreeTimeList()) {
            CourseRequestInterface.FreeTime freeTime = new CourseRequestInterface.FreeTime();
            freeTime.setStart(time.getStart());
            freeTime.setLength(time.getLength());
            for (DayCode c : DayCode.toDayCodes(time.getDays())) {
                freeTime.addDay(c.ordinal());
            }
            CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
            ret.addRequestedCourse(rc);
            rc.addFreeTime(freeTime);
        }
        for (int i = 0; i < request.getCourseCount(); ++i) {
            CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
            if (request.getCourse(i).hasUniqueId()) {
                rc.setCourseId(request.getCourse(i).getUniqueId());
            }
            rc.setCourseName(request.getCourse(i).getName());
            ret.addRequestedCourse(rc);
        }
        if (request.hasWaitList()) {
            ret.setWaitList(request.getWaitList());
        }
        return ret;
    }

    private ClassAssignmentInterface.ClassAssignment toAssignment(OnlineSectioningLog.Section section) {
        Long classId = this.toClassId(section);
        if (classId == null) {
            return null;
        }
        ClassAssignmentInterface.ClassAssignment a = new ClassAssignmentInterface.ClassAssignment();
        a.setClassId(classId);
        a.setClassNumber(section.getClazz().getExternalId());
        a.setSection(section.getClazz().getName());
        if (section.hasTime()) {
            a.setStart(section.getTime().getStart());
            a.setLength(section.getTime().getStart());
            a.setDatePattern(section.getTime().getPattern());
            for (DayCode c : DayCode.toDayCodes(section.getTime().getDays())) {
                a.addDay(c.ordinal());
            }
        }
        for (OnlineSectioningLog.Entity instructor : section.getInstructorList()) {
            a.addInstructor(instructor.getName());
            a.addInstructoEmail(instructor.hasExternalId() ? instructor.getExternalId() : null);
        }
        for (OnlineSectioningLog.Entity location : section.getLocationList()) {
            a.addRoom(location.getUniqueId(), location.getName());
        }
        a.setPinned(section.getPreference() == OnlineSectioningLog.Section.Preference.REQUIRED);
        a.setCourseId(this.toCourseId(section.getCourse()));
        String course = section.getCourse().getName();
        int idx = course.indexOf(32);
        a.setSubject(course.substring(0, idx));
        a.setCourseNbr(course.substring(idx + 1));
        a.setSubpart(section.getSubpart().getName());
        return a;
    }

    private FindAssignmentAction convertFindAssignment(OnlineSectioningLog.Action action) {
        CourseRequestInterface request = new CourseRequestInterface();
        ArrayList<ClassAssignmentInterface.ClassAssignment> assignment = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
        request.setAcademicSessionId(action.getSession().getUniqueId());
        request.setStudentId(this.toStudentId(action.getStudent()));
        for (OnlineSectioningLog.Request r : action.getRequestList()) {
            if (r.getAlternative()) {
                request.getAlternatives().add(this.toRequest(r));
            } else {
                request.getCourses().add(this.toRequest(r));
            }
            for (OnlineSectioningLog.Section section : r.getSectionList()) {
                ClassAssignmentInterface.ClassAssignment a = this.toAssignment(section);
                if (a == null) continue;
                assignment.add(a);
            }
        }
        if (request.getCourses().isEmpty()) {
            return null;
        }
        sLog.debug((Object)("Find assignment for " + request.getCourses() + " (" + assignment + ")"));
        return this.createAction(FindAssignmentAction.class).forRequest(request).withAssignment(assignment);
    }

    private ComputeSuggestionsAction convertSuggestions(OnlineSectioningLog.Action action) {
        CourseRequestInterface request = new CourseRequestInterface();
        ArrayList<ClassAssignmentInterface.ClassAssignment> assignment = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
        ClassAssignmentInterface.ClassAssignment selected = null;
        request.setAcademicSessionId(action.getSession().getUniqueId());
        request.setStudentId(this.toStudentId(action.getStudent()));
        for (OnlineSectioningLog.Request r : action.getRequestList()) {
            if (r.getAlternative()) {
                request.getAlternatives().add(this.toRequest(r));
            } else {
                request.getCourses().add(this.toRequest(r));
            }
            for (OnlineSectioningLog.Section section : r.getSectionList()) {
                ClassAssignmentInterface.ClassAssignment a = this.toAssignment(section);
                if (a == null) continue;
                if (section.getPreference() == OnlineSectioningLog.Section.Preference.SELECTED) {
                    selected = a;
                }
                assignment.add(a);
            }
        }
        if (request.getCourses().isEmpty() || selected == null) {
            return null;
        }
        sLog.debug((Object)("Find suggestions for " + request.getCourses() + " (" + selected + ")"));
        return ((ComputeSuggestionsAction)this.createAction(ComputeSuggestionsAction.class).forRequest(request).withAssignment(assignment)).withSelection(selected);
    }

    public EnrollStudent convertEnrollFromReload(OnlineSectioningLog.Action action) {
        CourseRequestInterface request = new CourseRequestInterface();
        ArrayList<ClassAssignmentInterface.ClassAssignment> assignment = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
        request.setAcademicSessionId(action.getSession().getUniqueId());
        request.setStudentId(this.toStudentId(action.getStudent()));
        for (OnlineSectioningLog.Request r : action.getRequestList()) {
            if (r.getAlternative()) {
                request.getAlternatives().add(this.toRequest(r));
                continue;
            }
            request.getCourses().add(this.toRequest(r));
        }
        for (OnlineSectioningLog.Enrollment enrollment : action.getEnrollmentList()) {
            if (enrollment.getType() != OnlineSectioningLog.Enrollment.EnrollmentType.STORED) continue;
            for (OnlineSectioningLog.Section section : enrollment.getSectionList()) {
                ClassAssignmentInterface.ClassAssignment a = this.toAssignment(section);
                if (a == null) continue;
                assignment.add(a);
            }
        }
        sLog.debug((Object)("Enroll for " + request.getCourses() + " (" + assignment + ")"));
        return this.createAction(EnrollStudent.class).forStudent(request.getStudentId()).withRequest(request).withAssignment(assignment);
    }

    private OnlineSectioningAction<?> convert(OnlineSectioningLog.Action action) {
        if (action.getOperation().equals("section")) {
            return this.convertFindAssignment(action);
        }
        if (action.getOperation().equals("suggestions")) {
            return this.convertSuggestions(action);
        }
        if (action.getOperation().equals("reload-student")) {
            return this.convertEnrollFromReload(action);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OnlineSectioningTestFwk.Operation> operations() {
        if ("true".equals(System.getProperty("convertIds", "true"))) {
            Session hibSession = new _RootDAO().getSession();
            try {
                this.iStudentIds = new HashMap<String, Long>();
                for (Object[] o : hibSession.createQuery("select s.uniqueId, s.externalUniqueId from Student s where s.session.uniqueId = :sessionId").setLong("sessionId", this.getServer().getAcademicSession().getUniqueId().longValue()).list()) {
                    this.iStudentIds.put((String)o[1], (Long)o[0]);
                }
                this.iCourseIds = new HashMap<String, Long>();
                for (Object[] o : hibSession.createQuery("select co.uniqueId, co.subjectAreaAbbv || ' ' || co.courseNbr from CourseOffering co where co.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", this.getServer().getAcademicSession().getUniqueId().longValue()).list()) {
                    this.iCourseIds.put((String)o[1], (Long)o[0]);
                }
                this.iClassIds = new HashMap<String, Long>();
                for (Class_ c : hibSession.createQuery("select c  from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering io inner join io.courseOfferings co where io.session.uniqueId = :sessionId").setLong("sessionId", this.getServer().getAcademicSession().getUniqueId().longValue()).list()) {
                    this.iClassIds.put(c.getClassLabel(hibSession), c.getUniqueId());
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            {
            }
        }
        int nrTasks = Integer.valueOf(System.getProperty("nrTasks", "-1"));
        ArrayList<OnlineSectioningTestFwk.Operation> operations = new ArrayList<OnlineSectioningTestFwk.Operation>();
        try {
            FileInputStream in = new FileInputStream(this.iLogFile);
            try {
                CodedInputStream cin = CodedInputStream.newInstance((InputStream)in);
                cin.setSizeLimit(0x40000000);
                OnlineSectioningLog.ExportedLog log = null;
                while ((log = this.readLog(cin)) != null) {
                    ArrayList actions = new ArrayList();
                    Long studentId = null;
                    boolean hasSectionOrSuggestion = false;
                    for (OnlineSectioningLog.Action action : log.getActionList()) {
                        OnlineSectioningAction<?> a;
                        if (studentId == null && action.hasStudent() && action.getStudent().hasExternalId()) {
                            studentId = this.toStudentId(action.getStudent());
                        }
                        if ((a = this.convert(action)) == null) continue;
                        if (a instanceof FindAssignmentAction || a instanceof ComputeSuggestionsAction) {
                            hasSectionOrSuggestion = true;
                        }
                        actions.add(a);
                    }
                    if (studentId != null && !actions.isEmpty() && hasSectionOrSuggestion) {
                        operations.add(new ReplayOperation(studentId, actions));
                    }
                    if (nrTasks <= 0 || operations.size() < 3 * nrTasks) continue;
                    break;
                }
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
        catch (IOException e) {
            sLog.fatal((Object)("Failed to load log: " + e.getMessage()), (Throwable)e);
        }
        return operations;
    }

    public static void main(String[] args) {
        new ReplayLogTest(new File(args[0])).test(Integer.valueOf(System.getProperty("nrTasks", "-1")), Integer.valueOf(System.getProperty("nrConcurrent", "10")));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReplayOperation
    implements OnlineSectioningTestFwk.Operation {
        private Long iStudentId = null;
        private List<OnlineSectioningAction<?>> iActions = null;
        private OnlineSectioningServer iServer;
        private int iGood = 0;

        public ReplayOperation(Long studentId, List<OnlineSectioningAction<?>> actions) {
            this.iStudentId = studentId;
            this.iActions = actions;
        }

        private <E> E executeAction(OnlineSectioningAction<E> action) {
            E ret = null;
            try {
                ret = this.iServer.execute(action, ReplayLogTest.this.user());
                ++this.iGood;
            }
            catch (SectioningException e) {
                for (String ok : ReplayLogTest.this.sOkErrors) {
                    if (e.getMessage() == null || !e.getMessage().matches(ok)) continue;
                    return null;
                }
                sLog.warn((Object)("Failed to run " + action.name() + " for " + this.iStudentId + ": " + e.getMessage()), (Throwable)e);
            }
            return ret;
        }

        @Override
        public double execute(OnlineSectioningServer s) {
            this.iServer = s;
            XStudent student = this.iServer.getStudent(this.iStudentId);
            EnrollStudent back = null;
            if (student != null) {
                CourseRequestInterface request = this.iServer.execute(ReplayLogTest.this.createAction(GetRequest.class).forStudent(this.iStudentId), ReplayLogTest.this.user());
                ClassAssignmentInterface assignment = this.iServer.execute(ReplayLogTest.this.createAction(GetAssignment.class).forStudent(this.iStudentId), ReplayLogTest.this.user());
                ArrayList assignments = new ArrayList();
                if (assignment != null) {
                    for (ClassAssignmentInterface.CourseAssignment ca : assignment.getCourseAssignments()) {
                        assignments.addAll(ca.getClassAssignments());
                    }
                }
                back = s.createAction(EnrollStudent.class).forStudent(this.iStudentId).withRequest(request).withAssignment(assignments);
            }
            boolean undo = false;
            int nrActions = 0;
            try {
                for (OnlineSectioningAction<?> action : this.iActions) {
                    if (action instanceof EnrollStudent) {
                        if (back == null || !this.iServer.getAcademicSession().isSectioningEnabled()) continue;
                        undo = true;
                        this.executeAction(action);
                        ++nrActions;
                        continue;
                    }
                    this.executeAction(action);
                    ++nrActions;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (undo && back != null) {
                this.executeAction(back);
                ++nrActions;
            }
            return nrActions == 0 ? 1.0 : (double)this.iGood / (double)nrActions;
        }
    }
}

