/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Date;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.StudentNote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SerializeWith(value=XStudentNoteSerializer.class)
public class XStudentNote
implements Serializable,
Comparable<XStudentNote>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iId;
    private String iNote;
    private String iUserId;
    private Date iTimeStamp;

    public XStudentNote(StudentNote note) {
        this.iId = note.getUniqueId();
        this.iNote = note.getTextNote();
        this.iUserId = note.getUserId();
        this.iTimeStamp = note.getTimeStamp();
    }

    public XStudentNote(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public Long getNoteId() {
        return this.iId;
    }

    public String getNote() {
        return this.iNote;
    }

    public boolean hasNote() {
        return this.iNote != null && !this.iNote.isEmpty();
    }

    public String getUserId() {
        return this.iUserId;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public int hashCode() {
        return (int)(this.getNoteId() ^ this.getNoteId() >>> 32);
    }

    @Override
    public int compareTo(XStudentNote note) {
        int cmp = this.getTimeStamp().compareTo(note.getTimeStamp());
        if (cmp != 0) {
            return cmp;
        }
        return this.getNoteId().compareTo(note.getNoteId());
    }

    public String toString() {
        return this.getNote();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long id = in.readLong();
        this.iId = id < 0L ? null : new Long(id);
        this.iNote = (String)in.readObject();
        this.iUserId = (String)in.readObject();
        long ts = in.readLong();
        this.iTimeStamp = ts == 0L ? null : new Date(ts);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iId == null ? -1L : this.iId);
        out.writeObject(this.iNote);
        out.writeObject(this.iUserId);
        out.writeLong(this.iTimeStamp == null ? 0L : this.iTimeStamp.getTime());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XStudentNoteSerializer
    implements Externalizer<XStudentNote> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XStudentNote object) throws IOException {
            object.writeExternal(output);
        }

        public XStudentNote readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XStudentNote(input);
        }
    }
}

