/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRoomFeature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iLabel;
    private String iAbbv;
    private String iDescription;
    private RoomFeatureType iFeatureType;
    private Set<Location> iRooms;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_LABEL = "label";
    public static String PROP_ABBV = "abbv";
    public static String PROP_DESCRIPTION = "description";

    public BaseRoomFeature() {
        this.initialize();
    }

    public BaseRoomFeature(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getLabel() {
        return this.iLabel;
    }

    public void setLabel(String label) {
        this.iLabel = label;
    }

    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    public RoomFeatureType getFeatureType() {
        return this.iFeatureType;
    }

    public void setFeatureType(RoomFeatureType featureType) {
        this.iFeatureType = featureType;
    }

    public Set<Location> getRooms() {
        return this.iRooms;
    }

    public void setRooms(Set<Location> rooms) {
        this.iRooms = rooms;
    }

    public void addTorooms(Location location) {
        if (this.iRooms == null) {
            this.iRooms = new HashSet<Location>();
        }
        this.iRooms.add(location);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RoomFeature)) {
            return false;
        }
        if (this.getUniqueId() == null || ((RoomFeature)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((RoomFeature)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "RoomFeature[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    public String toDebugString() {
        return "RoomFeature[\n\tAbbv: " + this.getAbbv() + "\n\tDescription: " + this.getDescription() + "\n\tFeatureType: " + this.getFeatureType() + "\n\tLabel: " + this.getLabel() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

