/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomPicture;
import org.unitime.timetable.model.RoomType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRoom
extends Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iBuildingAbbv;
    private String iRoomNumber;
    private String iClassification;
    private RoomType iRoomType;
    private Building iBuilding;
    private Set<RoomPicture> iPictures;
    private Set<EventServiceProvider> iAllowedServices;
    public static String PROP_ROOM_NUMBER = "roomNumber";
    public static String PROP_CLASSIFICATION = "classification";

    public BaseRoom() {
        this.initialize();
    }

    public BaseRoom(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    @Override
    protected void initialize() {
    }

    public String getBuildingAbbv() {
        return this.iBuildingAbbv;
    }

    public void setBuildingAbbv(String buildingAbbv) {
        this.iBuildingAbbv = buildingAbbv;
    }

    public String getRoomNumber() {
        return this.iRoomNumber;
    }

    public void setRoomNumber(String roomNumber) {
        this.iRoomNumber = roomNumber;
    }

    public String getClassification() {
        return this.iClassification;
    }

    public void setClassification(String classification) {
        this.iClassification = classification;
    }

    @Override
    public RoomType getRoomType() {
        return this.iRoomType;
    }

    @Override
    public void setRoomType(RoomType roomType) {
        this.iRoomType = roomType;
    }

    public Building getBuilding() {
        return this.iBuilding;
    }

    public void setBuilding(Building building) {
        this.iBuilding = building;
    }

    public Set<RoomPicture> getPictures() {
        return this.iPictures;
    }

    public void setPictures(Set<RoomPicture> pictures) {
        this.iPictures = pictures;
    }

    public void addTopictures(RoomPicture roomPicture) {
        if (this.iPictures == null) {
            this.iPictures = new HashSet<RoomPicture>();
        }
        this.iPictures.add(roomPicture);
    }

    @Override
    public Set<EventServiceProvider> getAllowedServices() {
        return this.iAllowedServices;
    }

    @Override
    public void setAllowedServices(Set<EventServiceProvider> allowedServices) {
        this.iAllowedServices = allowedServices;
    }

    public void addToallowedServices(EventServiceProvider eventServiceProvider) {
        if (this.iAllowedServices == null) {
            this.iAllowedServices = new HashSet<EventServiceProvider>();
        }
        this.iAllowedServices.add(eventServiceProvider);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Room)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Room)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Room)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "Room[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "Room[\n\tArea: " + this.getArea() + "\n\tBreakTime: " + this.getBreakTime() + "\n\tBuilding: " + this.getBuilding() + "\n\tCapacity: " + this.getCapacity() + "\n\tClassification: " + this.getClassification() + "\n\tCoordinateX: " + this.getCoordinateX() + "\n\tCoordinateY: " + this.getCoordinateY() + "\n\tDisplayName: " + this.getDisplayName() + "\n\tEventAvailability: " + this.getEventAvailability() + "\n\tEventDepartment: " + this.getEventDepartment() + "\n\tEventStatus: " + this.getEventStatus() + "\n\tExamCapacity: " + this.getExamCapacity() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tIgnoreRoomCheck: " + this.getIgnoreRoomCheck() + "\n\tIgnoreTooFar: " + this.getIgnoreTooFar() + "\n\tManagerIds: " + this.getManagerIds() + "\n\tNote: " + this.getNote() + "\n\tPattern: " + this.getPattern() + "\n\tPermanentId: " + this.getPermanentId() + "\n\tRoomNumber: " + this.getRoomNumber() + "\n\tRoomType: " + this.getRoomType() + "\n\tSession: " + this.getSession() + "\n\tShareNote: " + this.getShareNote() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

