/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.SponsoringOrganization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iEventName;
    private Integer iMinCapacity;
    private Integer iMaxCapacity;
    private String iEmail;
    private Date iExpirationDate;
    private Integer iExamStatus;
    private Long iDepartmentId;
    private EventContact iMainContact;
    private SponsoringOrganization iSponsoringOrganization;
    private Set<EventContact> iAdditionalContacts;
    private Set<EventNote> iNotes;
    private Set<Meeting> iMeetings;
    private Set<EventServiceProvider> iRequestedServices;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_EVENT_NAME = "eventName";
    public static String PROP_MIN_CAPACITY = "minCapacity";
    public static String PROP_MAX_CAPACITY = "maxCapacity";
    public static String PROP_EMAIL = "email";
    public static String PROP_EXPIRATION_DATE = "expirationDate";

    public BaseEvent() {
        this.initialize();
    }

    public BaseEvent(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getEventName() {
        return this.iEventName;
    }

    public void setEventName(String eventName) {
        this.iEventName = eventName;
    }

    public Integer getMinCapacity() {
        return this.iMinCapacity;
    }

    public void setMinCapacity(Integer minCapacity) {
        this.iMinCapacity = minCapacity;
    }

    public Integer getMaxCapacity() {
        return this.iMaxCapacity;
    }

    public void setMaxCapacity(Integer maxCapacity) {
        this.iMaxCapacity = maxCapacity;
    }

    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    public Date getExpirationDate() {
        return this.iExpirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.iExpirationDate = expirationDate;
    }

    public Integer getExamStatus() {
        return this.iExamStatus;
    }

    public void setExamStatus(Integer examStatus) {
        this.iExamStatus = examStatus;
    }

    public Long getDepartmentId() {
        return this.iDepartmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.iDepartmentId = departmentId;
    }

    public EventContact getMainContact() {
        return this.iMainContact;
    }

    public void setMainContact(EventContact mainContact) {
        this.iMainContact = mainContact;
    }

    public SponsoringOrganization getSponsoringOrganization() {
        return this.iSponsoringOrganization;
    }

    public void setSponsoringOrganization(SponsoringOrganization sponsoringOrganization) {
        this.iSponsoringOrganization = sponsoringOrganization;
    }

    public Set<EventContact> getAdditionalContacts() {
        return this.iAdditionalContacts;
    }

    public void setAdditionalContacts(Set<EventContact> additionalContacts) {
        this.iAdditionalContacts = additionalContacts;
    }

    public void addToadditionalContacts(EventContact eventContact) {
        if (this.iAdditionalContacts == null) {
            this.iAdditionalContacts = new HashSet<EventContact>();
        }
        this.iAdditionalContacts.add(eventContact);
    }

    public Set<EventNote> getNotes() {
        return this.iNotes;
    }

    public void setNotes(Set<EventNote> notes) {
        this.iNotes = notes;
    }

    public void addTonotes(EventNote eventNote) {
        if (this.iNotes == null) {
            this.iNotes = new HashSet<EventNote>();
        }
        this.iNotes.add(eventNote);
    }

    public Set<Meeting> getMeetings() {
        return this.iMeetings;
    }

    public void setMeetings(Set<Meeting> meetings) {
        this.iMeetings = meetings;
    }

    public void addTomeetings(Meeting meeting) {
        if (this.iMeetings == null) {
            this.iMeetings = new HashSet<Meeting>();
        }
        this.iMeetings.add(meeting);
    }

    public Set<EventServiceProvider> getRequestedServices() {
        return this.iRequestedServices;
    }

    public void setRequestedServices(Set<EventServiceProvider> requestedServices) {
        this.iRequestedServices = requestedServices;
    }

    public void addTorequestedServices(EventServiceProvider eventServiceProvider) {
        if (this.iRequestedServices == null) {
            this.iRequestedServices = new HashSet<EventServiceProvider>();
        }
        this.iRequestedServices.add(eventServiceProvider);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Event)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Event)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Event)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Event[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Event[\n\tEmail: " + this.getEmail() + "\n\tEventName: " + this.getEventName() + "\n\tExpirationDate: " + this.getExpirationDate() + "\n\tMainContact: " + this.getMainContact() + "\n\tMaxCapacity: " + this.getMaxCapacity() + "\n\tMinCapacity: " + this.getMinCapacity() + "\n\tSponsoringOrganization: " + this.getSponsoringOrganization() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

