/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.hibernate.Query;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseTimePattern;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.RequiredTimeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimePattern
extends BaseTimePattern
implements Comparable<TimePattern> {
    private static final long serialVersionUID = 1L;
    public static final int sTypeStandard = 0;
    public static final int sTypeEvening = 1;
    public static final int sTypeSaturday = 2;
    public static final int sTypeMorning = 3;
    public static final int sTypeExtended = 4;
    public static final int sTypeExactTime = 5;
    public static final String[] sTypes = new String[]{"Standard", "Evening", "Saturday", "Morning", "Extended", "Exact Time"};
    public static String TIME_PATTERN_ATTR_NAME = "timePatternsList";

    public TimePattern() {
    }

    public TimePattern(Long uniqueId) {
        super(uniqueId);
    }

    public static List<TimePattern> findAll(Session session, Boolean visible) {
        return TimePattern.findAll(session.getUniqueId(), visible);
    }

    public static List<TimePattern> findAll(Long sessionId, Boolean visible) {
        String query = "from TimePattern tp where tp.session.uniqueId=:sessionId";
        if (visible != null) {
            query = query + " and visible=:visible";
        }
        org.hibernate.Session hibSession = new TimePatternDAO().getSession();
        Query q = hibSession.createQuery(query);
        q.setCacheable(true);
        q.setLong("sessionId", sessionId.longValue());
        if (visible != null) {
            q.setBoolean("visible", visible.booleanValue());
        }
        List v = q.list();
        Collections.sort(v);
        return v;
    }

    @Deprecated
    public static List<TimePattern> findApplicable(UserContext user, int minPerWeek, boolean includeExactTime, Department department) throws Exception {
        boolean includeExtended = user.getCurrentAuthority().hasRight(Right.ExtendedTimePatterns);
        return TimePattern.findByMinPerWeek(user.getCurrentAcademicSessionId(), false, includeExtended, includeExactTime, minPerWeek, includeExtended ? null : department);
    }

    @Deprecated
    public static List<TimePattern> findByMinPerWeek(Session session, boolean includeHidden, boolean includeExtended, boolean includeExactTime, int minPerWeek, Department department) {
        return TimePattern.findByMinPerWeek(session.getUniqueId(), includeHidden, includeExtended, includeExactTime, minPerWeek, department);
    }

    @Deprecated
    public static List<TimePattern> findByMinPerWeek(Long sessionId, boolean includeHidden, boolean includeExtended, boolean includeExactTime, int minPerWeek, Department department) {
        List list = null;
        list = includeExactTime && department == null ? new TimePatternDAO().getSession().createQuery("select distinct p from TimePattern as p where p.session.uniqueId=:sessionId and " + (!includeHidden ? "p.visible=true and " : "") + "(p.type=" + 5 + " or ( p.type!=" + 5 + " and " + (!includeExtended ? "p.type!=4 and " : "") + "p.minPerMtg * p.nrMeetings = :minPerWeek ))").setLong("sessionId", sessionId.longValue()).setInteger("minPerWeek", minPerWeek).setCacheable(true).list() : new TimePatternDAO().getSession().createQuery("select distinct p from TimePattern as p where p.session.uniqueId=:sessionId and p.type!=5 and " + (!includeHidden ? "p.visible=true and " : "") + (!includeExtended ? "p.type!=4 and " : "") + "p.minPerMtg * p.nrMeetings = :minPerWeek").setLong("sessionId", sessionId.longValue()).setInteger("minPerWeek", minPerWeek).setCacheable(true).list();
        if (!includeExtended && department != null) {
            for (TimePattern tp : department.getTimePatterns()) {
                if (tp.getMinPerMtg() * tp.getNrMeetings() != minPerWeek || tp.getType() != 4 || !includeHidden && !tp.isVisible().booleanValue()) continue;
                list.add(tp);
            }
        }
        if (includeExactTime && department != null) {
            for (TimePattern tp : department.getTimePatterns()) {
                if (tp.getType() != 5) continue;
                list.add(tp);
                break;
            }
        }
        Collections.sort(list);
        return list;
    }

    public static List<TimePattern> findApplicable(UserContext user, int minutes, DatePattern datePattern, DurationModel model, boolean includeExactTime, Department department) {
        boolean includeExtended = user.getCurrentAuthority().hasRight(Right.ExtendedTimePatterns);
        return TimePattern.findApplicable(user.getCurrentAcademicSessionId(), false, includeExtended, includeExactTime, minutes, datePattern, model, includeExtended ? null : department);
    }

    public static List<TimePattern> findApplicable(Session session, boolean includeHidden, boolean includeExtended, boolean includeExactTime, int minutes, DatePattern datePattern, DurationModel model, Department department) {
        return TimePattern.findApplicable(session.getUniqueId(), includeHidden, includeExtended, includeExactTime, minutes, datePattern, model, department);
    }

    public static List<TimePattern> findApplicable(Long sessionId, boolean includeHidden, boolean includeExtended, boolean includeExactTime, int minutes, DatePattern datePattern, DurationModel model, Department department) {
        ArrayList<TimePattern> list = new ArrayList<TimePattern>();
        for (TimePattern pattern : TimePatternDAO.getInstance().getSession().createQuery("from TimePattern where session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
            if (!includeHidden && !pattern.isVisible().booleanValue() || !includeExtended && pattern.getType() == 4 && (department == null || !department.getTimePatterns().contains(pattern))) continue;
            if (pattern.getType() == 5) {
                if (!includeExactTime || !includeExtended && !pattern.getDepartments().isEmpty() && (department == null || !pattern.getDepartments().contains(department))) continue;
                list.add(pattern);
                continue;
            }
            if (!model.isValidCombination(minutes, datePattern, pattern)) continue;
            list.add(pattern);
        }
        Collections.sort(list);
        return list;
    }

    public static TimePattern findByName(Session session, String name) {
        return TimePattern.findByName(session.getUniqueId(), name);
    }

    public static TimePattern findByName(Long sessionId, String name) {
        List list = new TimePatternDAO().getSession().createQuery("select distinct p from TimePattern as p where p.session.uniqueId=:sessionId and p.name=:name").setLong("sessionId", sessionId.longValue()).setText("name", name).setCacheable(true).list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (TimePattern)list.get(0);
    }

    public static TimePattern findExactTime(Long sessionId) {
        List list = new TimePatternDAO().getSession().createQuery("select distinct p from TimePattern as p where p.session.uniqueId=:sessionId and p.type=5").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (TimePattern)list.get(0);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof TimePattern)) {
            return false;
        }
        return this.getUniqueId().equals(((TimePattern)o).getUniqueId());
    }

    @Override
    public int compareTo(TimePattern t) {
        int nrCombT;
        int cmp = this.getType().compareTo(t.getType());
        if (cmp != 0) {
            return cmp;
        }
        cmp = -this.getNrMeetings().compareTo(t.getNrMeetings());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getMinPerMtg().compareTo(t.getMinPerMtg());
        if (cmp != 0) {
            return cmp;
        }
        int nrComb = this.getTimes().size() * this.getDays().size();
        cmp = Double.compare(nrComb, nrCombT = t.getTimes().size() * t.getDays().size());
        if (cmp != 0) {
            return cmp;
        }
        return this.getName().compareTo(t.getName());
    }

    public TimePatternModel getTimePatternModel() {
        return this.getTimePatternModel(null, true);
    }

    public TimePatternModel getTimePatternModel(boolean allowHardPreferences) {
        return this.getTimePatternModel(null, allowHardPreferences);
    }

    public TimePatternModel getTimePatternModel(TimeLocation assignment, boolean allowHardPreferences) {
        return new TimePatternModel(this, assignment, allowHardPreferences);
    }

    public static Set findAllUsed(Session session) {
        return TimePattern.findAllUsed(session.getUniqueId());
    }

    public static Set findAllUsed(Long sessionId) {
        TreeSet ret = new TreeSet(new TimePatternDAO().getSession().createQuery("select distinct tp from TimePref as p inner join p.timePattern as tp where tp.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
        ret.addAll(new TimePatternDAO().getSession().createQuery("select distinct tp from Assignment as a inner join a.timePattern as tp where tp.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
        return ret;
    }

    public boolean isEditable() {
        if (TimePattern.isTimePatternEditableInitialDataLoad() && this.getSession().getStatusType().isAllowRollForward()) {
            return true;
        }
        return !TimePattern.findAllUsed(this.getSession()).contains(this);
    }

    public static RequiredTimeTable getDefaultRequiredTimeTable() {
        return new RequiredTimeTable(new TimePatternModel());
    }

    public RequiredTimeTable getRequiredTimeTable(boolean allowHardPreferences) {
        return this.getRequiredTimeTable(null, allowHardPreferences);
    }

    public RequiredTimeTable getRequiredTimeTable(TimeLocation assignment, boolean allowHardPreferences) {
        return new RequiredTimeTable(this.getTimePatternModel(assignment, allowHardPreferences));
    }

    public Set getDepartments(Long sessionId) {
        TreeSet<Department> ret = new TreeSet<Department>();
        for (Department d : this.getDepartments()) {
            if (sessionId != null && !d.getSession().getUniqueId().equals(sessionId)) continue;
            ret.add(d);
        }
        return ret;
    }

    @Override
    public Integer getBreakTime() {
        Integer breakTime = super.getBreakTime();
        if (breakTime != null) {
            return breakTime;
        }
        if (this.getSlotsPerMtg() == null) {
            return new Integer(10);
        }
        if (this.getSlotsPerMtg() % 12 == 0) {
            return new Integer(10);
        }
        if (this.getSlotsPerMtg() > 6) {
            return new Integer(15);
        }
        if (this.getType() == 5) {
            return new Integer(10);
        }
        return new Integer(0);
    }

    public Object clone() {
        TimePattern newTimePattern = new TimePattern();
        newTimePattern.setBreakTime(this.getBreakTime());
        if (this.getDays() != null) {
            TimePatternDays origTpDays2 = null;
            TimePatternDays newTpDays = null;
            for (TimePatternDays origTpDays2 : this.getDays()) {
                newTpDays = new TimePatternDays();
                newTpDays.setDayCode(origTpDays2.getDayCode());
                newTimePattern.addTodays(newTpDays);
            }
        }
        newTimePattern.setMinPerMtg(this.getMinPerMtg());
        newTimePattern.setName(this.getName());
        newTimePattern.setNrMeetings(this.getNrMeetings());
        newTimePattern.setSlotsPerMtg(this.getSlotsPerMtg());
        if (this.getTimes() != null) {
            TimePatternTime origTpTime2 = null;
            TimePatternTime newTpTime = null;
            for (TimePatternTime origTpTime2 : this.getTimes()) {
                newTpTime = new TimePatternTime();
                newTpTime.setStartSlot(origTpTime2.getStartSlot());
                newTimePattern.addTotimes(newTpTime);
            }
        }
        newTimePattern.setSession(this.getSession());
        newTimePattern.setType(this.getType());
        newTimePattern.setVisible(this.isVisible());
        return newTimePattern;
    }

    private boolean possibleMatch(TimePattern other, boolean strongComparison) {
        if (!this.getNrMeetings().equals(other.getNrMeetings())) {
            return false;
        }
        if (!this.getMinPerMtg().equals(other.getMinPerMtg())) {
            return false;
        }
        if (strongComparison && !this.getBreakTime().equals(other.getBreakTime())) {
            return false;
        }
        return !strongComparison || this.getSlotsPerMtg().equals(other.getSlotsPerMtg());
    }

    public boolean contains(TimePattern other, boolean strongComparison) {
        if (!this.possibleMatch(other, strongComparison)) {
            return false;
        }
        return this.getDays().containsAll(other.getDays()) && this.getTimes().containsAll(other.getTimes());
    }

    public boolean match(TimePattern other, boolean strongComparison) {
        if (!this.possibleMatch(other, strongComparison)) {
            return false;
        }
        return this.getDays().equals(other.getDays()) && this.getTimes().equals(other.getTimes());
    }

    public static TimePattern getMatchingTimePattern(Long sessionId, TimePattern pattern) {
        if (pattern.getType() == 5) {
            return TimePattern.findExactTime(sessionId);
        }
        TreeSet list = new TreeSet(new TimePatternDAO().getSession().createQuery("select distinct p from TimePattern as p where p.session.uniqueId=:sessionId and p.minPerMtg = :minPerMtg and p.nrMeetings = :nrMeetings").setLong("sessionId", sessionId.longValue()).setInteger("minPerMtg", pattern.getMinPerMtg().intValue()).setInteger("nrMeetings", pattern.getNrMeetings().intValue()).setCacheable(true).list());
        for (TimePattern tp : list) {
            if (!tp.isVisible().booleanValue() || !tp.match(pattern, true)) continue;
            return tp;
        }
        for (TimePattern tp : list) {
            if (!tp.isVisible().booleanValue() || !tp.match(pattern, false)) continue;
            return tp;
        }
        for (TimePattern tp : list) {
            if (!tp.isVisible().booleanValue() || !tp.contains(pattern, true)) continue;
            return tp;
        }
        for (TimePattern tp : list) {
            if (!tp.isVisible().booleanValue() || !tp.contains(pattern, false)) continue;
            return tp;
        }
        for (TimePattern tp : list) {
            if (tp.isVisible().booleanValue() || !tp.contains(pattern, true)) continue;
            return tp;
        }
        for (TimePattern tp : list) {
            if (tp.isVisible().booleanValue() || !tp.contains(pattern, false)) continue;
            return tp;
        }
        return null;
    }

    public static TimePref getMatchingTimePreference(Long sessionId, TimePref timePref) {
        TimePatternModel oldModel = timePref.getTimePatternModel();
        TimePattern newTimePattern = TimePattern.getMatchingTimePattern(sessionId, timePref.getTimePattern());
        if (newTimePattern == null) {
            if (oldModel.countPreferences(PreferenceLevel.sRequired) == 1) {
                newTimePattern = TimePattern.findExactTime(sessionId);
                if (newTimePattern == null) {
                    return null;
                }
                TimePatternModel newModel = newTimePattern.getTimePatternModel();
                for (int d = 0; d < oldModel.getNrDays(); ++d) {
                    for (int t = 0; t < oldModel.getNrTimes(); ++t) {
                        if (!PreferenceLevel.sRequired.equals(oldModel.getPreference(d, t))) continue;
                        newModel.setExactDays(oldModel.getDayCode(d));
                        newModel.setExactStartSlot(oldModel.getStartSlot(t));
                        TimePref newTimePref = new TimePref();
                        newTimePref.setPrefLevel(timePref.getPrefLevel());
                        newTimePref.setTimePattern(newTimePattern);
                        newTimePref.setPreference(newModel.getPreferences());
                        return newTimePref;
                    }
                }
            }
            return null;
        }
        TimePatternModel newModel = newTimePattern.getTimePatternModel();
        if (newModel.isExactTime()) {
            newModel.setExactDays(oldModel.getExactDays());
            newModel.setExactStartSlot(oldModel.getExactStartSlot());
        } else {
            newModel.combineMatching(oldModel);
        }
        TimePref newTimePref = new TimePref();
        newTimePref.setPrefLevel(timePref.getPrefLevel());
        newTimePref.setTimePattern(newTimePattern);
        newTimePref.setPreference(newModel.getPreferences());
        return newTimePref;
    }

    public static boolean isTimePatternEditableInitialDataLoad() {
        return ApplicationProperty.TimePatternEditableDuringInitialDataLoad.isTrue();
    }
}

