/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.Session;
import org.unitime.timetable.model.base.BaseStudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSectioningStatus
extends BaseStudentSectioningStatus {
    private static final long serialVersionUID = -33276457852954947L;

    public boolean hasOption(Option option) {
        return this.getStatus() != null && (this.getStatus() & option.toggle()) != 0;
    }

    public void addOption(Option option) {
        if (!this.hasOption(option)) {
            this.setStatus((this.getStatus() == null ? 0 : this.getStatus()) + option.toggle());
        }
    }

    public void removeOption(Option option) {
        if (this.hasOption(option)) {
            this.setStatus(this.getStatus() - option.toggle());
        }
    }

    public static StudentSectioningStatus getStatus(String reference, Long sessionId, Session hibSession) {
        StudentSectioningStatus status;
        if (reference != null && (status = (StudentSectioningStatus)hibSession.createQuery("from StudentSectioningStatus s where s.reference = :reference").setString("reference", reference).setMaxResults(1).setCacheable(true).uniqueResult()) != null) {
            return status;
        }
        if (sessionId != null && (status = (StudentSectioningStatus)hibSession.createQuery("select s.defaultSectioningStatus from Session s where s.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setMaxResults(1).setCacheable(true).uniqueResult()) != null) {
            return status;
        }
        return null;
    }

    public static boolean hasOption(Option option, String reference, Long sessionId, Session hibSession) {
        StudentSectioningStatus status = StudentSectioningStatus.getStatus(reference, sessionId, hibSession);
        return status == null || status.hasOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getMatchingStatuses(Option option) {
        Session hibSession = StudentSectioningStatusDAO.getInstance().createNewSession();
        try {
            HashSet<String> statuses = new HashSet<String>();
            for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll(hibSession)) {
                if (!status.hasOption(option)) continue;
                statuses.add(status.getReference());
            }
            HashSet<String> hashSet = statuses;
            return hashSet;
        }
        finally {
            hibSession.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        enabled("Access Enabled"),
        advisor("Advisor Can Enroll"),
        email("Email Notifications"),
        notype("Must Have Course Type"),
        waitlist("Wait-Listing Enabled"),
        nobatch("Do Not Schedule in Batch Solver"),
        enrollment("Enrollment Enabled"),
        admin("Admin Can Enroll");

        private String iName;

        private Option(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public int toggle() {
            return 1 << this.ordinal();
        }
    }
}

