/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.List;
import java.util.Vector;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.unitime.timetable.model.base.BaseSolverPredefinedSetting;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;

public class SolverPredefinedSetting
extends BaseSolverPredefinedSetting {
    private static final long serialVersionUID = 1L;
    public static final String[] sAppearances = new String[]{"Timetables", "Solver", "Examination Solver", "Student Sectioning Solver", "Instructor Scheduling Solver"};
    public static final int APPEARANCE_TIMETABLES = 0;
    public static final int APPEARANCE_SOLVER = 1;
    public static final int APPEARANCE_EXAM_SOLVER = 2;
    public static final int APPEARANCE_STUDENT_SOLVER = 3;
    public static final int APPEARANCE_INSTRUCTOR_SOLVER = 4;

    public SolverPredefinedSetting() {
    }

    public SolverPredefinedSetting(Long uniqueId) {
        super(uniqueId);
    }

    public static SolverPredefinedSetting findByName(String name) {
        List list = new SolverPredefinedSettingDAO().getSession().createCriteria(SolverPredefinedSetting.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).setCacheable(true).list();
        if (list.isEmpty()) {
            return null;
        }
        return (SolverPredefinedSetting)list.get(0);
    }

    public static String[] getNames(Integer appearance) {
        List list = new SolverPredefinedSettingDAO().getSession().createCriteria(SolverPredefinedSetting.class).add((Criterion)Restrictions.eq((String)"appearance", (Object)appearance)).addOrder(Order.asc((String)"name")).setCacheable(true).list();
        if (list.isEmpty()) {
            return new String[0];
        }
        String[] names = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SolverPredefinedSetting set = (SolverPredefinedSetting)list.get(i);
            names[i] = set.getName();
        }
        return names;
    }

    public static Vector getIdValueList(Integer appearance) {
        List list = new SolverPredefinedSettingDAO().getSession().createCriteria(SolverPredefinedSetting.class).add((Criterion)Restrictions.eq((String)"appearance", (Object)appearance)).addOrder(Order.asc((String)"name")).setCacheable(true).list();
        Vector<IdValue> idValueList = new Vector<IdValue>();
        for (SolverPredefinedSetting set : list) {
            idValueList.add(new IdValue(set.getUniqueId(), set.getDescription()));
        }
        return idValueList;
    }

    public static class IdValue {
        private Long iId;
        private String iValue;
        private String iType;
        private boolean iEnabled;

        public IdValue(Long id, String value) {
            this(id, value, null, true);
        }

        public IdValue(Long id, String value, String type) {
            this(id, value, type, true);
        }

        public IdValue(Long id, String value, String type, boolean enabled) {
            this.iId = id;
            this.iValue = value;
            this.iType = type;
            this.iEnabled = enabled;
        }

        public Long getId() {
            return this.iId;
        }

        public String getValue() {
            return this.iValue;
        }

        public String getType() {
            return this.iType;
        }

        public boolean getEnabled() {
            return this.iEnabled;
        }

        public boolean getDisabled() {
            return !this.iEnabled;
        }
    }
}

