/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.base.BaseRoomTypeOption;

public class RoomTypeOption
extends BaseRoomTypeOption {
    private static final long serialVersionUID = 1L;

    public RoomTypeOption() {
    }

    public RoomTypeOption(RoomType roomType, Department department) {
        this.setRoomType(roomType);
        this.setDepartment(department);
        this.initialize();
    }

    public static int getDefaultStatus() {
        return Status.NoEventManagement.ordinal();
    }

    public Status getEventStatus() {
        return Status.values()[this.getStatus() == null ? RoomTypeOption.getDefaultStatus() : this.getStatus()];
    }

    @Deprecated
    public boolean canScheduleEvents() {
        switch (Status.values()[this.getStatus() == null ? RoomTypeOption.getDefaultStatus() : this.getStatus()]) {
            case NoEventManagement: {
                return false;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NoEventManagement(false, false, false, false),
        AuthenticatedUsersCanRequestEventsManagersCanApprove(true, true, true, true),
        DepartmentalUsersCanRequestEventsManagersCanApprove(false, true, true, true),
        EventManagersCanRequestOrApproveEvents(false, false, true, true),
        AuthenticatedUsersCanRequestEventsNoApproval(true, true, true, false),
        DepartmentalUsersCanRequestEventsNoApproval(false, true, true, false),
        EventManagersCanRequestEventsNoApproval(false, false, true, false),
        AuthenticatedUsersCanRequestAutomaticApproval(true, true, true, true, true),
        DepartmentalUsersCanRequestAutomaticApproval(false, true, true, true, true),
        EventManagersCanRequestAutomaticApproval(false, false, true, true, true);

        private boolean iUserRequest;
        private boolean iDeptRequest;
        private boolean iMgrRequest;
        private boolean iMgrApproval;
        private boolean iAutoApproval;

        private Status(boolean userRequest, boolean deptRequest, boolean mgrRequest, boolean mgrApproval, boolean autoApproval) {
            this.iUserRequest = userRequest;
            this.iDeptRequest = deptRequest;
            this.iMgrRequest = mgrRequest;
            this.iMgrApproval = mgrApproval;
            this.iAutoApproval = autoApproval;
        }

        private Status(boolean userRequest, boolean deptRequest, boolean mgrRequest, boolean mgrApproval) {
            this(userRequest, deptRequest, mgrRequest, mgrApproval, false);
        }

        public boolean isAuthenticatedUsersCanRequestEvents() {
            return this.iUserRequest;
        }

        public boolean isDepartmentalUsersCanRequestEvents() {
            return this.iDeptRequest;
        }

        public boolean isEventManagersCanApprove() {
            return this.iMgrApproval;
        }

        public boolean isEventManagersCanRequestEvents() {
            return this.iMgrRequest;
        }

        public boolean isAutomaticApproval() {
            return this.iAutoApproval;
        }

        public String toString() {
            return this.name().replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2");
        }
    }
}

