/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.util.NameFormat;

public class UniTimePrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private String iExternalId;
    private String iName;
    private HashMap<Long, Long> iStudentId = new HashMap();
    private String iStudentExternalId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniTimePrincipal(String externalId, String studentExternalId, String name) {
        if (externalId == null) {
            throw new NullPointerException();
        }
        this.iExternalId = externalId;
        this.iStudentExternalId = studentExternalId;
        this.iName = name;
        Session hibSession = StudentDAO.getInstance().createNewSession();
        try {
            List student = hibSession.createQuery("select m from Student m where m.externalUniqueId = :uid").setString("uid", externalId).list();
            if (!student.isEmpty()) {
                for (Student s : student) {
                    this.addStudentId(s.getSession().getUniqueId(), s.getUniqueId());
                    this.iName = NameFormat.LAST_FIRST_MIDDLE.format(s);
                }
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(String externalId) {
        this.iExternalId = externalId;
    }

    public String getStudentExternalId() {
        return this.iStudentExternalId;
    }

    public void setStudentExternalId(String externalId) {
        this.iStudentExternalId = externalId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public Long getStudentId(Long sessionId) {
        return this.iStudentId.get(sessionId);
    }

    public void addStudentId(Long sessionId, Long studentId) {
        this.iStudentId.put(sessionId, studentId);
    }

    public int hashCode() {
        return this.iExternalId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof UniTimePrincipal)) {
            return false;
        }
        return this.getExternalId().equals(((UniTimePrincipal)o).getExternalId());
    }

    public String toString() {
        return "UniTimePrincipal{id:" + this.getExternalId() + ", name:" + this.getName() + "}";
    }
}

