/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Term iQuery = null;

    public Query(String query) {
        this.iQuery = Query.parse(query == null ? "" : query.trim());
    }

    public Query(Term query) {
        this.iQuery = query;
    }

    public Term getQuery() {
        return this.iQuery;
    }

    public boolean match(TermMatcher m) {
        return this.iQuery.match(m);
    }

    public String toString() {
        return this.iQuery.toString();
    }

    public String toString(QueryFormatter f) {
        return this.iQuery.toString(f);
    }

    public boolean hasAttribute(String ... attr) {
        for (String a : attr) {
            if (!this.iQuery.hasAttribute(a)) continue;
            return true;
        }
        return false;
    }

    private static List<String> split(String query, String ... splits) {
        ArrayList<String> ret = new ArrayList<String>();
        int bracket = 0;
        boolean quot = false;
        int last = 0;
        boolean white = false;
        block0: for (int i = 0; i < query.length(); ++i) {
            if (query.charAt(i) == '\"') {
                quot = !quot;
                white = !quot;
                continue;
            }
            if (!quot && query.charAt(i) == '(') {
                ++bracket;
                white = false;
                continue;
            }
            if (!quot && query.charAt(i) == ')') {
                --bracket;
                white = true;
                continue;
            }
            if (quot || bracket > 0 || !white && query.charAt(i) != ' ') {
                white = query.charAt(i) == ' ';
                continue;
            }
            white = query.charAt(i) == ' ';
            String q = query.substring(i).toLowerCase();
            for (String split : splits) {
                if (!split.isEmpty() && !q.startsWith(split + " ") && !q.startsWith(split + "\"") && !q.startsWith(split + "(")) continue;
                String x = query.substring(last, i).trim();
                if (split.isEmpty() && x.endsWith(":")) continue;
                if (!x.isEmpty()) {
                    ret.add(x);
                }
                last = i + split.length();
                if (split.isEmpty()) continue block0;
                i += split.length() - 1;
                continue block0;
            }
        }
        String x = query.substring(last).trim();
        if (!x.isEmpty()) {
            ret.add(x);
        }
        return ret;
    }

    private static Term parse(String query) {
        List<String> splits = Query.split(query, "and", "&&", "&");
        if (splits.size() > 1) {
            AndTerm t = new AndTerm();
            for (String q : splits) {
                t.add(Query.parse(q));
            }
            return t;
        }
        splits = Query.split(query, "or", "||", "|");
        if (splits.size() > 1) {
            OrTerm t = new OrTerm();
            for (String q : splits) {
                t.add(Query.parse(q));
            }
            return t;
        }
        splits = Query.split(query, "");
        if (splits.size() > 1) {
            AndTerm and = new AndTerm();
            boolean not = false;
            block2: for (String q : splits) {
                if (q.equalsIgnoreCase("not") || q.equals("!")) {
                    not = true;
                    continue;
                }
                if (q.startsWith("!(")) {
                    q = q.substring(1);
                    not = true;
                } else if (q.toLowerCase().startsWith("not(")) {
                    q = q.substring(3);
                    not = true;
                }
                if (not) {
                    and.add(new NotTerm(Query.parse(q)));
                    not = false;
                    continue;
                }
                Term t = Query.parse(q);
                if (t instanceof AtomTerm) {
                    AtomTerm a = (AtomTerm)t;
                    for (Term x : and.terms()) {
                        if (x instanceof AtomTerm && ((AtomTerm)x).sameAttribute(a)) {
                            and.remove(x);
                            OrTerm or = new OrTerm();
                            or.add(x);
                            or.add(a);
                            and.add(or);
                            continue block2;
                        }
                        if (!(x instanceof OrTerm) || !(((OrTerm)x).terms().get(0) instanceof AtomTerm) || !((AtomTerm)((OrTerm)x).terms().get(0)).sameAttribute(a)) continue;
                        ((OrTerm)x).terms().add(a);
                        continue block2;
                    }
                }
                and.add(t);
            }
            return and;
        }
        if (query.startsWith("(") && query.endsWith(")")) {
            return Query.parse(query.substring(1, query.length() - 1).trim());
        }
        if (query.startsWith("\"") && query.endsWith("\"") && query.length() >= 2) {
            return new AtomTerm(null, query.substring(1, query.length() - 1).trim());
        }
        int idx = query.indexOf(58);
        if (idx >= 0) {
            return new AtomTerm(query.substring(0, idx).trim().toLowerCase(), query.substring(idx + 1).trim());
        }
        return new AtomTerm(null, query);
    }

    public static void main(String[] args) {
        System.out.println(Query.parse("(dept:1124 or dept:1125) and area:bio"));
        System.out.println(Query.parse("a \"b c\" or ddd f \"x:x\" x: s !(band or org) (a)or(b)"));
        System.out.println(Query.parse("! f (a)or(b) d !d not x s"));
        System.out.println(Query.parse(""));
        System.out.println(Query.split("(a \"b c\")  ddd f", ""));
        System.out.println(Query.split("a \"b c\" OR not ddd f", "or"));
        System.out.println(Query.split("a or((\"b c\" or dddor) f) q", "or"));
    }

    public static interface QueryFormatter {
        public String format(String var1, String var2);
    }

    public static interface TermMatcher {
        public boolean match(String var1, String var2);
    }

    public static class AtomTerm
    implements Term {
        private static final long serialVersionUID = 1L;
        private String iAttr;
        private String iBody;

        public AtomTerm(String attr, String body) {
            if (body.startsWith("\"") && body.endsWith("\"") && body.length() > 1) {
                body = body.substring(1, body.length() - 1);
            }
            this.iAttr = attr;
            this.iBody = body;
        }

        public boolean match(TermMatcher m) {
            return m.match(this.iAttr, this.iBody);
        }

        public boolean hasAttribute(String attribute) {
            return attribute != null && attribute.equals(this.iAttr);
        }

        public boolean sameAttribute(AtomTerm t) {
            return t != null && this.hasAttribute(t.iAttr);
        }

        public String toString() {
            return (this.iAttr == null ? "" : this.iAttr + ":") + (this.iBody.indexOf(32) >= 0 ? "\"" + this.iBody + "\"" : this.iBody);
        }

        public String toString(QueryFormatter f) {
            return f.format(this.iAttr, this.iBody);
        }
    }

    public static class NotTerm
    implements Term {
        private static final long serialVersionUID = 1L;
        private Term iTerm;

        public NotTerm(Term t) {
            this.iTerm = t;
        }

        public boolean match(TermMatcher m) {
            return !this.iTerm.match(m);
        }

        public boolean hasAttribute(String attribute) {
            return this.iTerm.hasAttribute(attribute);
        }

        public String toString() {
            return "NOT " + this.iTerm.toString();
        }

        public String toString(QueryFormatter f) {
            return "NOT " + this.iTerm.toString(f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AndTerm
    extends CompositeTerm {
        private static final long serialVersionUID = 1L;

        public AndTerm() {
        }

        public AndTerm(Term ... terms) {
            super(terms);
        }

        public AndTerm(Collection<Term> terms) {
            super(terms);
        }

        @Override
        public String getOp() {
            return "AND";
        }

        @Override
        public boolean match(TermMatcher m) {
            for (Term t : this.terms()) {
                if (t.match(m)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrTerm
    extends CompositeTerm {
        private static final long serialVersionUID = 1L;

        public OrTerm() {
        }

        public OrTerm(Term ... terms) {
            super(terms);
        }

        public OrTerm(Collection<Term> terms) {
            super(terms);
        }

        @Override
        public String getOp() {
            return "OR";
        }

        @Override
        public boolean match(TermMatcher m) {
            if (this.terms().isEmpty()) {
                return true;
            }
            for (Term t : this.terms()) {
                if (!t.match(m)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CompositeTerm
    implements Term {
        private static final long serialVersionUID = 1L;
        private List<Term> iTerms = new ArrayList<Term>();

        public CompositeTerm() {
        }

        public CompositeTerm(Term ... terms) {
            for (Term t : terms) {
                this.add(t);
            }
        }

        public CompositeTerm(Collection<Term> terms) {
            for (Term t : terms) {
                this.add(t);
            }
        }

        public void add(Term t) {
            this.iTerms.add(t);
        }

        public void remove(Term t) {
            this.iTerms.remove(t);
        }

        protected List<Term> terms() {
            return this.iTerms;
        }

        public abstract String getOp();

        @Override
        public boolean hasAttribute(String attribute) {
            for (Term t : this.terms()) {
                if (!t.hasAttribute(attribute)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String ret = "";
            for (Term t : this.terms()) {
                if (!ret.isEmpty()) {
                    ret = ret + " " + this.getOp() + " ";
                }
                ret = ret + t;
            }
            return this.terms().size() > 1 ? "(" + ret + ")" : ret;
        }

        @Override
        public String toString(QueryFormatter f) {
            String ret = "";
            for (Term t : this.terms()) {
                if (!ret.isEmpty()) {
                    ret = ret + " " + this.getOp() + " ";
                }
                ret = ret + t.toString(f);
            }
            return this.terms().size() > 1 ? "(" + ret + ")" : ret;
        }
    }

    public static interface Term
    extends Serializable {
        public boolean match(TermMatcher var1);

        public String toString(QueryFormatter var1);

        public boolean hasAttribute(String var1);
    }
}

