/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeTimeParser
implements DataProvider<String, List<CourseRequestInterface.FreeTime>> {
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    private Map<String, ?> iValidCourseNames = null;

    @Override
    public void getData(String source, AsyncCallback<List<CourseRequestInterface.FreeTime>> callback) {
        try {
            callback.onSuccess(this.parseFreeTime(source));
        }
        catch (IllegalArgumentException e) {
            callback.onFailure((Throwable)e);
        }
    }

    public void setValidCourseNames(Map<String, ?> validCourseNames) {
        this.iValidCourseNames = validCourseNames;
    }

    public ArrayList<CourseRequestInterface.FreeTime> parseFreeTime(String text) throws IllegalArgumentException {
        String[] tokens;
        if (this.iValidCourseNames != null && this.iValidCourseNames.containsKey(text.toLowerCase())) {
            throw new IllegalArgumentException(MESSAGES.notFreeTimeIsCourse(text));
        }
        if (text.isEmpty()) {
            throw new IllegalArgumentException(MESSAGES.courseSelectionNoFreeTime());
        }
        for (String dnp : CONSTANTS.freeTimeDoNotParse()) {
            if (!text.matches(dnp)) continue;
            throw new IllegalArgumentException(MESSAGES.courseSelectionNoFreeTime());
        }
        ArrayList<CourseRequestInterface.FreeTime> ret = new ArrayList<CourseRequestInterface.FreeTime>();
        ArrayList lastDays = new ArrayList();
        String[] stringArray = tokens = text.split("[,;]");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            int startTime;
            String token;
            String original = token = stringArray[i];
            if (token.toLowerCase().startsWith(CONSTANTS.freePrefix().toLowerCase())) {
                token = token.substring(CONSTANTS.freePrefix().length());
            }
            ArrayList<Integer> days = new ArrayList<Integer>();
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            boolean found = false;
            do {
                int i2;
                found = false;
                for (i2 = 0; i2 < CONSTANTS.longDays().length; ++i2) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.longDays()[i2].toLowerCase())) continue;
                    days.add(i2);
                    token = token.substring(CONSTANTS.longDays()[i2].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i2 = 0; i2 < CONSTANTS.days().length; ++i2) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.days()[i2].toLowerCase())) continue;
                    days.add(i2);
                    token = token.substring(CONSTANTS.days()[i2].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i2 = 0; i2 < CONSTANTS.days().length; ++i2) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.days()[i2].substring(0, 2).toLowerCase())) continue;
                    days.add(i2);
                    token = token.substring(2);
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i2 = 0; i2 < CONSTANTS.shortDays().length; ++i2) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.shortDays()[i2].toLowerCase())) continue;
                    days.add(i2);
                    token = token.substring(CONSTANTS.shortDays()[i2].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i2 = 0; i2 < CONSTANTS.freeTimeShortDays().length; ++i2) {
                    if (!token.toLowerCase().startsWith(CONSTANTS.freeTimeShortDays()[i2].toLowerCase())) continue;
                    days.add(i2);
                    token = token.substring(CONSTANTS.freeTimeShortDays()[i2].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
            } while (found);
            int startHour = 0;
            int startMin = 0;
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            String number = "";
            while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                number = number + token.substring(0, 1);
                token = token.substring(1);
            }
            if (number.isEmpty()) {
                throw new IllegalArgumentException(MESSAGES.invalidFreeTimeExpectedDayOrNumber(original, 1 + original.lastIndexOf(token)));
            }
            if (number.length() > 2) {
                startHour = Integer.parseInt(number) / 100;
                startMin = Integer.parseInt(number) % 100;
            } else {
                startHour = Integer.parseInt(number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            if (token.startsWith(":")) {
                token = token.substring(1);
                while (token.startsWith(" ")) {
                    token = token.substring(1);
                }
                number = "";
                while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                    number = number + token.substring(0, 1);
                    token = token.substring(1);
                }
                if (number.isEmpty()) {
                    throw new IllegalArgumentException(MESSAGES.invalidFreeTimeExpectedNumber(original, 1 + original.lastIndexOf(token)));
                }
                startMin = Integer.parseInt(number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            boolean hasAmOrPm = false;
            if (token.toLowerCase().startsWith("am")) {
                token = token.substring(2);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("a")) {
                token = token.substring(1);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("pm")) {
                token = token.substring(2);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (token.toLowerCase().startsWith("p")) {
                token = token.substring(1);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (startHour < 7 && !hasAmOrPm) {
                startHour += 12;
            }
            if (startMin % 5 != 0) {
                startMin = 5 * ((startMin + 2) / 5);
            }
            if (startHour == 7 && startMin == 0 && !hasAmOrPm) {
                startHour += 12;
            }
            int endTime = startTime = (60 * startHour + startMin) / 5;
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            if (token.startsWith("-")) {
                int endHour = 0;
                int endMin = 0;
                token = token.substring(1);
                while (token.startsWith(" ")) {
                    token = token.substring(1);
                }
                number = "";
                while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                    number = number + token.substring(0, 1);
                    token = token.substring(1);
                }
                if (number.isEmpty()) {
                    throw new IllegalArgumentException(MESSAGES.invalidFreeTimeExpectedNumber(original, 1 + original.lastIndexOf(token)));
                }
                if (number.length() > 2) {
                    endHour = Integer.parseInt(number) / 100;
                    endMin = Integer.parseInt(number) % 100;
                } else {
                    endHour = Integer.parseInt(number);
                }
                while (token.startsWith(" ")) {
                    token = token.substring(1);
                }
                if (token.startsWith(":")) {
                    token = token.substring(1);
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    number = "";
                    while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                        number = number + token.substring(0, 1);
                        token = token.substring(1);
                    }
                    if (number.isEmpty()) {
                        throw new IllegalArgumentException(MESSAGES.invalidFreeTimeExpectedNumber(original, 1 + original.lastIndexOf(token)));
                    }
                    endMin = Integer.parseInt(number);
                }
                while (token.startsWith(" ")) {
                    token = token.substring(1);
                }
                hasAmOrPm = false;
                if (token.toLowerCase().startsWith("am")) {
                    token = token.substring(2);
                    hasAmOrPm = true;
                    if (endHour == 12) {
                        endHour += 12;
                    }
                }
                if (token.toLowerCase().startsWith("a")) {
                    token = token.substring(1);
                    hasAmOrPm = true;
                    if (endHour == 12) {
                        endHour += 12;
                    }
                }
                if (token.toLowerCase().startsWith("pm")) {
                    token = token.substring(2);
                    hasAmOrPm = true;
                    if (endHour < 12) {
                        endHour += 12;
                    }
                }
                if (token.toLowerCase().startsWith("p")) {
                    token = token.substring(1);
                    hasAmOrPm = true;
                    if (endHour < 12) {
                        endHour += 12;
                    }
                }
                if (endHour <= 7 && !hasAmOrPm) {
                    endHour += 12;
                }
                if (endMin % 5 != 0) {
                    endMin = 5 * ((endMin + 2) / 5);
                }
                endTime = (60 * endHour + endMin) / 5;
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            if (!token.isEmpty()) {
                throw new IllegalArgumentException(MESSAGES.invalidFreeTimeGeneric(original, 1 + original.lastIndexOf(token)));
            }
            if (days.isEmpty()) {
                days = lastDays;
            }
            if (days.isEmpty()) {
                for (int i3 = 0; i3 < CONSTANTS.freeTimeDays().length; ++i3) {
                    days.add(i3);
                }
            }
            if (startTime == endTime) {
                endTime += 6;
                if ((days.contains(0) || days.contains(2) || days.contains(4)) && !days.contains(1) && !days.contains(3)) {
                    if (startTime % 12 == 6) {
                        endTime += 6;
                    }
                } else if (!(!days.contains(1) && !days.contains(3) || days.contains(0) || days.contains(2) || days.contains(4))) {
                    if (startTime % 18 == 0) {
                        endTime += 12;
                    } else if (startTime % 18 == 6) {
                        endTime += 6;
                    }
                }
            }
            if (startTime < 0 || startTime > 288) {
                throw new IllegalArgumentException(MESSAGES.invalidFreeTimeInvalidStartTime(original));
            }
            if (endTime < 0 || endTime > 288) {
                throw new IllegalArgumentException(MESSAGES.invalidFreeTimeInvalidEndTime(original));
            }
            if (startTime >= endTime) {
                throw new IllegalArgumentException(MESSAGES.invalidFreeTimeStartNotBeforeEnd(original));
            }
            CourseRequestInterface.FreeTime f = new CourseRequestInterface.FreeTime();
            Iterator iterator = days.iterator();
            while (iterator.hasNext()) {
                int day = (Integer)iterator.next();
                f.addDay(day);
            }
            f.setStart(startTime);
            f.setLength(endTime - startTime);
            ret.add(f);
            lastDays = days;
        }
        return ret;
    }

    public String freeTimesToString(List<CourseRequestInterface.FreeTime> freeTimes) {
        String ret = "";
        String lastDays = null;
        for (CourseRequestInterface.FreeTime ft : freeTimes) {
            if (ret.length() > 0) {
                ret = ret + ", ";
            }
            String days = ft.getDaysString(CONSTANTS.shortDays(), "");
            if (ft.getDays().size() == CONSTANTS.freeTimeDays().length && !ft.getDays().contains(5) && !ft.getDays().contains(6)) {
                days = "";
            }
            ret = ret + (days.isEmpty() || days.equals(lastDays) ? "" : days + " ") + ft.getStartString(CONSTANTS.useAmPm()) + " - " + ft.getEndString(CONSTANTS.useAmPm());
            lastDays = days;
        }
        return CONSTANTS.freePrefix() + ret;
    }
}

