/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.unitime.timetable.gwt.client.aria.AriaCheckBox;
import org.unitime.timetable.gwt.client.aria.AriaHiddenLabel;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseFinderClasses
extends UniTimeTable<ClassAssignmentInterface.ClassAssignment>
implements CourseFinder.CourseFinderCourseDetails<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>> {
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private ClassAssignmentInterface.CourseAssignment iValue = null;
    private DataProvider<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>> iDataProvider = null;
    private Set<String> iSelectedClasses = new HashSet<String>();

    public CourseFinderClasses(boolean allowSelection) {
        this.setAllowSelection(allowSelection);
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        if (this.isAllowSelection()) {
            header.add(new UniTimeTableHeader(MESSAGES.colClassSelection()));
        }
        header.add(new UniTimeTableHeader(MESSAGES.colSubpart()));
        header.add(new UniTimeTableHeader(MESSAGES.colClass()));
        header.add(new UniTimeTableHeader(MESSAGES.colLimit()));
        header.add(new UniTimeTableHeader(MESSAGES.colDays()));
        header.add(new UniTimeTableHeader(MESSAGES.colStart()));
        header.add(new UniTimeTableHeader(MESSAGES.colEnd()));
        header.add(new UniTimeTableHeader(MESSAGES.colDate()));
        header.add(new UniTimeTableHeader(MESSAGES.colRoom()));
        header.add(new UniTimeTableHeader(MESSAGES.colInstructor()));
        header.add(new UniTimeTableHeader(MESSAGES.colParent()));
        header.add(new UniTimeTableHeader(MESSAGES.colHighDemand()));
        header.add(new UniTimeTableHeader(MESSAGES.colNoteIcon()));
        this.addRow(null, header);
        this.setEmptyMessage(MESSAGES.courseSelectionNoCourseSelected());
        if (this.isAllowSelection()) {
            this.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.ClassAssignment>(){

                @Override
                public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.ClassAssignment> event) {
                    CourseFinderClasses.this.selectClass(event.getRow(), CourseFinderClasses.this.isSelected(event.getRow()));
                }
            });
            this.addMouseDoubleClickListener(new UniTimeTable.MouseDoubleClickListener<ClassAssignmentInterface.ClassAssignment>(){

                @Override
                public void onMouseDoubleClick(UniTimeTable.TableEvent<ClassAssignmentInterface.ClassAssignment> event) {
                    CourseFinderClasses.this.selectClass(event.getRow(), CourseFinderClasses.this.isSelected(event.getRow()));
                }
            });
        }
    }

    public Widget asWidget() {
        return this;
    }

    public void setValue(ClassAssignmentInterface.CourseAssignment value) {
        if (value == null) {
            this.iValue = value;
            this.clearTable(1);
            this.setEmptyMessage(MESSAGES.courseSelectionNoCourseSelected());
        } else if (!value.equals(this.iValue)) {
            this.iValue = value;
            this.clearTable(1);
            this.setEmptyMessage(MESSAGES.courseSelectionLoadingClasses());
            this.iDataProvider.getData(value, new AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>>(){

                public void onFailure(Throwable caught) {
                    CourseFinderClasses.this.clearTable(1);
                    CourseFinderClasses.this.setEmptyMessage(caught.getMessage());
                }

                public void onSuccess(Collection<ClassAssignmentInterface.ClassAssignment> result) {
                    CourseFinderClasses.this.clearTable(1);
                    if (!result.isEmpty()) {
                        Long lastSubpartId = null;
                        for (final ClassAssignmentInterface.ClassAssignment clazz : result) {
                            int c;
                            ArrayList<Object> line = new ArrayList<Object>();
                            if (CourseFinderClasses.this.isAllowSelection()) {
                                if (!clazz.isCancelled() && (clazz.isSaved() || clazz.isAvailable())) {
                                    AriaCheckBox ch = new AriaCheckBox();
                                    ch.setValue(CourseFinderClasses.this.iSelectedClasses.contains(clazz.getSelection()));
                                    ch.setAriaLabel(ARIA.courseFinderPreferClass(MESSAGES.clazz(clazz.getSubject(), clazz.getCourseNbr(), clazz.getSubpart(), clazz.getSection())));
                                    ch.addClickHandler(new ClickHandler(){

                                        public void onClick(ClickEvent event) {
                                            event.stopPropagation();
                                        }
                                    });
                                    ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                                        public void onValueChange(ValueChangeEvent<Boolean> event) {
                                            CourseFinderClasses.this.setSelected(CourseFinderClasses.this.getRow(clazz.getClassId()), (Boolean)event.getValue());
                                            if (((Boolean)event.getValue()).booleanValue()) {
                                                CourseFinderClasses.this.iSelectedClasses.add(clazz.getSelection());
                                            } else {
                                                CourseFinderClasses.this.iSelectedClasses.remove(clazz.getSelection());
                                            }
                                        }
                                    });
                                    line.add(ch);
                                } else {
                                    line.add(new HTML("&nbsp;"));
                                }
                            }
                            line.add(new Label(clazz.getSubpart(), false));
                            line.add(new Label(clazz.getSection(), false));
                            line.add(new HTML(clazz.getLimitString(), false));
                            if (clazz.isAssigned()) {
                                line.add(new Label(clazz.getDaysString(CONSTANTS.shortDays()), false));
                                line.add(new Label(clazz.getStartString(CONSTANTS.useAmPm()), false));
                                line.add(new Label(clazz.getEndString(CONSTANTS.useAmPm()), false));
                            } else {
                                line.add(new ArrangeHours());
                            }
                            line.add(new Label(clazz.hasDatePattern() ? clazz.getDatePattern() : "", false));
                            line.add((Object)new Rooms(clazz.getRooms(), ","));
                            line.add((Object)new RoomsOrInstructors(clazz.getInstructors(), ","));
                            line.add(new Label(clazz.getParentSection() != null ? clazz.getParentSection() : ""));
                            line.add(clazz.isSaved() ? new WebTable.IconCell(RESOURCES.saved(), MESSAGES.saved(clazz.getSubpart() + " " + clazz.getSection()), null).getWidget() : (clazz.isCancelled() ? new WebTable.IconCell(RESOURCES.cancelled(), MESSAGES.classCancelled(clazz.getSubpart() + " " + clazz.getSection()), null).getWidget() : (clazz.isOfHighDemand() ? new WebTable.IconCell(RESOURCES.highDemand(), MESSAGES.highDemand(clazz.getExpected(), clazz.getAvailableLimit()), null).getWidget() : new Label())));
                            line.add(clazz.hasNote() && !clazz.getNote().equals(CourseFinderClasses.this.iValue.getNote()) ? new WebTable.IconCell(RESOURCES.note(), clazz.getNote(), "").getWidget() : new Label());
                            if (!clazz.isSaved() && !clazz.isAvailable()) {
                                line.add((Object)new AriaHiddenLabel(ARIA.courseFinderClassNotAvailable(MESSAGES.clazz(clazz.getSubject(), clazz.getCourseNbr(), clazz.getSubpart(), clazz.getSection()), clazz.isAssigned() ? clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + clazz.getRooms(",") : ARIA.arrangeHours())));
                            } else {
                                line.add((Object)new AriaHiddenLabel(ARIA.courseFinderClassAvailable(MESSAGES.clazz(clazz.getSubject(), clazz.getCourseNbr(), clazz.getSubpart(), clazz.getSection()), clazz.isAssigned() ? clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + clazz.getRooms(",") : ARIA.arrangeHours(), clazz.getLimitString())));
                            }
                            int row = CourseFinderClasses.this.addRow(clazz, line);
                            if (lastSubpartId != null && !clazz.getSubpartId().equals(lastSubpartId)) {
                                for (c = 0; c < CourseFinderClasses.this.getCellCount(row); ++c) {
                                    CourseFinderClasses.this.getCellFormatter().addStyleName(row, c, "top-border-dashed");
                                }
                            }
                            if (clazz.isCancelled() || !clazz.isSaved() && !clazz.isAvailable()) {
                                for (c = 0; c < CourseFinderClasses.this.getCellCount(row); ++c) {
                                    CourseFinderClasses.this.getCellFormatter().addStyleName(row, c, "text-gray");
                                }
                            }
                            if (CourseFinderClasses.this.isAllowSelection() && !clazz.isCancelled() && (clazz.isSaved() || clazz.isAvailable()) && CourseFinderClasses.this.iSelectedClasses.contains(clazz.getSelection())) {
                                CourseFinderClasses.this.setSelected(row, true);
                            }
                            lastSubpartId = clazz.getSubpartId();
                        }
                    } else {
                        CourseFinderClasses.this.setEmptyMessage(MESSAGES.courseSelectionNoClasses(MESSAGES.courseName(CourseFinderClasses.this.iValue.getSubject(), CourseFinderClasses.this.iValue.getCourseNbr())));
                    }
                }
            });
        }
    }

    public ClassAssignmentInterface.CourseAssignment getValue() {
        return this.iValue;
    }

    @Override
    public void setDataProvider(DataProvider<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>> provider) {
        this.iDataProvider = provider;
    }

    @Override
    public String getName() {
        return MESSAGES.courseSelectionClasses();
    }

    public Boolean isClassSelected(int row) {
        Widget w = this.getWidget(row, 0);
        if (w != null && w instanceof CheckBox) {
            return ((CheckBox)w).getValue();
        }
        return null;
    }

    public boolean isClassSelected(Long classId) {
        if (!this.isAllowSelection()) {
            return false;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            ClassAssignmentInterface.ClassAssignment record = (ClassAssignmentInterface.ClassAssignment)this.getData(row);
            if (record == null || !record.getClassId().equals(classId)) continue;
            return this.isClassSelected(row);
        }
        return false;
    }

    public int getRow(Long classId) {
        for (int row = 1; row < this.getRowCount(); ++row) {
            ClassAssignmentInterface.ClassAssignment record = (ClassAssignmentInterface.ClassAssignment)this.getData(row);
            if (record == null || !record.getClassId().equals(classId)) continue;
            return row;
        }
        return -1;
    }

    public void selectClass(Long classId, boolean value) {
        if (!this.isAllowSelection()) {
            return;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            ClassAssignmentInterface.ClassAssignment record = (ClassAssignmentInterface.ClassAssignment)this.getData(row);
            if (record == null || !record.getClassId().equals(classId)) continue;
            this.selectClass(row, value);
            break;
        }
    }

    public void selectClass(int row, boolean value) {
        Widget w = this.getWidget(row, 0);
        if (w != null && w instanceof CheckBox) {
            ((CheckBox)w).setValue(Boolean.valueOf(value));
            if (value) {
                this.iSelectedClasses.add(((ClassAssignmentInterface.ClassAssignment)this.getData(row)).getSelection());
            } else {
                this.iSelectedClasses.remove(((ClassAssignmentInterface.ClassAssignment)this.getData(row)).getSelection());
            }
        }
    }

    public CheckBox getClassSelection(int row) {
        Widget w = this.getWidget(row, 0);
        if (w != null && w instanceof CheckBox) {
            return (CheckBox)w;
        }
        return null;
    }

    @Override
    public boolean isCanSelectRow(int row) {
        return this.getClassSelection(row) != null;
    }

    @Override
    public void onSetValue(CourseRequestInterface.RequestedCourse course) {
        this.iSelectedClasses.clear();
        if (course != null && course.hasSelectedClasses()) {
            this.iSelectedClasses.addAll(course.getSelectedClasses());
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            ClassAssignmentInterface.ClassAssignment a = (ClassAssignmentInterface.ClassAssignment)this.getData(row);
            CheckBox ch = this.getClassSelection(row);
            if (ch == null || a == null) continue;
            ch.setValue(Boolean.valueOf(this.iSelectedClasses.contains(a.getSelection())));
            this.setSelected(row, this.iSelectedClasses.contains(a.getSelection()));
        }
    }

    @Override
    public void onGetValue(CourseRequestInterface.RequestedCourse course) {
        course.setSelectedClasses(null);
        for (int row = 1; row < this.getRowCount(); ++row) {
            Widget w;
            ClassAssignmentInterface.ClassAssignment clazz = (ClassAssignmentInterface.ClassAssignment)this.getData(row);
            if (clazz == null || (w = this.getWidget(row, 0)) == null || !(w instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
            course.setSelectedClass(clazz.getSelection(), true);
        }
    }

    public static class ArrangeHours
    extends HTML
    implements UniTimeTable.HasColSpan {
        public ArrangeHours() {
            super(MESSAGES.arrangeHours(), false);
        }

        public int getColSpan() {
            return 3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Rooms
    extends P {
        public Rooms(List<ClassAssignmentInterface.IdValue> list, String delimiter) {
            super("itemize");
            if (list != null) {
                Iterator<ClassAssignmentInterface.IdValue> i = list.iterator();
                while (i.hasNext()) {
                    final P p = new P((Element)DOM.createSpan(), "item");
                    final ClassAssignmentInterface.IdValue room = i.next();
                    p.setText(room.getValue() + (i.hasNext() ? delimiter : ""));
                    if (room.getId() != null) {
                        p.addMouseOverHandler(new MouseOverHandler(){

                            public void onMouseOver(MouseOverEvent event) {
                                RoomHint.showHint((Element)p.getElement(), room.getId(), null, null, true);
                            }
                        });
                        p.addMouseOutHandler(new MouseOutHandler(){

                            public void onMouseOut(MouseOutEvent event) {
                                RoomHint.hideHint();
                            }
                        });
                    }
                    this.add((Widget)p);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoomsOrInstructors
    extends P {
        public RoomsOrInstructors(List<String> list, String delimiter) {
            super("itemize");
            if (list != null) {
                Iterator<String> i = list.iterator();
                while (i.hasNext()) {
                    P p = new P((Element)DOM.createSpan(), "item");
                    p.setText(i.next() + (i.hasNext() ? delimiter : ""));
                    this.add((Widget)p);
                }
            }
        }
    }
}

