/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.user.client.Cookies;
import java.util.Date;

public class SectioningStatusCookie {
    private static SectioningStatusCookie sInstance = null;
    private int iOnlineTab = 0;
    private int iBashTab = 0;
    private String iOnlineQuery = "";
    private String iBashQuery = "";
    private int[] iSortBy = new int[]{0, 0, 0, 0, 0, 0};

    private SectioningStatusCookie() {
        try {
            String cookie = Cookies.getCookie((String)"UniTime:StudentStatus");
            if (cookie != null) {
                String[] params = cookie.split("\\|");
                int idx = 0;
                this.iOnlineTab = Integer.parseInt(params[idx++]);
                this.iOnlineQuery = params[idx++];
                this.iBashTab = Integer.parseInt(params[idx++]);
                this.iBashQuery = params[idx++];
                for (int i = 0; i < this.iSortBy.length; ++i) {
                    this.iSortBy[i] = Integer.parseInt(params[idx++]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static SectioningStatusCookie getInstance() {
        if (sInstance == null) {
            sInstance = new SectioningStatusCookie();
        }
        return sInstance;
    }

    private void save() {
        String cookie = this.iOnlineTab + "|" + this.iOnlineQuery + "|" + this.iBashTab + "|" + this.iBashQuery;
        for (int i = 0; i < this.iSortBy.length; ++i) {
            cookie = cookie + "|" + this.iSortBy[i];
        }
        Date expires = new Date(new Date().getTime() + 604800000L);
        Cookies.setCookie((String)"UniTime:StudentStatus", (String)cookie, (Date)expires);
    }

    public String getQuery(boolean online) {
        return online ? this.iOnlineQuery : this.iBashQuery;
    }

    public int getTab(boolean online) {
        return online ? this.iOnlineTab : this.iBashTab;
    }

    public void setQueryTab(boolean online, String query, int tab) {
        if (online) {
            this.iOnlineQuery = query;
            this.iOnlineTab = tab;
        } else {
            this.iBashQuery = query;
            this.iBashTab = tab;
        }
        this.save();
    }

    public int getSortBy(boolean online, int tab) {
        return this.iSortBy[online ? tab : 3 + tab];
    }

    public void setSortBy(boolean online, int tab, int ord) {
        this.iSortBy[online ? tab : 3 + tab] = ord;
        this.save();
    }
}

