/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.reservations;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.ReservationInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictionsTable
extends UniTimeTable<Node> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private UniTimeWidget<UniTimeTextBox> iLimit;
    private ReservationInterface.Offering iOffering = null;
    private Map<Long, Node> iConfigs = new HashMap<Long, Node>();
    private Map<Long, Node> iClasses = new HashMap<Long, Node>();

    public RestrictionsTable(UniTimeWidget<UniTimeTextBox> limit) {
        this.iLimit = limit;
        this.iLimit.getWidget().addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                RestrictionsTable.this.computeLimit();
            }
        });
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        header.add(new UniTimeTableHeader(MESSAGES.colConfigOrClass()));
        header.add(new UniTimeTableHeader(MESSAGES.colExternalId()));
        header.add(new UniTimeTableHeader(MESSAGES.colLimit()));
        header.add(new UniTimeTableHeader(MESSAGES.colTime()));
        header.add(new UniTimeTableHeader(MESSAGES.colDate()));
        header.add(new UniTimeTableHeader(MESSAGES.colRoom()));
        header.add(new UniTimeTableHeader(MESSAGES.colInstructor()));
        this.addRow(null, header);
        this.setAllowSelection(true);
        this.addMouseClickListener(new UniTimeTable.MouseClickListener<Node>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<Node> event) {
                RestrictionsTable.this.selectRow(event.getRow(), RestrictionsTable.this.isSelected(event.getRow()));
            }
        });
        this.setVisible(false);
        this.setStyleName("unitime-RestrictionsTable");
    }

    public void clear() {
        this.clearTable(1);
        this.iConfigs.clear();
        this.iClasses.clear();
        this.iOffering = null;
        this.setVisible(false);
    }

    public void setOffering(ReservationInterface.Offering offering) {
        this.clear();
        this.iOffering = offering;
        for (ReservationInterface.Config config : offering.getConfigs()) {
            this.addConfig(config);
        }
        this.computeLimit();
        this.setVisible(true);
        boolean hasInstructor = false;
        boolean hasAssignment = false;
        boolean hasExternalId = false;
        for (ReservationInterface.Config config : offering.getConfigs()) {
            for (ReservationInterface.Subpart subpart : config.getSubparts()) {
                for (ReservationInterface.Clazz clazz : subpart.getClasses()) {
                    if (clazz.hasInstructor()) {
                        hasInstructor = true;
                    }
                    if (clazz.hasTime() || clazz.hasRoom() || clazz.hasDate() || clazz.isCancelled()) {
                        hasAssignment = true;
                    }
                    if (!clazz.hasExternalId()) continue;
                    hasExternalId = true;
                }
            }
            if (!config.hasInstructionalMethod()) continue;
            hasExternalId = true;
        }
        this.setColumnVisible(1, hasExternalId);
        this.setColumnVisible(3, hasAssignment);
        this.setColumnVisible(4, hasAssignment);
        this.setColumnVisible(5, hasAssignment);
        this.setColumnVisible(6, hasInstructor);
    }

    private void addConfig(ReservationInterface.Config config) {
        ArrayList<Object> line = new ArrayList<Object>();
        Node node = new Node(null, MESSAGES.labelConfiguration(config.getAbbv()), config);
        line.add((Object)node);
        line.add(new Label(config.hasInstructionalMethod() ? config.getInstructionalMethod() : ""));
        line.add(new UniTimeTable.NumberCell(config.getLimit() == null ? MESSAGES.configUnlimited() : config.getLimit().toString()));
        line.add(new Label(""));
        line.add(new Label(""));
        line.add(new Label(""));
        line.add(new Label(""));
        this.iConfigs.put(config.getId(), node);
        node.setRow(this.addRow(node, line));
        for (ReservationInterface.Subpart subpart : config.getSubparts()) {
            if (subpart.getParentId() != null) continue;
            this.addClasses(node, subpart, null);
        }
    }

    protected void addClasses(Node node, ReservationInterface.Subpart subpart, Long parent) {
        for (ReservationInterface.Clazz clazz : subpart.getClasses()) {
            if (parent != null && !parent.equals(clazz.getParentId())) continue;
            Node classNode = this.addClass(node, clazz);
            for (ReservationInterface.Subpart child : subpart.getConfig().getSubparts()) {
                if (!subpart.getId().equals(child.getParentId())) continue;
                this.addClasses(classNode, child, clazz.getId());
            }
        }
    }

    protected Node addClass(Node parent, ReservationInterface.Clazz clazz) {
        ArrayList<Object> line = new ArrayList<Object>();
        Node node = new Node(parent, clazz.getAbbv(), clazz);
        line.add((Object)node);
        line.add(new Label(clazz.hasExternalId() ? clazz.getExternalId() : ""));
        line.add(new UniTimeTable.NumberCell(clazz.getLimit() == null ? "" : clazz.getLimit().toString()));
        if (clazz.isCancelled()) {
            line.add(new CancelledCell());
        } else {
            line.add(new Label(clazz.hasTime() ? clazz.getTime() : ""));
            line.add(new Label(clazz.hasDate() ? clazz.getDate() : ""));
            line.add(new Label(clazz.hasRoom() ? clazz.getRoom() : ""));
        }
        line.add(new Label(clazz.hasInstructor() ? clazz.getInstructor() : ""));
        node.setRow(this.addRow(node, line));
        if (clazz.isCancelled()) {
            for (Widget widget : line) {
                widget.addStyleName("cancelled");
            }
        }
        this.iClasses.put(clazz.getId(), node);
        parent.addChildNode(node);
        return node;
    }

    public void selectRow(int row, boolean value) {
        Node node = (Node)((Object)this.getData(row));
        if (node != null && node.isEnabled()) {
            node.setValue(value);
        } else if (value) {
            this.selectRow(row, false);
        }
    }

    public void populate(ReservationInterface reservation) {
        Node node;
        for (ReservationInterface.Config config : reservation.getConfigs()) {
            node = this.iConfigs.get(config.getId());
            if (node == null) continue;
            node.setValue(true);
        }
        for (ReservationInterface.Clazz clazz : reservation.getClasses()) {
            node = this.iClasses.get(clazz.getId());
            if (node == null) continue;
            node.setValue(true);
            for (Node p = node.getParentNode(); p != null; p = p.getParentNode()) {
                p.setOpened(true);
            }
        }
    }

    public void validate(ReservationInterface reservation) {
        ReservationInterface.IdName c;
        for (Node config : this.iConfigs.values()) {
            if (!config.getValue().booleanValue() || !config.isEnabled()) continue;
            c = new ReservationInterface.Config();
            c.setId(config.getConfig().getId());
            c.setName(config.getConfig().getName());
            reservation.getConfigs().add((ReservationInterface.Config)c);
        }
        for (Node clazz : this.iClasses.values()) {
            if (!clazz.getValue().booleanValue() || !clazz.isEnabled()) continue;
            c = new ReservationInterface.Clazz();
            c.setId(clazz.getClazz().getId());
            c.setName(clazz.getClazz().getName());
            reservation.getClasses().add((ReservationInterface.Clazz)c);
        }
    }

    public void computeLimit() {
        if (this.iOffering == null) {
            this.iLimit.clearHint();
        }
        int total = 0;
        int limit = -1;
        boolean totalUnlimited = false;
        boolean unlimited = false;
        for (ReservationInterface.Config config : this.iOffering.getConfigs()) {
            for (ReservationInterface.Subpart subpart : config.getSubparts()) {
                int lim = 0;
                boolean selected = false;
                for (ReservationInterface.Clazz clazz : subpart.getClasses()) {
                    Node node = this.iClasses.get(clazz.getId());
                    if (!node.getValue().booleanValue()) continue;
                    lim += clazz.getLimit().intValue();
                    selected = true;
                }
                if (!selected || limit >= 0 && limit <= lim) continue;
                limit = lim;
            }
        }
        int lim = 0;
        boolean selected = false;
        for (ReservationInterface.Config config : this.iOffering.getConfigs()) {
            Node cfg;
            if (config.getLimit() == null) {
                totalUnlimited = true;
            } else {
                total += config.getLimit().intValue();
            }
            if ((cfg = this.iConfigs.get(config.getId())) == null || !cfg.getValue().booleanValue()) continue;
            selected = true;
            if (cfg.getConfig().getLimit() == null) {
                unlimited = true;
                continue;
            }
            lim += cfg.getConfig().getLimit().intValue();
        }
        if (selected && (limit < 0 || limit > lim)) {
            limit = lim;
        }
        int entered = Integer.MAX_VALUE;
        try {
            entered = Integer.parseInt(this.iLimit.getWidget().getValue());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (limit >= 0 || unlimited) {
            if (unlimited || limit >= entered) {
                this.iLimit.clearHint();
            } else {
                this.iLimit.setHint(limit == 0 ? MESSAGES.hintNoSpaceSelected() : (limit == 1 ? MESSAGES.hintOnlyOneSpaceSelected() : MESSAGES.hintOnlyNSpacesSelected(limit)));
            }
        } else if (!this.iOffering.isOffered()) {
            this.iLimit.setHint(MESSAGES.hintCourseNotOffered(this.iOffering.getAbbv()));
        } else if (totalUnlimited || total >= entered || entered == Integer.MAX_VALUE) {
            this.iLimit.clearHint();
        } else {
            this.iLimit.setHint(total == 0 ? MESSAGES.hintNoSpaceInCourse(this.iOffering.getAbbv()) : (total == 1 ? MESSAGES.hintOnlyOneSpaceInCourse(this.iOffering.getAbbv()) : MESSAGES.hintOnlyNSpacesInCourse(total, this.iOffering.getAbbv())));
        }
    }

    private class CancelledCell
    extends Label
    implements UniTimeTable.HasColSpan,
    UniTimeTable.HasCellAlignment {
        public CancelledCell() {
            super(MESSAGES.reservationCancelledClass());
        }

        public int getColSpan() {
            return 3;
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_CENTER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Node
    extends P
    implements HasValue<Boolean>,
    HasEnabled {
        private Image iImage;
        private ReservationInterface.IdName iItem;
        private CheckBox iCheck;
        private Node iParent;
        private List<Node> iChildren;
        private boolean iOpened;
        private int iRow;

        public Node(Node parent, String name, ReservationInterface.IdName item) {
            super("unitime-RestrictionsNode");
            this.iParent = null;
            this.iChildren = new ArrayList<Node>();
            this.iOpened = false;
            this.iRow = -1;
            this.iImage = new Image();
            this.iImage.addStyleName("tree-icon");
            this.iItem = item;
            this.iParent = parent;
            this.iCheck = new CheckBox(name);
            this.iCheck.addStyleName("check-box");
            this.update();
            this.iImage.getElement().getStyle().setPaddingLeft((double)(16 * this.getIndent()), Style.Unit.PX);
            this.iCheck.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            this.iCheck.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (Node.this.iRow >= 0) {
                        RestrictionsTable.this.setSelected(Node.this.iRow, (Boolean)event.getValue());
                    }
                    Node.this.propagate();
                }
            });
            this.add((Widget)this.iImage);
            this.add((Widget)this.iCheck);
            this.iCheck.addKeyDownHandler(new KeyDownHandler(){

                public void onKeyDown(KeyDownEvent event) {
                    switch (event.getNativeKeyCode()) {
                        case 39: {
                            if (!Node.this.getChildrenNodes().isEmpty()) {
                                if (!Node.this.isOpened()) {
                                    Node.this.setOpened(true);
                                } else {
                                    for (Node n : Node.this.getChildrenNodes()) {
                                        if (!n.isEnabled() || !n.isNodeVisible()) continue;
                                        n.getCheckBox().setFocus(true);
                                        break;
                                    }
                                }
                            }
                            event.preventDefault();
                            break;
                        }
                        case 37: {
                            if (!Node.this.getChildrenNodes().isEmpty()) {
                                if (Node.this.isOpened()) {
                                    Node.this.setOpened(false);
                                } else if (Node.this.hasParentNode()) {
                                    Node.this.getParentNode().getCheckBox().setFocus(true);
                                }
                            } else if (Node.this.hasParentNode()) {
                                Node.this.getParentNode().getCheckBox().setFocus(true);
                            }
                            event.preventDefault();
                            break;
                        }
                        case 38: {
                            for (int r = Node.this.iRow - 1; r > 0; --r) {
                                Node n = (Node)((Object)RestrictionsTable.this.getData(r));
                                if (!n.isEnabled() || !n.isNodeVisible()) continue;
                                n.getCheckBox().setFocus(true);
                                break;
                            }
                            event.preventDefault();
                            break;
                        }
                        case 40: {
                            for (int r = Node.this.iRow + 1; r < RestrictionsTable.this.getRowCount(); ++r) {
                                Node n = (Node)((Object)RestrictionsTable.this.getData(r));
                                if (!n.isEnabled() || !n.isNodeVisible()) continue;
                                n.getCheckBox().setFocus(true);
                                break;
                            }
                            event.preventDefault();
                        }
                    }
                }
            });
        }

        public ReservationInterface.Clazz getClazz() {
            return (ReservationInterface.Clazz)this.iItem;
        }

        public ReservationInterface.Config getConfig() {
            return (ReservationInterface.Config)this.iItem;
        }

        public boolean isConfig() {
            return this.iParent == null;
        }

        public boolean isClazz() {
            return this.iParent != null;
        }

        public Node getParentNode() {
            return this.iParent;
        }

        public boolean hasParentNode() {
            return this.iParent != null;
        }

        public List<Node> getChildrenNodes() {
            return this.iChildren;
        }

        public CheckBox getCheckBox() {
            return this.iCheck;
        }

        public void addChildNode(Node node) {
            this.iChildren.add(node);
            this.update();
            if (this.iChildren.size() == 1) {
                this.iImage.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        Node.this.setOpened(!Node.this.isOpened());
                    }
                });
            }
        }

        public void setRow(int row) {
            this.iRow = row;
        }

        public int getRow() {
            return this.iRow;
        }

        protected int getIndent() {
            int ret = 0;
            Node p = this.iParent;
            while (p != null) {
                ++ret;
                p = p.iParent;
            }
            return ret;
        }

        public boolean isNodeVisible() {
            Node p = this.iParent;
            while (p != null) {
                if (!p.isOpened()) {
                    return false;
                }
                p = p.iParent;
            }
            return true;
        }

        protected void update() {
            if (this.iChildren.isEmpty()) {
                this.iImage.setResource(RESOURCES.treeLeaf());
            } else if (this.iOpened) {
                this.iImage.setResource(RESOURCES.treeOpen());
            } else {
                this.iImage.setResource(RESOURCES.treeClosed());
            }
            if (this.iRow >= 0) {
                RestrictionsTable.this.getRowFormatter().setVisible(this.iRow, this.isNodeVisible());
            }
            for (Node child : this.iChildren) {
                child.update();
            }
        }

        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) {
            return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
        }

        public boolean isOpened() {
            return this.iOpened;
        }

        public void setOpened(boolean opened) {
            this.iOpened = opened;
            this.update();
        }

        public Boolean getValue() {
            return this.iCheck.getValue();
        }

        public void setValue(Boolean value) {
            this.setValue(value, true);
        }

        public void setValue(Boolean value, boolean fireEvents) {
            this.iCheck.setValue(value);
            if (this.iRow >= 0) {
                RestrictionsTable.this.setSelected(this.iRow, value != false && this.isEnabled());
            }
            if (fireEvents) {
                this.propagate();
                ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
            }
        }

        public boolean isEnabled() {
            return this.iCheck.isEnabled();
        }

        public void setEnabled(boolean enabled) {
            this.iCheck.setEnabled(enabled);
            if (this.iRow >= 0) {
                RestrictionsTable.this.setSelected(this.iRow, this.getValue() != false && this.isEnabled());
            }
        }

        private void propagate() {
            this.propagateDown();
            this.propagateUp();
            RestrictionsTable.this.computeLimit();
        }

        private void propagateDown() {
            for (Node child : this.getChildrenNodes()) {
                child.setEnabled(this.getValue() == false);
                child.setValue(this.getValue(), false);
                child.propagateDown();
            }
        }

        private void propagateUp() {
            if (this.hasParentNode()) {
                if (!this.getValue().booleanValue()) {
                    for (Node c : this.getParentNode().getChildrenNodes()) {
                        if (!c.getValue().booleanValue()) continue;
                        return;
                    }
                }
                this.getParentNode().setEnabled(this.getValue() == false);
                this.getParentNode().setValue(this.getValue(), false);
                this.getParentNode().propagateUp();
            }
        }
    }
}

