/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.page;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MenuItemSeparator;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.Pages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeMenu;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.MenuInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniTimeMenuBar
extends UniTimeMenu {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private MenuBar iMenu = new MenuBar();
    private SimplePanel iSimple = null;
    private int iLastScrollLeft = 0;
    private int iLastScrollTop = 0;
    private int iLastClientWidth = 0;
    private Timer iMoveTimer;
    private HandlerRegistration iPageLabelRegistration = null;

    public UniTimeMenuBar(boolean absolute) {
        this.iMenu.addStyleName("unitime-NoPrint");
        this.iMenu.addStyleName("unitime-Menu");
        this.initWidget((Widget)this.iMenu);
        if (absolute) {
            this.iMenu.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            this.move(false);
            this.iMoveTimer = new Timer(){

                public void run() {
                    UniTimeMenuBar.this.move(true);
                }
            };
            Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

                public void onResize(ResizeEvent event) {
                    UniTimeMenuBar.this.delayedMove();
                }
            });
            Window.addWindowScrollHandler((Window.ScrollHandler)new Window.ScrollHandler(){

                public void onWindowScroll(Window.ScrollEvent event) {
                    UniTimeMenuBar.this.delayedMove();
                }
            });
            Client.addGwtPageChangedHandler(new Client.GwtPageChangedHandler(){

                public void onChange(Client.GwtPageChangeEvent event) {
                    UniTimeMenuBar.this.delayedMove();
                }
            });
            this.iSimple = new SimplePanel();
            this.iSimple.getElement().getStyle().setHeight(23.0, Style.Unit.PX);
            new Timer(){

                public void run() {
                    UniTimeMenuBar.this.delayedMove();
                }
            }.scheduleRepeating(5000);
        }
    }

    private void attach(final RootPanel rootPanel) {
        RPC.execute(new MenuInterface.MenuRpcRequest(), new AsyncCallback<GwtRpcResponseList<MenuInterface>>(){

            public void onSuccess(GwtRpcResponseList<MenuInterface> result) {
                UniTimeMenuBar.this.initMenu(UniTimeMenuBar.this.iMenu, result, 0);
                if (UniTimeMenuBar.this.iSimple != null) {
                    rootPanel.add((Widget)UniTimeMenuBar.this.iSimple);
                }
                rootPanel.add((Widget)UniTimeMenuBar.this);
                if (UniTimeMenuBar.this.iSimple != null) {
                    UniTimeMenuBar.this.iSimple.setHeight(UniTimeMenuBar.this.iMenu.getOffsetHeight() + "px");
                }
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    @Override
    public void reload() {
        RPC.execute(new MenuInterface.MenuRpcRequest(), new AsyncCallback<GwtRpcResponseList<MenuInterface>>(){

            public void onSuccess(GwtRpcResponseList<MenuInterface> result) {
                UniTimeMenuBar.this.iMenu.clearItems();
                if (UniTimeMenuBar.this.iPageLabelRegistration != null) {
                    UniTimeMenuBar.this.iPageLabelRegistration.removeHandler();
                    UniTimeMenuBar.this.iPageLabelRegistration = null;
                }
                UniTimeMenuBar.this.initMenu(UniTimeMenuBar.this.iMenu, result, 0);
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    private void move(boolean show) {
        this.iLastClientWidth = Window.getClientWidth();
        this.iLastScrollLeft = Window.getScrollLeft();
        this.iLastScrollTop = Window.getScrollTop();
        this.iMenu.getElement().getStyle().setWidth((double)(this.iLastClientWidth - 2), Style.Unit.PX);
        this.iMenu.getElement().getStyle().setLeft((double)this.iLastScrollLeft, Style.Unit.PX);
        this.iMenu.getElement().getStyle().setTop((double)this.iLastScrollTop, Style.Unit.PX);
        this.iMenu.setVisible(true);
    }

    private boolean needsMove() {
        return this.iLastClientWidth != Window.getClientWidth() || this.iLastScrollLeft != Window.getScrollLeft() || this.iLastScrollTop != Window.getScrollTop();
    }

    private void delayedMove() {
        if (this.needsMove()) {
            this.iMenu.setVisible(false);
            this.iMoveTimer.schedule(100);
        }
    }

    private void initMenu(MenuBar menu, List<MenuInterface> items, int level) {
        final MenuInterface.ValueEncoder encoder = new MenuInterface.ValueEncoder(){

            public String encode(String value) {
                return URL.encodeQueryString((String)value);
            }
        };
        MenuItemSeparator lastSeparator = null;
        for (final MenuInterface item : items) {
            MenuItem m;
            MenuInterface.PageNameInterface name;
            if (item.isSeparator()) {
                lastSeparator = new MenuItemSeparator();
                menu.addSeparator(lastSeparator);
                continue;
            }
            if (item.hasSubMenus()) {
                if (!item.hasPage()) {
                    MenuBar m2 = new MenuBar(true);
                    this.initMenu(m2, item.getSubMenus(), level + 1);
                    menu.addItem(new MenuItem(item.getName().replace(" ", "&nbsp;"), true, m2));
                    continue;
                }
                if ("PAGE_HELP".equals(item.getPage())) {
                    name = UniTimePageLabel.getInstance().getValue();
                    m = new MenuItem(item.getName().replace(" ", "&nbsp;"), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            MenuInterface.PageNameInterface name = UniTimePageLabel.getInstance().getValue();
                            if (name.hasHelpUrl()) {
                                UniTimeMenuBar.this.openUrl(MESSAGES.pageHelp(name.getName()), name.getHelpUrl(), item.getTarget());
                            }
                        }
                    });
                    m.setEnabled(name.hasHelpUrl());
                    this.iPageLabelRegistration = UniTimePageLabel.getInstance().addValueChangeHandler(new ValueChangeHandler<MenuInterface.PageNameInterface>(){

                        public void onValueChange(ValueChangeEvent<MenuInterface.PageNameInterface> event) {
                            m.setEnabled(((MenuInterface.PageNameInterface)event.getValue()).hasHelpUrl());
                        }
                    });
                    menu.addItem(m);
                    this.initMenu(menu, item.getSubMenus(), level);
                    continue;
                }
                menu.addItem(new MenuItem(item.getName().replace(" ", "&nbsp;"), true, (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        if (item.hasPage()) {
                            UniTimeMenuBar.this.openUrl(item.getName(), item.getURL(encoder), item.getTarget());
                        }
                    }
                }));
                this.initMenu(menu, item.getSubMenus(), level);
                continue;
            }
            if ("PAGE_HELP".equals(item.getPage())) {
                name = UniTimePageLabel.getInstance().getValue();
                m = new MenuItem(item.getName().replace(" ", "&nbsp;"), true, (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        MenuInterface.PageNameInterface name = UniTimePageLabel.getInstance().getValue();
                        if (name.hasHelpUrl()) {
                            UniTimeMenuBar.this.openUrl(MESSAGES.pageHelp(name.getName()), name.getHelpUrl(), item.getTarget());
                        }
                    }
                });
                m.setEnabled(name.hasHelpUrl());
                this.iPageLabelRegistration = UniTimePageLabel.getInstance().addValueChangeHandler(new ValueChangeHandler<MenuInterface.PageNameInterface>(){

                    public void onValueChange(ValueChangeEvent<MenuInterface.PageNameInterface> event) {
                        m.setEnabled(((MenuInterface.PageNameInterface)event.getValue()).hasHelpUrl());
                    }
                });
                menu.addItem(m);
                continue;
            }
            menu.addItem(new MenuItem(item.getName().replace(" ", "&nbsp;"), true, (Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    if (item.hasPage()) {
                        UniTimeMenuBar.this.openUrl(item.getName(), item.getURL(encoder), item.getTarget());
                    }
                }
            }));
        }
        if (level == 0 && lastSeparator != null) {
            lastSeparator.setStyleName("unitime-BlankSeparator");
            lastSeparator.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        }
    }

    protected void openUrl(String name, String url, String target) {
        if (target == null) {
            LoadingWidget.getInstance().show();
        }
        if ("dialog".equals(target)) {
            UniTimeFrameDialog.openDialog(name, url);
        } else if ("eval".equals(target)) {
            ToolBox.eval(url);
        } else if ("download".equals(target)) {
            ToolBox.open(url);
        } else {
            ToolBox.open(GWT.getHostPageBaseURL() + url);
        }
    }

    protected void openPage(String page) {
        try {
            for (Pages p : Pages.values()) {
                if (!p.name().equals(page)) continue;
                LoadingWidget.getInstance().setMessage(MESSAGES.waitLoading(p.name(MESSAGES)));
                UniTimePageLabel.getInstance().setPageName(p.name(MESSAGES));
                RootPanel.get((String)"UniTimeGWT:Body").add(p.widget());
                return;
            }
            Label error = new Label(page == null ? MESSAGES.failedToLoadPageNotProvided() : MESSAGES.failedToLoadPageNotRegistered(page));
            error.setStyleName("unitime-ErrorMessage");
            RootPanel.get((String)"UniTimeGWT:Body").add((Widget)error);
        }
        catch (Exception e) {
            Label error = new Label(MESSAGES.failedToLoadPage(e.getMessage()));
            error.setStyleName("unitime-ErrorMessage");
            RootPanel.get((String)"UniTimeGWT:Body").add((Widget)error);
            UniTimeNotifications.error(MESSAGES.failedToLoadPage(e.getMessage()), e);
        }
    }

    public void insert(RootPanel panel) {
        if ("hide".equals(Window.Location.getParameter((String)"menu"))) {
            panel.setVisible(false);
        } else {
            this.attach(panel);
        }
    }
}

