/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaSuggestBox;
import org.unitime.timetable.gwt.client.events.UniTimeFilterBox;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeachingRequestsFilterBox
extends UniTimeFilterBox<InstructorInterface.TeachingRequestsFilterRpcRequest> {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private Boolean iAssigned;
    private ListBox iDepartments;
    private String iDepartmentAttribute;
    private String iDepartmentTag;
    private AriaSuggestBox iCourse;
    private FilterBox.Chip iLastCourse;
    private AriaSuggestBox iInstructor;
    private FilterBox.Chip iLastInstructor;

    public TeachingRequestsFilterBox(Boolean assigned) {
        super(null);
        this.iAssigned = assigned;
        this.setShowSuggestionsOnFocus(false);
        this.iDepartmentAttribute = assigned != null ? "subject" : "department";
        this.iDepartmentTag = assigned != null ? MESSAGES.tagSubjectArea() : MESSAGES.tagDepartment();
        this.iDepartments = new ListBox();
        this.iDepartments.setMultipleSelect(false);
        this.iDepartments.setWidth("100%");
        this.addFilter(new FilterBox.CustomFilter(this.iDepartmentAttribute, this.iDepartmentTag, new Widget[]{this.iDepartments}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    FilterBox.Chip oldChip = TeachingRequestsFilterBox.this.getChip(TeachingRequestsFilterBox.this.iDepartmentAttribute);
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    for (int i = 0; i < TeachingRequestsFilterBox.this.iDepartments.getItemCount(); ++i) {
                        FilterBox.Chip chip = new FilterBox.Chip(TeachingRequestsFilterBox.this.iDepartmentAttribute, TeachingRequestsFilterBox.this.iDepartments.getValue(i)).withTranslatedCommand(TeachingRequestsFilterBox.this.iDepartmentTag);
                        String name = TeachingRequestsFilterBox.this.iDepartments.getItemText(i);
                        if (TeachingRequestsFilterBox.this.iDepartments.getValue(i).toLowerCase().startsWith(text.toLowerCase())) {
                            suggestions.add(new FilterBox.Suggestion(name, chip, oldChip));
                            continue;
                        }
                        if (text.length() <= 2 || !name.toLowerCase().contains(" " + text.toLowerCase()) && !name.toLowerCase().contains(" (" + text.toLowerCase())) continue;
                        suggestions.add(new FilterBox.Suggestion(name, chip, oldChip));
                    }
                    callback.onSuccess(suggestions);
                }
            }
        });
        this.iDepartments.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FilterBox.Chip newChip;
                FilterBox.Chip oldChip = TeachingRequestsFilterBox.this.getChip(TeachingRequestsFilterBox.this.iDepartmentAttribute);
                FilterBox.Chip chip = newChip = TeachingRequestsFilterBox.this.iDepartments.getSelectedIndex() <= 0 ? null : new FilterBox.Chip(TeachingRequestsFilterBox.this.iDepartmentAttribute, TeachingRequestsFilterBox.this.iDepartments.getValue(TeachingRequestsFilterBox.this.iDepartments.getSelectedIndex())).withTranslatedCommand(TeachingRequestsFilterBox.this.iDepartmentTag);
                if (oldChip != null) {
                    if (newChip == null) {
                        TeachingRequestsFilterBox.this.removeChip(oldChip, true);
                    } else if (!oldChip.getValue().equals(newChip.getValue())) {
                        TeachingRequestsFilterBox.this.removeChip(oldChip, false);
                        TeachingRequestsFilterBox.this.addChip(newChip, true);
                    }
                } else if (newChip != null) {
                    TeachingRequestsFilterBox.this.addChip(newChip, true);
                }
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("course", MESSAGES.tagCourse(), new String[0]));
        Label courseLab = new Label(MESSAGES.propCourse());
        this.iCourse = new AriaSuggestBox(new CourseOracle());
        this.iCourse.setStyleName("unitime-TextArea");
        this.iCourse.setWidth("200px");
        this.addFilter(new FilterBox.StaticSimpleFilter("course", MESSAGES.tagCourse(), new String[0]));
        this.iCourse.getValueBox().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TeachingRequestsFilterBox.this.courseChanged(true);
            }
        });
        this.iCourse.getValueBox().addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        TeachingRequestsFilterBox.this.courseChanged(false);
                    }
                });
            }
        });
        this.iCourse.getValueBox().addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 8) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            TeachingRequestsFilterBox.this.courseChanged(false);
                        }
                    });
                }
            }
        });
        this.iCourse.getValueBox().addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                TeachingRequestsFilterBox.this.courseChanged(true);
            }
        });
        this.iCourse.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                TeachingRequestsFilterBox.this.courseChanged(true);
            }
        });
        Label instructorLab = new Label(MESSAGES.propInstructor());
        instructorLab.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        this.iInstructor = new AriaSuggestBox(new InstructorOracle());
        this.iInstructor.setStyleName("unitime-TextArea");
        this.iInstructor.setWidth("200px");
        this.addFilter(new FilterBox.StaticSimpleFilter("instructor", MESSAGES.tagInstructor(), new String[0]));
        this.iInstructor.getValueBox().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TeachingRequestsFilterBox.this.instructorChanged(true);
            }
        });
        this.iInstructor.getValueBox().addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        TeachingRequestsFilterBox.this.instructorChanged(false);
                    }
                });
            }
        });
        this.iInstructor.getValueBox().addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 8) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            TeachingRequestsFilterBox.this.instructorChanged(false);
                        }
                    });
                }
            }
        });
        this.iInstructor.getValueBox().addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                TeachingRequestsFilterBox.this.instructorChanged(true);
            }
        });
        this.iInstructor.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                TeachingRequestsFilterBox.this.instructorChanged(true);
            }
        });
        this.addFilter(new FilterBox.CustomFilter("Other", MESSAGES.tagOther(), new Widget[]{courseLab, this.iCourse, instructorLab, this.iInstructor}));
        this.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                TeachingRequestsFilterBox.this.iLastCourse = TeachingRequestsFilterBox.this.getChip("course");
                TeachingRequestsFilterBox.this.iLastInstructor = TeachingRequestsFilterBox.this.getChip("instructor");
                if (!TeachingRequestsFilterBox.this.isFilterPopupShowing()) {
                    FilterBox.Chip course;
                    TeachingRequestsFilterBox.this.iDepartments.setSelectedIndex(0);
                    for (int i = 1; i < TeachingRequestsFilterBox.this.iDepartments.getItemCount(); ++i) {
                        String value = TeachingRequestsFilterBox.this.iDepartments.getValue(i);
                        if (!TeachingRequestsFilterBox.this.hasChip(new FilterBox.Chip(TeachingRequestsFilterBox.this.iDepartmentAttribute, value))) continue;
                        TeachingRequestsFilterBox.this.iDepartments.setSelectedIndex(i);
                        break;
                    }
                    if ((course = TeachingRequestsFilterBox.this.getChip("course")) == null) {
                        TeachingRequestsFilterBox.this.iCourse.setText("");
                    } else {
                        TeachingRequestsFilterBox.this.iCourse.setText(course.getValue());
                    }
                    FilterBox.Chip instructor = TeachingRequestsFilterBox.this.getChip("instructor");
                    if (instructor == null) {
                        TeachingRequestsFilterBox.this.iInstructor.setText("");
                    } else {
                        TeachingRequestsFilterBox.this.iInstructor.setText(instructor.getValue());
                    }
                }
                TeachingRequestsFilterBox.this.init(false, TeachingRequestsFilterBox.this.getAcademicSessionId(), new Command(){

                    public void execute() {
                        if (TeachingRequestsFilterBox.this.isFilterPopupShowing()) {
                            TeachingRequestsFilterBox.this.showFilterPopup();
                        }
                    }
                });
            }
        });
    }

    private void courseChanged(boolean fireChange) {
        FilterBox.Chip oldChip = this.getChip("course");
        if (this.iCourse.getText().isEmpty()) {
            if (oldChip != null) {
                this.removeChip(oldChip, fireChange);
            }
        } else {
            FilterBox.Chip newChip = new FilterBox.Chip("course", this.iCourse.getText()).withTranslatedCommand(MESSAGES.tagCourse());
            if (oldChip != null) {
                if (newChip.equals(oldChip)) {
                    if (fireChange && !newChip.equals(this.iLastCourse)) {
                        this.fireValueChangeEvent();
                    }
                    return;
                }
                this.removeChip(oldChip, false);
            }
            this.addChip(newChip, fireChange);
        }
    }

    private void instructorChanged(boolean fireChange) {
        FilterBox.Chip oldChip = this.getChip("instructor");
        if (this.iInstructor.getText().isEmpty()) {
            if (oldChip != null) {
                this.removeChip(oldChip, fireChange);
            }
        } else {
            FilterBox.Chip newChip = new FilterBox.Chip("instructor", this.iInstructor.getText()).withTranslatedCommand(MESSAGES.tagInstructor());
            if (oldChip != null) {
                if (newChip.equals(oldChip)) {
                    if (fireChange && !newChip.equals(this.iLastInstructor)) {
                        this.fireValueChangeEvent();
                    }
                    return;
                }
                this.removeChip(oldChip, false);
            }
            this.addChip(newChip, fireChange);
        }
    }

    @Override
    protected boolean populateFilter(FilterBox.Filter filter, List<EventInterface.FilterRpcResponse.Entity> entities) {
        if (this.iDepartmentAttribute.equals(filter.getCommand())) {
            this.iDepartments.clear();
            this.iDepartments.addItem("department".equals(this.iDepartmentAttribute) ? MESSAGES.itemAllDepartments() : MESSAGES.itemAllSubjectAreas(), "");
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    this.iDepartments.addItem(entity.getName() + (entity.getCount() > 0 ? " (" + entity.getCount() + ")" : ""), entity.getAbbreviation());
                }
            }
            this.iDepartments.setSelectedIndex(0);
            FilterBox.Chip dept = this.getChip(this.iDepartmentAttribute);
            if (dept != null) {
                for (int i = 1; i < this.iDepartments.getItemCount(); ++i) {
                    if (!dept.getValue().equals(this.iDepartments.getValue(i))) continue;
                    this.iDepartments.setSelectedIndex(i);
                    break;
                }
            }
            return true;
        }
        if (filter != null && filter instanceof FilterBox.StaticSimpleFilter) {
            FilterBox.StaticSimpleFilter simple = (FilterBox.StaticSimpleFilter)filter;
            ArrayList<FilterBox.Chip> chips = new ArrayList<FilterBox.Chip>();
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    chips.add(new FilterBox.Chip(filter.getCommand(), entity.getAbbreviation()).withLabel(entity.getName()).withCount(entity.getCount()).withTranslatedCommand(filter.getLabel()).withTranslatedValue(entity.getProperty("translated-value", null)));
                }
            }
            simple.setValues(chips);
            return true;
        }
        return false;
    }

    @Override
    public InstructorInterface.TeachingRequestsFilterRpcRequest createRpcRequest() {
        InstructorInterface.TeachingRequestsFilterRpcRequest req = new InstructorInterface.TeachingRequestsFilterRpcRequest();
        if (this.iAssigned != null) {
            req.setOption("assigned", this.iAssigned != false ? "true" : "false");
        }
        return req;
    }

    @Override
    protected void onLoad(EventInterface.FilterRpcResponse result) {
        if (!result.hasEntities()) {
            return;
        }
        boolean added = false;
        block0: for (String type : result.getTypes()) {
            if ("department".equals(type) || "subject".equals(type) || "assigned".equals(type)) continue;
            for (FilterBox.Filter filter : ((FilterBox)this.iFilter.getWidget()).getFilters()) {
                if (!filter.getCommand().equals(type)) continue;
                continue block0;
            }
            ((FilterBox)this.iFilter.getWidget()).getFilters().add(((FilterBox)this.iFilter.getWidget()).getFilters().size() - 1, new FilterBox.StaticSimpleFilter(type, null, new String[0]));
            added = true;
        }
        if (added) {
            this.setValue(this.getValue(), false);
        }
    }

    public class InstructorOracle
    extends SuggestOracle {
        public void requestSuggestions(final SuggestOracle.Request request, final SuggestOracle.Callback callback) {
            if (!request.getQuery().isEmpty()) {
                ((FilterBox)TeachingRequestsFilterBox.this.iFilter.getWidget()).getSuggestionsProvider().getSuggestions(((FilterBox)TeachingRequestsFilterBox.this.iFilter.getWidget()).getChips(null), request.getQuery(), new AsyncCallback<Collection<FilterBox.Suggestion>>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Collection<FilterBox.Suggestion> result) {
                        if (result == null) {
                            return;
                        }
                        ArrayList<InstructorSuggestion> suggestions = new ArrayList<InstructorSuggestion>();
                        for (FilterBox.Suggestion suggestion : result) {
                            if (suggestion.getChipToAdd() == null || !"instructor".equals(suggestion.getChipToAdd().getCommand())) continue;
                            suggestions.add(new InstructorSuggestion(suggestion));
                        }
                        callback.onSuggestionsReady(request, new SuggestOracle.Response(suggestions));
                    }
                });
            }
        }
    }

    public class InstructorSuggestion
    implements SuggestOracle.Suggestion {
        private FilterBox.Suggestion iSuggestion;

        InstructorSuggestion(FilterBox.Suggestion suggestion) {
            this.iSuggestion = suggestion;
        }

        public String getDisplayString() {
            return this.iSuggestion.getChipToAdd().getLabel();
        }

        public String getReplacementString() {
            return this.iSuggestion.getChipToAdd().getValue();
        }
    }

    public class CourseOracle
    extends SuggestOracle {
        public void requestSuggestions(final SuggestOracle.Request request, final SuggestOracle.Callback callback) {
            if (!request.getQuery().isEmpty()) {
                ((FilterBox)TeachingRequestsFilterBox.this.iFilter.getWidget()).getSuggestionsProvider().getSuggestions(((FilterBox)TeachingRequestsFilterBox.this.iFilter.getWidget()).getChips(null), request.getQuery(), new AsyncCallback<Collection<FilterBox.Suggestion>>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Collection<FilterBox.Suggestion> result) {
                        if (result == null) {
                            return;
                        }
                        ArrayList<CourseSuggestion> suggestions = new ArrayList<CourseSuggestion>();
                        for (FilterBox.Suggestion suggestion : result) {
                            if (suggestion.getChipToAdd() == null || !"course".equals(suggestion.getChipToAdd().getCommand())) continue;
                            suggestions.add(new CourseSuggestion(suggestion));
                        }
                        callback.onSuggestionsReady(request, new SuggestOracle.Response(suggestions));
                    }
                });
            }
        }

        public boolean isDisplayStringHTML() {
            return true;
        }
    }

    public class CourseSuggestion
    implements SuggestOracle.Suggestion {
        private FilterBox.Suggestion iSuggestion;

        CourseSuggestion(FilterBox.Suggestion suggestion) {
            this.iSuggestion = suggestion;
        }

        public String getDisplayString() {
            return this.iSuggestion.getChipToAdd().getLabel() + (this.iSuggestion.getChipToAdd().hasToolTip() ? " <span class='item-hint'>" + this.iSuggestion.getChipToAdd().getToolTip() + "</span>" : "");
        }

        public String getReplacementString() {
            return this.iSuggestion.getChipToAdd().getValue();
        }
    }
}

