/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.instructor.AttributesCell;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.instructor.ObjectivesCell;
import org.unitime.timetable.gwt.client.instructor.PreferenceCell;
import org.unitime.timetable.gwt.client.instructor.TeachingAssignmentsPage;
import org.unitime.timetable.gwt.client.instructor.TeachingRequestDetailPage;
import org.unitime.timetable.gwt.client.instructor.TimePreferenceCell;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeachingAssignmentsTable
extends UniTimeTable<TeachingAssignmentsPage.SingleTeachingAssingment> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final StudentSectioningMessages SECTMSG = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static NumberFormat sTeachingLoadFormat = NumberFormat.getFormat((String)CONSTANTS.teachingLoadFormat());
    private TeachingRequestDetailPage iDetail = null;
    private InstructorInterface.TeachingRequestsPagePropertiesResponse iProperties;

    public TeachingAssignmentsTable() {
        this.addStyleName("unitime-TeachingAssignments");
        this.addMouseClickListener(new UniTimeTable.MouseClickListener<TeachingAssignmentsPage.SingleTeachingAssingment>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<TeachingAssignmentsPage.SingleTeachingAssingment> event) {
                if (event.getData() != null) {
                    if (TeachingAssignmentsTable.this.iDetail == null) {
                        TeachingAssignmentsTable.this.iDetail = new TeachingRequestDetailPage(TeachingAssignmentsTable.this.iProperties){

                            @Override
                            protected void onAssignmentChanged(List<InstructorInterface.AssignmentInfo> assignments) {
                                TeachingAssignmentsTable.this.onAssignmentChanged(assignments);
                            }
                        };
                        TeachingAssignmentsTable.this.iDetail.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                            public void onClose(CloseEvent<PopupPanel> event) {
                                TeachingAssignmentsTable.this.clearHover();
                            }
                        });
                    }
                    TeachingAssignmentsTable.this.iDetail.showInstructorDetail(event.getData().getInstructor().getInstructorId());
                }
            }
        });
    }

    public void setProperties(InstructorInterface.TeachingRequestsPagePropertiesResponse properties) {
        this.iProperties = properties;
    }

    protected void onAssignmentChanged(List<InstructorInterface.AssignmentInfo> assignments) {
    }

    void populate(GwtRpcResponseList<InstructorInterface.InstructorInfo> results) {
        Object h;
        this.clearTable();
        ArrayList<COLUMN[]> header = new ArrayList<COLUMN[]>();
        COLUMN[] sortHeader = null;
        COLUMN sortColumn = null;
        boolean asc = true;
        int sort = InstructorCookie.getInstance().getSortTeachingAssignmentsBy();
        for (COLUMN cOLUMN : COLUMN.values()) {
            h = this.getHeader(cOLUMN);
            ((UniTimeTableHeader)h).addOperation(new UniTimeTableHeader.Operation((UniTimeTableHeader)h, cOLUMN){
                final /* synthetic */ UniTimeTableHeader val$h;
                final /* synthetic */ COLUMN val$column;
                {
                    this.val$h = uniTimeTableHeader;
                    this.val$column = cOLUMN;
                }

                public void execute() {
                    TeachingAssignmentsTable.this.sort(this.val$h, new TableComparator(this.val$column));
                    InstructorCookie.getInstance().setSortTeachingAssignmentsBy(this.val$h.getOrder() != false ? 1 + this.val$column.ordinal() : -1 - this.val$column.ordinal());
                    TeachingAssignmentsTable.this.hideDuplicateInstructors();
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return true;
                }

                public String getName() {
                    return MESSAGES.opSortBy(this.val$h.getHTML().replace("<br>", " "));
                }
            });
            header.add((COLUMN[])h);
            if (sort == 0 || Math.abs(sort) - 1 != cOLUMN.ordinal()) continue;
            sortHeader = h;
            sortColumn = cOLUMN;
            asc = sort > 0;
        }
        this.addRow(null, header);
        for (InstructorInterface.InstructorInfo instructor : results) {
            if (instructor.getAssignedRequests().isEmpty()) {
                TeachingAssignmentsPage.SingleTeachingAssingment assignment = new TeachingAssignmentsPage.SingleTeachingAssingment(instructor, null);
                ArrayList<Widget> arrayList = new ArrayList<Widget>();
                for (COLUMN column : COLUMN.values()) {
                    Widget cell = this.getCell(column, assignment);
                    if (cell == null) {
                        cell = new Label();
                    }
                    arrayList.add(cell);
                }
                this.addRow(assignment, arrayList);
                continue;
            }
            for (InstructorInterface.TeachingRequestInfo teachingRequestInfo : instructor.getAssignedRequests()) {
                if (!teachingRequestInfo.isMatchingFilter()) continue;
                TeachingAssignmentsPage.SingleTeachingAssingment assignment = new TeachingAssignmentsPage.SingleTeachingAssingment(instructor, teachingRequestInfo);
                ArrayList<Widget> line = new ArrayList<Widget>();
                for (COLUMN column : COLUMN.values()) {
                    Widget cell = this.getCell(column, assignment);
                    if (cell == null) {
                        cell = new Label();
                    }
                    line.add(cell);
                }
                int row = this.addRow(assignment, line);
                if (!teachingRequestInfo.isConflict()) continue;
                this.getRowFormatter().addStyleName(row, "enrollment-conflict");
            }
        }
        if (sortHeader != null) {
            this.sort((UniTimeTableHeader)sortHeader, new TableComparator(sortColumn), asc);
        }
        for (final COLUMN cOLUMN : COLUMN.values()) {
            h = (UniTimeTableHeader)header.get(cOLUMN.ordinal());
            final int colIdx = cOLUMN.ordinal();
            if (cOLUMN.isCanHide()) {
                UniTimeTableHeader.Operation op = new UniTimeTableHeader.Operation((UniTimeTableHeader)h){
                    final /* synthetic */ UniTimeTableHeader val$h;
                    {
                        this.val$h = uniTimeTableHeader;
                    }

                    public void execute() {
                        boolean visible = !InstructorCookie.getInstance().isTeachingAssignmentsColumnVisible(cOLUMN.ordinal());
                        InstructorCookie.getInstance().setTeachingAssignmentsColumnVisible(cOLUMN.ordinal(), visible);
                        TeachingAssignmentsTable.this.setColumnVisible(colIdx, visible);
                        if (COLUMN.NAME == cOLUMN && !visible) {
                            InstructorCookie.getInstance().setTeachingAssignmentsColumnVisible(COLUMN.EXTERNAL_ID.ordinal(), true);
                            TeachingAssignmentsTable.this.setColumnVisible(colIdx - 1, true);
                        } else if (COLUMN.EXTERNAL_ID == cOLUMN && !visible) {
                            InstructorCookie.getInstance().setTeachingAssignmentsColumnVisible(COLUMN.NAME.ordinal(), true);
                            TeachingAssignmentsTable.this.setColumnVisible(colIdx + 1, true);
                        }
                    }

                    public boolean isApplicable() {
                        return true;
                    }

                    public boolean hasSeparator() {
                        return false;
                    }

                    public String getName() {
                        if (InstructorCookie.getInstance().isTeachingAssignmentsColumnVisible(cOLUMN.ordinal())) {
                            return MESSAGES.opHide(this.val$h.getHTML().replace("<br>", " "));
                        }
                        return MESSAGES.opShow(this.val$h.getHTML().replace("<br>", " "));
                    }
                };
                ((UniTimeTableHeader)header.get(0)).getOperations().add(((UniTimeTableHeader)header.get(0)).getOperations().size() - 1, op);
                ((UniTimeTableHeader)header.get(1)).getOperations().add(((UniTimeTableHeader)header.get(1)).getOperations().size() - 1, op);
                ((UniTimeTableHeader)h).addOperation(new UniTimeTableHeader.Operation((UniTimeTableHeader)h){
                    final /* synthetic */ UniTimeTableHeader val$h;
                    {
                        this.val$h = uniTimeTableHeader;
                    }

                    public void execute() {
                        boolean visible = !InstructorCookie.getInstance().isTeachingAssignmentsColumnVisible(cOLUMN.ordinal());
                        InstructorCookie.getInstance().setTeachingAssignmentsColumnVisible(cOLUMN.ordinal(), visible);
                        TeachingAssignmentsTable.this.setColumnVisible(colIdx, visible);
                        if (COLUMN.NAME == cOLUMN && !visible) {
                            InstructorCookie.getInstance().setTeachingAssignmentsColumnVisible(COLUMN.EXTERNAL_ID.ordinal(), true);
                            TeachingAssignmentsTable.this.setColumnVisible(colIdx - 1, true);
                        } else if (COLUMN.EXTERNAL_ID == cOLUMN && !visible) {
                            InstructorCookie.getInstance().setTeachingAssignmentsColumnVisible(COLUMN.NAME.ordinal(), true);
                            TeachingAssignmentsTable.this.setColumnVisible(colIdx + 1, true);
                        }
                    }

                    public boolean isApplicable() {
                        return true;
                    }

                    public boolean hasSeparator() {
                        return true;
                    }

                    public String getName() {
                        if (InstructorCookie.getInstance().isTeachingAssignmentsColumnVisible(cOLUMN.ordinal())) {
                            return MESSAGES.opHideItem(this.val$h.getHTML().replace("<br>", " "));
                        }
                        return MESSAGES.opShowItem(this.val$h.getHTML().replace("<br>", " "));
                    }
                });
            }
            this.setColumnVisible(colIdx, !cOLUMN.isCanHide() || InstructorCookie.getInstance().isTeachingAssignmentsColumnVisible(cOLUMN.ordinal()));
        }
        this.hideDuplicateInstructors();
    }

    public void hideDuplicateInstructors() {
        InstructorInterface.InstructorInfo last = null;
        for (int i = 0; i < this.getRowCount(); ++i) {
            TeachingAssignmentsPage.SingleTeachingAssingment ta = (TeachingAssignmentsPage.SingleTeachingAssingment)this.getData(i);
            if (ta == null) {
                last = null;
                continue;
            }
            if (ta.getInstructor().equals(last)) {
                for (COLUMN column : COLUMN.values()) {
                    this.getCellFormatter().setStyleName(i, column.ordinal(), null);
                    if (column.isHasRequest()) continue;
                    this.getWidget(i, column.ordinal()).setVisible(false);
                }
            } else {
                for (COLUMN column : COLUMN.values()) {
                    this.getCellFormatter().setStyleName(i, column.ordinal(), "first-line");
                    if (column.isHasRequest()) continue;
                    this.getWidget(i, column.ordinal()).setVisible(true);
                }
            }
            last = ta.getInstructor();
        }
    }

    public UniTimeTableHeader getHeader(COLUMN column) {
        switch (column) {
            case COURSE: {
                return new UniTimeTableHeader(MESSAGES.colCourse());
            }
            case SECTION: {
                return new UniTimeTableHeader(MESSAGES.colSection());
            }
            case TIME: {
                return new UniTimeTableHeader(MESSAGES.colTime());
            }
            case DATE: {
                return new UniTimeTableHeader(MESSAGES.colDate());
            }
            case ROOM: {
                return new UniTimeTableHeader(MESSAGES.colRoom());
            }
            case LOAD: {
                return new UniTimeTableHeader(MESSAGES.colTeachingLoad());
            }
            case ATTRIBUTE_PREFS: {
                return new UniTimeTableHeader(MESSAGES.colAttributePreferences());
            }
            case INSTRUCTOR_PREFS: {
                return new UniTimeTableHeader(MESSAGES.colInstructorPreferences());
            }
            case EXTERNAL_ID: {
                return new UniTimeTableHeader(MESSAGES.colExternalId());
            }
            case NAME: {
                return new UniTimeTableHeader(MESSAGES.colNamePerson());
            }
            case ATTRIBUTES: {
                return new UniTimeTableHeader(MESSAGES.colAttributes());
            }
            case COURSE_PREF: {
                return new UniTimeTableHeader(MESSAGES.colCoursePreferences());
            }
            case DISTRIBUTION_PREF: {
                return new UniTimeTableHeader(MESSAGES.colDistributionPreferences());
            }
            case TIME_PREF: {
                UniTimeTableHeader timePrefHeader = new UniTimeTableHeader(MESSAGES.colTimePreferences());
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(true, RoomCookie.getInstance().areRoomsHorizontal());
                        TeachingAssignmentsTable.this.refreshTable();
                    }

                    public boolean isApplicable() {
                        return !RoomCookie.getInstance().isGridAsText();
                    }

                    public boolean hasSeparator() {
                        return false;
                    }

                    public String getName() {
                        return MESSAGES.opOrientationAsText();
                    }
                });
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(false, RoomCookie.getInstance().areRoomsHorizontal());
                        TeachingAssignmentsTable.this.refreshTable();
                    }

                    public boolean isApplicable() {
                        return RoomCookie.getInstance().isGridAsText();
                    }

                    public boolean hasSeparator() {
                        return false;
                    }

                    public String getName() {
                        return MESSAGES.opOrientationAsGrid();
                    }
                });
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(false, true);
                        TeachingAssignmentsTable.this.refreshTable();
                    }

                    public boolean isApplicable() {
                        return !RoomCookie.getInstance().isGridAsText() && !RoomCookie.getInstance().areRoomsHorizontal();
                    }

                    public boolean hasSeparator() {
                        return false;
                    }

                    public String getName() {
                        return MESSAGES.opOrientationHorizontal();
                    }
                });
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(false, false);
                        TeachingAssignmentsTable.this.refreshTable();
                    }

                    public boolean isApplicable() {
                        return !RoomCookie.getInstance().isGridAsText() && RoomCookie.getInstance().areRoomsHorizontal();
                    }

                    public boolean hasSeparator() {
                        return false;
                    }

                    public String getName() {
                        return MESSAGES.opOrientationVertical();
                    }
                });
                if (this.iProperties != null && this.iProperties.hasModes() && !RoomCookie.getInstance().isGridAsText()) {
                    int i = 0;
                    while (i < this.iProperties.getModes().size()) {
                        final RoomInterface.RoomSharingDisplayMode mode = this.iProperties.getModes().get(i);
                        final int index = i++;
                        timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                            public void execute() {
                                RoomCookie.getInstance().setMode(RoomCookie.getInstance().areRoomsHorizontal(), mode.toHex());
                                TeachingAssignmentsTable.this.refreshTable();
                            }

                            public boolean isApplicable() {
                                return !RoomCookie.getInstance().isGridAsText() && !mode.toHex().equals(RoomCookie.getInstance().getMode());
                            }

                            public boolean hasSeparator() {
                                return index == 0 || index == 1 && TeachingAssignmentsTable.this.iProperties.getModes().get(0).toHex().equals(RoomCookie.getInstance().getMode());
                            }

                            public String getName() {
                                return mode.getName();
                            }
                        });
                    }
                }
                return timePrefHeader;
            }
            case ASSIGNED_LOAD: {
                return new UniTimeTableHeader(MESSAGES.colAssignedLoad());
            }
            case OBJECTIVES: {
                return new UniTimeTableHeader(MESSAGES.colObjectives());
            }
        }
        return new UniTimeTableHeader(column.name());
    }

    public Widget getCell(COLUMN column, TeachingAssignmentsPage.SingleTeachingAssingment assignment) {
        InstructorInterface.InstructorInfo instructor = assignment.getInstructor();
        InstructorInterface.TeachingRequestInfo request = assignment.getRequest();
        switch (column) {
            case COURSE: {
                if (request == null) {
                    return null;
                }
                return new Label(request.getCourse().getCourseName(), false);
            }
            case SECTION: {
                if (request == null) {
                    return null;
                }
                P p = new P("sections");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("section");
                    i.setText(s.getSectionType() + (s.getExternalId() == null ? "" : " " + s.getExternalId()));
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case TIME: {
                if (request == null) {
                    return null;
                }
                P p = new P("times");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("time");
                    i.setHTML(s.getTime() == null ? SECTMSG.arrangeHours() : s.getTime());
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case DATE: {
                if (request == null) {
                    return null;
                }
                P p = new P("dates");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("date");
                    i.setHTML(s.getDate() == null ? SECTMSG.noDate() : s.getDate());
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case ROOM: {
                if (request == null) {
                    return null;
                }
                P p = new P("rooms");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("room");
                    i.setHTML(s.getRoom() == null ? SECTMSG.noRoom() : s.getRoom());
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case LOAD: {
                if (request == null) {
                    return null;
                }
                return new Label(sTeachingLoadFormat.format((double)request.getLoad()));
            }
            case EXTERNAL_ID: {
                InstructorInterface.PreferenceInterface pref;
                if (instructor.getExternalId() == null) {
                    return null;
                }
                Label extId = new Label(instructor.getExternalId());
                if (instructor.getTeachingPreference() != null && !"0".equals(instructor.getTeachingPreference()) && (pref = this.iProperties.getPreference(instructor.getTeachingPreference())) != null) {
                    extId.setTitle(pref.getName() + " " + instructor.getExternalId());
                    extId.getElement().getStyle().setColor(pref.getColor());
                }
                return extId;
            }
            case NAME: {
                InstructorInterface.PreferenceInterface pref;
                if (instructor.getInstructorName() == null) {
                    return null;
                }
                Label name = new Label(instructor.getInstructorName());
                if (instructor.getTeachingPreference() != null && !"0".equals(instructor.getTeachingPreference()) && (pref = this.iProperties.getPreference(instructor.getTeachingPreference())) != null) {
                    name.setTitle(pref.getName() + " " + instructor.getInstructorName());
                    name.getElement().getStyle().setColor(pref.getColor());
                }
                return name;
            }
            case ATTRIBUTE_PREFS: {
                if (request == null) {
                    return null;
                }
                return new PreferenceCell(this.iProperties, request.getAttributePreferences());
            }
            case INSTRUCTOR_PREFS: {
                if (request == null) {
                    return null;
                }
                return new PreferenceCell(this.iProperties, request.getInstructorPreferences());
            }
            case COURSE_PREF: {
                return new PreferenceCell(this.iProperties, instructor.getCoursePreferences());
            }
            case DISTRIBUTION_PREF: {
                return new PreferenceCell(this.iProperties, instructor.getDistributionPreferences());
            }
            case TIME_PREF: {
                return new TimePreferenceCell(this.iProperties, instructor);
            }
            case ATTRIBUTES: {
                return new AttributesCell(instructor.getAttributes());
            }
            case ASSIGNED_LOAD: {
                return new Label(sTeachingLoadFormat.format((double)instructor.getAssignedLoad()) + " / " + sTeachingLoadFormat.format((double)instructor.getMaxLoad()));
            }
            case OBJECTIVES: {
                if (request == null) {
                    return null;
                }
                return new ObjectivesCell(this.iProperties, request.getValues());
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableComparator
    implements Comparator<TeachingAssignmentsPage.SingleTeachingAssingment> {
        private COLUMN iColumn;

        public TableComparator(COLUMN column) {
            this.iColumn = column;
        }

        protected int compareSections(COLUMN column, InstructorInterface.SectionInfo s1, InstructorInterface.SectionInfo s2) {
            switch (column) {
                case SECTION: {
                    return this.compareOthers(s1, s2);
                }
                case TIME: {
                    return this.compareStrings(s1.getTime(), s2.getTime());
                }
                case DATE: {
                    return this.compareStrings(s1.getDate(), s2.getDate());
                }
                case ROOM: {
                    return this.compareStrings(s1.getRoom(), s2.getRoom());
                }
            }
            return 0;
        }

        protected int comparePreferences(List<InstructorInterface.PreferenceInfo> p1, List<InstructorInterface.PreferenceInfo> p2) {
            Iterator<InstructorInterface.PreferenceInfo> i1 = p1.iterator();
            Iterator<InstructorInterface.PreferenceInfo> i2 = p2.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                int cmp = i1.next().compareTo(i2.next());
                if (cmp == 0) continue;
                return cmp;
            }
            if (i2.hasNext()) {
                return -1;
            }
            if (i1.hasNext()) {
                return 1;
            }
            return i1.hasNext() ? 1 : (i2.hasNext() ? -1 : 0);
        }

        private int compareByColumn(COLUMN column, TeachingAssignmentsPage.SingleTeachingAssingment a1, TeachingAssignmentsPage.SingleTeachingAssingment a2) {
            InstructorInterface.InstructorInfo i1 = a1.getInstructor();
            InstructorInterface.InstructorInfo i2 = a2.getInstructor();
            InstructorInterface.TeachingRequestInfo r1 = a1.getRequest();
            InstructorInterface.TeachingRequestInfo r2 = a2.getRequest();
            if (column.isHasRequest()) {
                if (r1 == null) {
                    return r2 == null ? 0 : 1;
                }
                if (r2 == null) {
                    return -1;
                }
            }
            switch (column) {
                case COURSE: {
                    return this.compareOthers(r1.getCourse(), r2.getCourse());
                }
                case SECTION: 
                case TIME: 
                case DATE: 
                case ROOM: {
                    Iterator<InstructorInterface.SectionInfo> t1 = r1.getSections().iterator();
                    Iterator<InstructorInterface.SectionInfo> t2 = r2.getSections().iterator();
                    while (t1.hasNext() && t2.hasNext()) {
                        int cmp = this.compareSections(column, t1.next(), t2.next());
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    if (t2.hasNext()) {
                        return -1;
                    }
                    if (t1.hasNext()) {
                        return 1;
                    }
                    return t1.hasNext() ? 1 : (t2.hasNext() ? -1 : 0);
                }
                case ASSIGNED_LOAD: {
                    int cmp = this.compareNumbers(Float.valueOf(i1.getAssignedLoad()), Float.valueOf(i2.getAssignedLoad()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return this.compareNumbers(Float.valueOf(i1.getMaxLoad()), Float.valueOf(i2.getMaxLoad()));
                }
                case NAME: {
                    return this.compareStrings(i1.getInstructorName(), i2.getInstructorName());
                }
                case EXTERNAL_ID: {
                    return this.compareStrings(i1.getExternalId(), i2.getExternalId());
                }
                case LOAD: {
                    return this.compareNumbers(Float.valueOf(r1.getLoad()), Float.valueOf(r2.getLoad()));
                }
                case OBJECTIVES: {
                    TreeSet<String> keys = new TreeSet<String>(r1.getValues().keySet());
                    keys.addAll(r2.getValues().keySet());
                    for (String key : keys) {
                        Double d2;
                        Double d = r1.getValues().get(key);
                        int cmp = this.compareNumbers(d, d2 = r2.getValues().get(key));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
                case ATTRIBUTES: {
                    TreeSet<String> attributes = new TreeSet<String>();
                    for (InstructorInterface.AttributeInterface attributeInterface : i1.getAttributes()) {
                        attributes.add(attributeInterface.getName());
                    }
                    for (InstructorInterface.AttributeInterface attributeInterface : i2.getAttributes()) {
                        attributes.add(attributeInterface.getName());
                    }
                    for (String string : attributes) {
                        int cmp = this.compareBooleans(i1.hasAttribute(string), i2.hasAttribute(string));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
                case ATTRIBUTE_PREFS: {
                    return this.comparePreferences(r1.getAttributePreferences(), r2.getAttributePreferences());
                }
                case COURSE_PREF: {
                    return this.comparePreferences(i1.getCoursePreferences(), i2.getCoursePreferences());
                }
                case INSTRUCTOR_PREFS: {
                    return this.comparePreferences(r1.getInstructorPreferences(), r2.getInstructorPreferences());
                }
                case DISTRIBUTION_PREF: {
                    return this.comparePreferences(i1.getDistributionPreferences(), i2.getDistributionPreferences());
                }
                case TIME_PREF: {
                    return this.comparePreferences(i1.getTimePreferences(), i2.getTimePreferences());
                }
            }
            return 0;
        }

        @Override
        public int compare(TeachingAssignmentsPage.SingleTeachingAssingment a1, TeachingAssignmentsPage.SingleTeachingAssingment a2) {
            int cmp = this.compareByColumn(this.iColumn, a1, a2);
            if (cmp != 0) {
                return cmp;
            }
            cmp = a1.getInstructor().compareTo(a2.getInstructor());
            if (cmp != 0) {
                return cmp;
            }
            return this.compareOthers(a1.getRequest(), a2.getRequest());
        }

        protected int compareStrings(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        protected int compareNumbers(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }

        protected int compareBooleans(Boolean b1, Boolean b2) {
            return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
        }

        protected int compareOthers(Comparable c1, Comparable c2) {
            return c1 == null ? (c2 == null ? 0 : -1) : (c2 == null ? 1 : c1.compareTo(c2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum COLUMN {
        EXTERNAL_ID(true, false),
        NAME(true, false),
        ASSIGNED_LOAD(true, false),
        ATTRIBUTES(true, false),
        COURSE_PREF(true, false),
        TIME_PREF(true, false),
        DISTRIBUTION_PREF(true, false),
        COURSE(false, true),
        SECTION(false, true),
        TIME(true, true),
        DATE(true, true),
        ROOM(true, true),
        LOAD(true, true),
        ATTRIBUTE_PREFS(true, true),
        INSTRUCTOR_PREFS(true, true),
        OBJECTIVES(true, true);

        private boolean iCanHide;
        private boolean iHasRequest;

        private COLUMN(boolean canHide, boolean hasRequest) {
            this.iCanHide = canHide;
            this.iHasRequest = hasRequest;
        }

        public boolean isCanHide() {
            return this.iCanHide;
        }

        public boolean isHasRequest() {
            return this.iHasRequest;
        }

        public int flag() {
            return 1 << this.ordinal();
        }
    }
}

