/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import java.util.Comparator;
import org.unitime.timetable.gwt.shared.InstructorInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorComparator
implements Comparator<InstructorInterface> {
    private InstructorInterface.InstructorsColumn iColumn;
    private boolean iAsc;

    public InstructorComparator(InstructorInterface.InstructorsColumn column, boolean asc) {
        this.iColumn = column;
        this.iAsc = asc;
    }

    public int compareById(InstructorInterface r1, InstructorInterface r2) {
        return this.compare(r1.getId(), r2.getId());
    }

    public int compareByExternalId(InstructorInterface r1, InstructorInterface r2) {
        return this.compare(r1.getExternalId(), r2.getExternalId());
    }

    public int compareByName(InstructorInterface r1, InstructorInterface r2) {
        return this.compare(r1.getOrderName(), r2.getOrderName());
    }

    public int compareByPosition(InstructorInterface r1, InstructorInterface r2) {
        return this.compare(r1.getPosition() == null ? null : r1.getPosition().getSortOrder(), r2.getPosition() == null ? null : r2.getPosition().getSortOrder());
    }

    public int compareByMaxLoad(InstructorInterface r1, InstructorInterface r2) {
        return this.compare(r1.getMaxLoad(), r2.getMaxLoad());
    }

    public int compareByTeachingPreference(InstructorInterface r1, InstructorInterface r2) {
        return this.compare(r1.getTeachingPreference() == null ? null : r1.getTeachingPreference().getId(), r2.getTeachingPreference() == null ? null : r2.getTeachingPreference().getId());
    }

    protected int compareByColumn(InstructorInterface r1, InstructorInterface r2) {
        switch (this.iColumn) {
            case NAME: {
                return this.compareByName(r1, r2);
            }
            case ID: {
                return this.compareByExternalId(r1, r2);
            }
            case MAX_LOAD: {
                return this.compareByMaxLoad(r1, r2);
            }
            case POSITION: {
                return this.compareByPosition(r1, r2);
            }
            case TEACHING_PREF: {
                return this.compareByTeachingPreference(r1, r2);
            }
        }
        return this.compareByName(r1, r2);
    }

    public static boolean isApplicable(InstructorInterface.InstructorsColumn column) {
        switch (column) {
            case NAME: 
            case ID: 
            case MAX_LOAD: 
            case POSITION: 
            case TEACHING_PREF: 
            case SELECTION: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compare(InstructorInterface r1, InstructorInterface r2) {
        int cmp = this.compareByColumn(r1, r2);
        if (cmp == 0) {
            cmp = this.compareByName(r1, r2);
        }
        if (cmp == 0) {
            cmp = this.compareById(r1, r2);
        }
        return this.iAsc ? cmp : -cmp;
    }

    @Override
    protected int compare(String s1, String s2) {
        if (s1 == null || s1.isEmpty()) {
            return s2 == null || s2.isEmpty() ? 0 : 1;
        }
        return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
    }

    @Override
    protected int compare(Number n1, Number n2) {
        return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
    }

    @Override
    protected int compare(Boolean b1, Boolean b2) {
        return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
    }
}

