/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.events.EventAdd;
import org.unitime.timetable.gwt.client.events.EventCookie;
import org.unitime.timetable.gwt.client.events.RoomFilterBox;
import org.unitime.timetable.gwt.client.events.SessionDatesSelector;
import org.unitime.timetable.gwt.client.events.StartEndTimeSelector;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMeetingsDialog
extends UniTimeDialogBox {
    private static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static DateTimeFormat sDayOfWeek = DateTimeFormat.getFormat((String)"EEEE");
    private static DateTimeFormat sDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormat());
    private static DateTimeFormat sAriaDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.dateSelectionDateFormat());
    private SimpleForm iDatesForm;
    private SimpleForm iAvailabilityForm;
    private UniTimeHeaderPanel iDatesHeader;
    private UniTimeHeaderPanel iAvailabilityHeader;
    private P iRoomAvailability;
    private AriaTextBox iText;
    private Set<String> iSelected = new HashSet<String>();
    private EventInterface.EventRoomAvailabilityRpcResponse iResponse;
    private Map<String, P> iPanels = new HashMap<String, P>();
    private StartEndTimeSelector iTimes;
    private SessionDatesSelector iDates;
    private RoomFilterBox iRooms;
    private List<EventInterface.FilterRpcResponse.Entity> iMatchingRooms;
    private ScrollPanel iScrollDates;
    private ScrollPanel iScrollRooms;
    private int iIndex = 0;
    private int iStep = 10;
    private Long iEventId = null;
    private AsyncCallback<List<EventInterface.MeetingInterface>> iCallback;
    private AcademicSessionProvider iSession;
    private EventAdd.EventPropertiesProvider iProperties;
    private List<EventInterface.MeetingConflictInterface> iConflicts;
    private Integer iHoverDate = null;
    private EventInterface.FilterRpcResponse.Entity iHoverLoc = null;

    public AddMeetingsDialog(AcademicSessionProvider session, EventAdd.EventPropertiesProvider propeties, AsyncCallback<List<EventInterface.MeetingInterface>> callback) {
        super(true, true);
        this.setAnimationEnabled(false);
        this.iCallback = callback;
        this.iSession = session;
        this.iProperties = propeties;
        this.setText(MESSAGES.dialogAddMeetings());
        this.setEscapeToHide(true);
        this.iDatesForm = new SimpleForm();
        this.iDatesHeader = new UniTimeHeaderPanel();
        this.iDatesHeader.setRotateFocus(true);
        this.iDatesHeader.addButton("next", MESSAGES.buttonNext(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (AddMeetingsDialog.this.iDates.getSelectedDaysCount() == 0) {
                    AddMeetingsDialog.this.iDatesHeader.setErrorMessage(MESSAGES.errorNoDateSelected());
                    AriaStatus.getInstance().setText(MESSAGES.errorNoDateSelected());
                    return;
                }
                if (AddMeetingsDialog.this.getStartSlot() == null) {
                    AddMeetingsDialog.this.iDatesHeader.setErrorMessage(MESSAGES.errorNoStartTime());
                    AriaStatus.getInstance().setText(MESSAGES.errorNoStartTime());
                    return;
                }
                if (AddMeetingsDialog.this.getEndSlot() == null) {
                    AddMeetingsDialog.this.iDatesHeader.setErrorMessage(MESSAGES.errorNoEndTime());
                    AriaStatus.getInstance().setText(MESSAGES.errorNoEndTime());
                    return;
                }
                LoadingWidget.getInstance().show(MESSAGES.waitCheckingRoomAvailability());
                AddMeetingsDialog.this.iRooms.getElements(new AsyncCallback<List<EventInterface.FilterRpcResponse.Entity>>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        AddMeetingsDialog.this.iDatesHeader.setErrorMessage(caught.getMessage());
                        AriaStatus.getInstance().setText(caught.getMessage());
                    }

                    public void onSuccess(List<EventInterface.FilterRpcResponse.Entity> result) {
                        AddMeetingsDialog.this.iMatchingRooms = result;
                        if (result == null || result.isEmpty()) {
                            LoadingWidget.getInstance().hide();
                            AddMeetingsDialog.this.iDatesHeader.setErrorMessage(MESSAGES.errorNoMatchingRooms());
                            AriaStatus.getInstance().setText(MESSAGES.errorNoMatchingRooms());
                        } else if (AddMeetingsDialog.this.iDates.getSelectedDaysCount() > 0) {
                            AddMeetingsDialog.this.iDatesHeader.clearMessage();
                            if (AddMeetingsDialog.this.iProperties != null && AddMeetingsDialog.this.iProperties.isTooEarly(AddMeetingsDialog.this.getStartSlot(), AddMeetingsDialog.this.getEndSlot())) {
                                AddMeetingsDialog.this.iAvailabilityHeader.setWarningMessage(MESSAGES.warnMeetingTooEarly(TimeSelector.TimeUtils.slot2time(AddMeetingsDialog.this.getStartSlot()) + " - " + TimeSelector.TimeUtils.slot2time(AddMeetingsDialog.this.getEndSlot())));
                                AriaStatus.getInstance().setText(MESSAGES.warnMeetingTooEarly(TimeSelector.TimeUtils.slot2aria(AddMeetingsDialog.this.getStartSlot()) + " - " + TimeSelector.TimeUtils.slot2aria(AddMeetingsDialog.this.getEndSlot())));
                            } else {
                                AddMeetingsDialog.this.iAvailabilityHeader.clearMessage();
                            }
                            RPC.execute(EventInterface.EventRoomAvailabilityRpcRequest.checkAvailability(AddMeetingsDialog.this.getStartSlot(), AddMeetingsDialog.this.getEndSlot(), AddMeetingsDialog.this.getDates(), AddMeetingsDialog.this.getRooms(), AddMeetingsDialog.this.iEventId, AddMeetingsDialog.this.iSession.getAcademicSessionId()), new AsyncCallback<EventInterface.EventRoomAvailabilityRpcResponse>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    AddMeetingsDialog.this.iDatesHeader.setErrorMessage(caught.getMessage());
                                    AriaStatus.getInstance().setText(caught.getMessage());
                                }

                                public void onSuccess(EventInterface.EventRoomAvailabilityRpcResponse result) {
                                    LoadingWidget.getInstance().hide();
                                    AddMeetingsDialog.this.iResponse = result;
                                    AddMeetingsDialog.this.populate(0, EventCookie.getInstance().getRoomsSortBy());
                                    AddMeetingsDialog.this.setWidget((Widget)AddMeetingsDialog.this.iAvailabilityForm);
                                    AddMeetingsDialog.this.recenter();
                                    AddMeetingsDialog.this.iText.setFocus(true);
                                }
                            });
                        }
                    }
                });
            }
        });
        this.iDatesForm.addHeaderRow((Widget)this.iDatesHeader);
        SimpleForm form = new SimpleForm();
        form.removeStyleName("unitime-NotPrintableBottomLine");
        this.iDates = new SessionDatesSelector(session);
        form.addRow(MESSAGES.propDates(), (Widget)this.iDates);
        this.iTimes = new StartEndTimeSelector();
        form.addRow(MESSAGES.propTimes(), (Widget)this.iTimes);
        this.iRooms = new RoomFilterBox(session);
        form.addRow(MESSAGES.propLocations(), (Widget)this.iRooms);
        this.iScrollDates = new ScrollPanel((Widget)form);
        this.iScrollDates.setStyleName("unitime-VerticalScrollPanel");
        this.iDatesForm.addRow((Widget)this.iScrollDates);
        this.iDatesForm.addBottomRow((Widget)this.iDatesHeader.clonePanel());
        this.iAvailabilityForm = new SimpleForm();
        this.iAvailabilityHeader = new UniTimeHeaderPanel();
        this.iAvailabilityHeader.setRotateFocus(true);
        this.iAvailabilityHeader.addButton("dates", MESSAGES.buttonPrevious(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                AddMeetingsDialog.this.setWidget((Widget)AddMeetingsDialog.this.iDatesForm);
                AddMeetingsDialog.this.recenter();
                AddMeetingsDialog.this.iResponse = null;
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        AddMeetingsDialog.this.iDates.setFocus(true);
                    }
                });
            }
        });
        this.iAvailabilityHeader.addButton("prev", MESSAGES.buttonLeft(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AddMeetingsDialog.this.populate(AddMeetingsDialog.this.iIndex - AddMeetingsDialog.this.iStep, null);
                AddMeetingsDialog.this.recenter();
            }
        });
        this.iAvailabilityHeader.addButton("next", MESSAGES.buttonRight(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AddMeetingsDialog.this.populate(AddMeetingsDialog.this.iIndex + AddMeetingsDialog.this.iStep, null);
                AddMeetingsDialog.this.recenter();
            }
        });
        this.iAvailabilityHeader.addButton("more", MESSAGES.buttonMoreOperations(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                final PopupPanel popup = new PopupPanel(true);
                MenuBar menu = new MenuBar(true);
                for (final SortRoomsBy sortBy : SortRoomsBy.values()) {
                    if (sortBy == SortRoomsBy.DISTANCE && !AddMeetingsDialog.this.iRooms.hasChip(new FilterBox.Chip("flag", "Nearby"))) continue;
                    MenuItem item = new MenuItem((sortBy.ordinal() == EventCookie.getInstance().getRoomsSortBy() ? "&uarr; " : (sortBy.ordinal() + SortRoomsBy.values().length == EventCookie.getInstance().getRoomsSortBy() ? "&darr; " : "")) + MESSAGES.opSortBy(AddMeetingsDialog.getSortRoomsByName(sortBy)), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            if (sortBy.ordinal() == EventCookie.getInstance().getRoomsSortBy()) {
                                EventCookie.getInstance().setSortRoomsBy(SortRoomsBy.values().length + sortBy.ordinal());
                            } else {
                                EventCookie.getInstance().setSortRoomsBy(sortBy.ordinal());
                            }
                            AddMeetingsDialog.this.populate(0, EventCookie.getInstance().getRoomsSortBy());
                            AddMeetingsDialog.this.recenter();
                        }
                    });
                    item.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    menu.addItem(item);
                }
                menu.addSeparator();
                MenuItem swapItem = new MenuItem(MESSAGES.opSwapAxes(), true, (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        popup.hide();
                        EventCookie.getInstance().setRoomsHorizontal(!EventCookie.getInstance().areRoomsHorizontal());
                        AddMeetingsDialog.this.populate(0, EventCookie.getInstance().getRoomsSortBy());
                        AddMeetingsDialog.this.recenter();
                    }
                });
                swapItem.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                menu.addItem(swapItem);
                MenuItem expandOrCollapseAll = new MenuItem(EventCookie.getInstance().isExpandRoomConflicts() ? MESSAGES.opCollapseAll() : MESSAGES.opExpandAll(), true, (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        popup.hide();
                        EventCookie.getInstance().setExpandRoomConflicts(!EventCookie.getInstance().isExpandRoomConflicts());
                        AddMeetingsDialog.this.populate(AddMeetingsDialog.this.iIndex, EventCookie.getInstance().getRoomsSortBy());
                        AddMeetingsDialog.this.recenter();
                    }
                });
                expandOrCollapseAll.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                menu.addItem(expandOrCollapseAll);
                menu.setVisible(true);
                menu.setFocusOnHoverEnabled(true);
                popup.add((Widget)menu);
                popup.showRelativeTo((UIObject)event.getSource());
                if (event.getSource() instanceof Focusable) {
                    final Focusable focusable = (Focusable)event.getSource();
                    popup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                        public void onClose(CloseEvent<PopupPanel> event) {
                            focusable.setFocus(true);
                        }
                    });
                }
                menu.focus();
            }
        });
        this.iAvailabilityHeader.addButton("select", MESSAGES.buttonSelect(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                AddMeetingsDialog.this.hide();
                ArrayList<EventInterface.MeetingInterface> meetings = new ArrayList<EventInterface.MeetingInterface>();
                for (Integer date : AddMeetingsDialog.this.getDates()) {
                    for (EventInterface.FilterRpcResponse.Entity room : AddMeetingsDialog.this.getRooms()) {
                        if (!AddMeetingsDialog.this.isSelected(date, room)) continue;
                        EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
                        meeting.setDayOfYear(date);
                        meeting.setStartSlot(AddMeetingsDialog.this.getStartSlot());
                        meeting.setEndSlot(AddMeetingsDialog.this.getEndSlot());
                        meeting.setStartOffset(0);
                        meeting.setEndOffset(-Integer.parseInt(room.getProperty("breakTime", "0")));
                        meeting.setLocation(new EventInterface.ResourceInterface(room));
                        meeting.setConflicts(AddMeetingsDialog.this.getConflicts(date, room));
                        meetings.add(meeting);
                    }
                }
                AddMeetingsDialog.this.iCallback.onSuccess(meetings);
            }
        });
        this.iAvailabilityForm.addHeaderRow((Widget)this.iAvailabilityHeader);
        this.iRoomAvailability = new P("unitime-MeetingSelection");
        this.iText = new AriaTextBox();
        this.iText.setStyleName("text");
        this.iScrollRooms = new ScrollPanel((Widget)this.iRoomAvailability);
        this.iAvailabilityForm.addRow((Widget)this.iScrollRooms);
        this.iAvailabilityForm.addNotPrintableBottomRow((Widget)this.iAvailabilityHeader.clonePanel());
        this.setWidget((Widget)this.iDatesForm);
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
            }
        });
        this.iText.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (AddMeetingsDialog.this.iResponse == null) {
                    return;
                }
                if (EventCookie.getInstance().areRoomsHorizontal()) {
                    int min = AddMeetingsDialog.this.iIndex;
                    int max = Math.min(AddMeetingsDialog.this.iIndex + AddMeetingsDialog.this.iStep, AddMeetingsDialog.this.getRooms().size()) - 1;
                    switch (event.getNativeKeyCode()) {
                        case 40: {
                            if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null) {
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).removeStyleName("hover");
                                int idx = Math.min(Math.max(0, AddMeetingsDialog.this.getDates().indexOf(AddMeetingsDialog.this.iHoverDate) + 1), AddMeetingsDialog.this.getDates().size() - 1);
                                AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(idx);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            } else {
                                AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(0);
                                AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(min);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            }
                            AddMeetingsDialog.this.iScrollRooms.ensureVisible((UIObject)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()));
                            break;
                        }
                        case 38: {
                            if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null) {
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).removeStyleName("hover");
                                int idx = Math.min(Math.max(0, AddMeetingsDialog.this.getDates().indexOf(AddMeetingsDialog.this.iHoverDate) - 1), AddMeetingsDialog.this.getDates().size() - 1);
                                AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(idx);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            } else {
                                AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(AddMeetingsDialog.this.getDates().size() - 1);
                                AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(min);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            }
                            AddMeetingsDialog.this.iScrollDates.ensureVisible((UIObject)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()));
                            break;
                        }
                        case 39: {
                            if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null) {
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).removeStyleName("hover");
                                int idx = Math.min(Math.max(min, AddMeetingsDialog.this.getRooms().indexOf(AddMeetingsDialog.this.iHoverLoc) + 1), max);
                                AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(idx);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                                break;
                            }
                            AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(0);
                            AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(min);
                            ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            break;
                        }
                        case 37: {
                            if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null) {
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).removeStyleName("hover");
                                int idx = Math.min(Math.max(min, AddMeetingsDialog.this.getRooms().indexOf(AddMeetingsDialog.this.iHoverLoc) - 1), max);
                                AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(idx);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                                break;
                            }
                            AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(0);
                            AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(max);
                            ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            break;
                        }
                        case 34: {
                            if (AddMeetingsDialog.this.iIndex + AddMeetingsDialog.this.iStep >= AddMeetingsDialog.this.getRooms().size()) break;
                            AddMeetingsDialog.this.populate(AddMeetingsDialog.this.iIndex + AddMeetingsDialog.this.iStep, null);
                            break;
                        }
                        case 33: {
                            if (AddMeetingsDialog.this.iIndex <= 0) break;
                            AddMeetingsDialog.this.populate(AddMeetingsDialog.this.iIndex - AddMeetingsDialog.this.iStep, null);
                            break;
                        }
                        case 13: 
                        case 32: {
                            if (AddMeetingsDialog.this.iHoverDate == null || AddMeetingsDialog.this.iHoverLoc == null) break;
                            AddMeetingsDialog.this.setSelected(AddMeetingsDialog.this.iHoverDate, AddMeetingsDialog.this.iHoverLoc, !AddMeetingsDialog.this.isSelected(AddMeetingsDialog.this.iHoverDate, AddMeetingsDialog.this.iHoverLoc));
                        }
                    }
                } else {
                    int min = AddMeetingsDialog.this.iIndex;
                    int max = Math.min(AddMeetingsDialog.this.iIndex + AddMeetingsDialog.this.iStep, AddMeetingsDialog.this.getDates().size()) - 1;
                    switch (event.getNativeKeyCode()) {
                        case 39: {
                            if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null) {
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).removeStyleName("hover");
                                int idx = Math.min(Math.max(min, AddMeetingsDialog.this.getDates().indexOf(AddMeetingsDialog.this.iHoverDate) + 1), max);
                                AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(idx);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            } else {
                                AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(min);
                                AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(0);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            }
                            AddMeetingsDialog.this.iScrollRooms.ensureVisible((UIObject)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()));
                            break;
                        }
                        case 37: {
                            if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null) {
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).removeStyleName("hover");
                                int idx = Math.min(Math.max(min, AddMeetingsDialog.this.getDates().indexOf(AddMeetingsDialog.this.iHoverDate) - 1), max);
                                AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(idx);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            } else {
                                AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(max);
                                AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(0);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            }
                            AddMeetingsDialog.this.iScrollDates.ensureVisible((UIObject)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()));
                            break;
                        }
                        case 40: {
                            if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null) {
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).removeStyleName("hover");
                                int idx = Math.min(Math.max(0, AddMeetingsDialog.this.getRooms().indexOf(AddMeetingsDialog.this.iHoverLoc) + 1), AddMeetingsDialog.this.getRooms().size() - 1);
                                AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(idx);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                                break;
                            }
                            AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(min);
                            AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(0);
                            ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            break;
                        }
                        case 38: {
                            if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null) {
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).removeStyleName("hover");
                                int idx = Math.min(Math.max(0, AddMeetingsDialog.this.getRooms().indexOf(AddMeetingsDialog.this.iHoverLoc) - 1), AddMeetingsDialog.this.getRooms().size() - 1);
                                AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(idx);
                                ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                                break;
                            }
                            AddMeetingsDialog.this.iHoverDate = AddMeetingsDialog.this.getDates().get(min);
                            AddMeetingsDialog.this.iHoverLoc = AddMeetingsDialog.this.getRooms().get(AddMeetingsDialog.this.getRooms().size() - 1);
                            ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                            break;
                        }
                        case 34: {
                            if (AddMeetingsDialog.this.iIndex + AddMeetingsDialog.this.iStep >= AddMeetingsDialog.this.getDates().size()) break;
                            AddMeetingsDialog.this.populate(AddMeetingsDialog.this.iIndex + AddMeetingsDialog.this.iStep, null);
                            break;
                        }
                        case 33: {
                            if (AddMeetingsDialog.this.iIndex <= 0) break;
                            AddMeetingsDialog.this.populate(AddMeetingsDialog.this.iIndex - AddMeetingsDialog.this.iStep, null);
                            break;
                        }
                        case 13: 
                        case 32: {
                            if (AddMeetingsDialog.this.iHoverDate == null || AddMeetingsDialog.this.iHoverLoc == null) break;
                            AddMeetingsDialog.this.setSelected(AddMeetingsDialog.this.iHoverDate, AddMeetingsDialog.this.iHoverLoc, !AddMeetingsDialog.this.isSelected(AddMeetingsDialog.this.iHoverDate, AddMeetingsDialog.this.iHoverLoc));
                        }
                    }
                }
                AddMeetingsDialog.this.iText.setAriaLabel(AddMeetingsDialog.this.toAriaLabel(true, true, false));
            }
        });
        this.iText.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                switch (event.getNativeEvent().getKeyCode()) {
                    case 33: 
                    case 34: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        event.preventDefault();
                    }
                }
            }
        });
        this.iText.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                switch (event.getNativeEvent().getKeyCode()) {
                    case 32: {
                        if (AddMeetingsDialog.this.iText.getValue().isEmpty()) {
                            event.preventDefault();
                        }
                        return;
                    }
                    case 13: {
                        event.preventDefault();
                        return;
                    }
                }
            }
        });
        this.iText.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null) {
                    ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).addStyleName("hover");
                }
                AddMeetingsDialog.this.iText.setAriaLabel(AddMeetingsDialog.this.toAriaLabel(true, true, false));
            }
        });
        this.iText.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null) {
                    ((P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))).removeStyleName("hover");
                }
            }
        });
    }

    public static String getSortRoomsByName(SortRoomsBy sortBy) {
        switch (sortBy) {
            case CAPACITY: {
                return MESSAGES.colCapacity();
            }
            case NAME: {
                return MESSAGES.colName();
            }
            case DISTANCE: {
                return MESSAGES.colRoomDistance();
            }
            case AVAILABILITY: {
                return MESSAGES.colRoomAvailability();
            }
        }
        return null;
    }

    public Comparator<EventInterface.FilterRpcResponse.Entity> getSortRoomsComparator(SortRoomsBy sortBy, final boolean preferSize, final List<Integer> dates) {
        switch (sortBy) {
            case CAPACITY: {
                return new Comparator<EventInterface.FilterRpcResponse.Entity>(){

                    @Override
                    public int compare(EventInterface.FilterRpcResponse.Entity r1, EventInterface.FilterRpcResponse.Entity r2) {
                        int cmp = Integer.valueOf(r1.getProperty("capacity", "0")).compareTo(Integer.valueOf(r2.getProperty("capacity", "0")));
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = r1.getName().compareTo(r2.getName());
                        return cmp == 0 ? r1.getUniqueId().compareTo(r2.getUniqueId()) : cmp;
                    }
                };
            }
            case NAME: {
                return new Comparator<EventInterface.FilterRpcResponse.Entity>(){

                    @Override
                    public int compare(EventInterface.FilterRpcResponse.Entity r1, EventInterface.FilterRpcResponse.Entity r2) {
                        int cmp = r1.getName().compareTo(r2.getName());
                        return cmp == 0 ? r1.getUniqueId().compareTo(r2.getUniqueId()) : cmp;
                    }
                };
            }
            case DISTANCE: {
                return new Comparator<EventInterface.FilterRpcResponse.Entity>(){

                    @Override
                    public int compare(EventInterface.FilterRpcResponse.Entity r1, EventInterface.FilterRpcResponse.Entity r2) {
                        int cmp = Integer.valueOf(r1.getProperty("distance", "0")).compareTo(Integer.valueOf(r2.getProperty("distance", "0")));
                        if (cmp != 0) {
                            return cmp;
                        }
                        if (preferSize && (cmp = Integer.valueOf(r1.getProperty("capacity", "0")).compareTo(Integer.valueOf(r2.getProperty("capacity", "0")))) != 0) {
                            return cmp;
                        }
                        cmp = r1.getName().compareTo(r2.getName());
                        return cmp == 0 ? r1.getUniqueId().compareTo(r2.getUniqueId()) : cmp;
                    }
                };
            }
            case AVAILABILITY: {
                return new Comparator<EventInterface.FilterRpcResponse.Entity>(){

                    @Override
                    public int compare(EventInterface.FilterRpcResponse.Entity r1, EventInterface.FilterRpcResponse.Entity r2) {
                        int cmp;
                        if (dates != null) {
                            int a1 = 0;
                            int a2 = 0;
                            for (Integer date : dates) {
                                Set<EventInterface.MeetingConflictInterface> c1 = AddMeetingsDialog.this.getConflicts(date, r1);
                                Set<EventInterface.MeetingConflictInterface> c2 = AddMeetingsDialog.this.getConflicts(date, r2);
                                if (c1 == null || c1.isEmpty()) {
                                    ++a1;
                                }
                                if (c2 != null && !c2.isEmpty()) continue;
                                ++a2;
                            }
                            if (a1 > a2) {
                                return -1;
                            }
                            if (a1 < a2) {
                                return 1;
                            }
                        }
                        if ((cmp = Integer.valueOf(r1.getProperty("distance", "0")).compareTo(Integer.valueOf(r2.getProperty("distance", "0")))) != 0) {
                            return cmp;
                        }
                        if (preferSize && (cmp = Integer.valueOf(r1.getProperty("capacity", "0")).compareTo(Integer.valueOf(r2.getProperty("capacity", "0")))) != 0) {
                            return cmp;
                        }
                        cmp = r1.getName().compareTo(r2.getName());
                        return cmp == 0 ? r1.getUniqueId().compareTo(r2.getUniqueId()) : cmp;
                    }
                };
            }
        }
        return null;
    }

    public static Comparator<EventInterface.FilterRpcResponse.Entity> inverse(final Comparator<EventInterface.FilterRpcResponse.Entity> cmp) {
        return new Comparator<EventInterface.FilterRpcResponse.Entity>(){

            @Override
            public int compare(EventInterface.FilterRpcResponse.Entity r1, EventInterface.FilterRpcResponse.Entity r2) {
                return -cmp.compare(r1, r2);
            }
        };
    }

    public void showDialog(Long eventId, List<EventInterface.MeetingConflictInterface> conflicts) {
        this.iStep = Math.max(1, (Window.getClientWidth() - 100) / 105);
        ToolBox.setMaxHeight(this.iScrollRooms.getElement().getStyle(), Window.getClientHeight() - 100 + "px");
        ToolBox.setMaxHeight(this.iScrollDates.getElement().getStyle(), Window.getClientHeight() - 100 + "px");
        int nrMonths = Math.max(1, Math.min(5, (Window.getClientWidth() - 100) / 225));
        this.iDates.setWidth(225 * nrMonths + "px");
        this.iConflicts = conflicts;
        this.iResponse = null;
        this.iEventId = eventId;
        this.setWidget((Widget)this.iDatesForm);
        this.center();
        RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.iDates.setFocus(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.getElement().getClientHeight() > Window.getClientHeight() - 100) {
            this.recenter();
        }
    }

    public void hide() {
        super.hide();
        GwtHint.getInstance().hide();
    }

    public List<EventInterface.FilterRpcResponse.Entity> getRooms() {
        return this.iMatchingRooms;
    }

    public Integer getStartSlot() {
        return this.iTimes.getValue().getStart();
    }

    public Integer getEndSlot() {
        return this.iTimes.getValue().getEnd();
    }

    public List<Integer> getDates() {
        return this.iDates.getSelectedDays();
    }

    public boolean isSelected(Integer date, EventInterface.FilterRpcResponse.Entity room) {
        return this.iSelected.contains(date + ":" + room.getUniqueId());
    }

    public void reset(String roomFilterValue, List<Date> selectedDates, StartEndTimeSelector.StartEndTime selectedTimes) {
        this.reset(roomFilterValue, null, selectedDates, selectedTimes);
    }

    public void reset(String roomFilterValue, List<EventInterface.MeetingInterface> meetings, List<Date> selectedDates, StartEndTimeSelector.StartEndTime selectedTimes) {
        this.iMatchingRooms = null;
        this.iDates.setValue(selectedDates);
        this.iTimes.setValue(selectedTimes, true);
        this.iTimes.setDiff(12);
        this.iRooms.setValue(roomFilterValue == null || roomFilterValue.isEmpty() ? "flag:Event" : (roomFilterValue.contains("flag:All") || roomFilterValue.contains("flag:Event") ? roomFilterValue : "flag:Event " + roomFilterValue), true);
        this.iSelected.clear();
        if (meetings != null && !meetings.isEmpty()) {
            EventInterface.MeetingInterface first = meetings.get(0);
            this.iTimes.setValue(new StartEndTimeSelector.StartEndTime(first.getStartSlot(), first.getEndSlot()), true);
            TreeSet<Date> dates = new TreeSet<Date>();
            TreeSet<String> rooms = new TreeSet<String>();
            for (EventInterface.MeetingInterface m : meetings) {
                dates.add(m.getMeetingDate());
                if (m.getLocation() == null) continue;
                this.iSelected.add(m.getDayOfYear() + ":" + m.getLocation().getId());
                rooms.add(m.getLocationName());
            }
            this.iDates.setValue(new ArrayList<Date>(dates));
            String roomFilter = "";
            for (String room : rooms) {
                if (!roomFilter.isEmpty()) {
                    roomFilter = roomFilter + " or ";
                }
                roomFilter = roomFilter + room;
            }
            this.iRooms.setValue((roomFilterValue == null || roomFilterValue.isEmpty() ? "flag:Event" : (roomFilterValue.contains("flag:All") || roomFilterValue.contains("flag:Event") ? roomFilterValue : "flag:Event " + roomFilterValue)) + (roomFilter.isEmpty() ? "" : " " + roomFilter), true);
        }
    }

    private void populate(int index, Integer sortBy) {
        Comparator<EventInterface.FilterRpcResponse.Entity> comparator;
        if (sortBy != null && sortBy >= 0 && sortBy < SortRoomsBy.values().length) {
            Comparator<EventInterface.FilterRpcResponse.Entity> comparator2 = this.getSortRoomsComparator(SortRoomsBy.values()[sortBy], this.iRooms.getChip("size") != null, this.getDates());
            if (comparator2 != null) {
                Collections.sort(this.iMatchingRooms, comparator2);
            }
        } else if (sortBy != null && sortBy >= SortRoomsBy.values().length && sortBy < 2 * SortRoomsBy.values().length && (comparator = this.getSortRoomsComparator(SortRoomsBy.values()[sortBy - SortRoomsBy.values().length], this.iRooms.getChip("size") != null, this.getDates())) != null) {
            Collections.sort(this.iMatchingRooms, AddMeetingsDialog.inverse(comparator));
        }
        if (EventCookie.getInstance().areRoomsHorizontal()) {
            this.populateHorizontal(index);
        } else {
            this.populateVertical(index);
        }
        AriaStatus.getInstance().setText(this.toAriaLabel(false, true, true));
    }

    protected String conflicts2html(Set<EventInterface.MeetingConflictInterface> conflicts) {
        String conf = "";
        int count = 0;
        for (EventInterface.MeetingConflictInterface event : conflicts) {
            if (EventCookie.getInstance().isExpandRoomConflicts() || conflicts.size() == 1) {
                conf = conf + (conf.isEmpty() ? "" : "<br>") + event.getName() + (event.getType() == EventInterface.EventType.Unavailabile ? "" : "<br><span class='type'>" + (event.hasLimit() ? (event.hasEnrollment() ? MESSAGES.addMeetingsLimitEnrollmentAndType(event.getLimit(), event.getEnrollment(), CONSTANTS.eventTypeShort()[event.getType().ordinal()]) : MESSAGES.addMeetingsLimitAndType(event.getLimit(), CONSTANTS.eventTypeShort()[event.getType().ordinal()])) : event.getType().getAbbreviation(CONSTANTS)) + "</span>") + "<br><span class='time'>" + TimeSelector.TimeUtils.slot2short(event.getStartSlot()) + " - " + TimeSelector.TimeUtils.slot2short(event.getEndSlot()) + "</span>";
            } else {
                if (count == 2 && conflicts.size() > 2) {
                    conf = conf + "<br>...";
                    break;
                }
                conf = conf + (conf.isEmpty() ? "" : "<br>") + event.getName() + (event.getType() == EventInterface.EventType.Unavailabile ? "" : " (" + CONSTANTS.eventTypeShort()[event.getType().ordinal()] + ")");
            }
            ++count;
        }
        return conf;
    }

    protected String conflicts2text(EventInterface.FilterRpcResponse.Entity room, Date d, Set<EventInterface.MeetingConflictInterface> conflicts) {
        String capacity = room.getProperty("capacity", null);
        String distance = room.getProperty("distance", null);
        String hint = room.getProperty("type", null) + (capacity != null ? ", " + MESSAGES.hintRoomCapacity(capacity) : "") + (distance != null && !"0".equals(distance) ? ", " + MESSAGES.hintRoomDistance(distance) : "");
        String message = ARIA.dateTimeRoomSelection(sAriaDateFormat.format(d), TimeSelector.TimeUtils.slot2aria(this.getStartSlot()), TimeSelector.TimeUtils.slot2aria(this.getEndSlot()), room.getName(), hint);
        if (conflicts != null && !conflicts.isEmpty()) {
            message = message + ". " + MESSAGES.propConflicts();
            for (EventInterface.MeetingConflictInterface event : conflicts) {
                message = message + " " + (event.getType() == EventInterface.EventType.Unavailabile ? "" : event.getType().getAbbreviation(CONSTANTS)) + " " + event.getName() + " " + ARIA.timeSelection(TimeSelector.TimeUtils.slot2aria(event.getStartSlot()), TimeSelector.TimeUtils.slot2aria(event.getEndSlot()));
            }
        } else {
            message = message + ARIA.selectionAvailable();
        }
        return message;
    }

    protected String conflicts2hint(EventInterface.FilterRpcResponse.Entity room, Date d, Set<EventInterface.MeetingConflictInterface> conflicts) {
        String capacity = room.getProperty("capacity", null);
        String distance = room.getProperty("distance", null);
        String hint = room.getProperty("type", null) + (capacity != null ? ", " + MESSAGES.hintRoomCapacity(capacity) : "") + (distance != null && !"0".equals(distance) ? ", " + MESSAGES.hintRoomDistance(distance) : "");
        String message = MESSAGES.dateTimeHint(sDayOfWeek.format(d), sDateFormat.format(d), TimeSelector.TimeUtils.slot2short(this.getStartSlot()), TimeSelector.TimeUtils.slot2short(this.getEndSlot())) + "<br>" + room.getName() + " (" + hint + ")";
        if (conflicts != null && !conflicts.isEmpty()) {
            boolean hasSponsorOrInstructor = false;
            boolean hasLimit = false;
            boolean hasEnrollment = false;
            for (EventInterface.MeetingConflictInterface event : conflicts) {
                if (event.hasSponsor() || event.hasInstructors()) {
                    hasSponsorOrInstructor = true;
                }
                if (event.hasLimit()) {
                    hasLimit = true;
                }
                if (!event.hasEnrollment()) continue;
                hasEnrollment = true;
            }
            message = message + "<br>" + MESSAGES.propConflicts();
            message = message + "<table border='0' class='table'><tr class='row'><td class='header'>" + MESSAGES.colName() + "</td>" + "<td class='header'>" + MESSAGES.colType() + "</td>" + "<td class='header'>" + MESSAGES.colTime() + "</td>" + (hasEnrollment ? "<td class='header'>" + MESSAGES.colEnrollment() + "</td>" : "") + (hasLimit ? "<td class='header'>" + MESSAGES.colLimit() + "</td>" : "") + (hasSponsorOrInstructor ? "<td class='header'>" + MESSAGES.colSponsorOrInstructor() + "</td>" : "") + "</tr>";
            for (EventInterface.MeetingConflictInterface event : conflicts) {
                message = message + "<tr class='row'><td>" + event.getName() + "</td><td>" + event.getType().getAbbreviation(CONSTANTS) + "</td>" + "<td>" + TimeSelector.TimeUtils.slot2short(event.getStartSlot()) + " - " + TimeSelector.TimeUtils.slot2short(event.getEndSlot()) + "</td>" + (hasEnrollment ? "<td align='right'>" + (event.hasEnrollment() ? event.getEnrollment().toString() : "") + "</td>" : "") + (hasLimit ? "<td align='right'>" + (event.hasLimit() ? event.getLimit().toString() : "") + "</td>" : "") + (hasSponsorOrInstructor ? "<td>" + (event.hasSponsor() ? event.getSponsor().getName() : (event.hasInstructors() ? event.getInstructorNames("<br>", MESSAGES) : "")) + "</td>" : "") + "</tr>";
            }
            message = message + "</table>";
        }
        return message;
    }

    private void populateHorizontal(int index) {
        this.iIndex = index;
        if (this.iIndex < 0) {
            this.iIndex = 0;
        }
        if (this.iIndex >= this.getRooms().size()) {
            this.iIndex = this.iStep * (this.getRooms().size() / this.iStep);
        }
        this.iAvailabilityHeader.setEnabled("prev", this.iIndex > 0);
        this.iAvailabilityHeader.setEnabled("next", this.iIndex + this.iStep < this.getRooms().size());
        this.iRoomAvailability.clear();
        this.iRoomAvailability.add((Widget)this.iText);
        this.iPanels.clear();
        P box = new P("box");
        this.iRoomAvailability.add((Widget)box);
        P row = new P("row");
        box.add((Widget)row);
        row.add((Widget)new P("corner"));
        for (int i = this.iIndex; i < this.iIndex + this.iStep && i < this.getRooms().size(); ++i) {
            final EventInterface.FilterRpcResponse.Entity room = this.getRooms().get(i);
            final P p = new P("room");
            String displayName = room.getProperty("display", null);
            p.setHTML(MESSAGES.singleRoomSelection(room.getName() + (displayName != null && !displayName.isEmpty() ? "<br>" + displayName : ""), room.getProperty("type", null), room.getProperty("capacity", null)));
            if ("1".equals(room.getProperty("ignoreRoomCheck", "0"))) {
                p.addStyleName("unitime-IgnoreRoomCheck");
            }
            p.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    P p2;
                    if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null && (p2 = (P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))) != null) {
                        p2.removeStyleName("hover");
                    }
                    ((P)((Object)event.getSource())).addStyleName("hover");
                    RoomHint.showHint((Element)p.getElement(), room.getUniqueId(), "", room.getProperty("distance", ""), true);
                }
            });
            p.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    ((P)((Object)event.getSource())).removeStyleName("hover");
                    RoomHint.hideHint();
                }
            });
            row.add((Widget)p);
            p.addMouseDownHandler(new MouseDownHandler(){

                public void onMouseDown(MouseDownEvent event) {
                    boolean selected = true;
                    for (Integer date : AddMeetingsDialog.this.getDates()) {
                        if (AddMeetingsDialog.this.isSelected(date, room)) continue;
                        selected = false;
                        AddMeetingsDialog.this.setSelected(date, room, true);
                    }
                    if (selected) {
                        for (Integer date : AddMeetingsDialog.this.getDates()) {
                            AddMeetingsDialog.this.setSelected(date, room, false);
                        }
                    }
                    event.preventDefault();
                    event.stopPropagation();
                    AddMeetingsDialog.this.iText.setFocus(true);
                }
            });
        }
        for (final Integer date : this.getDates()) {
            row = new P("row");
            box.add((Widget)row);
            P day = new P("date");
            final Date d = this.iDates.getDate(date);
            day.setHTML(MESSAGES.dateTimeHeader(sDayOfWeek.format(d), sDateFormat.format(d), TimeSelector.TimeUtils.slot2short(this.getStartSlot()), TimeSelector.TimeUtils.slot2short(this.getEndSlot())));
            row.add((Widget)day);
            day.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    P p;
                    if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null && (p = (P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))) != null) {
                        p.removeStyleName("hover");
                    }
                    ((P)((Object)event.getSource())).addStyleName("hover");
                }
            });
            day.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    ((P)((Object)event.getSource())).removeStyleName("hover");
                }
            });
            day.addMouseDownHandler(new MouseDownHandler(){

                public void onMouseDown(MouseDownEvent event) {
                    EventInterface.FilterRpcResponse.Entity room;
                    int i;
                    boolean selected = true;
                    for (i = AddMeetingsDialog.this.iIndex; i < AddMeetingsDialog.this.iIndex + AddMeetingsDialog.this.iStep && i < AddMeetingsDialog.this.getRooms().size(); ++i) {
                        room = AddMeetingsDialog.this.getRooms().get(i);
                        if (AddMeetingsDialog.this.isSelected(date, room)) continue;
                        selected = false;
                        AddMeetingsDialog.this.setSelected(date, room, true);
                    }
                    if (selected) {
                        for (i = AddMeetingsDialog.this.iIndex; i < AddMeetingsDialog.this.iIndex + AddMeetingsDialog.this.iStep && i < AddMeetingsDialog.this.getRooms().size(); ++i) {
                            room = AddMeetingsDialog.this.getRooms().get(i);
                            AddMeetingsDialog.this.setSelected(date, room, false);
                        }
                    }
                    event.preventDefault();
                    event.stopPropagation();
                    AddMeetingsDialog.this.iText.setFocus(true);
                }
            });
            for (int i = this.iIndex; i < this.iIndex + this.iStep && i < this.getRooms().size(); ++i) {
                final EventInterface.FilterRpcResponse.Entity room = this.getRooms().get(i);
                final Set<EventInterface.MeetingConflictInterface> conflicts = this.getConflicts(date, room);
                final P p = new P("cell");
                if (conflicts == null || conflicts.isEmpty()) {
                    p.addStyleName("free");
                } else {
                    p.addStyleName("conflict");
                    p.setHTML(this.conflicts2html(conflicts));
                }
                Roles.getTextboxRole().setAriaLabelProperty((Element)p.getElement(), this.conflicts2text(room, d, conflicts));
                this.iPanels.put(date + ":" + room.getUniqueId(), p);
                p.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        AddMeetingsDialog.this.setSelected(date, room, !AddMeetingsDialog.this.isSelected(date, room));
                        event.preventDefault();
                        event.stopPropagation();
                        AddMeetingsDialog.this.iText.setFocus(true);
                    }
                });
                if (this.isSelected(date, room)) {
                    p.addStyleName("selected");
                }
                row.add((Widget)p);
                p.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent event) {
                        P p2;
                        if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null && (p2 = (P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))) != null) {
                            p2.removeStyleName("hover");
                        }
                        ((P)((Object)event.getSource())).addStyleName("hover");
                        AddMeetingsDialog.this.iHoverDate = date;
                        AddMeetingsDialog.this.iHoverLoc = room;
                        GwtHint.showHint((Element)p.getElement(), AddMeetingsDialog.this.conflicts2hint(room, d, conflicts));
                        event.preventDefault();
                        event.stopPropagation();
                        AddMeetingsDialog.this.iText.setFocus(true);
                    }
                });
                p.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent event) {
                        ((P)((Object)event.getSource())).removeStyleName("hover");
                        GwtHint.hideHint();
                    }
                });
            }
        }
        HashSet<String> selected = new HashSet<String>();
        for (Integer date : this.getDates()) {
            for (EventInterface.FilterRpcResponse.Entity room : this.getRooms()) {
                String selection = date + ":" + room.getUniqueId();
                if (!this.iSelected.contains(selection)) continue;
                selected.add(selection);
            }
        }
        this.iSelected = selected;
        this.iAvailabilityHeader.setEnabled("select", !selected.isEmpty());
        if (this.iHoverDate != null && this.iHoverLoc != null && this.iPanels.get(this.iHoverDate + ":" + this.iHoverLoc.getUniqueId()) == null) {
            this.iHoverDate = null;
            this.iHoverLoc = null;
        }
    }

    private void populateVertical(int index) {
        this.iIndex = index;
        if (this.iIndex < 0) {
            this.iIndex = 0;
        }
        if (this.iIndex >= this.getDates().size()) {
            this.iIndex = this.iStep * (this.getDates().size() / this.iStep);
        }
        this.iAvailabilityHeader.setEnabled("prev", this.iIndex > 0);
        this.iAvailabilityHeader.setEnabled("next", this.iIndex + this.iStep < this.getDates().size());
        this.iRoomAvailability.clear();
        this.iRoomAvailability.add((Widget)this.iText);
        this.iPanels.clear();
        P box = new P("box");
        this.iRoomAvailability.add((Widget)box);
        P row = new P("row");
        box.add((Widget)row);
        row.add((Widget)new P("corner"));
        for (int i = this.iIndex; i < this.iIndex + this.iStep && i < this.getDates().size(); ++i) {
            final Integer date = this.getDates().get(i);
            P day = new P("room");
            Date d = this.iDates.getDate(date);
            day.setHTML(MESSAGES.dateTimeHeader(sDayOfWeek.format(d), sDateFormat.format(d), TimeSelector.TimeUtils.slot2short(this.getStartSlot()), TimeSelector.TimeUtils.slot2short(this.getEndSlot())));
            row.add((Widget)day);
            day.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    P p;
                    if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null && (p = (P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))) != null) {
                        p.removeStyleName("hover");
                    }
                    ((P)((Object)event.getSource())).addStyleName("hover");
                }
            });
            day.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    ((P)((Object)event.getSource())).removeStyleName("hover");
                }
            });
            day.addMouseDownHandler(new MouseDownHandler(){

                public void onMouseDown(MouseDownEvent event) {
                    boolean selected = true;
                    for (EventInterface.FilterRpcResponse.Entity room : AddMeetingsDialog.this.getRooms()) {
                        if (AddMeetingsDialog.this.isSelected(date, room)) continue;
                        selected = false;
                        AddMeetingsDialog.this.setSelected(date, room, true);
                    }
                    if (selected) {
                        for (EventInterface.FilterRpcResponse.Entity room : AddMeetingsDialog.this.getRooms()) {
                            AddMeetingsDialog.this.setSelected(date, room, false);
                        }
                    }
                    event.preventDefault();
                    event.stopPropagation();
                    AddMeetingsDialog.this.iText.setFocus(true);
                }
            });
        }
        for (int ri = 0; ri < this.getRooms().size(); ++ri) {
            row = new P("row");
            box.add((Widget)row);
            final EventInterface.FilterRpcResponse.Entity room = this.getRooms().get(ri);
            final P prm = new P("date");
            String displayName = room.getProperty("display", null);
            prm.setHTML(MESSAGES.singleRoomSelection(room.getName() + (displayName != null && !displayName.isEmpty() ? "<br>" + displayName : ""), room.getProperty("type", null), room.getProperty("capacity", null)));
            if ("1".equals(room.getProperty("ignoreRoomCheck", "0"))) {
                prm.addStyleName("unitime-IgnoreRoomCheck");
            }
            prm.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    P p;
                    if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null && (p = (P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))) != null) {
                        p.removeStyleName("hover");
                    }
                    ((P)((Object)event.getSource())).addStyleName("hover");
                    RoomHint.showHint((Element)prm.getElement(), room.getUniqueId(), "", room.getProperty("distance", ""), true);
                }
            });
            prm.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    ((P)((Object)event.getSource())).removeStyleName("hover");
                    RoomHint.hideHint();
                }
            });
            row.add((Widget)prm);
            prm.addMouseDownHandler(new MouseDownHandler(){

                public void onMouseDown(MouseDownEvent event) {
                    Integer date;
                    int i;
                    boolean selected = true;
                    for (i = AddMeetingsDialog.this.iIndex; i < AddMeetingsDialog.this.iIndex + AddMeetingsDialog.this.iStep && i < AddMeetingsDialog.this.getDates().size(); ++i) {
                        date = AddMeetingsDialog.this.getDates().get(i);
                        if (AddMeetingsDialog.this.isSelected(date, room)) continue;
                        selected = false;
                        AddMeetingsDialog.this.setSelected(date, room, true);
                    }
                    if (selected) {
                        for (i = AddMeetingsDialog.this.iIndex; i < AddMeetingsDialog.this.iIndex + AddMeetingsDialog.this.iStep && i < AddMeetingsDialog.this.getDates().size(); ++i) {
                            date = AddMeetingsDialog.this.getDates().get(i);
                            AddMeetingsDialog.this.setSelected(date, room, false);
                        }
                    }
                    event.preventDefault();
                    event.stopPropagation();
                    AddMeetingsDialog.this.iText.setFocus(true);
                }
            });
            for (int i = this.iIndex; i < this.iIndex + this.iStep && i < this.getDates().size(); ++i) {
                final Integer date = this.getDates().get(i);
                final Set<EventInterface.MeetingConflictInterface> conflicts = this.getConflicts(date, room);
                final Date d = this.iDates.getDate(date);
                final P p = new P("cell");
                if (conflicts == null || conflicts.isEmpty()) {
                    p.addStyleName("free");
                } else {
                    p.addStyleName("conflict");
                    p.setHTML(this.conflicts2html(conflicts));
                }
                Roles.getTextboxRole().setAriaLabelProperty((Element)p.getElement(), this.conflicts2text(room, d, conflicts));
                this.iPanels.put(date + ":" + room.getUniqueId(), p);
                p.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        AddMeetingsDialog.this.setSelected(date, room, !AddMeetingsDialog.this.isSelected(date, room));
                        event.preventDefault();
                        event.stopPropagation();
                        AddMeetingsDialog.this.iText.setFocus(true);
                    }
                });
                if (this.isSelected(date, room)) {
                    p.addStyleName("selected");
                }
                row.add((Widget)p);
                p.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent event) {
                        P p2;
                        if (AddMeetingsDialog.this.iHoverDate != null && AddMeetingsDialog.this.iHoverLoc != null && (p2 = (P)((Object)AddMeetingsDialog.this.iPanels.get(AddMeetingsDialog.this.iHoverDate + ":" + AddMeetingsDialog.this.iHoverLoc.getUniqueId()))) != null) {
                            p2.removeStyleName("hover");
                        }
                        ((P)((Object)event.getSource())).addStyleName("hover");
                        AddMeetingsDialog.this.iHoverDate = date;
                        AddMeetingsDialog.this.iHoverLoc = room;
                        GwtHint.showHint((Element)p.getElement(), AddMeetingsDialog.this.conflicts2hint(room, d, conflicts));
                        event.preventDefault();
                        event.stopPropagation();
                        AddMeetingsDialog.this.iText.setFocus(true);
                    }
                });
                p.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent event) {
                        ((P)((Object)event.getSource())).removeStyleName("hover");
                        GwtHint.hideHint();
                    }
                });
            }
        }
        HashSet<String> selected = new HashSet<String>();
        for (Integer date : this.getDates()) {
            for (EventInterface.FilterRpcResponse.Entity room : this.getRooms()) {
                String selection = date + ":" + room.getUniqueId();
                if (!this.iSelected.contains(selection)) continue;
                selected.add(selection);
            }
        }
        this.iSelected = selected;
        this.iAvailabilityHeader.setEnabled("select", !selected.isEmpty());
        if (this.iHoverDate != null && this.iHoverLoc != null && this.iPanels.get(this.iHoverDate + ":" + this.iHoverLoc.getUniqueId()) == null) {
            this.iHoverDate = null;
            this.iHoverLoc = null;
        }
    }

    public Set<EventInterface.MeetingConflictInterface> getConflicts(Integer date, EventInterface.FilterRpcResponse.Entity room) {
        Set<EventInterface.MeetingConflictInterface> overlaps;
        HashSet<EventInterface.MeetingConflictInterface> conflicts = new HashSet<EventInterface.MeetingConflictInterface>();
        if (this.iConflicts != null) {
            for (EventInterface.MeetingConflictInterface m : this.iConflicts) {
                if (m.getDayOfYear() != date.intValue() || m.getLocation() == null || !m.getLocation().getId().equals(room.getUniqueId()) || this.getStartSlot() >= m.getEndSlot() || m.getStartSlot() >= this.getEndSlot()) continue;
                conflicts.add(m);
            }
        }
        if (this.iResponse != null && (overlaps = this.iResponse.getOverlaps(date, Long.valueOf(room.getProperty("permId", null)))) != null) {
            conflicts.addAll(overlaps);
        }
        return conflicts;
    }

    public void setSelected(Integer date, EventInterface.FilterRpcResponse.Entity room, boolean selected) {
        Set<EventInterface.MeetingConflictInterface> conf;
        String dateStr = sAriaDateFormat.format(this.iDates.getDate(date));
        String roomStr = room.getName();
        if (!"1".equals(room.getProperty("overbook", "0")) && selected && (conf = this.getConflicts(date, room)) != null && !conf.isEmpty()) {
            AriaStatus.getInstance().setText(ARIA.dateRoomCanNotSelect(dateStr, roomStr));
            return;
        }
        String selection = date + ":" + room.getUniqueId();
        P p = this.iPanels.get(selection);
        if (selected) {
            p.addStyleName("selected");
            this.iSelected.add(selection);
        } else {
            p.removeStyleName("selected");
            this.iSelected.remove(selection);
        }
        this.iAvailabilityHeader.setEnabled("select", !this.iSelected.isEmpty());
        AriaStatus.getInstance().setText(selected ? ARIA.dateRoomSelected(dateStr, roomStr) : ARIA.dateRoomUnselected(dateStr, roomStr));
        this.iText.setText("");
    }

    public void recenter() {
        GwtHint.getInstance().hide();
        this.iScrollRooms.getElement().getStyle().clearHeight();
        if (this.getElement().getClientHeight() > Window.getClientHeight() - 100) {
            this.iScrollRooms.getElement().getStyle().setHeight((double)(Window.getClientHeight() - 200), Style.Unit.PX);
        }
        this.iScrollDates.getElement().getStyle().clearHeight();
        if (this.getElement().getClientHeight() > Window.getClientHeight() - 100) {
            this.iScrollDates.getElement().getStyle().setHeight((double)(Window.getClientHeight() - 200), Style.Unit.PX);
        }
        int left = Window.getClientWidth() - this.getOffsetWidth() >> 1;
        int top = Window.getClientHeight() - this.getOffsetHeight() >> 1;
        this.setPopupPosition(Math.max(Window.getScrollLeft() + left, 0), Math.max(Window.getScrollTop() + top, 0));
    }

    public String toAriaLabel(boolean hover, boolean description, boolean selection) {
        String label = "";
        if (hover && this.iHoverDate != null && this.iHoverLoc != null) {
            P p = this.iPanels.get(this.iHoverDate + ":" + this.iHoverLoc.getUniqueId());
            label = this.iSelected.contains(this.iHoverDate + ":" + this.iHoverLoc.getUniqueId()) ? ARIA.selectedSelection(Roles.getTextboxRole().getAriaLabelProperty((Element)p.getElement())) : Roles.getTextboxRole().getAriaLabelProperty((Element)p.getElement());
        } else if (description) {
            label = EventCookie.getInstance().areRoomsHorizontal() ? ARIA.meetingSelectionDescriptionRoomsHorizontal(this.getDates().size(), 1 + this.iIndex, Math.min(this.iIndex + this.iStep, this.getRooms().size())) : ARIA.meetingSelectionDescriptionDatesHorizontal(this.getRooms().size(), 1 + this.iIndex, Math.min(this.iIndex + this.iStep, this.getDates().size()));
        }
        if (selection) {
            if (this.iSelected.isEmpty()) {
                label = label + " " + ARIA.meetingSelectionNothingSelected();
            } else {
                String selected = "";
                for (Integer date : this.getDates()) {
                    for (EventInterface.FilterRpcResponse.Entity room : this.getRooms()) {
                        if (!this.iSelected.contains(date + ":" + room.getUniqueId())) continue;
                        if (!selected.isEmpty()) {
                            selected = selected + ", ";
                        }
                        selected = selected + ARIA.dateRoomSelection(sAriaDateFormat.format(this.iDates.getDate(date)), room.getName());
                    }
                }
                label = label + " " + ARIA.meetingSelectionSelected(selected);
            }
        }
        return label;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SortRoomsBy {
        CAPACITY,
        NAME,
        DISTANCE,
        AVAILABILITY;

    }
}

