/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.aria;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Button;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;

public class AriaButton
extends Button
implements HasAriaLabel {
    private boolean iFocused = false;

    public AriaButton() {
    }

    public AriaButton(String html) {
        super(html);
        this.setAriaLabel(UniTimeHeaderPanel.stripAccessKey(html).replace("&nbsp;", " ").replace("&#8209;", "-"));
        Character accessKey = UniTimeHeaderPanel.guessAccessKey(html);
        if (accessKey != null) {
            this.setAccessKey(accessKey.charValue());
        }
        ToolBox.setMinWidth(this.getElement().getStyle(), "75px");
        this.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                AriaButton.this.iFocused = true;
            }
        });
        this.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                AriaButton.this.iFocused = false;
            }
        });
    }

    public AriaButton(ImageResource image, String html) {
        super(html);
        super.setHTML("<img src='" + image.getSafeUri().asString() + "' class='gwt-Image'></img><span class='gwt-Label' style='padding-left: 5px;'>" + html + "</span>");
        this.addStyleName("unitime-ImageButton");
        this.setAriaLabel(UniTimeHeaderPanel.stripAccessKey(html));
        Character accessKey = UniTimeHeaderPanel.guessAccessKey(html);
        if (accessKey != null) {
            this.setAccessKey(accessKey.charValue());
        }
        ToolBox.setMinWidth(this.getElement().getStyle(), "75px");
        this.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                AriaButton.this.iFocused = true;
            }
        });
        this.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                AriaButton.this.iFocused = false;
            }
        });
    }

    public AriaButton(String html, ImageResource image) {
        super(html);
        super.setHTML("<span class='gwt-Label' style='padding-right: 5px;'>" + html + "</span><img src='" + image.getSafeUri().asString() + "' class='gwt-Image'></img>");
        this.addStyleName("unitime-ImageButton");
        this.setAriaLabel(UniTimeHeaderPanel.stripAccessKey(html));
        Character accessKey = UniTimeHeaderPanel.guessAccessKey(html);
        if (accessKey != null) {
            this.setAccessKey(accessKey.charValue());
        }
        ToolBox.setMinWidth(this.getElement().getStyle(), "75px");
        this.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                AriaButton.this.iFocused = true;
            }
        });
        this.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                AriaButton.this.iFocused = false;
            }
        });
    }

    public void setHTML(String html) {
        super.setHTML(html);
        this.setAriaLabel(UniTimeHeaderPanel.stripAccessKey(html));
        Character accessKey = UniTimeHeaderPanel.guessAccessKey(html);
        if (accessKey != null) {
            this.setAccessKey(accessKey.charValue());
        }
    }

    public void setAriaLabel(String text) {
        if (text == null || text.isEmpty()) {
            Roles.getButtonRole().removeAriaLabelledbyProperty((Element)this.getElement());
        } else {
            Roles.getButtonRole().setAriaLabelProperty((Element)this.getElement(), text);
        }
    }

    public String getAriaLabel() {
        return Roles.getButtonRole().getAriaLabelProperty((Element)this.getElement());
    }

    public boolean isFocused() {
        return this.iFocused;
    }
}

