/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.hibernate.Session;
import org.springframework.security.authentication.encoding.MessageDigestPasswordEncoder;
import org.unitime.timetable.model.User;

public class UserEditForm
extends ActionForm {
    private static final long serialVersionUID = 8703608968811726905L;
    private String iOp = null;
    private String iExternalId = null;
    private String iName = null;
    private String iPassword = null;
    private String iToken = null;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iExternalId == null || this.iExternalId.trim().length() == 0) {
            errors.add("externalId", new ActionMessage("errors.required", (Object)""));
        } else if (!"Update".equals(this.getOp()) && User.findByExternalId(this.getExternalId()) != null) {
            errors.add("externalId", new ActionMessage("errors.exists", (Object)this.iExternalId));
        }
        if (this.iName == null || this.iName.trim().length() == 0) {
            errors.add("name", new ActionMessage("errors.required", (Object)""));
        } else {
            try {
                User user = User.findByUserName(this.iName);
                if (user != null && !user.getExternalUniqueId().equals(this.iExternalId)) {
                    errors.add("name", new ActionMessage("errors.exists", (Object)this.iName));
                }
            }
            catch (Exception e) {
                errors.add("name", new ActionMessage("errors.generic", (Object)e.getMessage()));
            }
        }
        if (this.iPassword == null || this.iPassword.trim().length() == 0) {
            errors.add("password", new ActionMessage("errors.required", (Object)""));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = "List";
        this.iExternalId = null;
        this.iName = null;
        this.iPassword = null;
        this.iToken = null;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(String externalId) {
        this.iExternalId = externalId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getPassword() {
        return this.iPassword;
    }

    public void setPassword(String password) {
        this.iPassword = password;
    }

    public String getToken() {
        return this.iToken;
    }

    public void setToken(String token) {
        this.iToken = token;
    }

    public void load(User user) {
        if (user == null) {
            this.setOp("Save");
        } else {
            this.setOp("Update");
            this.setExternalId(user.getExternalUniqueId());
            this.setName(user.getUsername());
            this.setPassword(user.getPassword());
        }
    }

    public static String encodePassword(String clearTextPassword) {
        return new MessageDigestPasswordEncoder("MD5", true).encodePassword(clearTextPassword, null);
    }

    public void saveOrUpdate(Session hibSession) throws Exception {
        if ("Update".equals(this.getOp())) {
            User u = User.findByExternalId(this.getExternalId());
            if (u.getUsername().equals(this.getName())) {
                if (!this.getPassword().equals(u.getPassword())) {
                    u.setPassword(UserEditForm.encodePassword(this.getPassword()));
                }
                hibSession.update((Object)u);
            } else {
                User w = new User();
                w.setExternalUniqueId(u.getExternalUniqueId());
                w.setUsername(this.getName());
                if (this.getPassword().equals(u.getPassword())) {
                    w.setPassword(this.getPassword());
                } else {
                    w.setPassword(UserEditForm.encodePassword(this.getPassword()));
                }
                hibSession.delete((Object)u);
                hibSession.save((Object)w);
            }
        } else {
            User u = new User();
            u.setExternalUniqueId(this.getExternalId());
            u.setUsername(this.getName());
            u.setPassword(UserEditForm.encodePassword(this.getPassword()));
            hibSession.save((Object)u);
        }
    }

    public void delete(Session hibSession) {
        User u = User.findByExternalId(this.getExternalId());
        if (u != null) {
            hibSession.delete((Object)u);
        }
    }
}

