/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.dao.SolverParameterDefDAO;

public class SolverSettingsForm
extends ActionForm {
    private static final long serialVersionUID = -9205033432561871308L;
    private String op;
    private Long uniqueId;
    private String name;
    private String description;
    private String appearance;
    private Map params;
    private Map useDefaults;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        SolverPredefinedSetting set;
        ActionErrors errors = new ActionErrors();
        if (this.name == null || this.name.trim().length() == 0) {
            errors.add("name", new ActionMessage("errors.required", (Object)""));
        } else if ("Add New".equals(this.op) && (set = SolverPredefinedSetting.findByName(this.name)) != null) {
            errors.add("name", new ActionMessage("errors.exists", (Object)this.name));
        }
        if (this.description == null || this.description.trim().length() == 0) {
            errors.add("description", new ActionMessage("errors.required", (Object)""));
        }
        if (this.appearance == null || this.appearance.trim().length() == 0) {
            errors.add("appearance", new ActionMessage("errors.required", (Object)""));
        }
        for (Map.Entry entry : this.params.entrySet()) {
            Long parm = (Long)entry.getKey();
            String val = (String)entry.getValue();
            Boolean useDefault = (Boolean)this.useDefaults.get(parm);
            if (useDefault.booleanValue() || val != null && val.trim().length() != 0) continue;
            errors.add("parameter[" + parm + "]", new ActionMessage("errors.required", (Object)""));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.name = "";
        this.description = "";
        this.op = null;
        this.uniqueId = null;
        this.params = new Hashtable();
        this.useDefaults = new Hashtable();
        for (SolverParameterDef def : new SolverParameterDefDAO().findAll()) {
            if (!def.isVisible().booleanValue()) continue;
            if ("boolean".equals(def.getType())) {
                this.params.put(def.getUniqueId(), "false");
            } else {
                this.params.put(def.getUniqueId(), "");
            }
            this.useDefaults.put(def.getUniqueId(), Boolean.FALSE);
        }
    }

    public void loadDefaults() {
        for (SolverParameterDef def : new SolverParameterDefDAO().findAll()) {
            if (!def.isVisible().booleanValue()) continue;
            this.params.put(def.getUniqueId(), def.getDefault());
            this.useDefaults.put(def.getUniqueId(), Boolean.TRUE);
        }
    }

    public void loadDefaults(HttpServletRequest request) {
        for (SolverParameterDef def : new SolverParameterDefDAO().findAll()) {
            if (!def.isVisible().booleanValue()) continue;
            this.params.put(def.getUniqueId(), request.getParameter("parameter[" + def.getUniqueId() + "]") == null ? def.getDefault() : request.getParameter("parameter[" + def.getUniqueId() + "]"));
            this.useDefaults.put(def.getUniqueId(), request.getParameter("useDefault[" + def.getUniqueId() + "]") == null || "false".equals(request.getParameter("useDefault[" + def.getUniqueId() + "]")) ? Boolean.FALSE : Boolean.TRUE);
        }
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public Long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAppearance() {
        return this.appearance;
    }

    public void setAppearance(String appearance) {
        this.appearance = appearance;
    }

    public int getAppearanceIdx() {
        for (int i = 0; i < SolverPredefinedSetting.sAppearances.length; ++i) {
            if (!SolverPredefinedSetting.sAppearances[i].equals(this.appearance)) continue;
            return i;
        }
        return -1;
    }

    public void setAppearanceIdx(int idx) {
        if (idx < 0) {
            this.appearance = "";
        }
        this.appearance = SolverPredefinedSetting.sAppearances[idx];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getUseDefault(Long id) {
        return (Boolean)this.useDefaults.get(id);
    }

    public void setUseDefault(Long id, Boolean useDefault) {
        this.useDefaults.put(id, useDefault);
    }

    public boolean getUseDefault(int id) {
        return this.getUseDefault(new Long(id));
    }

    public void setUseDefault(int id, boolean useDefault) {
        this.setUseDefault(new Long(id), new Boolean(useDefault));
    }

    public String getParameter(Long id) {
        return (String)this.params.get(id);
    }

    public void setParameter(Long id, String value) {
        this.params.put(id, value);
    }

    public String getParameter(int id) {
        return this.getParameter(new Long(id));
    }

    public void setParameter(int id, String value) {
        this.setParameter(new Long(id), value);
    }

    public String[] getAppearances() {
        return SolverPredefinedSetting.sAppearances;
    }

    public Collection getEnum(String type) {
        Vector<String> options = new Vector<String>();
        StringTokenizer stk = new StringTokenizer(type, ",");
        while (stk.hasMoreTokens()) {
            options.add(stk.nextToken());
        }
        return options;
    }
}

