/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.LabelValueBean;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.form.PreferencesForm;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.util.IdValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorEditForm
extends PreferencesForm {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = 7234507709430023477L;
    private String deptCode;
    private String instructorId;
    private String puId;
    private String name;
    private String careerAcct;
    private String posType;
    private String note;
    private boolean displayPrefs;
    private String lname;
    private String mname;
    private String fname;
    private String title;
    private String deptName;
    private String email;
    private String searchSelect;
    private ExternalUidLookup.UserInfo i2a2Match;
    private Collection staffMatch;
    private Boolean matchFound;
    private String screenName;
    private String prevId;
    private String nextId;
    private boolean ignoreDist;
    private Boolean lookupEnabled;
    private String maxLoad;
    private String teachingPreference;
    private Map<Long, Boolean> attributes;
    private List<IdValue> departments;

    public boolean getIgnoreDist() {
        return this.ignoreDist;
    }

    public void setIgnoreDist(boolean ignoreDist) {
        this.ignoreDist = ignoreDist;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFname() {
        return this.fname;
    }

    public void setFname(String fname) {
        this.fname = fname;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLname() {
        return this.lname;
    }

    public void setLname(String lname) {
        this.lname = lname;
    }

    public String getMname() {
        return this.mname;
    }

    public void setMname(String mname) {
        this.mname = mname;
    }

    public String getCareerAcct() {
        return this.careerAcct;
    }

    public void setCareerAcct(String careerAcct) {
        this.careerAcct = careerAcct;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getPosType() {
        return this.posType;
    }

    public void setPosType(String posCode) {
        this.posType = posCode;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public String getTeachingPreference() {
        return this.teachingPreference;
    }

    public void setTeachingPreference(String teachingPref) {
        this.teachingPreference = teachingPref;
    }

    public String getMaxLoad() {
        return this.maxLoad;
    }

    public void setMaxLoad(String maxLoad) {
        this.maxLoad = maxLoad;
    }

    public boolean getAttribute(long attributeId) {
        if (this.attributes == null) {
            return false;
        }
        Boolean value = this.attributes.get(attributeId);
        return value == null ? false : value;
    }

    public void setAttribute(long attributeId, Boolean value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<Long, Boolean>();
        }
        this.attributes.put(attributeId, value == null ? false : value);
    }

    public boolean getAttribute(String attributeId) {
        if (this.attributes == null) {
            return false;
        }
        Boolean value = this.attributes.get(Long.valueOf(attributeId));
        return value == null ? false : value;
    }

    public void setAttribute(String attributeId, boolean value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<Long, Boolean>();
        }
        this.attributes.put(Long.valueOf(attributeId), value);
    }

    public void clearAttributes() {
        this.attributes = null;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.instructorId = "";
        this.screenName = "instructor";
        super.reset(mapping, request);
        this.setPosType(request);
        this.nextId = null;
        this.prevId = null;
        this.ignoreDist = false;
        this.email = null;
        this.teachingPreference = PreferenceLevel.sProhibited;
        this.maxLoad = null;
        this.attributes = null;
    }

    private void setPosType(HttpServletRequest request) {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        for (PositionType pt : PositionType.getPositionTypeList()) {
            list.add(new LabelValueBean(pt.getLabel().trim(), pt.getUniqueId().toString()));
        }
        request.setAttribute(PositionType.POSTYPE_ATTR_NAME, list);
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.op.equals(MSG.actionLookupInstructor())) {
            if (!(this.fname != null && this.fname.trim().length() != 0 || this.lname != null && this.lname.trim().length() != 0 || this.careerAcct != null && this.careerAcct.trim().length() != 0)) {
                errors.add("fname", new ActionMessage("errors.generic", (Object)MSG.errorSupplyInfoForInstructorLookup()));
            }
            return errors;
        }
        if (!this.screenName.equalsIgnoreCase("instructorPref") && (this.lname == null || this.lname.trim().equals(""))) {
            errors.add("Last Name", new ActionMessage("errors.generic", (Object)MSG.errorRequiredLastName()));
        }
        if (errors.size() == 0) {
            return super.validate(mapping, request);
        }
        return errors;
    }

    public String getInstructorId() {
        return this.instructorId;
    }

    public void setInstructorId(String instructorId) {
        this.instructorId = instructorId;
    }

    public String getPuId() {
        return this.puId;
    }

    public void setPuId(String puId) {
        this.puId = puId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }

    public boolean isDisplayPrefs() {
        return this.displayPrefs;
    }

    public void setDisplayPrefs(boolean displayPrefs) {
        this.displayPrefs = displayPrefs;
    }

    public ExternalUidLookup.UserInfo getI2a2Match() {
        return this.i2a2Match;
    }

    public void setI2a2Match(ExternalUidLookup.UserInfo match) {
        this.i2a2Match = match;
    }

    public Collection getStaffMatch() {
        return this.staffMatch;
    }

    public void setStaffMatch(Collection staffMatch) {
        this.staffMatch = staffMatch;
    }

    public Boolean getMatchFound() {
        return this.matchFound;
    }

    public void setMatchFound(Boolean matchFound) {
        this.matchFound = matchFound;
    }

    public String getSearchSelect() {
        return this.searchSelect;
    }

    public void setSearchSelect(String searchSelect) {
        this.searchSelect = searchSelect;
    }

    @Override
    public void setPreviousId(String prevId) {
        this.prevId = prevId;
    }

    @Override
    public String getPreviousId() {
        return this.prevId;
    }

    @Override
    public void setNextId(String nextId) {
        this.nextId = nextId;
    }

    @Override
    public String getNextId() {
        return this.nextId;
    }

    public Boolean getLookupEnabled() {
        return this.lookupEnabled;
    }

    public void setLookupEnabled(Boolean lookupEnabled) {
        this.lookupEnabled = lookupEnabled;
    }

    public List<IdValue> getDepartments() {
        return this.departments;
    }

    public void setDepartments(List<IdValue> departments) {
        this.departments = departments;
    }
}

