/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;

public class ExamSolverForm
extends ActionForm {
    private static final long serialVersionUID = -5175131851787620507L;
    private String iOp = null;
    private Long iSetting = null;
    private Vector iSettings = new Vector();
    private Hashtable iParamValues = new Hashtable();
    private Hashtable iDefaults = new Hashtable();
    private static Long sEmpty = new Long(-1L);
    private static Long sDefault = new Long(-2L);
    private static Long sSolver = new Long(-3L);
    private Vector iParams = new Vector();
    private String iHost = null;
    private Long iExamType = null;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iSetting == null || this.iSetting.intValue() < 0) {
            errors.add("setting", new ActionMessage("errors.lookup.config.required", (Object)""));
        }
        for (Map.Entry entry : this.iParamValues.entrySet()) {
            Long parm = (Long)entry.getKey();
            String val = (String)entry.getValue();
            if (val != null && val.trim().length() != 0) continue;
            errors.add("parameterValue[" + parm + "]", new ActionMessage("errors.required", (Object)""));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iSettings.clear();
        this.iSetting = sEmpty;
        ExamSolverProxy solver = WebSolver.getExamSolver(request.getSession());
        this.iExamType = null;
        if (solver != null) {
            this.iExamType = solver.getExamTypeId();
        } else if (request.getSession().getAttribute("Exam.Type") != null) {
            this.iExamType = (Long)request.getSession().getAttribute("Exam.Type");
        }
        Transaction tx = null;
        this.iParams.clear();
        this.iDefaults.clear();
        this.iParamValues.clear();
        try {
            Hashtable<Long, String> settings;
            SolverPredefinedSettingDAO dao = new SolverPredefinedSettingDAO();
            Session hibSession = dao.getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            List defaultsList = hibSession.createCriteria(SolverParameterDef.class).setCacheable(true).list();
            Hashtable<Long, String> defaults = new Hashtable<Long, String>();
            Hashtable<Long, String> empty = new Hashtable<Long, String>();
            for (SolverParameterDef def : defaultsList) {
                if (!"ExamBasic".equals(def.getGroup().getName()) || !def.isVisible().booleanValue()) continue;
                if ("boolean".equals(def.getType())) {
                    this.iParamValues.put(def.getUniqueId(), "false");
                    empty.put(def.getUniqueId(), "false");
                } else {
                    this.iParamValues.put(def.getUniqueId(), "");
                    empty.put(def.getUniqueId(), "");
                }
                this.iParams.add(new SolverPredefinedSetting.IdValue(def.getUniqueId(), def.getDescription(), def.getType(), true));
                defaults.put(def.getUniqueId(), def.getDefault());
            }
            this.iDefaults.put(sEmpty, empty);
            this.iDefaults.put(sDefault, defaults);
            List settingsList = hibSession.createCriteria(SolverPredefinedSetting.class).add((Criterion)Restrictions.eq((String)"appearance", (Object)2)).setCacheable(true).list();
            for (SolverPredefinedSetting setting : settingsList) {
                settings = new Hashtable<Long, String>();
                for (SolverParameter param : setting.getParameters()) {
                    if (!"ExamBasic".equals(param.getDefinition().getGroup().getName())) continue;
                    settings.put(param.getDefinition().getUniqueId(), param.getValue());
                }
                this.iSettings.add(new SolverPredefinedSetting.IdValue(setting.getUniqueId(), setting.getDescription()));
                this.iDefaults.put(setting.getUniqueId(), settings);
            }
            if (solver != null) {
                this.iSetting = solver.getProperties().getPropertyLong("General.SettingsId", null);
                Hashtable<Long, String> settings2 = new Hashtable<Long, String>();
                for (SolverParameterDef def : defaultsList) {
                    String value;
                    if (!"ExamBasic".equals(def.getGroup().getName()) || !def.isVisible().booleanValue() || (value = solver.getProperties().getProperty(def.getName())) == null) continue;
                    settings2.put(def.getUniqueId(), value);
                }
                this.iDefaults.put(sSolver, settings2);
            }
            if (this.iSetting != null) {
                SolverPredefinedSetting setting;
                boolean contains = false;
                Enumeration e = this.iSettings.elements();
                while (!contains && e.hasMoreElements()) {
                    SolverPredefinedSetting.IdValue x = (SolverPredefinedSetting.IdValue)e.nextElement();
                    if (!x.getId().equals(this.iSetting)) continue;
                    contains = true;
                }
                if (!contains && (setting = (SolverPredefinedSetting)new SolverPredefinedSettingDAO().get(this.iSetting)) != null) {
                    this.iSettings.add(new SolverPredefinedSetting.IdValue(setting.getUniqueId(), setting.getDescription()));
                    settings = new Hashtable();
                    for (SolverParameter param : setting.getParameters()) {
                        if (!"ExamBasic".equals(param.getDefinition().getGroup().getName())) continue;
                        settings.put(param.getDefinition().getUniqueId(), param.getValue());
                    }
                    this.iDefaults.put(setting.getUniqueId(), settings);
                }
            }
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            Debug.error(e);
        }
        this.iHost = solver == null ? "auto" : solver.getHost();
    }

    public void init(boolean change) {
        if (this.iDefaults.containsKey(sSolver)) {
            this.iParamValues.putAll((Hashtable)this.iDefaults.get(sSolver));
        }
        if (this.iSetting == null || this.iSetting.equals(sEmpty)) {
            Enumeration e = this.iSettings.elements();
            while (e.hasMoreElements()) {
                SolverPredefinedSetting.IdValue x = (SolverPredefinedSetting.IdValue)e.nextElement();
                if (!"default".equalsIgnoreCase(x.getValue())) continue;
                this.iSetting = x.getId();
                this.change();
            }
        } else if (change) {
            this.change();
        }
        if (this.iSetting == null || this.iSetting.equals(sEmpty)) {
            this.iSettings.insertElementAt(new SolverPredefinedSetting.IdValue(sEmpty, ""), 0);
        }
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getOp() {
        return this.iOp;
    }

    public Vector getSettings() {
        return this.iSettings;
    }

    public void setSettings(Vector settings) {
        this.iSettings = settings;
    }

    public Long getSetting() {
        return this.iSetting;
    }

    public void setSetting(Long setting) {
        this.iSetting = setting;
    }

    public void change() {
        Enumeration e = this.iParams.elements();
        while (e.hasMoreElements()) {
            Object value;
            SolverPredefinedSetting.IdValue p = (SolverPredefinedSetting.IdValue)e.nextElement();
            if (p.getDisabled()) continue;
            Hashtable d = (Hashtable)this.iDefaults.get(this.iSetting);
            Object v = value = d == null ? null : (Object)d.get(p.getId());
            if (value == null) {
                value = ((Hashtable)this.iDefaults.get(sDefault)).get(p.getId());
            }
            if (value == null) continue;
            this.iParamValues.put(p.getId(), value);
        }
    }

    public Vector getParameters() {
        return this.iParams;
    }

    public void setParamters(Vector parameters) {
        this.iParams = parameters;
    }

    public SolverPredefinedSetting.IdValue getParameter(Long id) {
        Enumeration e = this.iParams.elements();
        while (e.hasMoreElements()) {
            SolverPredefinedSetting.IdValue p = (SolverPredefinedSetting.IdValue)e.nextElement();
            if (!p.getId().equals(id)) continue;
            return p;
        }
        return null;
    }

    public String getParameterDefault(Long settingId, Long parameterId) {
        String ret = (String)((Hashtable)this.iDefaults.get(settingId)).get(parameterId);
        if (ret == null) {
            ret = (String)((Hashtable)this.iDefaults.get(sDefault)).get(parameterId);
        }
        return ret;
    }

    public String getParameterValue(Long id) {
        return (String)this.iParamValues.get(id);
    }

    public void setParameterValue(Long id, String value) {
        this.iParamValues.put(id, value);
    }

    public Hashtable getParameterValues() {
        return this.iParamValues;
    }

    public String getParameterValue(long id) {
        return this.getParameterValue(new Long(id));
    }

    public String getParameterValue(int id) {
        return this.getParameterValue(new Long(id));
    }

    public void setParameterValue(long id, String value) {
        this.setParameterValue(new Long(id), value);
    }

    public void setParameterValue(int id, String value) {
        this.setParameterValue(new Long(id), value);
    }

    public Collection getEnum(String type) {
        Vector<String> options = new Vector<String>();
        options.add("");
        StringTokenizer stk = new StringTokenizer(type, ",");
        while (stk.hasMoreTokens()) {
            options.add(stk.nextToken());
        }
        return options;
    }

    public String getHost() {
        return this.iHost;
    }

    public void setHost(String host) {
        this.iHost = host;
    }

    public Long getExamType() {
        return this.iExamType;
    }

    public void setExamType(Long type) {
        this.iExamType = type;
    }
}

