/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;

public class UserAccessFilter
implements Filter {
    public static String sAllowNone = "none";
    public static String sAllowAdmin = "admin";
    public static String sAllowLoggedIn = "logged-in";
    public static String sAllowAll = "all";
    private String iAllow = null;

    public void init(FilterConfig cfg) throws ServletException {
        this.iAllow = cfg.getInitParameter("allow");
    }

    private UserContext getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!sAllowAll.equals(this.iAllow)) {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                HttpSession session = httpRequest.getSession();
                UserContext user = this.getUser();
                if (sAllowLoggedIn.equals(this.iAllow) && user != null) {
                    session.setAttribute("exception", (Object)new ServletException("Access Denied."));
                    httpResponse.sendRedirect(httpRequest.getContextPath() + "/error.jsp");
                    return;
                }
                if (sAllowAdmin.equals(this.iAllow) && (user == null || user.getCurrentAuthority() == null || !user.getCurrentAuthority().hasRight(Right.IsAdmin))) {
                    session.setAttribute("exception", (Object)new ServletException("Access Denied."));
                    httpResponse.sendRedirect(httpRequest.getContextPath() + "/error.jsp");
                    return;
                }
            } else {
                throw new ServletException("Access Denied.");
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

