/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseBoolean;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.MenuInterface;
import org.unitime.timetable.security.SessionContext;

public class BusySessions {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtRpcImplements(value=MenuInterface.IsSessionBusyRpcRequest.class)
    public static class Backend
    implements GwtRpcImplementation<MenuInterface.IsSessionBusyRpcRequest, GwtRpcResponseBoolean> {
        @Autowired
        private Tracker unitimeBusySessions;

        @Override
        public GwtRpcResponseBoolean execute(MenuInterface.IsSessionBusyRpcRequest request, SessionContext context) {
            return new GwtRpcResponseBoolean(this.unitimeBusySessions.isWorking(context.getHttpSessionId()));
        }
    }

    @Service(value="unitimeBusySessions")
    public static class Tracker {
        private Map<String, Counter> iCounters = new HashMap<String, Counter>();

        public void create(String id) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy(String id) {
            Map<String, Counter> map = this.iCounters;
            synchronized (map) {
                this.iCounters.remove(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String increment(String id) {
            Map<String, Counter> map = this.iCounters;
            synchronized (map) {
                Counter counter = this.iCounters.get(id);
                if (counter == null) {
                    counter = new Counter();
                    this.iCounters.put(id, counter);
                }
                counter.increment();
            }
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrement(String id) {
            Map<String, Counter> map = this.iCounters;
            synchronized (map) {
                Counter counter = this.iCounters.get(id);
                if (counter != null) {
                    counter.decrement();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWorking(String id) {
            if (id == null) {
                return false;
            }
            Map<String, Counter> map = this.iCounters;
            synchronized (map) {
                Counter counter = this.iCounters.get(id);
                return counter != null && counter.get() > 1;
            }
        }
    }

    private static class Counter {
        private int iValue;

        private Counter() {
        }

        public int get() {
            return this.iValue;
        }

        public void increment() {
            ++this.iValue;
        }

        public void decrement() {
            --this.iValue;
        }

        public String toString() {
            return String.valueOf(this.iValue);
        }
    }

    public static class Listener
    implements HttpSessionListener {
        private Tracker iTracker;

        protected Tracker getTracker(HttpSessionEvent event) {
            if (this.iTracker == null) {
                WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)event.getSession().getServletContext());
                this.iTracker = (Tracker)applicationContext.getBean("unitimeBusySessions");
            }
            return this.iTracker;
        }

        public void sessionCreated(HttpSessionEvent event) {
            Tracker tracker = this.getTracker(event);
            if (tracker != null) {
                tracker.create(event.getSession().getId());
            }
        }

        public void sessionDestroyed(HttpSessionEvent event) {
            Tracker tracker = this.getTracker(event);
            if (tracker != null) {
                tracker.destroy(event.getSession().getId());
            }
        }
    }

    public static class Filter
    implements javax.servlet.Filter {
        private Tracker iTracker;

        protected Tracker getTracker(ServletRequest request) {
            if (this.iTracker == null) {
                WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
                this.iTracker = (Tracker)applicationContext.getBean("unitimeBusySessions");
            }
            return this.iTracker;
        }

        protected String increment(ServletRequest request) {
            Tracker tracker;
            if (request instanceof HttpServletRequest && (tracker = this.getTracker(request)) != null) {
                return tracker.increment(((HttpServletRequest)request).getSession().getId());
            }
            return null;
        }

        protected void decrement(ServletRequest request, String id) {
            Tracker tracker;
            if (request instanceof HttpServletRequest && id != null && (tracker = this.getTracker(request)) != null) {
                tracker.decrement(id);
            }
        }

        public void destroy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            String id = this.increment(request);
            try {
                chain.doFilter(request, response);
                Object var6_5 = null;
                this.decrement(request, id);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.decrement(request, id);
                throw throwable;
            }
        }

        public void init(FilterConfig config) throws ServletException {
        }
    }
}

