/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.rooms;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.rooms.RoomsExporter;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="org.unitime.timetable.export.Exporter:rooms.json")
public class RoomsExportJSON
extends RoomsExporter {
    @Override
    public String reference() {
        return "rooms.json";
    }

    @Override
    protected void print(ExportHelper helper, List<RoomInterface.RoomDetailInterface> rooms, RoomsExporter.ExportContext context) throws IOException {
        helper.getSessionContext().checkPermission(Right.RoomsExportJson);
        helper.setup("application/json", this.reference(), false);
        Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).setFieldNamingStrategy(new FieldNamingStrategy(){
            Pattern iPattern = Pattern.compile("i([A-Z])(.*)");

            public String translateName(Field f) {
                Matcher matcher = this.iPattern.matcher(f.getName());
                if (matcher.matches()) {
                    return matcher.group(1).toLowerCase() + matcher.group(2);
                }
                return f.getName();
            }
        }).setPrettyPrinting().create();
        helper.getWriter().write(gson.toJson(rooms));
    }
}

