/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.rooms;

import com.lowagie.text.Font;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.export.rooms.RoomFeaturesExportCSV;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.util.PdfFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="org.unitime.timetable.export.Exporter:roomfeatures.pdf")
public class RoomFeaturesExportPDF
extends RoomFeaturesExportCSV {
    @Override
    public String reference() {
        return "roomfeatures.pdf";
    }

    @Override
    protected void print(ExportHelper helper, List<RoomInterface.FeatureInterface> features, int dm, String department) throws IOException {
        PDFPrinter out = new PDFPrinter(helper.getOutputStream(), false);
        helper.setup(out.getContentType(), this.reference(), false);
        this.print(out, features, dm, department);
        out.flush();
        out.close();
    }

    @Override
    protected void printHeader(Exporter.Printer out) throws IOException {
        out.printHeader(MESSAGES.colName(), MESSAGES.colAbbreviation(), MESSAGES.colType(), MESSAGES.colDepartment(), MESSAGES.colRooms(), MESSAGES.colDescription());
    }

    @Override
    protected void printLine(Exporter.Printer out, RoomInterface.FeatureInterface feature, int dm) throws IOException {
        ((PDFPrinter)out).printLine(new PDFPrinter.A(feature.getLabel(), new PDFPrinter.F[0]), new PDFPrinter.A(feature.getAbbreviation(), new PDFPrinter.F[0]), new PDFPrinter.A(feature.getType() == null ? "" : feature.getType().getAbbreviation(), new PDFPrinter.F[0]), new PDFPrinter.A(feature.isDepartmental() ? this.dept2string(feature.getDepartment(), dm) : "", new PDFPrinter.F[0]), this.rooms(feature), new PDFPrinter.A(feature.getDescription(), new PDFPrinter.F[0]).maxWidth(Float.valueOf(250.0f)));
    }

    protected PDFPrinter.A rooms(RoomInterface.FeatureInterface feature) {
        PDFPrinter.A ret = new PDFPrinter.A();
        if (feature.hasRooms()) {
            Font font = PdfFont.getFont(true);
            String rooms = "";
            Iterator<EventInterface.FilterRpcResponse.Entity> i = feature.getRooms().iterator();
            while (i.hasNext()) {
                String chip = this.name(i.next()) + (i.hasNext() ? ", " : "");
                StringBuilder stringBuilder = new StringBuilder();
                if (font.getBaseFont().getWidthPoint(stringBuilder.append(rooms).append(chip).toString(), font.getSize()) < 500.0f) {
                    rooms = rooms + chip;
                    continue;
                }
                ret.add(new PDFPrinter.A(rooms, new PDFPrinter.F[0]));
                rooms = chip;
            }
            if (!rooms.isEmpty()) {
                ret.add(new PDFPrinter.A(rooms, new PDFPrinter.F[0]));
            }
        }
        return ret;
    }
}

