/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.CourseOfferingComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=EventInterface.RelatedObjectLookupRpcRequest.class)
public class RelatedObjectLookupBackend
extends EventAction<EventInterface.RelatedObjectLookupRpcRequest, GwtRpcResponseList<EventInterface.RelatedObjectLookupRpcResponse>> {
    /*
     * WARNING - void declaration
     */
    @Override
    public GwtRpcResponseList<EventInterface.RelatedObjectLookupRpcResponse> execute(EventInterface.RelatedObjectLookupRpcRequest request, EventAction.EventContext context) {
        context.checkPermission(Right.EventAddCourseRelated);
        GwtRpcResponseList<EventInterface.RelatedObjectLookupRpcResponse> response = new GwtRpcResponseList<EventInterface.RelatedObjectLookupRpcResponse>();
        Session hibSession = SessionDAO.getInstance().getSession();
        boolean isInstructor = false;
        boolean isOther = false;
        for (UserAuthority userAuthority : context.getUser().getAuthorities()) {
            if (!request.getSessionId().equals(userAuthority.getAcademicSession().getQualifierId()) || !userAuthority.hasRight(Right.EventAddCourseRelated)) continue;
            if ("Instructor".equals(userAuthority.getRole())) {
                isInstructor = true;
                continue;
            }
            isOther = true;
        }
        if (isInstructor && !isOther) {
            switch (request.getLevel()) {
                case SESSION: {
                    Iterator subjects = new TreeSet();
                    ((TreeSet)((Object)subjects)).addAll(hibSession.createQuery("select distinct co.subjectArea from ClassInstructor ci inner join ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.session.uniqueId = :sessionId and ci.instructor.externalUniqueId = :externalId").setLong("sessionId", request.getUniqueId().longValue()).setString("externalId", context.getUser().getExternalUserId()).setCacheable(true).list());
                    ((TreeSet)((Object)subjects)).addAll(hibSession.createQuery("select distinct co.subjectArea from CourseOffering co inner join co.instructionalOffering.offeringCoordinators oc where co.subjectArea.session.uniqueId = :sessionId and oc.instructor.externalUniqueId = :externalId").setLong("sessionId", request.getUniqueId().longValue()).setString("externalId", context.getUser().getExternalUserId()).setCacheable(true).list());
                    Iterator iterator = ((TreeSet)((Object)subjects)).iterator();
                    while (iterator.hasNext()) {
                        SubjectArea subject = (SubjectArea)iterator.next();
                        response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.SUBJECT, subject.getUniqueId(), subject.getSubjectAreaAbbreviation()));
                    }
                    break;
                }
                case SUBJECT: {
                    TreeSet treeSet = new TreeSet(new CourseOfferingComparator());
                    treeSet.addAll(hibSession.createQuery("select distinct co from ClassInstructor ci inner join ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId = :subjectAreaId and ci.instructor.externalUniqueId = :externalId").setLong("subjectAreaId", request.getUniqueId().longValue()).setString("externalId", context.getUser().getExternalUserId()).setCacheable(true).list());
                    treeSet.addAll(hibSession.createQuery("select distinct co from CourseOffering co inner join co.instructionalOffering.offeringCoordinators oc where co.subjectArea.uniqueId = :subjectAreaId and oc.instructor.externalUniqueId = :externalId").setLong("subjectAreaId", request.getUniqueId().longValue()).setString("externalId", context.getUser().getExternalUserId()).setCacheable(true).list());
                    for (CourseOffering course : treeSet) {
                        EventInterface.RelatedObjectInterface related = new EventInterface.RelatedObjectInterface();
                        if (course.getIsControl().booleanValue()) {
                            related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Offering);
                            related.setUniqueId(course.getInstructionalOffering().getUniqueId());
                            related.setName(course.getCourseName());
                            related.addCourseId(course.getUniqueId());
                            related.addCourseName(course.getCourseName());
                            related.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                            related.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId()});
                            related.setNote(course.getScheduleBookNote());
                            if (context.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                                related.setDetailPage("instructionalOfferingDetail.do?io=" + course.getInstructionalOffering().getUniqueId());
                            }
                        } else {
                            related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Course);
                            related.setUniqueId(course.getUniqueId());
                            related.setName(course.getCourseName());
                            related.addCourseId(course.getUniqueId());
                            related.addCourseName(course.getCourseName());
                            related.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                            related.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId()});
                            related.setNote(course.getScheduleBookNote());
                            if (context.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                                related.setDetailPage("instructionalOfferingDetail.do?io=" + course.getInstructionalOffering().getUniqueId());
                            }
                        }
                        response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.COURSE, course.getUniqueId(), course.getCourseNbr(), course.getTitle(), related));
                    }
                    break;
                }
                case COURSE: {
                    CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getUniqueId());
                    if (course == null) break;
                    boolean coordinator = false;
                    for (OfferingCoordinator oc : course.getInstructionalOffering().getOfferingCoordinators()) {
                        if (!context.getUser().getExternalUserId().equals(oc.getInstructor().getExternalUniqueId())) continue;
                        coordinator = true;
                        break;
                    }
                    TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(null));
                    if (coordinator) {
                        configs.addAll(course.getInstructionalOffering().getInstrOfferingConfigs());
                    } else {
                        HashSet classes = new HashSet(hibSession.createQuery("select distinct ci.classInstructing from ClassInstructor ci inner join ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.uniqueId = :courseId and ci.instructor.externalUniqueId = :externalId").setLong("courseId", request.getUniqueId().longValue()).setString("externalId", context.getUser().getExternalUserId()).setCacheable(true).list());
                        for (Class_ class_ : classes) {
                            if (!classes.containsAll(class_.getSchedulingSubpart().getClasses())) continue;
                            configs.add(class_.getSchedulingSubpart().getInstrOfferingConfig());
                        }
                    }
                    if (coordinator || course.getInstructionalOffering().getInstrOfferingConfigs().size() == configs.size()) {
                        if (course.isIsControl().booleanValue()) {
                            EventInterface.RelatedObjectInterface relatedOffering = new EventInterface.RelatedObjectInterface();
                            relatedOffering.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Offering);
                            relatedOffering.setUniqueId(course.getInstructionalOffering().getUniqueId());
                            relatedOffering.setName(course.getCourseName());
                            relatedOffering.setNote(course.getScheduleBookNote());
                            relatedOffering.addCourseId(course.getUniqueId());
                            relatedOffering.addCourseName(course.getCourseName());
                            relatedOffering.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                            relatedOffering.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId()});
                            if (context.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                                relatedOffering.setDetailPage("instructionalOfferingDetail.do?io=" + course.getInstructionalOffering().getUniqueId());
                            }
                            response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.OFFERING, course.getInstructionalOffering().getUniqueId(), "Offering", relatedOffering));
                        }
                        EventInterface.RelatedObjectInterface relatedCourse = new EventInterface.RelatedObjectInterface();
                        relatedCourse.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Course);
                        relatedCourse.setUniqueId(course.getUniqueId());
                        relatedCourse.setName(course.getCourseName());
                        relatedCourse.setNote(course.getScheduleBookNote());
                        relatedCourse.addCourseId(course.getUniqueId());
                        relatedCourse.addCourseName(course.getCourseName());
                        relatedCourse.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                        relatedCourse.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId()});
                        if (context.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                            relatedCourse.setDetailPage("instructionalOfferingDetail.do?io=" + course.getInstructionalOffering().getUniqueId());
                        }
                        response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.COURSE, course.getUniqueId(), "Course", relatedCourse));
                    }
                    if (!configs.isEmpty()) {
                        response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.NONE, null, "-- Configurations --"));
                        for (InstrOfferingConfig instrOfferingConfig : configs) {
                            EventInterface.RelatedObjectInterface relatedObjectInterface = new EventInterface.RelatedObjectInterface();
                            relatedObjectInterface.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Config);
                            relatedObjectInterface.setUniqueId(instrOfferingConfig.getUniqueId());
                            relatedObjectInterface.setName(instrOfferingConfig.getName() + (instrOfferingConfig.getInstructionalMethod() == null ? "" : " (" + instrOfferingConfig.getInstructionalMethod().getLabel() + ")"));
                            relatedObjectInterface.addCourseId(course.getUniqueId());
                            relatedObjectInterface.addCourseName(course.getCourseName());
                            relatedObjectInterface.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                            relatedObjectInterface.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId(), instrOfferingConfig.getUniqueId()});
                            if (context.hasPermission(instrOfferingConfig.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                                relatedObjectInterface.setDetailPage("instructionalOfferingDetail.do?io=" + instrOfferingConfig.getInstructionalOffering().getUniqueId());
                            }
                            response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.CONFIG, instrOfferingConfig.getUniqueId(), instrOfferingConfig.getName() + (instrOfferingConfig.getInstructionalMethod() == null ? "" : " (" + instrOfferingConfig.getInstructionalMethod().getLabel() + ")"), relatedObjectInterface));
                        }
                    }
                    TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(new SchedulingSubpartComparator(null));
                    if (coordinator) {
                        for (InstrOfferingConfig instrOfferingConfig : configs) {
                            subparts.addAll(instrOfferingConfig.getSchedulingSubparts());
                        }
                    } else {
                        subparts.addAll(hibSession.createQuery("select distinct ci.classInstructing.schedulingSubpart from ClassInstructor ci inner join ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.uniqueId = :courseId and ci.instructor.externalUniqueId = :externalId").setLong("courseId", request.getUniqueId().longValue()).setString("externalId", context.getUser().getExternalUserId()).setCacheable(true).list());
                    }
                    if (subparts.isEmpty()) break;
                    if (!configs.isEmpty()) {
                        response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.NONE, null, "-- Subparts --"));
                    }
                    for (SchedulingSubpart schedulingSubpart : subparts) {
                        String name = schedulingSubpart.getItype().getAbbv();
                        String sufix = schedulingSubpart.getSchedulingSubpartSuffix();
                        for (SchedulingSubpart parent = schedulingSubpart.getParentSubpart(); parent != null; parent = parent.getParentSubpart()) {
                            name = "\u00a0\u00a0\u00a0\u00a0" + name;
                        }
                        if (schedulingSubpart.getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
                            name = name + " [" + schedulingSubpart.getInstrOfferingConfig().getName() + "]";
                        }
                        response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.SUBPART, schedulingSubpart.getUniqueId(), name + (sufix == null || sufix.isEmpty() ? "" : " (" + sufix + ")")));
                    }
                    break;
                }
                case SUBPART: {
                    CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getCourseId());
                    boolean coordinator = false;
                    for (OfferingCoordinator offeringCoordinator : course.getInstructionalOffering().getOfferingCoordinators()) {
                        if (!context.getUser().getExternalUserId().equals(offeringCoordinator.getInstructor().getExternalUniqueId())) continue;
                        coordinator = true;
                        break;
                    }
                    TreeSet<Class_> treeSet = new TreeSet<Class_>(new ClassComparator(5));
                    if (coordinator) {
                        treeSet.addAll(hibSession.createQuery("select c from Class_ c where c.schedulingSubpart.uniqueId = :subpartId").setLong("subpartId", request.getUniqueId().longValue()).setCacheable(true).list());
                    } else {
                        treeSet.addAll(hibSession.createQuery("select distinct ci.classInstructing from ClassInstructor ci inner join ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where ci.classInstructing.schedulingSubpart.uniqueId = :subpartId and ci.instructor.externalUniqueId = :externalId").setLong("subpartId", request.getUniqueId().longValue()).setString("externalId", context.getUser().getExternalUserId()).setCacheable(true).list());
                    }
                    for (Class_ clazz : treeSet) {
                        String extId = clazz.getClassSuffix(course);
                        EventInterface.RelatedObjectInterface relatedClass = new EventInterface.RelatedObjectInterface();
                        relatedClass.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Class);
                        relatedClass.setUniqueId(clazz.getUniqueId());
                        relatedClass.setName(clazz.getClassLabel(course));
                        String note = course.getScheduleBookNote();
                        if (clazz.getSchedulePrintNote() != null && !clazz.getSchedulePrintNote().isEmpty()) {
                            note = (note == null || note.isEmpty() ? "" : note + "\n") + clazz.getSchedulePrintNote();
                        }
                        relatedClass.setNote(note);
                        relatedClass.addCourseId(course.getUniqueId());
                        relatedClass.addCourseName(course.getCourseName());
                        relatedClass.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                        relatedClass.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId(), clazz.getSchedulingSubpart().getUniqueId(), clazz.getUniqueId()});
                        if (context.hasPermission(clazz, Right.ClassDetail)) {
                            relatedClass.setDetailPage("classDetail.do?cid=" + clazz.getUniqueId());
                        }
                        response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.CLASS, clazz.getUniqueId(), clazz.getSectionNumberString(hibSession), extId == null || extId.isEmpty() || extId.equalsIgnoreCase(clazz.getSectionNumberString(hibSession)) ? null : extId, relatedClass));
                    }
                    break;
                }
                default: {
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.NONE, null, "N/A"));
                }
            }
            return response;
        }
        switch (request.getLevel()) {
            case SESSION: {
                for (Object[] objectArray : hibSession.createQuery("select s.uniqueId, s.subjectAreaAbbreviation from SubjectArea s where s.session.uniqueId = :sessionId order by s.subjectAreaAbbreviation").setLong("sessionId", request.getUniqueId().longValue()).setCacheable(true).list()) {
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.SUBJECT, (Long)objectArray[0], (String)objectArray[1]));
                }
                break;
            }
            case SUBJECT: {
                for (CourseOffering courseOffering : hibSession.createQuery("select co from CourseOffering co where co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.notOffered = false order by co.courseNbr").setLong("subjectAreaId", request.getUniqueId().longValue()).setCacheable(true).list()) {
                    EventInterface.RelatedObjectInterface related = new EventInterface.RelatedObjectInterface();
                    if (courseOffering.getIsControl().booleanValue()) {
                        related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Offering);
                        related.setUniqueId(courseOffering.getInstructionalOffering().getUniqueId());
                        related.setName(courseOffering.getCourseName());
                        related.addCourseId(courseOffering.getUniqueId());
                        related.addCourseName(courseOffering.getCourseName());
                        related.addCourseTitle(courseOffering.getTitle() == null ? "" : courseOffering.getTitle());
                        related.setSelection(new long[]{courseOffering.getSubjectArea().getUniqueId(), courseOffering.getUniqueId()});
                        related.setNote(courseOffering.getScheduleBookNote());
                        if (context.hasPermission(courseOffering.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                            related.setDetailPage("instructionalOfferingDetail.do?io=" + courseOffering.getInstructionalOffering().getUniqueId());
                        }
                    } else {
                        related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Course);
                        related.setUniqueId(courseOffering.getUniqueId());
                        related.setName(courseOffering.getCourseName());
                        related.addCourseId(courseOffering.getUniqueId());
                        related.addCourseName(courseOffering.getCourseName());
                        related.addCourseTitle(courseOffering.getTitle() == null ? "" : courseOffering.getTitle());
                        related.setSelection(new long[]{courseOffering.getSubjectArea().getUniqueId(), courseOffering.getUniqueId()});
                        related.setNote(courseOffering.getScheduleBookNote());
                        if (context.hasPermission(courseOffering.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                            related.setDetailPage("instructionalOfferingDetail.do?io=" + courseOffering.getInstructionalOffering().getUniqueId());
                        }
                    }
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.COURSE, courseOffering.getUniqueId(), courseOffering.getCourseNbr(), courseOffering.getTitle(), related));
                }
                break;
            }
            case COURSE: {
                CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getUniqueId());
                if (course == null) break;
                if (course.isIsControl().booleanValue()) {
                    EventInterface.RelatedObjectInterface relatedObjectInterface = new EventInterface.RelatedObjectInterface();
                    relatedObjectInterface.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Offering);
                    relatedObjectInterface.setUniqueId(course.getInstructionalOffering().getUniqueId());
                    relatedObjectInterface.setName(course.getCourseName());
                    relatedObjectInterface.setNote(course.getScheduleBookNote());
                    relatedObjectInterface.addCourseId(course.getUniqueId());
                    relatedObjectInterface.addCourseName(course.getCourseName());
                    relatedObjectInterface.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                    relatedObjectInterface.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId()});
                    if (context.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                        relatedObjectInterface.setDetailPage("instructionalOfferingDetail.do?io=" + course.getInstructionalOffering().getUniqueId());
                    }
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.OFFERING, course.getInstructionalOffering().getUniqueId(), "Offering", relatedObjectInterface));
                }
                EventInterface.RelatedObjectInterface relatedObjectInterface = new EventInterface.RelatedObjectInterface();
                relatedObjectInterface.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Course);
                relatedObjectInterface.setUniqueId(course.getUniqueId());
                relatedObjectInterface.setName(course.getCourseName());
                relatedObjectInterface.setNote(course.getScheduleBookNote());
                relatedObjectInterface.addCourseId(course.getUniqueId());
                relatedObjectInterface.addCourseName(course.getCourseName());
                relatedObjectInterface.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                relatedObjectInterface.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId()});
                if (context.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                    relatedObjectInterface.setDetailPage("instructionalOfferingDetail.do?io=" + course.getInstructionalOffering().getUniqueId());
                }
                response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.COURSE, course.getUniqueId(), "Course", relatedObjectInterface));
                TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(null));
                configs.addAll(course.getInstructionalOffering().getInstrOfferingConfigs());
                TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(new SchedulingSubpartComparator(null));
                if (!configs.isEmpty()) {
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.NONE, null, "-- Configurations --"));
                    for (InstrOfferingConfig config : configs) {
                        EventInterface.RelatedObjectInterface relatedObjectInterface2 = new EventInterface.RelatedObjectInterface();
                        relatedObjectInterface2.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Config);
                        relatedObjectInterface2.setUniqueId(config.getUniqueId());
                        relatedObjectInterface2.setName(config.getName() + (config.getInstructionalMethod() == null ? "" : " (" + config.getInstructionalMethod().getLabel() + ")"));
                        relatedObjectInterface2.addCourseId(course.getUniqueId());
                        relatedObjectInterface2.addCourseName(course.getCourseName());
                        relatedObjectInterface2.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                        relatedObjectInterface2.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId(), config.getUniqueId()});
                        if (context.hasPermission(config.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                            relatedObjectInterface2.setDetailPage("instructionalOfferingDetail.do?io=" + config.getInstructionalOffering().getUniqueId());
                        }
                        response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.CONFIG, config.getUniqueId(), config.getName() + (config.getInstructionalMethod() == null ? "" : " (" + config.getInstructionalMethod().getLabel() + ")"), relatedObjectInterface2));
                        subparts.addAll(config.getSchedulingSubparts());
                    }
                }
                if (subparts.isEmpty()) break;
                response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.NONE, null, "-- Subparts --"));
                for (SchedulingSubpart subpart : subparts) {
                    void var13_49;
                    void var13_46;
                    String string = subpart.getItype().getAbbv();
                    String string2 = subpart.getSchedulingSubpartSuffix();
                    for (SchedulingSubpart parent = subpart.getParentSubpart(); parent != null; parent = parent.getParentSubpart()) {
                        String string3 = "\u00a0\u00a0\u00a0\u00a0" + (String)var13_46;
                    }
                    if (subpart.getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
                        String string4 = (String)var13_46 + " [" + subpart.getInstrOfferingConfig().getName() + "]";
                    }
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.SUBPART, subpart.getUniqueId(), (String)var13_49 + (string2 == null || string2.isEmpty() ? "" : " (" + string2 + ")")));
                }
                break;
            }
            case SUBPART: {
                CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getCourseId());
                SchedulingSubpart subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(request.getUniqueId());
                if (subpart == null) break;
                TreeSet<Class_> classes = new TreeSet<Class_>(new ClassComparator(5));
                classes.addAll(subpart.getClasses());
                for (Class_ class_ : classes) {
                    String extId = class_.getClassSuffix(course);
                    EventInterface.RelatedObjectInterface relatedClass = new EventInterface.RelatedObjectInterface();
                    relatedClass.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Class);
                    relatedClass.setUniqueId(class_.getUniqueId());
                    relatedClass.setName(class_.getClassLabel(course));
                    String note = course.getScheduleBookNote();
                    if (class_.getSchedulePrintNote() != null && !class_.getSchedulePrintNote().isEmpty()) {
                        note = (note == null || note.isEmpty() ? "" : note + "\n") + class_.getSchedulePrintNote();
                    }
                    relatedClass.setNote(note);
                    relatedClass.addCourseId(course.getUniqueId());
                    relatedClass.addCourseName(course.getCourseName());
                    relatedClass.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                    relatedClass.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId(), subpart.getUniqueId(), class_.getUniqueId()});
                    if (context.hasPermission(class_, Right.ClassDetail)) {
                        relatedClass.setDetailPage("classDetail.do?cid=" + class_.getUniqueId());
                    }
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.CLASS, class_.getUniqueId(), class_.getSectionNumberString(hibSession), extId == null || extId.isEmpty() || extId.equalsIgnoreCase(class_.getSectionNumberString(hibSession)) ? null : extId, relatedClass));
                }
                break;
            }
            default: {
                response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.NONE, null, "N/A"));
            }
        }
        return response;
    }
}

