/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventEmail;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao._RootDAO;

@Service(value="eventInboundEmailService")
public class EventInboundEmailService {
    private Pattern iSubjectPattern = Pattern.compile("(?i)\\[EVENT-([0-9a-f]+)\\]");
    private static Logger sLog = Logger.getLogger(EventInboundEmailService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(MimeMessage message) throws MessagingException, IOException {
        Session hibSession;
        block29: {
            block28: {
                block27: {
                    block26: {
                        sLog.info((Object)("Recieved message: " + message.getSubject()));
                        Matcher subjectMatcher = this.iSubjectPattern.matcher(message.getSubject());
                        if (!subjectMatcher.find()) {
                            return;
                        }
                        hibSession = new _RootDAO().createNewSession();
                        try {
                            Event event = (Event)EventDAO.getInstance().get(Long.parseLong(subjectMatcher.group(1), 16), hibSession);
                            if (event == null) {
                                Object var21_5 = null;
                                break block26;
                            }
                            String body = null;
                            if (message.getContent() instanceof String) {
                                body = (String)message.getContent();
                            } else if (message.getContent() instanceof MimeMultipart) {
                                MimeMultipart multi = (MimeMultipart)message.getContent();
                                if (multi.getBodyPart(0).getContent() instanceof MimeMultipart && ((MimeMultipart)multi.getBodyPart(0).getContent()).getBodyPart(0).getContent() instanceof String) {
                                    body = (String)((MimeMultipart)multi.getBodyPart(0).getContent()).getBodyPart(0).getContent();
                                } else if (multi.getBodyPart(0).getContent() instanceof String) {
                                    body = (String)multi.getBodyPart(0).getContent();
                                }
                            }
                            BodyPart attachment = null;
                            if (message.getContent() instanceof MimeMultipart) {
                                MimeMultipart multi = (MimeMultipart)message.getContent();
                                for (int i = 1; i < multi.getCount(); ++i) {
                                    if (!"attachment".equalsIgnoreCase(multi.getBodyPart(i).getDisposition()) || multi.getBodyPart(i).getFileName() == null) continue;
                                    attachment = multi.getBodyPart(i);
                                    break;
                                }
                            }
                            if (body == null) {
                                break block27;
                            }
                            BufferedReader reader = new BufferedReader(new StringReader(body));
                            String text = null;
                            String line = null;
                            String skip = null;
                            while ((line = reader.readLine()) != null) {
                                if ((line = line.trim()).isEmpty() && text == null && skip == null) continue;
                                if (line.matches("(?i)-+ ?Original message ?-+") || line.matches("(?i)-+ ?Forwarded message ?-+") || line.matches("On .* wrote:") || line.matches("(?i)[0-9]+/[0-9]+/[0-9]+ " + ApplicationProperty.EmailSenderName.value() + " <" + ApplicationProperty.EmailSenderAddress.value() + ">")) break;
                                if (line.startsWith(">") || line.isEmpty()) {
                                    skip = (skip == null ? "" : skip + "\n") + line;
                                    continue;
                                }
                                text = (text == null ? "" : text + "\n") + (skip == null ? "" : skip + "\n") + line;
                                skip = null;
                            }
                            reader.close();
                            if (text == null && attachment == null) {
                                break block28;
                            }
                            final EventNote note = new EventNote();
                            note.setEvent(event);
                            note.setNoteType(8);
                            Date ts = new Date();
                            if (message.getReceivedDate() != null) {
                                ts = message.getReceivedDate();
                            } else if (message.getSentDate() != null) {
                                ts = message.getSentDate();
                            }
                            note.setTimeStamp(ts);
                            String user = "EMAIL";
                            String userId = null;
                            InternetAddress from = null;
                            if (message.getFrom() != null && message.getFrom().length > 0 && message.getFrom()[0] instanceof InternetAddress) {
                                from = (InternetAddress)message.getFrom()[0];
                                user = from.getPersonal() != null ? from.getPersonal() : from.getAddress();
                            }
                            note.setUser(user);
                            note.setUserId(userId);
                            note.setTextNote(text);
                            if (note.getTextNote() != null && note.getTextNote().length() > 2000) {
                                note.setTextNote(note.getTextNote().substring(0, 2000));
                            }
                            if (attachment != null) {
                                int len;
                                note.setAttachedName(attachment.getFileName());
                                note.setAttachedContentType(attachment.getContentType());
                                InputStream input = attachment.getInputStream();
                                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                                byte[] buffer = new byte[1024];
                                while ((len = input.read(buffer)) != -1) {
                                    bytes.write(buffer, 0, len);
                                }
                                input.close();
                                bytes.flush();
                                bytes.close();
                                note.setAttachedFile(bytes.toByteArray());
                            }
                            event.getNotes().add(note);
                            hibSession.saveOrUpdate((Object)note);
                            hibSession.update((Object)event);
                            hibSession.flush();
                            DataSource data = null;
                            if (note.getAttachedFile() != null) {
                                data = new DataSource(){

                                    public OutputStream getOutputStream() throws IOException {
                                        return null;
                                    }

                                    public String getName() {
                                        return note.getAttachedName();
                                    }

                                    public InputStream getInputStream() throws IOException {
                                        return new ByteArrayInputStream(note.getAttachedFile());
                                    }

                                    public String getContentType() {
                                        return note.getAttachedContentType();
                                    }
                                };
                            }
                            try {
                                EventEmail.eventUpdated(event, text, from, data);
                            }
                            catch (Exception e) {
                                sLog.error((Object)("Failed to sent confirmation email: " + e.getMessage()), (Throwable)e);
                            }
                            break block29;
                        }
                        catch (Throwable throwable) {
                            Object var21_9 = null;
                            hibSession.close();
                            throw throwable;
                        }
                    }
                    hibSession.close();
                    return;
                }
                Object var21_6 = null;
                hibSession.close();
                return;
            }
            Object var21_7 = null;
            hibSession.close();
            return;
        }
        Object var21_8 = null;
        hibSession.close();
    }
}

