/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.FilterBoxBackend;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.FinalExamEvent;
import org.unitime.timetable.model.MidtermExamEvent;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SpecialEvent;
import org.unitime.timetable.model.UnavailableEvent;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=EventInterface.EventFilterRpcRequest.class)
public class EventFilterBackend
extends FilterBoxBackend<EventInterface.EventFilterRpcRequest> {
    public static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    public static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public void load(EventInterface.EventFilterRpcRequest request, EventInterface.FilterRpcResponse response, EventAction.EventContext context) {
        int type;
        EventQuery query = EventFilterBackend.getQuery(request, context);
        Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date today = cal.getTime();
        org.hibernate.Session hibSession = EventDAO.getInstance().getSession();
        HashMap<Integer, Integer> type2count = new HashMap<Integer, Integer>();
        for (Object[] o : query.select("e.class, count(distinct e)").group("e.class").order("e.class").exclude("query").exclude("type").query(hibSession).list()) {
            int type2 = ((Number)o[0]).intValue();
            int count = ((Number)o[1]).intValue();
            type2count.put(type2, count);
        }
        for (int i = 0; i < Event.sEventTypesAbbv.length; ++i) {
            EventInterface.FilterRpcResponse.Entity e = new EventInterface.FilterRpcResponse.Entity(new Long(i), Event.sEventTypesAbbv[i], CONSTANTS.eventTypeAbbv()[i], "translated-value", CONSTANTS.eventTypeShort()[i]);
            Integer count = (Integer)type2count.get(i);
            e.setCount(count == null ? 0 : count);
            response.add("type", e);
        }
        HashMap<Integer, Integer> day2count = new HashMap<Integer, Integer>();
        for (Object[] o : query.select(HibernateUtil.dayOfWeek("m.meetingDate") + ", count(distinct e)").order(HibernateUtil.dayOfWeek("m.meetingDate")).group(HibernateUtil.dayOfWeek("m.meetingDate")).exclude("query").exclude("day").query(hibSession).list()) {
            type = ((Number)o[0]).intValue();
            int count = ((Number)o[1]).intValue();
            day2count.put(type, count);
        }
        for (int i = 0; i < Constants.DAY_NAMES_FULL.length; ++i) {
            String day = Constants.DAY_NAMES_FULL[i];
            type = 0;
            switch (i) {
                case 0: {
                    type = 0;
                    break;
                }
                case 1: {
                    type = 1;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 3: {
                    type = 3;
                    break;
                }
                case 4: {
                    type = 4;
                    break;
                }
                case 5: {
                    type = 5;
                    break;
                }
                case 6: {
                    type = 6;
                }
            }
            Integer count = (Integer)day2count.get(type);
            EventInterface.FilterRpcResponse.Entity e = new EventInterface.FilterRpcResponse.Entity(new Long(type), day, CONSTANTS.longDays()[i], "translated-value", CONSTANTS.longDays()[i]);
            e.setCount(count == null ? 0 : count);
            response.add("day", e);
        }
        EventInterface.FilterRpcResponse.Entity all = new EventInterface.FilterRpcResponse.Entity(0L, "All", CONSTANTS.eventModeLabel()[0], "translated-value", CONSTANTS.eventModeAbbv()[0]);
        all.setCount(((Number)query.select("count(distinct e)").exclude("query").exclude("mode").query(hibSession).uniqueResult()).intValue());
        response.add("mode", all);
        if (context.isAuthenticated() && context.getUser().getCurrentAuthority() != null) {
            int myCnt = ((Number)query.select("count(distinct e)").where("e.mainContact.externalUniqueId = :user and e.class not in (ClassEvent, FinalExamEvent, MidtermExamEvent)").set("user", context.getUser().getExternalUserId()).exclude("query").exclude("mode").query(hibSession).uniqueResult()).intValue();
            EventInterface.FilterRpcResponse.Entity my = new EventInterface.FilterRpcResponse.Entity(1L, "My", CONSTANTS.eventModeLabel()[1], "translated-value", CONSTANTS.eventModeAbbv()[1]);
            my.setCount(myCnt);
            response.add("mode", my);
            if (context.hasPermission(Right.HasRole)) {
                int approvedCnt = ((Number)query.select("count(distinct e)").where("m.approvalStatus = 1").exclude("query").exclude("mode").query(hibSession).uniqueResult()).intValue();
                EventInterface.FilterRpcResponse.Entity approved = new EventInterface.FilterRpcResponse.Entity(2L, "Approved", CONSTANTS.eventModeLabel()[2], "translated-value", CONSTANTS.eventModeAbbv()[2]);
                approved.setCount(approvedCnt);
                response.add("mode", approved);
                int notApprovedCnt = ((Number)query.select("count(distinct e)").where("m.approvalStatus = 0").exclude("query").exclude("mode").query(hibSession).uniqueResult()).intValue();
                EventInterface.FilterRpcResponse.Entity notApproved = new EventInterface.FilterRpcResponse.Entity(3L, "Unapproved", CONSTANTS.eventModeLabel()[3], "translated-value", CONSTANTS.eventModeAbbv()[3]);
                notApproved.setCount(notApprovedCnt);
                response.add("mode", notApproved);
                EventInterface.FilterRpcResponse.Entity conflicting = new EventInterface.FilterRpcResponse.Entity(5L, "Conflicting", CONSTANTS.eventModeLabel()[5], "translated-value", CONSTANTS.eventModeAbbv()[5]);
                if (ApplicationProperty.EventFilterSkipConflictCounts.isFalse()) {
                    int conflictingCnt = ((Number)query.select("count(distinct e)").from("Meeting mx").joinWithLocation().where("mx.uniqueId!=m.uniqueId and m.meetingDate=mx.meetingDate and m.startPeriod < mx.stopPeriod and m.stopPeriod > mx.startPeriod and m.locationPermanentId = mx.locationPermanentId and m.approvalStatus <= 1 and mx.approvalStatus <= 1 and l.ignoreRoomCheck = false").exclude("query").exclude("mode").query(hibSession).uniqueResult()).intValue();
                    conflicting.setCount(conflictingCnt);
                }
                response.add("mode", conflicting);
                if (context.getUser().getCurrentAuthority().hasRight(Right.EventMeetingApprove)) {
                    int awaitingCnt = ((Number)query.select("count(distinct e)").where("m.approvalStatus = 0 and m.meetingDate >= :today").set("today", today).exclude("query").exclude("mode").query(hibSession).uniqueResult()).intValue();
                    EventInterface.FilterRpcResponse.Entity awaiting = new EventInterface.FilterRpcResponse.Entity(4L, "Awaiting", CONSTANTS.eventModeLabel()[4], "translated-value", CONSTANTS.eventModeAbbv()[4]);
                    awaiting.setCount(awaitingCnt);
                    response.add("mode", awaiting);
                    if (context.getUser().getCurrentAuthority().hasRight(Right.EventMeetingApprove)) {
                        int myApprovalCnt = ((Number)query.select("count(distinct e)").joinWithLocation().from("inner join l.eventDepartment.timetableManagers g").where("m.approvalStatus = 0 and g.externalUniqueId = :user and m.meetingDate >= :today").set("user", context.getUser().getExternalUserId()).set("today", today).exclude("query").exclude("mode").query(hibSession).uniqueResult()).intValue();
                        EventInterface.FilterRpcResponse.Entity myAwaiting = new EventInterface.FilterRpcResponse.Entity(6L, "My Awaiting", CONSTANTS.eventModeLabel()[6], "translated-value", CONSTANTS.eventModeAbbv()[6]);
                        myAwaiting.setCount(myApprovalCnt);
                        response.add("mode", myAwaiting);
                    }
                    int rejectedCnt = ((Number)query.select("count(distinct e)").where("m.approvalStatus >= 2").exclude("query").exclude("mode").query(hibSession).uniqueResult()).intValue();
                    EventInterface.FilterRpcResponse.Entity rejected = new EventInterface.FilterRpcResponse.Entity(7L, "Cancelled", CONSTANTS.eventModeLabel()[7], "translated-value", CONSTANTS.eventModeAbbv()[7]);
                    rejected.setCount(rejectedCnt);
                    response.add("mode", rejected);
                }
                if (context.getUser().getCurrentAuthority().hasRight(Right.EventSetExpiration)) {
                    int expiringCnt = ((Number)query.select("count(distinct e)").where("m.approvalStatus = 0 and e.expirationDate is not null").exclude("query").exclude("mode").query(hibSession).uniqueResult()).intValue();
                    EventInterface.FilterRpcResponse.Entity expiring = new EventInterface.FilterRpcResponse.Entity(8L, "Expiring", CONSTANTS.eventModeLabel()[8], new String[0]);
                    expiring.setCount(expiringCnt);
                    response.add("mode", expiring);
                }
            }
        }
        for (Object[] org : query.select("o.uniqueId, o.name, count(distinct e)").from("inner join e.sponsoringOrganization o").group("o.uniqueId, o.name").order("o.name").exclude("query").exclude("sponsor").query(hibSession).list()) {
            Long id = (Long)org[0];
            String name = (String)org[1];
            int count = ((Number)org[2]).intValue();
            EventInterface.FilterRpcResponse.Entity sponsor = new EventInterface.FilterRpcResponse.Entity(id, name, name, new String[0]);
            sponsor.setCount(count);
            response.add("sponsor", sponsor);
        }
        for (Object[] org : query.select("p.uniqueId, p.reference, p.label, count(distinct e)").from("inner join e.requestedServices p").group("p.uniqueId, p.reference, p.label").order("p.label").exclude("query").exclude("service").query(hibSession).list()) {
            Long id = (Long)org[0];
            String abbv = (String)org[1];
            String name = (String)org[2];
            int count = ((Number)org[3]).intValue();
            EventInterface.FilterRpcResponse.Entity provider = new EventInterface.FilterRpcResponse.Entity(id, abbv, name, new String[0]);
            provider.setCount(count);
            response.add("service", provider);
        }
        if (context.hasPermission(Right.EventLookupSchedule)) {
            if (context.hasPermission(Right.CanLookupStudents)) {
                response.add("role", new EventInterface.FilterRpcResponse.Entity(1L, "Student", CONSTANTS.eventRole()[1], "translated-value", CONSTANTS.eventRole()[1]));
            }
            if (context.hasPermission(Right.CanLookupInstructors)) {
                response.add("role", new EventInterface.FilterRpcResponse.Entity(2L, "Instructor", CONSTANTS.eventRole()[2], "translated-value", CONSTANTS.eventRole()[2]));
                response.add("role", new EventInterface.FilterRpcResponse.Entity(3L, "Coordinator", CONSTANTS.eventRole()[3], "translated-value", CONSTANTS.eventRole()[3]));
            }
            if (context.hasPermission(Right.CanLookupEventContacts)) {
                response.add("role", new EventInterface.FilterRpcResponse.Entity(4L, "Contact", CONSTANTS.eventRole()[4], "translated-value", CONSTANTS.eventRole()[4]));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static EventQuery getQuery(EventInterface.FilterRpcRequest request, EventAction.EventContext context) {
        Integer before;
        EventQuery query = new EventQuery(request.getSessionId());
        if (request.hasOptions("flag") && request.getOption("flag").contains("All Sessions")) {
            query.checkSession(false);
        }
        Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date today = cal.getTime();
        if (!context.hasPermission(Right.HasRole)) {
            query.addWhere("xstatus", "(e.class != ClassEvent or bit_and(s.statusType.status, :XstClass) > 0) and (e.class != FinalExamEvent or (e.examStatus is null and bit_and(s.statusType.status, :XstFinal) > 0) or bit_and(e.examStatus, :XstFinal) > 0) and (e.class != MidtermExamEvent or (e.examStatus is null and bit_and(s.statusType.status, :XstMidtr) > 0) or bit_and(e.examStatus, :XstMidtr) > 0)");
            query.addParameter("xstatus", "XstClass", DepartmentStatusType.Status.ReportClasses.toInt());
            query.addParameter("xstatus", "XstFinal", DepartmentStatusType.Status.ReportExamsFinal.toInt());
            query.addParameter("xstatus", "XstMidtr", DepartmentStatusType.Status.ReportExamsMidterm.toInt());
        } else if (ApplicationProperty.EventHasRoleCheckReportStatus.isTrue() && !context.hasPermission(Right.DepartmentIndependent) && !context.hasPermission(Right.StatusIndependent)) {
            ArrayList<Long> departmentIds = new ArrayList<Long>();
            for (UserQualifier userQualifier : context.getUser().getCurrentAuthority().getQualifiers("Department")) {
                departmentIds.add((Long)userQualifier.getQualifierId());
            }
            query.addWhere("xstatus", "(e.class != ClassEvent or bit_and(s.statusType.status, :XstClass) > 0 or e.departmentId in (:XstDepts))");
            query.addParameter("xstatus", "XstClass", DepartmentStatusType.Status.ReportClasses.toInt());
            query.addParameter("xstatus", "XstDepts", departmentIds);
        }
        if (request.getText() != null && !request.getText().isEmpty()) {
            query.addWhere("query", "lower(e.eventName) like lower(:Xquery) || '%'" + (request.getText().length() >= 2 ? " or lower(e.eventName) like '% ' || lower(:Xquery) || '%'" : ""));
            query.addParameter("query", "Xquery", request.getText());
        }
        if (request.hasOptions("type")) {
            String type = "";
            for (String string : request.getOptions("type")) {
                if (!type.isEmpty()) {
                    type = type + ",";
                }
                if (string.equals(Event.sEventTypesAbbv[0])) {
                    type = type + ClassEvent.class.getName();
                }
                if (string.equals(Event.sEventTypesAbbv[3])) {
                    type = type + CourseEvent.class.getName();
                }
                if (string.equals(Event.sEventTypesAbbv[4])) {
                    type = type + SpecialEvent.class.getName();
                }
                if (string.equals(Event.sEventTypesAbbv[1])) {
                    type = type + FinalExamEvent.class.getName();
                }
                if (string.equals(Event.sEventTypesAbbv[2])) {
                    type = type + MidtermExamEvent.class.getName();
                }
                if (!string.equals(Event.sEventTypesAbbv[5])) continue;
                type = type + UnavailableEvent.class.getName();
            }
            query.addWhere("type", "e.class in (" + type + ")");
        }
        Integer after = null;
        if (request.hasOption("after") && (after = TimeSelector.TimeUtils.parseTime2(CONSTANTS, request.getOption("after"), null)) != null) {
            query.addWhere("after", "m.stopPeriod > :Xafter");
            query.addParameter("after", "Xafter", after);
        }
        if (request.hasOption("before") && (before = TimeSelector.TimeUtils.parseTime2(CONSTANTS, request.getOption("before"), after)) != null) {
            query.addWhere("before", "m.startPeriod < :Xbefore");
            query.addParameter("before", "Xbefore", before);
        }
        if (request.hasOptions("day")) {
            String dow = "";
            for (String day : request.getOptions("day")) {
                if (!dow.isEmpty()) {
                    dow = dow + ",";
                }
                if (Constants.DAY_NAMES_FULL[0].equals(day)) {
                    dow = dow + "0";
                }
                if (Constants.DAY_NAMES_FULL[1].equals(day)) {
                    dow = dow + "1";
                }
                if (Constants.DAY_NAMES_FULL[2].equals(day)) {
                    dow = dow + "2";
                }
                if (Constants.DAY_NAMES_FULL[3].equals(day)) {
                    dow = dow + "3";
                }
                if (Constants.DAY_NAMES_FULL[4].equals(day)) {
                    dow = dow + "4";
                }
                if (Constants.DAY_NAMES_FULL[5].equals(day)) {
                    dow = dow + "5";
                }
                if (!Constants.DAY_NAMES_FULL[6].equals(day)) continue;
                dow = dow + "6";
            }
            if (dow.indexOf(44) >= 0) {
                query.addWhere("day", HibernateUtil.dayOfWeek("m.meetingDate") + " in (" + dow + ")");
            } else {
                query.addWhere("day", HibernateUtil.dayOfWeek("m.meetingDate") + " = " + dow);
            }
        }
        if (request.hasOption("from")) {
            Date date = null;
            try {
                int n = Integer.parseInt(request.getOption("from"));
                date = DateUtils.getDate(((Session)SessionDAO.getInstance().get(request.getSessionId())).getSessionStartYear(), n);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    date = Formats.getDateFormat(Formats.Pattern.FILTER_DATE).parse(request.getOption("from"));
                }
                catch (ParseException p) {
                    // empty catch block
                }
            }
            if (date != null) {
                query.addParameter("from", "Xfrom", date);
                query.addWhere("from", "m.meetingDate >= :Xfrom");
            }
        }
        if (request.hasOption("to")) {
            Date last = null;
            try {
                int n = Integer.parseInt(request.getOption("to"));
                last = DateUtils.getDate(((Session)SessionDAO.getInstance().get(request.getSessionId())).getSessionStartYear(), n);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    last = Formats.getDateFormat(Formats.Pattern.FILTER_DATE).parse(request.getOption("to"));
                }
                catch (ParseException p) {
                    // empty catch block
                }
            }
            if (last != null) {
                query.addParameter("to", "Xto", last);
                query.addWhere("to", "m.meetingDate <= :Xto");
            }
        }
        if (request.hasOptions("dates")) {
            void var7_17;
            ArrayList<Date> dates = new ArrayList<Date>();
            String string = "";
            for (String d : request.getOptions("dates")) {
                Date date = null;
                try {
                    int dayOfYear = Integer.parseInt(d);
                    date = DateUtils.getDate(((Session)SessionDAO.getInstance().get(request.getSessionId())).getSessionStartYear(), dayOfYear);
                }
                catch (NumberFormatException f) {
                    try {
                        date = Formats.getDateFormat(Formats.Pattern.FILTER_DATE).parse(d);
                    }
                    catch (ParseException p) {
                        // empty catch block
                    }
                }
                if (date == null) continue;
                String string2 = (String)var7_17 + (var7_17.isEmpty() ? "" : ",") + ":Xdate" + dates.size();
                dates.add(date);
            }
            if (!dates.isEmpty()) {
                query.addWhere("dates", "m.meetingDate in (" + (String)var7_17 + ")");
                for (int i = 0; i < dates.size(); ++i) {
                    query.addParameter("dates", "Xdate" + i, dates.get(i));
                }
            }
        }
        if (request.hasOptions("room")) {
            String ids = "";
            for (String id : request.getOptions("room")) {
                ids = ids + (ids.isEmpty() ? "" : ",") + id;
            }
            query.addWhere("room", "l.uniqueId in (" + ids + ")");
        }
        if (request.hasOptions("sponsor")) {
            String sponsor = "";
            boolean bl = false;
            for (String s : request.getOptions("sponsor")) {
                void var7_21;
                sponsor = sponsor + (sponsor.isEmpty() ? "" : ",") + ":Xsp" + (int)var7_21;
                query.addParameter("sponsor", "Xsp" + (int)var7_21, s);
                ++var7_21;
            }
            query.addWhere("sponsor", "e.sponsoringOrganization.name in (" + sponsor + ")");
        }
        if (request.hasOption("service")) {
            query.addFrom("service", "EventServiceProvider Xesp");
            query.addWhere("service", "Xesp.reference = :Xesp and Xesp in elements(e.requestedServices)");
            query.addParameter("service", "Xesp", request.getOption("service"));
        }
        if (request.hasOption("mode")) {
            String mode = request.getOption("mode");
            if (("my".equalsIgnoreCase(mode) || CONSTANTS.eventModeLabel()[1].equals(mode)) && context.isAuthenticated()) {
                query.addWhere("mode", "e.mainContact.externalUniqueId = :Xowner and e.class not in (ClassEvent, FinalExamEvent, MidtermExamEvent)");
                query.addParameter("mode", "Xowner", context.getUser().getExternalUserId());
            } else if ("approved".equalsIgnoreCase(mode) || CONSTANTS.eventModeLabel()[2].equals(mode)) {
                query.addWhere("mode", "m.approvalStatus = 1");
            } else if ("unapproved".equalsIgnoreCase(mode) || CONSTANTS.eventModeLabel()[3].equals(mode)) {
                query.addWhere("mode", "m.approvalStatus = 0");
            } else if ("awaiting".equalsIgnoreCase(mode) || CONSTANTS.eventModeLabel()[4].equals(mode)) {
                query.addWhere("mode", "m.approvalStatus = 0 and m.meetingDate >= :Xtoday");
                query.addParameter("mode", "Xtoday", today);
            } else if (("my awaiting".equalsIgnoreCase(mode) || CONSTANTS.eventModeLabel()[6].equals(mode)) && context.isAuthenticated()) {
                query.addFrom("mode", "Location Xl inner join Xl.eventDepartment.timetableManagers Xg");
                query.addWhere("mode", "m.approvalStatus = 0 and Xl.session.uniqueId = :sessionId and Xl.permanentId = m.locationPermanentId and Xg.externalUniqueId = :Xuser and m.meetingDate >= :Xtoday");
                query.addParameter("mode", "Xuser", context.getUser().getExternalUserId());
                query.addParameter("mode", "Xtoday", today);
            } else if ("conflicting".equalsIgnoreCase(mode) || CONSTANTS.eventModeLabel()[5].equals(mode)) {
                query.addFrom("mode", "Meeting Xm, Location Xl");
                query.addWhere("mode", "Xm.uniqueId != m.uniqueId and m.meetingDate = Xm.meetingDate and m.startPeriod < Xm.stopPeriod and m.stopPeriod > Xm.startPeriod and m.locationPermanentId = Xm.locationPermanentId and m.approvalStatus <= 1 and Xm.approvalStatus <= 1 and Xl.permanentId = m.locationPermanentId and Xl.session.uniqueId = :sessionId and Xl.ignoreRoomCheck = false");
            } else if ("cancelled".equalsIgnoreCase(mode) || CONSTANTS.eventModeLabel()[7].equals(mode)) {
                query.addWhere("mode", "m.approvalStatus >= 2");
            } else if ("expiring".equalsIgnoreCase(mode) || CONSTANTS.eventModeLabel()[8].equals(mode)) {
                query.addWhere("mode", "m.approvalStatus = 0 and e.expirationDate is not null");
            } else {
                query.addWhere("mode", "m.approvalStatus <= 1");
            }
        } else if (!request.hasOption("requested")) {
            query.addWhere("mode", "m.approvalStatus <= 1");
        }
        if (request.hasOption("requested")) {
            void var7_23;
            String requested = "";
            boolean bl = false;
            StringTokenizer s = new StringTokenizer(request.getOption("requested").trim(), ", ");
            while (s.hasMoreTokens()) {
                String token = s.nextToken().toUpperCase();
                requested = requested + (requested.isEmpty() ? "" : " and ") + "(upper(e.mainContact.firstName) like :Xreq" + (int)var7_23 + " || '%' or " + "upper(e.mainContact.middleName) like :Xreq" + (int)var7_23 + " || '%' or upper(e.mainContact.lastName) like :Xreq" + (int)var7_23 + " || '%' or upper(e.mainContact.emailAddress) like :Xreq" + (int)var7_23 + " || '%')";
                query.addParameter("requested", "Xreq" + (int)var7_23, token);
                ++var7_23;
            }
            if (var7_23 > 0) {
                requested = "(" + requested + ") or (upper(trim(trailing ' ' from e.mainContact.lastName || ', ' || e.mainContact.firstName || ' ' || e.mainContact.middleName)) = :Xreq)";
                query.addParameter("requested", "Xreq", request.getOption("requested").trim().toUpperCase());
                query.addWhere("requested", requested);
            }
        }
        if (request.hasOptions("id")) {
            String q = "";
            boolean bl = false;
            for (String id : request.getOptions("id")) {
                void var7_25;
                if (!q.isEmpty()) {
                    q = q + ",";
                }
                q = q + ":Xid" + (int)var7_25;
                query.addParameter("id", "Xid" + (int)var7_25, id);
                ++var7_25;
            }
            query.addWhere("id", "e.uniqueId in (" + q + ")");
        }
        return query;
    }

    @Override
    public void suggestions(EventInterface.EventFilterRpcRequest request, EventInterface.FilterRpcResponse response, EventAction.EventContext context) {
        org.hibernate.Session hibSession = EventDAO.getInstance().getSession();
        EventQuery query = EventFilterBackend.getQuery(request, context);
        for (Event event : query.select("distinct e").limit(20).order("e.eventName").query(hibSession).list()) {
            response.addSuggestion(event.getEventName(), event.getEventName(), event.getEventTypeLabel());
        }
        if (!(!context.hasPermission(Right.EventLookupContact) && !context.hasPermission(Right.EventLookupSchedule) || request.getText().isEmpty() || response.getSuggestions() != null && response.getSuggestions().size() >= 20)) {
            EventQuery.EventInstance instance = query.select("distinct c").from("inner join e.mainContact c").exclude("sponsor").exclude("requested").exclude("query");
            int id = 0;
            StringTokenizer s = new StringTokenizer(request.getText().trim(), ", ");
            while (s.hasMoreTokens()) {
                String token = s.nextToken().toUpperCase();
                instance.where("upper(c.firstName) like :cn" + id + " || '%' or upper(c.middleName) like :cn" + id + " || '%' or upper(c.lastName) like :cn" + id + " || '%' or upper(c.emailAddress) like :cn" + id + " || '%'").set("cn" + id, token);
                ++id;
            }
            HashSet<String> contacts = new HashSet<String>();
            if (id > 0) {
                for (EventContact contact : instance.limit(20).query(hibSession).list()) {
                    if (!contacts.add(contact.getName().trim().toLowerCase())) continue;
                    response.addSuggestion(contact.getName().trim(), contact.getName().trim(), "Requested By", "requested");
                }
            }
        }
    }

    @Override
    public void enumarate(EventInterface.EventFilterRpcRequest request, EventInterface.FilterRpcResponse response, EventAction.EventContext context) {
        org.hibernate.Session hibSession = EventDAO.getInstance().getSession();
        EventQuery query = EventFilterBackend.getQuery(request, context);
        for (Event event : query.select("distinct e").query(hibSession).list()) {
            EventInterface.FilterRpcResponse.Entity entity = new EventInterface.FilterRpcResponse.Entity(event.getUniqueId(), event.getEventTypeAbbv(), event.getEventName(), new String[0]);
            response.addResult(entity);
        }
    }

    public static void main(String[] args) {
        System.out.println("XstClass = " + DepartmentStatusType.Status.ReportClasses.toInt());
        System.out.println("XstFinal = " + DepartmentStatusType.Status.ReportExamsFinal.toInt());
        System.out.println("XstMidtr = " + DepartmentStatusType.Status.ReportExamsMidterm.toInt());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventQuery {
        private Long iSessionId;
        private boolean iCheckSession = true;
        private Map<String, String> iFrom = new HashMap<String, String>();
        private Map<String, String> iWhere = new HashMap<String, String>();
        private Map<String, Map<String, Object>> iParams = new HashMap<String, Map<String, Object>>();

        public EventQuery(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public void checkSession(boolean check) {
            this.iCheckSession = check;
        }

        public void addFrom(String option, String from) {
            this.iFrom.put(option, from);
        }

        public void addWhere(String option, String where) {
            this.iWhere.put(option, where);
        }

        private void addParameter(String option, String name, Object value) {
            Map<String, Object> params = this.iParams.get(option);
            if (params == null) {
                params = new HashMap<String, Object>();
                this.iParams.put(option, params);
            }
            params.put(name, value);
        }

        public String getFrom(Collection<String> excludeOption) {
            String from = "";
            for (Map.Entry<String, String> entry : this.iFrom.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                from = from + (entry.getValue().startsWith("inner join") || entry.getValue().startsWith("left outer join") ? " " : ", ") + entry.getValue();
            }
            return from;
        }

        public String getWhere(Collection<String> excludeOption) {
            String where = "";
            for (Map.Entry<String, String> entry : this.iWhere.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                where = where + " and (" + entry.getValue() + ")";
            }
            return where;
        }

        public Query setParams(Query query, Collection<String> excludeOption) {
            for (Map.Entry<String, Map<String, Object>> entry : this.iParams.entrySet()) {
                if (excludeOption != null && excludeOption.contains(entry.getKey())) continue;
                for (Map.Entry<String, Object> param : entry.getValue().entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setInteger(param.getKey(), ((Integer)param.getValue()).intValue());
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setLong(param.getKey(), ((Long)param.getValue()).longValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setString(param.getKey(), (String)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setBoolean(param.getKey(), ((Boolean)param.getValue()).booleanValue());
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setDate(param.getKey(), (Date)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof List) {
                        List list = (List)param.getValue();
                        if (!list.isEmpty() && list.get(0) instanceof Long) {
                            query.setParameterList(param.getKey(), (Collection)list, (Type)new LongType());
                            continue;
                        }
                        if (!list.isEmpty() && list.get(0) instanceof String) {
                            query.setParameterList(param.getKey(), (Collection)list, (Type)new StringType());
                            continue;
                        }
                        query.setParameterList(param.getKey(), (Collection)list);
                        continue;
                    }
                    query.setString(param.getKey(), param.getValue().toString());
                }
            }
            return query;
        }

        public EventInstance select(String select) {
            return new EventInstance(select, this.iWhere.containsKey("room"));
        }

        public class EventInstance {
            private String iSelect = null;
            private String iFrom = null;
            private String iWhere = null;
            private String iOrderBy = null;
            private String iGroupBy = null;
            private String iType = "Event";
            private Integer iLimit = null;
            private boolean iJoinWithLocation = false;
            private Set<String> iExclude = new HashSet<String>();
            private Map<String, Object> iParams = new HashMap<String, Object>();

            private EventInstance(String select, boolean joinWithLocation) {
                this.iSelect = select;
                this.iJoinWithLocation = joinWithLocation;
            }

            public EventInstance from(String from) {
                this.iFrom = from;
                return this;
            }

            public EventInstance where(String where) {
                this.iWhere = this.iWhere == null ? "(" + where + ")" : this.iWhere + " and (" + where + ")";
                return this;
            }

            public EventInstance type(String type) {
                this.iType = type;
                return this;
            }

            public EventInstance order(String orderBy) {
                this.iOrderBy = orderBy;
                return this;
            }

            public EventInstance group(String groupBy) {
                this.iGroupBy = groupBy;
                return this;
            }

            public EventInstance exclude(String excludeOption) {
                this.iExclude.add(excludeOption);
                return this;
            }

            public EventInstance set(String param, Object value) {
                this.iParams.put(param, value);
                return this;
            }

            public EventInstance limit(Integer limit) {
                this.iLimit = limit == null || limit <= 0 ? null : limit;
                return this;
            }

            public EventInstance joinWithLocation() {
                this.iJoinWithLocation = true;
                return this;
            }

            public String query() {
                return "select " + (this.iSelect == null ? "distinct e" : this.iSelect) + " from " + this.iType + " e inner join e.meetings m" + (this.iJoinWithLocation ? ", Location l inner join l.session s" : ", Session s") + (this.iFrom == null ? "" : (this.iFrom.trim().toLowerCase().startsWith("inner join") ? " " + this.iFrom : ", " + this.iFrom)) + EventQuery.this.getFrom(this.iExclude) + (EventQuery.this.iCheckSession ? "" : ", Session z") + " where " + (EventQuery.this.iCheckSession ? "s.uniqueId = :sessionId and m.meetingDate >= s.eventBeginDate and m.meetingDate <= s.eventEndDate" : "z.uniqueId = :sessionId and s.academicInitiative = z.academicInitiative") + (this.iJoinWithLocation ? " and m.locationPermanentId = l.permanentId" : "") + EventQuery.this.getWhere(this.iExclude) + (this.iWhere == null ? "" : " and (" + this.iWhere + ")") + (this.iGroupBy == null ? "" : " group by " + this.iGroupBy) + (this.iOrderBy == null ? "" : " order by " + this.iOrderBy);
            }

            public Query query(org.hibernate.Session hibSession) {
                Query query = EventQuery.this.setParams(hibSession.createQuery(this.query()), this.iExclude).setLong("sessionId", EventQuery.this.iSessionId.longValue()).setCacheable(true);
                for (Map.Entry<String, Object> param : this.iParams.entrySet()) {
                    if (param.getValue() instanceof Integer) {
                        query.setInteger(param.getKey(), ((Integer)param.getValue()).intValue());
                        continue;
                    }
                    if (param.getValue() instanceof Long) {
                        query.setLong(param.getKey(), ((Long)param.getValue()).longValue());
                        continue;
                    }
                    if (param.getValue() instanceof String) {
                        query.setString(param.getKey(), (String)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof Boolean) {
                        query.setBoolean(param.getKey(), ((Boolean)param.getValue()).booleanValue());
                        continue;
                    }
                    if (param.getValue() instanceof Date) {
                        query.setDate(param.getKey(), (Date)param.getValue());
                        continue;
                    }
                    if (param.getValue() instanceof Collection) {
                        query.setParameterList(param.getKey(), (Collection)param.getValue());
                        continue;
                    }
                    query.setString(param.getKey(), param.getValue().toString());
                }
                if (this.iLimit != null) {
                    query.setMaxResults(this.iLimit.intValue());
                }
                return query;
            }
        }
    }
}

