/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.api.ApiToken;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.UserEditForm;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.User;
import org.unitime.timetable.model.dao.UserDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/userEdit")
public class UserEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    ApiToken apiToken;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String op;
            UserEditForm myForm = (UserEditForm)form;
            this.sessionContext.checkPermission(Right.Users);
            String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            if (op == null) {
                myForm.reset(mapping, request);
            }
            if ("Back".equals(op)) {
                myForm.reset(mapping, request);
            }
            if ("Add User".equals(op)) {
                myForm.load(null);
            }
            if ("Request Password Change".equals(op)) {
                response.sendRedirect("gwt.jsp?page=password&reset=1");
                return null;
            }
            if ("Update".equals(op) || "Save".equals(op)) {
                ActionErrors errors = myForm.validate(mapping, request);
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                } else {
                    Transaction tx = null;
                    try {
                        Session hibSession = new UserDAO().getSession();
                        if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                            tx = hibSession.beginTransaction();
                        }
                        myForm.saveOrUpdate(hibSession);
                        if (tx != null) {
                            tx.commit();
                        }
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        throw e;
                    }
                    myForm.reset(mapping, request);
                }
            }
            if ("Edit".equals(op)) {
                String id = request.getParameter("id");
                ActionMessages errors = new ActionMessages();
                if (id == null || id.trim().length() == 0) {
                    errors.add("externalId", new ActionMessage("errors.invalid", (Object)id));
                    this.saveErrors(request, errors);
                } else {
                    User u = User.findByExternalId(id);
                    if (u == null) {
                        errors.add("externalId", new ActionMessage("errors.invalid", (Object)id));
                        this.saveErrors(request, errors);
                    } else {
                        myForm.load(u);
                        if (ApplicationProperty.ApiCanUseAPIToken.isTrue()) {
                            myForm.setToken(this.apiToken.getToken(u.getExternalUniqueId(), u.getPassword()));
                        }
                    }
                }
            }
            if ("Delete".equals(op)) {
                Transaction tx = null;
                try {
                    Session hibSession = new UserDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    myForm.delete(hibSession);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                myForm.reset(mapping, request);
            }
            if ("List".equals(myForm.getOp())) {
                this.getUserList(request);
                return mapping.findForward("list");
            }
            return mapping.findForward("Save".equals(myForm.getOp()) ? "add" : "edit");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void getUserList(HttpServletRequest request) throws Exception {
        WebTable.setOrder(this.sessionContext, "users.ord", request.getParameter("ord"), 1);
        WebTable webTable = null;
        boolean showTokents = ApplicationProperty.ApiCanUseAPIToken.isTrue();
        webTable = showTokents ? new WebTable(4, null, "userEdit.do?ord=%%", new String[]{"External ID", "User Name", "Manager", "API Secret"}, new String[]{"left", "left", "left", "left"}, null) : new WebTable(3, null, "userEdit.do?ord=%%", new String[]{"External ID", "User Name", "Manager"}, new String[]{"left", "left", "left"}, null);
        List users = new UserDAO().findAll();
        if (users.isEmpty()) {
            webTable.addLine(null, new String[]{"No users defined."}, null);
        }
        for (User user : users) {
            String onClick = "onClick=\"document.location='userEdit.do?op=Edit&id=" + user.getExternalUniqueId() + "';\"";
            TimetableManager mgr = TimetableManager.findByExternalId(user.getExternalUniqueId());
            if (showTokents) {
                String token = this.apiToken.getToken(user.getExternalUniqueId(), user.getPassword());
                webTable.addLine(onClick, new String[]{user.getExternalUniqueId(), user.getUsername(), mgr == null ? "" : mgr.getName(), token == null ? "" : token}, new Comparable[]{user.getExternalUniqueId(), user.getUsername(), mgr == null ? "" : mgr.getName(), null});
                continue;
            }
            webTable.addLine(onClick, new String[]{user.getExternalUniqueId(), user.getUsername(), mgr == null ? "" : mgr.getName()}, new Comparable[]{user.getExternalUniqueId(), user.getUsername(), mgr == null ? "" : mgr.getName()});
        }
        request.setAttribute("Users.table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "users.ord")));
    }
}

