/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.unitime.commons.MultiComparable;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoleListForm;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;

@Service(value="/selectPrimaryRole")
public class RoleListAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    /*
     * WARNING - void declaration
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoleListForm roleListForm = (RoleListForm)form;
        UserContext user = null;
        try {
            user = (UserContext)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (user == null) {
            return mapping.findForward("loginRequired");
        }
        if (user.getAuthorities().isEmpty()) {
            return mapping.findForward("norole");
        }
        if (roleListForm.getAuthority() != null) {
            UserAuthority authority = user.getAuthority(roleListForm.getAuthority());
            if (authority != null) {
                void var10_15;
                user.setCurrentAuthority(authority);
                SessionAttribute[] sessionAttributeArray = SessionAttribute.values();
                int n = sessionAttributeArray.length;
                boolean bl = false;
                while (var10_15 < n) {
                    SessionAttribute s = sessionAttributeArray[var10_15];
                    this.sessionContext.removeAttribute(s);
                    ++var10_15;
                }
            }
            if (roleListForm.getTarget() != null && !roleListForm.getTarget().isEmpty()) {
                response.sendRedirect(roleListForm.getTarget());
                return null;
            }
            return mapping.findForward("success");
        }
        UserAuthority authority = this.setupAuthorities(request, user);
        if (!"Y".equals(request.getParameter("list")) && authority != null) {
            user.setCurrentAuthority(authority);
            if (roleListForm.getTarget() != null && !roleListForm.getTarget().isEmpty()) {
                response.sendRedirect(roleListForm.getTarget());
                return null;
            }
            return mapping.findForward("success");
        }
        HashSet<String> roles = new HashSet<String>();
        for (UserAuthority userAuthority : user.getAuthorities()) {
            roles.add(userAuthority.getRole());
        }
        switch (roles.size()) {
            case 0: {
                return mapping.findForward("norole");
            }
            case 1: {
                return mapping.findForward("getDefaultAcadSession");
            }
        }
        return mapping.findForward("getUserSelectedRole");
    }

    /*
     * WARNING - void declaration
     */
    private UserAuthority setupAuthorities(HttpServletRequest request, UserContext user) {
        void var5_7;
        WebTable.setOrder(this.sessionContext, "roleLists.ord", request.getParameter("ord"), -2);
        HashSet<String> roles = new HashSet<String>();
        for (UserAuthority userAuthority : user.getAuthorities()) {
            roles.add(userAuthority.getRole());
        }
        WebTable table = new WebTable(4, "Select " + (roles.size() > 1 ? "User Role &amp; " : "") + "Academic Session", "selectPrimaryRole.do?list=Y&ord=%%", new String[]{"User Role", "Academic Session", "Academic Initiative", "Academic Session Status"}, new String[]{"left", "left", "left", "left"}, new boolean[]{true, true, true, true});
        boolean bl = false;
        UserAuthority firstAuthority = null;
        for (UserAuthority userAuthority : user.getAuthorities()) {
            Session session;
            Session session2 = session = userAuthority.getAcademicSession() == null ? null : (Session)SessionDAO.getInstance().get((Long)userAuthority.getAcademicSession().getQualifierId());
            if (session == null) continue;
            String onClick = "onClick=\"roleListForm.authority.value='" + userAuthority.getAuthority() + "';roleListForm.submit();\"";
            String bgColor = userAuthority.equals(user.getCurrentAuthority()) ? "rgb(168,187,225)" : null;
            table.addLine(onClick, new String[]{userAuthority.getLabel(), session.getAcademicYear() + " " + session.getAcademicTerm(), session.getAcademicInitiative(), session.getStatusType() == null ? "" : session.getStatusType().getLabel()}, new Comparable[]{new MultiComparable((Comparable)((Object)userAuthority.toString()), session.getSessionBeginDateTime(), (Comparable)((Object)session.getAcademicInitiative())), new MultiComparable(session.getSessionBeginDateTime(), (Comparable)((Object)session.getAcademicInitiative()), (Comparable)((Object)userAuthority.toString())), new MultiComparable((Comparable)((Object)session.getAcademicInitiative()), session.getSessionBeginDateTime(), (Comparable)((Object)userAuthority.toString())), new MultiComparable(Integer.valueOf(session.getStatusType() == null ? -1 : session.getStatusType().getOrd()), (Comparable)((Object)session.getAcademicInitiative()), session.getSessionBeginDateTime(), (Comparable)((Object)userAuthority.toString()))}).setBgColor(bgColor);
            if (firstAuthority == null) {
                firstAuthority = userAuthority;
            }
            ++var5_7;
        }
        if (user.getCurrentAuthority() == null && var5_7 == false) {
            table.addLine(new String[]{"<i><font color='red'>No user role and/or academic session associated with the user " + (user.getName() == null ? user.getUsername() : user.getName()) + ".</font></i>", null, null, null}, null);
        }
        if (var5_7 == true && firstAuthority != null) {
            user.setCurrentAuthority(firstAuthority);
        }
        request.setAttribute(Roles.USER_ROLES_ATTR_NAME, (Object)table.printTable(WebTable.getOrder(this.sessionContext, "roleLists.ord")));
        return user.getCurrentAuthority();
    }
}

