/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.InstructorAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/instructorAdd")
public class InstructorAddAction
extends InstructorAction {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.execute(mapping, form, request, response);
        InstructorEditForm frm = (InstructorEditForm)form;
        frm.setMatchFound(null);
        ActionMessages errors = new ActionMessages();
        String op = frm.getOp();
        if (op.equals(MSG.actionBackToInstructors())) {
            response.sendRedirect(response.encodeURL("instructorList.do"));
            return null;
        }
        if (this.sessionContext.getAttribute(SessionAttribute.DepartmentId) != null) {
            String deptId = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentId);
            Department d = (Department)new DepartmentDAO().get(new Long(deptId));
            frm.setDeptName(d.getName().trim());
            frm.setDeptCode(d.getDeptCode());
        }
        this.sessionContext.checkPermission((Serializable)((Object)frm.getDeptCode()), "Department", Right.InstructorAdd);
        if (op.equals(MSG.actionSaveInstructor())) {
            errors = frm.validate(mapping, request);
            if (errors.size() == 0 && this.isDeptInstructorUnique(frm, request)) {
                this.doUpdate(frm, request);
                response.sendRedirect(response.encodeURL("instructorList.do"));
                return null;
            }
            if (errors.size() == 0) {
                errors.add("uniqueId", new ActionMessage("errors.generic", (Object)MSG.errorInstructorIdAlreadyExistsInList()));
            }
            this.saveErrors(request, errors);
            return mapping.findForward("showAdd");
        }
        if (op.equals(MSG.actionLookupInstructor())) {
            errors = frm.validate(mapping, request);
            if (errors.size() == 0) {
                this.findMatchingInstructor(frm, request);
                if (frm.getMatchFound() == null || !frm.getMatchFound().booleanValue()) {
                    errors.add("lookup", new ActionMessage("errors.generic", (Object)MSG.errorNoMatchingRecordsFound()));
                }
            }
            this.saveErrors(request, errors);
            return mapping.findForward("showAdd");
        }
        if (op.equals(MSG.actionSelectInstructor())) {
            String select = frm.getSearchSelect();
            if (select != null && select.trim().length() > 0) {
                if (select.equalsIgnoreCase("i2a2")) {
                    this.fillI2A2Info(frm, request);
                } else {
                    this.fillStaffInfo(frm, request);
                }
            } else {
                errors.add("lookup", new ActionMessage("errors.generic", (Object)MSG.errorNoInstructorSelectedFromList()));
                this.saveErrors(request, errors);
            }
            return mapping.findForward("showAdd");
        }
        return mapping.findForward("showAdd");
    }
}

