/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.dom4j.Document;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.jdbc.internal.BasicFormatterImpl;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.QueryExecutionRequestException;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.HibernateQueryTestForm;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/hibernateQueryTest")
public class HibernateQueryTestAction
extends Action {
    private static Level iOriginalLevel = null;
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sessionContext.checkPermission(Right.TestHQL);
        String op = request.getParameter("op");
        if (op == null || !op.equals("Submit")) {
            if ("Clear Cache".equals(op)) {
                HibernateUtil.clearCache();
            }
            return mapping.findForward("displayQueryForm");
        }
        HibernateQueryTestForm frm = (HibernateQueryTestForm)form;
        ActionErrors errors = frm.validate(mapping, request);
        Logger sqlLog = Logger.getLogger((String)"org.hibernate.SQL");
        if (iOriginalLevel == null) {
            iOriginalLevel = sqlLog.getLevel();
        }
        sqlLog.setLevel(Level.DEBUG);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WriterAppender myAppender = new WriterAppender((Layout)new PatternLayout("%m%n"), (OutputStream)out);
        sqlLog.addAppender((Appender)myAppender);
        if (errors.size() == 0) {
            try {
                int limit = ApplicationProperty.TestHQLMaxLines.intValue();
                String query = frm.getQuery();
                _RootDAO rdao = new _RootDAO();
                Session hibSession = rdao.getSession();
                Query q = hibSession.createQuery(query);
                try {
                    List l = q.list();
                    StringBuffer s = new StringBuffer();
                    int line = 0;
                    Iterator i = l.iterator();
                    while (i.hasNext()) {
                        if (limit > 0 && line >= limit) {
                            s.append("<tr><td>...</td></tr>");
                            break;
                        }
                        Object o = i.next();
                        if (s.length() == 0) {
                            this.printHeader(s, o);
                        }
                        this.printLine(s, o, (SessionImplementor)hibSession);
                        ++line;
                    }
                    if (s.length() > 0) {
                        this.printFooter(s);
                        request.setAttribute("result", (Object)s.toString());
                    }
                    frm.setListSize(String.valueOf(l.size()));
                }
                catch (QueryExecutionRequestException e) {
                    Transaction tx = null;
                    try {
                        tx = hibSession.beginTransaction();
                        int i = q.executeUpdate();
                        request.setAttribute("result", (Object)(i + " lines updated."));
                        frm.setListSize(String.valueOf(i));
                        tx.commit();
                    }
                    catch (Exception ex) {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                        throw ex;
                    }
                    hibSession.flush();
                    HibernateUtil.clearCache();
                }
            }
            catch (Exception e) {
                errors.add("query", new ActionMessage("errors.generic", (Object)e.getMessage()));
                Debug.error(e);
            }
        }
        sqlLog.removeAppender((Appender)myAppender);
        sqlLog.setLevel(iOriginalLevel == null ? Level.INFO : iOriginalLevel);
        out.flush();
        out.close();
        String sql = "";
        StringTokenizer stk = new StringTokenizer(new String(out.toByteArray()), "\n");
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken();
            String comment = null;
            if (line.indexOf("/*") >= 0 && line.indexOf("/*") < line.indexOf("*/")) {
                comment = line.substring(line.indexOf("/*") + 2, line.indexOf("*/"));
                line = line.substring(0, line.indexOf("/*")) + line.substring(line.indexOf("*/") + 2);
            }
            if (sql.length() > 0) {
                sql = sql + "<br><br>";
            }
            if (comment != null) {
                sql = sql + "<font color='gray'>-- " + comment + "</font>";
            }
            BasicFormatterImpl f = new BasicFormatterImpl();
            sql = sql + f.format(line).replaceAll("\n", "<br>").replaceAll(" ", "&nbsp;");
        }
        if (sql.length() > 0) {
            request.setAttribute("sql", (Object)sql);
        }
        this.saveErrors(request, (ActionMessages)errors);
        return mapping.findForward("displayQueryForm");
    }

    private void header(StringBuffer s, int idx, String text) {
        s.append("<td class='WebTableHeader'><i>");
        if (text == null || text.length() <= 0) {
            s.append("Col " + idx);
        } else {
            s.append(text.substring(0, 1).toUpperCase());
            if (text.length() > 1) {
                s.append(text.substring(1));
            }
        }
        s.append("</i></td>");
    }

    private boolean skip(Type t, boolean lazy) {
        try {
            if (t.isCollectionType()) {
                if (!lazy) {
                    return true;
                }
                SessionFactory hibSessionFactory = new _RootDAO().getSession().getSessionFactory();
                Type w = ((CollectionType)t).getElementType((SessionFactoryImplementor)hibSessionFactory);
                Class<?> ts = w.getReturnedClass().getMethod("toString", new Class[0]).getDeclaringClass();
                return ts.equals(Object.class) || ts.getName().startsWith("org.unitime.timetable.model.base.Base");
            }
        }
        catch (MappingException e) {
            return true;
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        try {
            Class<?> ts = t.getReturnedClass().getMethod("toString", new Class[0]).getDeclaringClass();
            return ts.equals(Object.class) || ts.getName().startsWith("org.unitime.timetable.model.base.Base");
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    public void printHeader(StringBuffer s, Object o) {
        s.append("<table width='100%' border='0' cellspacing='0' cellpadding='3'>");
        s.append("<tr align='left'>");
        SessionFactory hibSessionFactory = new _RootDAO().getSession().getSessionFactory();
        int idx = 1;
        if (o == null) {
            this.header(s, idx++, null);
        } else if (o instanceof Object[]) {
            Object[] x = (Object[])o;
            for (int i = 0; i < x.length; ++i) {
                if (x[i] == null) {
                    this.header(s, idx++, null);
                    continue;
                }
                ClassMetadata meta = hibSessionFactory.getClassMetadata(x[i].getClass());
                if (meta == null) {
                    this.header(s, idx++, null);
                    continue;
                }
                this.header(s, idx++, meta.getIdentifierPropertyName());
                for (int j = 0; j < meta.getPropertyNames().length; ++j) {
                    if (this.skip(meta.getPropertyTypes()[j], meta.getPropertyLaziness()[j])) continue;
                    this.header(s, idx++, meta.getPropertyNames()[j]);
                }
            }
        } else {
            ClassMetadata meta = hibSessionFactory.getClassMetadata(o.getClass());
            if (meta == null) {
                this.header(s, idx++, null);
            } else {
                this.header(s, idx++, meta.getIdentifierPropertyName());
                for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                    if (this.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                    this.header(s, idx++, meta.getPropertyNames()[i]);
                }
            }
        }
        s.append("</tr>");
    }

    private void line(StringBuffer s, Object text) {
        s.append("<td>");
        if (text != null) {
            if (text instanceof Document) {
                s.append(((Document)text).asXML().replace("<", "&lt;").replace(">", "&gt;"));
            } else {
                s.append(text.toString());
            }
        }
        s.append("</td>");
    }

    public void printLine(StringBuffer s, Object o, SessionImplementor session) {
        s.append("<tr align='left' onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';\" onmouseout=\"this.style.backgroundColor='transparent';\" >");
        SessionFactory hibSessionFactory = new _RootDAO().getSession().getSessionFactory();
        if (o == null) {
            this.line(s, null);
        } else if (o instanceof Object[]) {
            Object[] x = (Object[])o;
            for (int i = 0; i < x.length; ++i) {
                if (x[i] == null) {
                    this.line(s, null);
                    continue;
                }
                ClassMetadata meta = hibSessionFactory.getClassMetadata(x[i].getClass());
                if (meta == null) {
                    this.line(s, x[i]);
                    continue;
                }
                this.line(s, meta.getIdentifier(x[i], session));
                for (int j = 0; j < meta.getPropertyNames().length; ++j) {
                    if (this.skip(meta.getPropertyTypes()[j], meta.getPropertyLaziness()[j])) continue;
                    this.line(s, meta.getPropertyValue(x[i], meta.getPropertyNames()[j]));
                }
            }
        } else {
            ClassMetadata meta = hibSessionFactory.getClassMetadata(o.getClass());
            if (meta == null) {
                this.line(s, o);
            } else {
                this.line(s, meta.getIdentifier(o, session));
                for (int i = 0; i < meta.getPropertyNames().length; ++i) {
                    if (this.skip(meta.getPropertyTypes()[i], meta.getPropertyLaziness()[i])) continue;
                    this.line(s, meta.getPropertyValue(o, meta.getPropertyNames()[i]));
                }
            }
        }
        s.append("</tr>");
    }

    public void printFooter(StringBuffer s) {
        s.append("</table>");
    }
}

