/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ExamDistributionPrefsForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DistributionPrefDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.ExamDistributionPrefsTableBuilder;

@Service(value="/examDistributionPrefs")
public class ExamDistributionPrefsAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sessionContext.checkPermission(Right.ExaminationDistributionPreferences);
        MessageResources rsc = this.getResources(request);
        ActionMessages errors = new ActionMessages();
        ExamDistributionPrefsForm frm = (ExamDistributionPrefsForm)form;
        String deleteId = request.getParameter("deleteId");
        String deleteType = request.getParameter("deleteType");
        String distPrefId = request.getParameter("dp");
        String reloadCause = request.getParameter("reloadCause");
        String reloadId = request.getParameter("reloadId");
        String op = frm.getOp();
        if (op == null || op.trim().length() == 0) {
            op = deleteType != null && deleteType.length() > 0 ? "delete" : "view";
            frm.setOp(op);
        }
        if (reloadCause != null && reloadCause.length() > 0) {
            op = "reload";
        }
        if (op.equals(rsc.getMessage("button.cancel"))) {
            frm.reset(mapping, request);
            if (BackTracker.doBack(request, response)) {
                return null;
            }
            op = "view";
        }
        LookupTables.setupExamTypes(request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable, DepartmentStatusType.Status.ExamView);
        request.setAttribute("examTypesAdd", ExamType.findAllApplicable(this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable, DepartmentStatusType.Status.ExamEdit));
        if (op.equals(rsc.getMessage("button.save")) || op.equals(rsc.getMessage("button.update"))) {
            Debug.debug("Saving distribution pref ...");
            this.sessionContext.setAttribute(SessionAttribute.ExamType, (Object)frm.getExamType());
            errors = frm.validate(mapping, request);
            if (errors.size() == 0) {
                try {
                    this.doAddOrUpdate(request, frm);
                    if (frm.getDistPrefId() != null) {
                        request.setAttribute("backType", (Object)"PreferenceGroup");
                        request.setAttribute("backId", (Object)frm.getDistPrefId());
                    }
                    frm.reset(mapping, request);
                    if (BackTracker.doBack(request, response)) {
                        return null;
                    }
                    op = "view";
                }
                catch (Exception e) {
                    Debug.error(e);
                    errors.add("classes", new ActionMessage("errors.generic", (Object)e.getMessage()));
                    this.saveErrors(request, errors);
                }
            } else {
                this.saveErrors(request, errors);
            }
        }
        if (op.equals(rsc.getMessage("button.delete")) || op.equals("delete")) {
            if (deleteType.equals("distObject")) {
                frm.deleteExam(Integer.parseInt(deleteId));
            }
            if (deleteType.equals("distPref")) {
                distPrefId = frm.getDistPrefId();
                this.doDelete(request, distPrefId);
                frm.reset(mapping, request);
                if (BackTracker.doBack(request, response)) {
                    return null;
                }
                op = "view";
            }
            if (deleteType.equals("examType")) {
                this.sessionContext.setAttribute(SessionAttribute.ExamType, (Object)frm.getExamType());
            }
        }
        if (op.equals(rsc.getMessage("button.addDistPref"))) {
            Debug.debug("Adding new Class via redirect ...");
            frm.setDistType("-");
            if (request.getAttribute("subjectAreaId") != null) {
                frm.setSubjectArea(0, Long.valueOf(request.getAttribute("subjectAreaId").toString()));
            }
            if (request.getAttribute("courseOffrId") != null) {
                CourseOffering course = (CourseOffering)new CourseOfferingDAO().get(Long.valueOf(request.getAttribute("courseOffrId").toString()));
                frm.setSubjectArea(0, course.getSubjectArea().getUniqueId());
                frm.setCourseNbr(0, course.getUniqueId());
            }
            if (request.getAttribute("examId") != null) {
                Exam exam = (Exam)new ExamDAO().get(Long.valueOf(request.getAttribute("examId").toString()));
                frm.setExam(0, exam.getUniqueId());
                frm.setSubjectArea(0, exam.firstSubjectArea().getUniqueId());
                frm.setCourseNbr(0, exam.firstCourseOffering().getUniqueId());
                frm.setExamType(exam.getExamType().getUniqueId());
            }
            frm.getSubjectArea().add(new Long(-1L));
            frm.getCourseNbr().add(new Long(-1L));
            frm.getExam().add(new Long(-1L));
        }
        if (op.equals(rsc.getMessage("button.addExam"))) {
            Debug.debug("Adding new Class ...");
            frm.getSubjectArea().add(new Long(-1L));
            frm.getCourseNbr().add(new Long(-1L));
            frm.getExam().add(new Long(-1L));
        }
        if (op.equals(rsc.getMessage("button.search")) || op.equals(rsc.getMessage("button.exportPDF"))) {
            String subjectAreaId = frm.getFilterSubjectAreaId();
            String courseNbr = frm.getFilterCourseNbr();
            if (subjectAreaId != null && subjectAreaId.length() > 0) {
                this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjectAreaId);
            } else {
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsSubjectArea);
            }
            if (courseNbr != null && courseNbr.length() > 0) {
                this.sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)courseNbr);
            } else {
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsCourseNumber);
            }
            this.sessionContext.setAttribute(SessionAttribute.ExamType, (Object)frm.getExamType());
            op = op.equals(rsc.getMessage("button.exportPDF")) ? "export" : "view";
        }
        if (op != null && (op.equals("view") || op.equals("export")) && distPrefId != null && distPrefId.trim().length() > 0) {
            Debug.debug("Loading dist pref - " + distPrefId);
            frm.reset(mapping, request);
            this.doLoad(frm, distPrefId);
        }
        if (op != null && op.equals("reload")) {
            if (reloadCause != null && reloadCause.equals("moveUp")) {
                int index = Integer.parseInt(reloadId);
                Debug.debug("moving up ... " + reloadId);
                frm.swapExams(index, index - 1);
            }
            if (reloadCause != null && reloadCause.equals("moveDown")) {
                int index = Integer.parseInt(reloadId);
                Debug.debug("moving down ... " + reloadId);
                frm.swapExams(index, index + 1);
            }
        }
        if (frm.getDistType() != null && !frm.getDistType().equals("-")) {
            Vector<PreferenceLevel> prefs = new Vector<PreferenceLevel>();
            DistributionType dist = (DistributionType)new DistributionTypeDAO().get(new Long(frm.getDistType()));
            frm.setDescription(dist.getDescr());
            boolean containsPref = false;
            for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList()) {
                if (!dist.isAllowed(pref)) continue;
                prefs.addElement(pref);
                if (frm.getPrefLevel() == null || frm.getPrefLevel().equals("-") || !pref.getPrefId().equals(new Integer(frm.getPrefLevel()))) continue;
                containsPref = true;
            }
            if (!containsPref) {
                frm.setPrefLevel("-");
            }
            if (prefs.size() == 1) {
                frm.setPrefLevel(((PreferenceLevel)prefs.firstElement()).getPrefId().toString());
            }
            request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, prefs);
            LookupTables.setupExamDistribTypes(request, this.sessionContext, dist);
        } else {
            request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, new Vector(0));
            frm.setDescription("");
            LookupTables.setupExamDistribTypes(request, this.sessionContext, null);
        }
        if ("export".equals(op) && (frm.getDistPrefId() == null || frm.getDistPrefId().length() == 0)) {
            OutputStream out = ExportUtils.getPdfOutputStream(response, "distpref");
            new ExamDistributionPrefsTableBuilder().getDistPrefsTableAsPdf(out, request, this.sessionContext, Constants.ALL_OPTION_VALUE.equals(frm.getFilterSubjectAreaId()) || frm.getFilterSubjectAreaId().isEmpty() ? null : Long.valueOf(frm.getFilterSubjectAreaId()), frm.getFilterCourseNbr(), frm.getExamType());
            out.flush();
            out.close();
            return null;
        }
        request.setAttribute("listSize", (Object)("" + (frm.getSubjectArea().size() - 1)));
        if (frm.getExamType() == null) {
            if (this.sessionContext.getAttribute(SessionAttribute.ExamType) != null) {
                frm.setExamType((Long)this.sessionContext.getAttribute(SessionAttribute.ExamType));
            } else {
                TreeSet<ExamType> types = ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId());
                if (!types.isEmpty()) {
                    frm.setExamType(types.first().getUniqueId());
                }
            }
        }
        frm.setFilterSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser(), false));
        if (frm.getFilterSubjectAreas().size() == 1) {
            SubjectArea firstSubjectArea = (SubjectArea)frm.getFilterSubjectAreas().iterator().next();
            frm.setFilterSubjectAreaId(firstSubjectArea.getUniqueId().toString());
        }
        if ("view".equals(op) && (frm.getDistPrefId() == null || frm.getDistPrefId().length() == 0)) {
            String subject = (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
            if (subject != null && subject.indexOf(44) >= 0) {
                subject = subject.substring(0, subject.indexOf(44));
            }
            frm.setFilterSubjectAreaId(subject);
            frm.setFilterCourseNbr((String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber));
            ExamDistributionPrefsTableBuilder tbl = new ExamDistributionPrefsTableBuilder();
            if (frm.getFilterSubjectAreaId() == null) {
                if (this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                    frm.setFilterSubjectAreaId(Constants.BLANK_OPTION_VALUE);
                } else {
                    frm.setFilterSubjectAreaId(Constants.ALL_OPTION_VALUE);
                }
            }
            if (frm.getFilterSubjectAreaId() != null && frm.getFilterSubjectAreaId().length() > 0 && !"null".equals(frm.getFilterSubjectAreaId())) {
                String html = tbl.getDistPrefsTable(request, this.sessionContext, Constants.ALL_OPTION_VALUE.equals(frm.getFilterSubjectAreaId()) ? null : Long.valueOf(frm.getFilterSubjectAreaId()), frm.getFilterCourseNbr(), frm.getExamType());
                if (html != null) {
                    request.setAttribute("distPrefs", (Object)html);
                }
            } else {
                request.setAttribute("distPrefs", (Object)"");
            }
            BackTracker.markForBack(request, "examDistributionPrefs.do", "Exam Distribution Prefs", true, true);
            return mapping.findForward("list");
        }
        return mapping.findForward(frm.getDistPrefId() == null || frm.getDistPrefId().length() == 0 ? "add" : "edit");
    }

    private void doLoad(ExamDistributionPrefsForm frm, String distPrefId) {
        this.sessionContext.checkPermission((Serializable)((Object)distPrefId), "DistributionPref", Right.ExaminationDistributionPreferenceDetail);
        DistributionPref dp = (DistributionPref)new DistributionPrefDAO().get(new Long(distPrefId));
        frm.setDistType(dp.getDistributionType().getUniqueId().toString());
        frm.setDescription(dp.getDistributionType().getDescr());
        frm.setPrefLevel(dp.getPrefLevel().getPrefId().toString());
        frm.setDistPrefId(distPrefId);
        for (DistributionObject distObj : new TreeSet<DistributionObject>(dp.getDistributionObjects())) {
            Exam exam = (Exam)distObj.getPrefGroup();
            frm.getSubjectArea().add(exam.firstSubjectArea().getUniqueId());
            frm.getCourseNbr().add(exam.firstCourseOffering().getUniqueId());
            frm.getExam().add(exam.getUniqueId());
        }
    }

    private void doAddOrUpdate(HttpServletRequest request, ExamDistributionPrefsForm frm) throws Exception {
        String distPrefId = frm.getDistPrefId();
        if (distPrefId != null && !distPrefId.isEmpty()) {
            this.sessionContext.checkPermission((Serializable)((Object)distPrefId), "DistributionPref", Right.ExaminationDistributionPreferenceEdit);
        } else {
            this.sessionContext.checkPermission(Right.ExaminationDistributionPreferenceAdd);
        }
        DistributionPref dp = null;
        DistributionPrefDAO dpDao = new DistributionPrefDAO();
        Transaction tx = null;
        Session hibSession = dpDao.getSession();
        HashSet<PreferenceGroup> relatedExams = new HashSet<PreferenceGroup>();
        try {
            tx = hibSession.beginTransaction();
            if (distPrefId != null && !distPrefId.isEmpty()) {
                dp = (DistributionPref)dpDao.get(Long.valueOf(distPrefId), hibSession);
                Set<DistributionObject> s = dp.getDistributionObjects();
                for (DistributionObject dObj : s) {
                    PreferenceGroup preferenceGroup = dObj.getPrefGroup();
                    relatedExams.add(preferenceGroup);
                    preferenceGroup.getDistributionObjects().remove(dObj);
                    hibSession.saveOrUpdate((Object)preferenceGroup);
                }
                s.clear();
                dp.setDistributionObjects(s);
            } else {
                dp = new DistributionPref();
            }
            dp.setDistributionType((DistributionType)new DistributionTypeDAO().get(new Long(frm.getDistType()), hibSession));
            dp.setGrouping(-1);
            dp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(frm.getPrefLevel())));
            dp.setOwner((PreferenceGroup)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            HashSet<Exam> addedExams = new HashSet<Exam>();
            int idx = 0;
            for (Object e : frm.getExam()) {
                Exam exam;
                Long examId = e instanceof Long ? (Long)e : Long.valueOf(e.toString());
                if (examId < 0L || (exam = (Exam)new ExamDAO().get(examId, hibSession)) == null || !addedExams.add(exam)) continue;
                relatedExams.add(exam);
                DistributionObject dObj = new DistributionObject();
                dObj.setPrefGroup(exam);
                dObj.setDistributionPref(dp);
                dObj.setSequenceNumber(new Integer(++idx));
                exam.getDistributionObjects().add(dObj);
                dp.addTodistributionObjects(dObj);
            }
            hibSession.saveOrUpdate((Object)dp);
            for (Exam exam : relatedExams) {
                ChangeLog.addChange(hibSession, this.sessionContext, exam, ChangeLog.Source.DIST_PREF_EDIT, distPrefId != null && distPrefId.trim().length() > 0 ? ChangeLog.Operation.UPDATE : ChangeLog.Operation.CREATE, exam.firstSubjectArea(), exam.firstDepartment());
            }
            tx.commit();
            hibSession.flush();
            hibSession.refresh((Object)dp.getOwner());
            frm.setDistPrefId(dp.getUniqueId().toString());
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            hibSession.clear();
            throw e;
        }
    }

    private void doDelete(HttpServletRequest request, String distPrefId) {
        block6: {
            Transaction tx = null;
            this.sessionContext.checkPermission((Serializable)((Object)distPrefId), "DistributionPref", Right.ExaminationDistributionPreferenceDelete);
            try {
                DistributionPrefDAO dpDao = new DistributionPrefDAO();
                Session hibSession = dpDao.getSession();
                tx = hibSession.getTransaction();
                if (tx == null || !tx.isActive()) {
                    tx = hibSession.beginTransaction();
                }
                HashSet<PreferenceGroup> relatedExams = new HashSet<PreferenceGroup>();
                DistributionPref dp = (DistributionPref)dpDao.get(new Long(distPrefId));
                PreferenceGroup owner = dp.getOwner();
                owner.getPreferences().remove(dp);
                for (DistributionObject distributionObject : dp.getDistributionObjects()) {
                    PreferenceGroup pg = distributionObject.getPrefGroup();
                    relatedExams.add(pg);
                    pg.getDistributionObjects().remove(distributionObject);
                    hibSession.saveOrUpdate((Object)pg);
                }
                hibSession.delete((Object)dp);
                hibSession.saveOrUpdate((Object)owner);
                for (Exam exam : relatedExams) {
                    ChangeLog.addChange(hibSession, this.sessionContext, exam, ChangeLog.Source.DIST_PREF_EDIT, ChangeLog.Operation.DELETE, exam.firstSubjectArea(), exam.firstDepartment());
                }
                if (tx != null && tx.isActive()) {
                    tx.commit();
                }
                hibSession.flush();
                hibSession.refresh((Object)owner);
            }
            catch (Exception e) {
                Debug.error(e);
                if (tx == null || !tx.isActive()) break block6;
                tx.rollback();
            }
        }
    }
}

