/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.action.PreferencesAction;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ExamEditForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.ExamDistributionPrefsTableBuilder;
import org.unitime.timetable.webutil.Navigation;

@Service(value="/examDetail")
public class ExamDetailAction
extends PreferencesAction {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExamEditForm frm = (ExamEditForm)form;
        try {
            super.execute(mapping, form, request, response);
            MessageResources rsc = this.getResources(request);
            ActionMessages errors = new ActionMessages();
            String examId = null;
            if (request.getParameter("examId") != null && request.getParameter("examId").trim().length() != 0) {
                examId = request.getParameter("examId");
            }
            if (examId == null && request.getAttribute("examId") != null && request.getAttribute("examId").toString().trim().length() != 0) {
                examId = request.getAttribute("examId").toString();
            }
            String op = frm.getOp();
            if (request.getParameter("op2") != null && request.getParameter("op2").length() > 0) {
                op = request.getParameter("op2");
            }
            if (op == null) {
                throw new Exception("Null Operation not supported.");
            }
            if (op.equals(rsc.getMessage("button.editExam")) || op.equals(rsc.getMessage("button.cloneExam")) || op.equals(rsc.getMessage("button.addDistPref")) || op.equals(rsc.getMessage("button.nextExam")) || op.equals(rsc.getMessage("button.previousExam"))) {
                examId = frm.getExamId();
            } else {
                frm.reset(mapping, request);
            }
            Debug.debug("op: " + op);
            Debug.debug("exam: " + examId);
            if (examId == null || examId.trim() == "") {
                throw new Exception("Exam Info not supplied.");
            }
            boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
            Exam exam = (Exam)new ExamDAO().get(Long.valueOf(examId));
            if (exam == null && BackTracker.hasBack(request, 1)) {
                if (request.getParameter("backType") != null) {
                    request.setAttribute("backType", (Object)request.getParameter("backType"));
                }
                if (request.getParameter("backId") != null) {
                    request.setAttribute("backId", (Object)request.getParameter("backId"));
                }
                BackTracker.doBack(request, response);
                return null;
            }
            this.sessionContext.checkPermission((Serializable)((Object)examId), "Exam", Right.ExaminationDetail);
            if (op.equals(rsc.getMessage("button.editExam")) && examId != null && examId.trim() != "") {
                this.sessionContext.checkPermission(exam, Right.ExaminationEdit);
                response.sendRedirect(response.encodeURL("examEdit.do?examId=" + examId));
                return null;
            }
            if (op.equals(rsc.getMessage("button.cloneExam")) && examId != null && examId.trim() != "") {
                this.sessionContext.checkPermission(exam, Right.ExaminationClone);
                response.sendRedirect(response.encodeURL("examEdit.do?examId=" + examId + "&clone=true"));
                return null;
            }
            if (op.equals(rsc.getMessage("button.nextExam"))) {
                response.sendRedirect(response.encodeURL("examDetail.do?examId=" + frm.getNextId()));
                return null;
            }
            if (op.equals(rsc.getMessage("button.previousExam"))) {
                response.sendRedirect(response.encodeURL("examDetail.do?examId=" + frm.getPreviousId()));
                return null;
            }
            if (op.equals(rsc.getMessage("button.deleteExam"))) {
                this.sessionContext.checkPermission(exam, Right.ExaminationDelete);
                Session hibSession = new ExamDAO().getSession();
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    ChangeLog.addChange(hibSession, this.sessionContext, exam, ChangeLog.Source.EXAM_EDIT, ChangeLog.Operation.DELETE, exam.firstSubjectArea(), exam.firstDepartment());
                    exam.deleteDependentObjects(hibSession, false);
                    hibSession.delete((Object)exam);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                if (BackTracker.hasBack(request, 1)) {
                    request.setAttribute("backType", (Object)"Exam");
                    request.setAttribute("backId", (Object)"-1");
                    BackTracker.doBack(request, response);
                    return null;
                }
                return mapping.findForward("showList");
            }
            if (op.equals(rsc.getMessage("button.addDistPref"))) {
                this.sessionContext.checkPermission(exam, Right.DistributionPreferenceExam);
                request.setAttribute("examId", (Object)examId);
                return mapping.findForward("addDistributionPrefs");
            }
            this.doLoad(request, frm, exam);
            ExamDistributionPrefsTableBuilder tbl = new ExamDistributionPrefsTableBuilder();
            String html = tbl.getDistPrefsTable(request, this.sessionContext, exam);
            if (html != null) {
                request.setAttribute("distPrefs", (Object)html);
            }
            if (!exam.getOwners().isEmpty()) {
                WebTable table = new WebTable(7, null, new String[]{"Object", "Type", "Title", "Manager", "Students", "Limit", "Assignment"}, new String[]{"left", "center", "left", "left", "right", "right", "left"}, new boolean[]{true, true, true, true, true, true, true});
                for (ExamOwner owner : new TreeSet<ExamOwner>(exam.getOwners())) {
                    String onclick = null;
                    String name = null;
                    String type = null;
                    String students = String.valueOf(owner.countStudents());
                    String limit = String.valueOf(owner.getLimit());
                    String manager = null;
                    String assignment = null;
                    String title = null;
                    String rowStyle = null;
                    String rowTitle = null;
                    switch (owner.getOwnerType()) {
                        case 3: {
                            Class_ clazz = (Class_)owner.getOwnerObject();
                            if (this.sessionContext.hasPermission(clazz, Right.ClassDetail)) {
                                onclick = "onClick=\"document.location='classDetail.do?cid=" + clazz.getUniqueId() + "';\"";
                            }
                            name = owner.getLabel();
                            type = "Class";
                            manager = clazz.getManagingDept().getShortLabel();
                            if (clazz.getCommittedAssignment() != null) {
                                assignment = clazz.getCommittedAssignment().getPlacement().getLongName(CONSTANTS.useAmPm());
                            }
                            if ((title = clazz.getSchedulePrintNote()) == null || title.length() == 0) {
                                title = clazz.getSchedulingSubpart().getControllingCourseOffering().getTitle();
                            }
                            if (!clazz.isCancelled().booleanValue()) break;
                            rowStyle = "color: gray; font-style: italic;";
                            rowTitle = MSG.classNoteCancelled(clazz.getClassLabel());
                            break;
                        }
                        case 2: {
                            InstrOfferingConfig config = (InstrOfferingConfig)owner.getOwnerObject();
                            if (this.sessionContext.hasPermission(config.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                                onclick = "onClick=\"document.location='instructionalOfferingDetail.do?io=" + config.getInstructionalOffering().getUniqueId() + "';\"";
                            }
                            name = owner.getLabel();
                            type = "Configuration";
                            manager = config.getInstructionalOffering().getControllingCourseOffering().getDepartment().getShortLabel();
                            title = config.getControllingCourseOffering().getTitle();
                            break;
                        }
                        case 0: {
                            InstructionalOffering offering = (InstructionalOffering)owner.getOwnerObject();
                            if (this.sessionContext.hasPermission(offering, Right.InstructionalOfferingDetail)) {
                                onclick = "onClick=\"document.location='instructionalOfferingDetail.do?io=" + offering.getUniqueId() + "';\"";
                            }
                            name = owner.getLabel();
                            type = "Offering";
                            manager = offering.getControllingCourseOffering().getDepartment().getShortLabel();
                            title = offering.getControllingCourseOffering().getTitle();
                            break;
                        }
                        case 1: {
                            CourseOffering course = (CourseOffering)owner.getOwnerObject();
                            if (this.sessionContext.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                                onclick = "onClick=\"document.location='instructionalOfferingDetail.do?io=" + course.getInstructionalOffering().getUniqueId() + "';\"";
                            }
                            name = owner.getLabel();
                            type = "Course";
                            manager = course.getDepartment().getShortLabel();
                            title = course.getTitle();
                        }
                    }
                    WebTable.WebTableLine line = table.addLine(onclick, new String[]{name, type, title, manager, students, limit, assignment}, null);
                    if (rowStyle != null) {
                        line.setStyle(rowStyle);
                    }
                    if (rowTitle == null) continue;
                    line.setTitle(rowTitle);
                }
                request.setAttribute("ExamDetail.table", (Object)table.printTable());
            }
            ExamAssignment ea = null;
            ExamSolverProxy examAssignment = WebSolver.getExamSolver(request.getSession());
            if (examAssignment != null && examAssignment.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
                ea = examAssignment.getAssignmentInfo(exam.getUniqueId());
            } else if (exam.getAssignedPeriod() != null) {
                ea = new ExamAssignmentInfo(exam);
            }
            if (ea != null && ea.getPeriod() != null) {
                String assignment = "<tr><td>Examination Period:</td><td>" + ea.getPeriodNameWithPref() + "</td></tr>";
                if (!ea.getRooms().isEmpty()) {
                    assignment = assignment + "<tr><td>Room" + (ea.getRooms().size() > 1 ? "s" : "") + ":</td><td>";
                    assignment = assignment + ea.getRoomsNameWithPref("<br>");
                    assignment = assignment + "</td></tr>";
                }
                if (((ExamAssignmentInfo)ea).getNrDistributionConflicts() > 0) {
                    assignment = assignment + "<tr><td>Violated Distributions:</td><td>";
                    assignment = assignment + ((ExamAssignmentInfo)ea).getDistributionConflictTable();
                    assignment = assignment + "</td></tr>";
                }
                if (((ExamAssignmentInfo)ea).getHasConflicts()) {
                    assignment = assignment + "<tr><td>Student Conflicts</td><td>";
                    assignment = assignment + ((ExamAssignmentInfo)ea).getConflictTable();
                    assignment = assignment + "</td></tr>";
                }
                if (((ExamAssignmentInfo)ea).getHasInstructorConflicts()) {
                    assignment = assignment + "<tr><td>Instructor Conflicts</td><td>";
                    assignment = assignment + ((ExamAssignmentInfo)ea).getInstructorConflictTable();
                    assignment = assignment + "</td></tr>";
                }
                request.setAttribute("ExamDetail.assignment", (Object)assignment);
            }
            BackTracker.markForBack(request, "examDetail.do?examId=" + examId, "Exam (" + (frm.getName() == null ? frm.getLabel().trim() : frm.getName().trim()) + ")", true, false);
            frm.setAvailableTimePatterns(null);
            this.initPrefs(frm, exam, null, false);
            this.generateExamPeriodGrid(request, frm, exam, "init", timeVertical, false);
            this.processPrefAction(request, frm, errors);
            this.setupInstructors(request, frm, exam);
            LookupTables.setupRooms(request, exam);
            LookupTables.setupBldgs(request, exam);
            LookupTables.setupRoomFeatures(request, exam);
            LookupTables.setupRoomGroups(request, exam);
            LookupTables.setupExamTypes(request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable, DepartmentStatusType.Status.ExamView);
            return mapping.findForward("showExamDetail");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    protected void doLoad(HttpServletRequest request, ExamEditForm frm, Exam exam) {
        frm.setExamId(exam.getUniqueId().toString());
        frm.setLabel(exam.getLabel());
        frm.setName(exam.generateName().equals(exam.getName()) ? null : exam.getName());
        frm.setNote(exam.getNote() == null ? null : exam.getNote().replaceAll("\n", "<br>"));
        frm.setLength(exam.getLength());
        frm.setSize(String.valueOf(exam.getSize()));
        frm.setPrintOffset(exam.getPrintOffset() == null || exam.getPrintOffset() == 0 ? null : (exam.getPrintOffset() > 0 ? "+" : "") + exam.getPrintOffset());
        frm.setSeatingType(Exam.sSeatingTypes[exam.getSeatingType()]);
        frm.setMaxNbrRooms(exam.getMaxNbrRooms());
        frm.setExamType(exam.getExamType().getUniqueId());
        frm.setAccommodation(StudentAccomodation.toHtml(StudentAccomodation.getAccommodations(exam)));
        TreeSet<DepartmentalInstructor> instructors = new TreeSet<DepartmentalInstructor>(exam.getInstructors());
        for (DepartmentalInstructor instr : instructors) {
            frm.getInstructors().add(instr.getUniqueId().toString());
        }
        Long nextId = Navigation.getNext(this.sessionContext, Navigation.sInstructionalOfferingLevel, exam.getUniqueId());
        Long prevId = Navigation.getPrevious(this.sessionContext, Navigation.sInstructionalOfferingLevel, exam.getUniqueId());
        frm.setPreviousId(prevId == null ? null : prevId.toString());
        frm.setNextId(nextId == null ? null : nextId.toString());
        ExamPeriod avgPeriod = exam.getAveragePeriod();
        frm.setAvgPeriod(avgPeriod == null ? null : avgPeriod.getName());
    }

    protected void setupInstructors(HttpServletRequest request, ExamEditForm frm, Exam exam) throws Exception {
        List instructors = frm.getInstructors();
        if (instructors.size() == 0) {
            return;
        }
        HashSet<Long> deptIds = new HashSet<Long>();
        for (DepartmentalInstructor instr : exam.getInstructors()) {
            deptIds.add(instr.getDepartment().getUniqueId());
        }
        for (ExamOwner own : exam.getOwners()) {
            deptIds.add(own.getCourse().getDepartment().getUniqueId());
        }
        Long[] deptsIdsArray = new Long[deptIds.size()];
        int idx = 0;
        Iterator i = deptIds.iterator();
        while (i.hasNext()) {
            deptsIdsArray[idx++] = (Long)i.next();
        }
        LookupTables.setupInstructors(request, this.sessionContext, deptsIdsArray);
        Vector deptInstrList = (Vector)request.getAttribute(DepartmentalInstructor.INSTR_LIST_ATTR_NAME);
        for (int i2 = 0; i2 < instructors.size(); ++i2) {
            request.setAttribute(DepartmentalInstructor.INSTR_LIST_ATTR_NAME + i2, (Object)deptInstrList);
        }
    }
}

