/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ClassInstructorAssignmentForm;
import org.unitime.timetable.interfaces.ExternalInstrOfferingConfigAssignInstructorsAction;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.comparators.DepartmentalInstructorComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.util.LookupTables;

@Service(value="/classInstructorAssignment")
public class ClassInstructorAssignmentAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    Permission<InstructionalOffering> permissionOfferingLockNeeded;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        MessageResources rsc = this.getResources(request);
        ClassInstructorAssignmentForm frm = (ClassInstructorAssignmentForm)form;
        Object object = request.getParameter("op") == null ? (frm.getOp() == null || frm.getOp().length() == 0 ? (request.getAttribute("op") == null ? null : request.getAttribute("op").toString()) : frm.getOp()) : (op = request.getParameter("op"));
        if (op == null) {
            op = request.getParameter("hdnOp");
        }
        if (op == null || op.trim().length() == 0) {
            throw new Exception(MSG.exceptionOperationNotInterpreted() + op);
        }
        String instrOffrConfigId = "";
        frm.setOp(op);
        frm.setProxy(WebSolver.getClassAssignmentProxy(request.getSession()));
        instrOffrConfigId = request.getParameter("uid") == null ? (request.getAttribute("uid") == null ? (frm.getInstrOffrConfigId() != null ? frm.getInstrOffrConfigId().toString() : null) : request.getAttribute("uid").toString()) : request.getParameter("uid");
        InstrOfferingConfigDAO iocDao = new InstrOfferingConfigDAO();
        InstrOfferingConfig ioc = (InstrOfferingConfig)iocDao.get(Long.valueOf(instrOffrConfigId));
        frm.setInstrOffrConfigId(Long.valueOf(instrOffrConfigId));
        this.sessionContext.checkPermission(ioc, Right.AssignInstructors);
        ArrayList<DepartmentalInstructor> instructors = new ArrayList<DepartmentalInstructor>(ioc.getDepartment().getInstructors());
        Collections.sort(instructors, new DepartmentalInstructorComparator());
        request.setAttribute(DepartmentalInstructor.INSTR_LIST_ATTR_NAME, instructors);
        LookupTables.setupInstructorTeachingResponsibilities(request);
        if (op.equalsIgnoreCase(MSG.actionAssignInstructors())) {
            this.doLoad(request, frm, instrOffrConfigId, ioc);
        }
        if (op.equals(MSG.actionUpdateClassInstructorsAssignment()) || op.equals(MSG.actionNextIO()) || op.equals(MSG.actionPreviousIO()) || op.equals(MSG.actionUnassignAllInstructorsFromConfig())) {
            ActionErrors errors;
            if (op.equals(MSG.actionUnassignAllInstructorsFromConfig())) {
                frm.unassignAllInstructors();
            }
            if ((errors = frm.validate(mapping, request)).size() == 0) {
                frm.updateClasses();
                InstrOfferingConfig cfg = (InstrOfferingConfig)new InstrOfferingConfigDAO().get(frm.getInstrOffrConfigId());
                Session hibSession = InstructionalOfferingDAO.getInstance().getSession();
                ChangeLog.addChange(hibSession, this.sessionContext, cfg, ChangeLog.Source.CLASS_INSTR_ASSIGN, ChangeLog.Operation.UPDATE, cfg.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), null);
                if (this.permissionOfferingLockNeeded.check(this.sessionContext.getUser(), cfg.getInstructionalOffering())) {
                    StudentSectioningQueue.offeringChanged(hibSession, this.sessionContext.getUser(), cfg.getInstructionalOffering().getSessionId(), cfg.getInstructionalOffering().getUniqueId());
                }
                hibSession.flush();
                String className = ApplicationProperty.ExternalActionInstrOfferingConfigAssignInstructors.value();
                if (className != null && className.trim().length() > 0) {
                    ExternalInstrOfferingConfigAssignInstructorsAction assignAction = (ExternalInstrOfferingConfigAssignInstructorsAction)Class.forName(className).newInstance();
                    assignAction.performExternalInstrOfferingConfigAssignInstructorsAction(ioc, InstrOfferingConfigDAO.getInstance().getSession());
                }
                if (op.equals(MSG.actionNextIO())) {
                    response.sendRedirect(response.encodeURL("classInstructorAssignment.do?uid=" + frm.getNextId() + "&op=" + URLEncoder.encode(MSG.actionAssignInstructors(), "UTF-8")));
                    return null;
                }
                if (op.equals(MSG.actionPreviousIO())) {
                    response.sendRedirect(response.encodeURL("classInstructorAssignment.do?uid=" + frm.getPreviousId() + "&op=" + URLEncoder.encode(MSG.actionAssignInstructors(), "UTF-8")));
                    return null;
                }
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("instructionalOfferingDetail"));
                redirect.addParameter("io", (Object)frm.getInstrOfferingId());
                redirect.addParameter("op", (Object)"view");
                return redirect;
            }
            this.saveErrors(request, (ActionMessages)errors);
        }
        if (op.equals(rsc.getMessage("button.delete"))) {
            frm.deleteInstructor();
        }
        if (op.equals(rsc.getMessage("button.addInstructor"))) {
            frm.addInstructor();
        }
        return mapping.findForward("classInstructorAssignment");
    }

    private void doLoad(HttpServletRequest request, ClassInstructorAssignmentForm frm, String instrOffrConfigId, InstrOfferingConfig ioc) throws Exception {
        if (instrOffrConfigId == null || instrOffrConfigId.trim().length() == 0) {
            throw new Exception(MSG.exceptionMissingIOConfig());
        }
        InstructionalOffering io = ioc.getInstructionalOffering();
        frm.setInstrOffrConfigId(ioc.getUniqueId());
        frm.setInstrOffrConfigLimit(ioc.getLimit());
        frm.setInstrOfferingId(io.getUniqueId());
        frm.setDisplayExternalId(ApplicationProperty.ClassSetupShowExternalIds.isTrue());
        String name = io.getCourseNameWithTitle();
        if (io.hasMultipleConfigurations()) {
            name = name + " [" + ioc.getName() + "]";
        }
        frm.setInstrOfferingName(name);
        if (ioc.getSchedulingSubparts() == null || ioc.getSchedulingSubparts().size() == 0) {
            throw new Exception(MSG.exceptionIOConfigUndefined());
        }
        InstrOfferingConfig config = ioc.getNextInstrOfferingConfig(this.sessionContext);
        if (config != null) {
            frm.setNextId(config.getUniqueId().toString());
        } else {
            frm.setNextId(null);
        }
        config = ioc.getPreviousInstrOfferingConfig(this.sessionContext);
        if (config != null) {
            frm.setPreviousId(config.getUniqueId().toString());
        } else {
            frm.setPreviousId(null);
        }
        ArrayList<SchedulingSubpart> subpartList = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
        Collections.sort(subpartList, new SchedulingSubpartComparator());
        for (SchedulingSubpart ss : subpartList) {
            if (ss.getClasses() == null || ss.getClasses().size() == 0) {
                throw new Exception(MSG.exceptionInitialIOSetupIncomplete());
            }
            if (ss.getParentSubpart() != null) continue;
            this.loadClasses(frm, ss.getClasses(), new String());
        }
        String coordinators = "";
        String instructorNameFormat = this.sessionContext.getUser().getProperty(UserProperty.NameFormat);
        for (OfferingCoordinator coordinator : new TreeSet<OfferingCoordinator>(io.getOfferingCoordinators())) {
            if (!coordinators.isEmpty()) {
                coordinators = coordinators + "<br>";
            }
            coordinators = coordinators + "<a href='instructorDetail.do?instructorId=" + coordinator.getInstructor().getUniqueId() + "' class='noFancyLinks'>" + coordinator.getInstructor().getName(instructorNameFormat) + (coordinator.getResponsibility() == null ? (coordinator.getPercentShare() != 0 ? " (" + coordinator.getPercentShare() + "%)" : "") : " (" + coordinator.getResponsibility().getLabel() + (coordinator.getPercentShare() > 0 ? ", " + coordinator.getPercentShare() + "%" : "") + ")") + "</a>";
        }
        frm.setCoordinators(coordinators);
    }

    private void loadClasses(ClassInstructorAssignmentForm frm, Set classes, String indent) {
        if (classes != null && classes.size() > 0) {
            ArrayList classesList = new ArrayList(classes);
            if (CommonValues.Yes.eq(UserProperty.ClassesKeepSort.get(this.sessionContext.getUser()))) {
                Collections.sort(classesList, new ClassCourseComparator(this.sessionContext.getUser().getProperty("InstructionalOfferingList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)), frm.getProxy(), false));
            } else {
                Collections.sort(classesList, new ClassComparator(3));
            }
            Class_ cls = null;
            Iterator it = classesList.iterator();
            while (it.hasNext()) {
                frm.addToClasses(cls, !this.sessionContext.hasPermission(cls = (Class_)it.next(), Right.AssignInstructorsClass), indent);
                this.loadClasses(frm, cls.getChildClasses(), indent + "&nbsp;&nbsp;&nbsp;&nbsp;");
            }
        }
    }
}

