/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.util;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.spi.NamingManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.ConfigHelper;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.IntegerType;
import org.hibernate.type.Type;
import org.unitime.commons.LocalContext;
import org.unitime.commons.hibernate.connection.DisposableConnectionProvider;
import org.unitime.commons.hibernate.id.UniqueIdGenerator;
import org.unitime.commons.hibernate.util.DatabaseUpdate;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.base._BaseRootDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateUtil {
    private static Log sLog = LogFactory.getLog(HibernateUtil.class);
    private static SessionFactory sSessionFactory = null;
    private static String sConnectionUrl = null;

    private static void setProperty(Document document, String name, String value) {
        if (value == null) {
            HibernateUtil.removeProperty(document, name);
        } else {
            Element hibConfiguration = (Element)document.getElementsByTagName("hibernate-configuration").item(0);
            Element sessionFactoryConfig = (Element)hibConfiguration.getElementsByTagName("session-factory").item(0);
            NodeList properties = sessionFactoryConfig.getElementsByTagName("property");
            for (int i = 0; i < properties.getLength(); ++i) {
                Element property = (Element)properties.item(i);
                if (!name.equals(property.getAttribute("name"))) continue;
                Text text = (Text)property.getFirstChild();
                if (text == null) {
                    property.appendChild(document.createTextNode(value));
                } else {
                    text.setData(value);
                }
                return;
            }
            Element property = document.createElement("property");
            property.setAttribute("name", name);
            property.appendChild(document.createTextNode(value));
            sessionFactoryConfig.appendChild(property);
        }
    }

    private static void removeProperty(Document document, String name) {
        Element hibConfiguration = (Element)document.getElementsByTagName("hibernate-configuration").item(0);
        Element sessionFactoryConfig = (Element)hibConfiguration.getElementsByTagName("session-factory").item(0);
        NodeList properties = sessionFactoryConfig.getElementsByTagName("property");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element property = (Element)properties.item(i);
            if (!name.equals(property.getAttribute("name"))) continue;
            sessionFactoryConfig.removeChild(property);
            return;
        }
    }

    public static void configureHibernate(String connectionUrl) throws Exception {
        Properties properties = ApplicationProperties.getProperties();
        properties.setProperty("connection.url", connectionUrl);
        HibernateUtil.configureHibernate(properties);
    }

    public static String getProperty(Properties properties, String name) {
        String value = properties.getProperty(name);
        if (value != null) {
            sLog.debug((Object)("   -- " + name + "=" + value));
            return value;
        }
        sLog.debug((Object)("   -- using application properties for " + name));
        value = ApplicationProperties.getProperty(name);
        sLog.debug((Object)("     -- " + name + "=" + value));
        return value;
    }

    public static void fixSchemaInFormulas(Configuration cfg) {
        cfg.buildMappings();
        String schema = cfg.getProperty("default_schema");
        if (schema != null) {
            Iterator i = cfg.getClassMappings();
            while (i.hasNext()) {
                PersistentClass pc = (PersistentClass)i.next();
                Iterator j = pc.getPropertyIterator();
                while (j.hasNext()) {
                    Property p = (Property)j.next();
                    Iterator k = p.getColumnIterator();
                    while (k.hasNext()) {
                        Formula f;
                        Selectable c = (Selectable)k.next();
                        if (!(c instanceof Formula) || (f = (Formula)c).getFormula() == null || f.getFormula().indexOf("%SCHEMA%") < 0) continue;
                        f.setFormula(f.getFormula().replaceAll("%SCHEMA%", schema));
                        sLog.debug((Object)("Schema updated in " + pc.getClassName() + "." + p.getName() + " to " + f.getFormula()));
                    }
                }
            }
        }
    }

    public static void configureHibernate(Properties properties) throws Exception {
        String idgen;
        if (sSessionFactory != null) {
            sSessionFactory.close();
            sSessionFactory = null;
        }
        if (!NamingManager.hasInitialContextFactoryBuilder()) {
            NamingManager.setInitialContextFactoryBuilder(new LocalContext(null));
        }
        sLog.info((Object)("Connecting to " + HibernateUtil.getProperty(properties, "connection.url")));
        ClassLoader classLoader = HibernateUtil.class.getClassLoader();
        sLog.debug((Object)"  -- class loader retrieved");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        sLog.debug((Object)"  -- document factory created");
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                if (publicId.equals("-//Hibernate/Hibernate Mapping DTD 3.0//EN")) {
                    return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-mapping-3.0.dtd"));
                }
                if (publicId.equals("-//Hibernate/Hibernate Mapping DTD//EN")) {
                    return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-mapping-3.0.dtd"));
                }
                if (publicId.equals("-//Hibernate/Hibernate Configuration DTD 3.0//EN")) {
                    return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-configuration-3.0.dtd"));
                }
                if (publicId.equals("-//Hibernate/Hibernate Configuration DTD//EN")) {
                    return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-configuration-3.0.dtd"));
                }
                return null;
            }
        });
        sLog.debug((Object)"  -- document builder created");
        Document document = builder.parse(classLoader.getResource("hibernate.cfg.xml").openStream());
        sLog.debug((Object)"  -- hibernate.cfg.xml parsed");
        String dialect = HibernateUtil.getProperty(properties, "dialect");
        if (dialect != null) {
            HibernateUtil.setProperty(document, "dialect", dialect);
        }
        if ((idgen = HibernateUtil.getProperty(properties, "tmtbl.uniqueid.generator")) != null) {
            HibernateUtil.setProperty(document, "tmtbl.uniqueid.generator", idgen);
        }
        if (ApplicationProperty.HibernateClusterEnabled.isFalse()) {
            HibernateUtil.setProperty(document, "net.sf.ehcache.configurationResourceName", "ehcache-nocluster.xml");
        }
        HibernateUtil.setProperty(document, "hibernate.cache.use_second_level_cache", "false");
        HibernateUtil.setProperty(document, "hibernate.cache.use_query_cache", "false");
        HibernateUtil.removeProperty(document, "hibernate.cache.region.factory_class");
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("hibernate.") && !name.startsWith("connection.") && !name.startsWith("tmtbl.hibernate.")) continue;
            String value = properties.getProperty(name);
            if ("NULL".equals(value)) {
                HibernateUtil.removeProperty(document, name);
            } else {
                HibernateUtil.setProperty(document, name, value);
            }
            if (!name.equals("connection.password")) {
                sLog.debug((Object)("  -- set " + name + ": " + value));
                continue;
            }
            sLog.debug((Object)("  -- set " + name + ": *****"));
        }
        String default_schema = HibernateUtil.getProperty(properties, "default_schema");
        if (default_schema != null) {
            HibernateUtil.setProperty(document, "default_schema", default_schema);
        }
        sLog.debug((Object)"  -- hibernate.cfg.xml altered");
        Configuration cfg = new Configuration();
        sLog.debug((Object)"  -- configuration object created");
        cfg.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                if (publicId.equals("-//Hibernate/Hibernate Mapping DTD 3.0//EN")) {
                    return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-mapping-3.0.dtd"));
                }
                if (publicId.equals("-//Hibernate/Hibernate Mapping DTD//EN")) {
                    return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-mapping-3.0.dtd"));
                }
                if (publicId.equals("-//Hibernate/Hibernate Configuration DTD 3.0//EN")) {
                    return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-configuration-3.0.dtd"));
                }
                if (publicId.equals("-//Hibernate/Hibernate Configuration DTD//EN")) {
                    return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-configuration-3.0.dtd"));
                }
                return null;
            }
        });
        sLog.debug((Object)"  -- added entity resolver");
        cfg.configure(document);
        sLog.debug((Object)"  -- hibernate configured");
        HibernateUtil.fixSchemaInFormulas(cfg);
        UniqueIdGenerator.configure(cfg);
        new _BaseRootDAO(){

            void setConf(Configuration cfg) {
                _BaseRootDAO.sConfiguration = cfg;
            }

            protected Class getReferenceClass() {
                return null;
            }
        }.setConf(cfg);
        sLog.debug((Object)"  -- configuration set to _BaseRootDAO");
        sSessionFactory = cfg.buildSessionFactory();
        sLog.debug((Object)"  -- session factory created");
        new _BaseRootDAO(){

            void setSF(SessionFactory fact) {
                _BaseRootDAO.sSessionFactory = fact;
            }

            protected Class getReferenceClass() {
                return null;
            }
        }.setSF(sSessionFactory);
        sLog.debug((Object)"  -- session factory set to _BaseRootDAO");
        HibernateUtil.addBitwiseOperationsToDialect();
        sLog.debug((Object)"  -- bitwise operation added to the dialect if needed");
        DatabaseUpdate.update();
    }

    public static void closeHibernate() {
        if (sSessionFactory != null) {
            ConnectionProvider cp;
            if (sSessionFactory instanceof SessionFactoryImpl && (cp = ((SessionFactoryImpl)sSessionFactory).getConnectionProvider()) instanceof DisposableConnectionProvider) {
                try {
                    ((DisposableConnectionProvider)cp).destroy();
                }
                catch (Exception e) {
                    sLog.error((Object)("Failed to destroy connection provider: " + e.getMessage()));
                }
            }
            sSessionFactory.close();
            sSessionFactory = null;
        }
    }

    public static void configureHibernateFromRootDAO(String cfgName, Configuration cfg) {
        try {
            String idgen;
            String default_schema;
            EntityResolver entityResolver = new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    if (publicId.equals("-//Hibernate/Hibernate Mapping DTD 3.0//EN")) {
                        return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-mapping-3.0.dtd"));
                    }
                    if (publicId.equals("-//Hibernate/Hibernate Mapping DTD//EN")) {
                        return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-mapping-3.0.dtd"));
                    }
                    if (publicId.equals("-//Hibernate/Hibernate Configuration DTD 3.0//EN")) {
                        return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-configuration-3.0.dtd"));
                    }
                    if (publicId.equals("-//Hibernate/Hibernate Configuration DTD//EN")) {
                        return new InputSource(HibernateUtil.class.getClassLoader().getResourceAsStream("org/hibernate/hibernate-configuration-3.0.dtd"));
                    }
                    return null;
                }
            };
            cfg.setEntityResolver(entityResolver);
            sLog.debug((Object)"  -- added entity resolver");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            sLog.debug((Object)"  -- document factory created");
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(entityResolver);
            sLog.debug((Object)"  -- document builder created");
            Document document = builder.parse(ConfigHelper.getConfigStream((String)(cfgName == null ? "hibernate.cfg.xml" : cfgName)));
            String dialect = ApplicationProperty.DatabaseDialect.value();
            if (dialect != null) {
                HibernateUtil.setProperty(document, "dialect", dialect);
            }
            if ((default_schema = ApplicationProperty.DatabaseSchema.value()) != null) {
                HibernateUtil.setProperty(document, "default_schema", default_schema);
            }
            if ((idgen = ApplicationProperty.DatabaseUniqueIdGenerator.value()) != null) {
                HibernateUtil.setProperty(document, "tmtbl.uniqueid.generator", idgen);
            }
            if (ApplicationProperty.HibernateClusterEnabled.isFalse()) {
                HibernateUtil.setProperty(document, "net.sf.ehcache.configurationResourceName", "ehcache-nocluster.xml");
            }
            Enumeration<?> e = ApplicationProperties.getProperties().propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith("hibernate.") && !name.startsWith("connection.") && !name.startsWith("tmtbl.hibernate.")) continue;
                String value = ApplicationProperties.getProperty(name);
                if ("NULL".equals(value)) {
                    HibernateUtil.removeProperty(document, name);
                } else {
                    HibernateUtil.setProperty(document, name, value);
                }
                if (!name.equals("connection.password")) {
                    sLog.debug((Object)("  -- set " + name + ": " + value));
                    continue;
                }
                sLog.debug((Object)("  -- set " + name + ": *****"));
            }
            cfg.configure(document);
            sLog.debug((Object)"  -- hibernate configured");
            HibernateUtil.fixSchemaInFormulas(cfg);
            sLog.debug((Object)("  -- %SCHEMA% in formulas changed to " + cfg.getProperty("default_schema")));
            UniqueIdGenerator.configure(cfg);
            sLog.debug((Object)"  -- UniquId generator configured");
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to configure hibernate, reason: " + e.getMessage()), (Throwable)e);
        }
    }

    public static String getConnectionUrl() {
        if (sConnectionUrl == null) {
            try {
                SessionImplementor session = (SessionImplementor)new _RootDAO().getSession();
                Connection connection = session.getJdbcConnectionAccess().obtainConnection();
                sConnectionUrl = connection.getMetaData().getURL();
                session.getJdbcConnectionAccess().releaseConnection(connection);
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to get connection string, reason: " + e.getMessage()), (Throwable)e);
            }
        }
        return sConnectionUrl;
    }

    public static String getDatabaseName() {
        String schema = _RootDAO.getConfiguration().getProperty("default_schema");
        String url = HibernateUtil.getConnectionUrl();
        if (url == null) {
            return "N/A";
        }
        if (url.startsWith("jdbc:oracle:")) {
            return schema + "@" + url.substring(1 + url.lastIndexOf(58));
        }
        return schema;
    }

    public static void clearCache() {
        HibernateUtil.clearCache(null, true);
    }

    public static void clearCache(Class persistentClass) {
        HibernateUtil.clearCache(persistentClass, false);
    }

    public static void clearCache(Class persistentClass, boolean evictQueries) {
        _RootDAO dao = new _RootDAO();
        Session hibSession = dao.getSession();
        SessionFactory hibSessionFactory = hibSession.getSessionFactory();
        if (persistentClass == null) {
            for (Map.Entry entry : hibSessionFactory.getAllClassMetadata().entrySet()) {
                String className = (String)entry.getKey();
                ClassMetadata classMetadata = (ClassMetadata)entry.getValue();
                try {
                    hibSessionFactory.getCache().evictEntityRegion(Class.forName(className));
                    for (int j = 0; j < classMetadata.getPropertyNames().length; ++j) {
                        if (!classMetadata.getPropertyTypes()[j].isCollectionType()) continue;
                        try {
                            hibSessionFactory.getCache().evictCollectionRegion(className + "." + classMetadata.getPropertyNames()[j]);
                            continue;
                        }
                        catch (MappingException e) {
                            // empty catch block
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                }
            }
            hibSessionFactory.getCache().evictEntityRegions();
            hibSessionFactory.getCache().evictCollectionRegions();
        } else {
            ClassMetadata classMetadata = hibSessionFactory.getClassMetadata(persistentClass);
            hibSessionFactory.getCache().evictEntityRegion(persistentClass);
            if (classMetadata != null) {
                for (int j = 0; j < classMetadata.getPropertyNames().length; ++j) {
                    if (!classMetadata.getPropertyTypes()[j].isCollectionType()) continue;
                    try {
                        hibSessionFactory.getCache().evictCollectionRegion(persistentClass.getClass().getName() + "." + classMetadata.getPropertyNames()[j]);
                        continue;
                    }
                    catch (MappingException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (evictQueries) {
            hibSessionFactory.getCache().evictQueryRegions();
            hibSessionFactory.getCache().evictDefaultQueryRegion();
        }
    }

    public static Class<?> getDialect() {
        try {
            return Class.forName(_RootDAO.getConfiguration().getProperty("dialect"));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean isMySQL() {
        return MySQLDialect.class.isAssignableFrom(HibernateUtil.getDialect());
    }

    public static boolean isOracle() {
        return Oracle8iDialect.class.isAssignableFrom(HibernateUtil.getDialect());
    }

    public static String addDate(String dateSQL, String incrementSQL) {
        if (HibernateUtil.isMySQL()) {
            return "adddate(" + dateSQL + "," + incrementSQL + ")";
        }
        return dateSQL + (incrementSQL.startsWith("+") || incrementSQL.startsWith("-") ? "" : "+") + incrementSQL;
    }

    public static String dayOfWeek(String field) {
        if (HibernateUtil.isOracle()) {
            return "(trunc(" + field + ") - trunc(" + field + ", 'IW'))";
        }
        return "weekday(" + field + ")";
    }

    public static String date(Date date) {
        if (HibernateUtil.isOracle()) {
            return "to_date('" + new SimpleDateFormat("yyyy-MM-dd").format(date) + "', 'YYYY-MM-DD')";
        }
        return "str_to_date('" + new SimpleDateFormat("yyyy-MM-dd").format(date) + "', '%Y-%m-%d')";
    }

    public static void addBitwiseOperationsToDialect() {
        SessionFactoryImplementor hibSessionFactory = (SessionFactoryImplementor)new _RootDAO().getSession().getSessionFactory();
        Dialect dialect = hibSessionFactory.getDialect();
        if (!dialect.getFunctions().containsKey("bit_and")) {
            if (HibernateUtil.isOracle()) {
                dialect.getFunctions().put("bit_and", new StandardSQLFunction("bitand", (Type)IntegerType.INSTANCE));
            } else {
                dialect.getFunctions().put("bit_and", new SQLFunctionTemplate((Type)IntegerType.INSTANCE, "?1 & ?2"));
            }
        }
    }
}

