/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.csv;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.util.CSVFile;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructionalOfferingListForm;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SectioningInfo;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.RequiredTimeTable;
import org.unitime.timetable.webutil.WebInstructionalOfferingTableBuilder;

public class CsvInstructionalOfferingTableBuilder
extends WebInstructionalOfferingTableBuilder {
    protected CSVFile iFile = null;
    protected static String indent = "    ";
    protected static String TEXT_SEPARATOR = " ";
    protected static String LINE_SEPARATOR = "\n";

    protected String escape(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("\"", "\"\"");
    }

    public CSVFile.CSVField createCell(String text) {
        return new CSVFile.CSVField((Object)this.escape(text));
    }

    public CSVFile.CSVField createCell() {
        return this.createCell(null);
    }

    public void addText(CSVFile.CSVField cell, String text, boolean newLine) {
        cell.set((Object)(cell.toString().isEmpty() ? this.escape(text) : cell.toString() + (newLine ? LINE_SEPARATOR : TEXT_SEPARATOR) + this.escape(text)));
    }

    public void addText(CSVFile.CSVField cell, String text) {
        this.addText(cell, text, false);
    }

    public void setText(CSVFile.CSVField cell, String text) {
        cell.set((Object)this.escape(text));
    }

    public int getNrColumns() {
        int ret = 0;
        if (this.isShowLabel()) {
            ++ret;
        }
        if (this.isShowDivSec()) {
            ++ret;
        }
        if (this.isShowDemand()) {
            ++ret;
        }
        if (this.isShowProjectedDemand()) {
            ++ret;
        }
        if (this.isShowLimit()) {
            ++ret;
        }
        if (this.isShowRoomRatio()) {
            ++ret;
        }
        if (this.isShowManager()) {
            ++ret;
        }
        if (this.isShowDatePattern()) {
            ++ret;
        }
        if (this.isShowMinPerWk()) {
            ++ret;
        }
        if (this.isShowTimePattern()) {
            ++ret;
        }
        if (this.isShowPreferences()) {
            ret += this.PREFERENCE_COLUMN_ORDER.length + (this.getDisplayDistributionPrefs() ? 0 : -1);
        }
        if (this.isShowInstructor()) {
            ++ret;
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            ret += this.TIMETABLE_COLUMN_ORDER.length;
        }
        if (this.isShowTitle()) {
            ++ret;
        }
        if (this.isShowCredit()) {
            ++ret;
        }
        if (this.isShowSubpartCredit()) {
            ++ret;
        }
        if (this.isShowConsent()) {
            ++ret;
        }
        if (this.isShowSchedulePrintNote()) {
            ++ret;
        }
        if (this.isShowNote()) {
            ++ret;
        }
        if (this.isShowExam()) {
            if (this.isShowExamName()) {
                ++ret;
            }
            if (this.isShowExamTimetable()) {
                ret += 2;
            }
        }
        return ret;
    }

    protected void csvBuildTableHeader(Long sessionId) {
        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
        if (this.isShowLabel()) {
            line.add(this.createCell(MSG.columnName()));
        }
        if (this.isShowDivSec()) {
            line.add(this.createCell(MSG.columnExternalId()));
        }
        if (this.isShowDemand()) {
            if (StudentClassEnrollment.sessionHasEnrollments(sessionId)) {
                line.add(this.createCell(MSG.columnDemand()));
            } else {
                line.add(this.createCell(MSG.columnLastDemand()));
            }
        }
        if (this.isShowProjectedDemand()) {
            line.add(this.createCell(MSG.columnProjectedDemand()));
        }
        if (this.isShowLimit()) {
            line.add(this.createCell(MSG.columnLimit()));
        }
        if (this.isShowRoomRatio()) {
            line.add(this.createCell(MSG.columnRoomRatio()));
        }
        if (this.isShowManager()) {
            line.add(this.createCell(MSG.columnManager()));
        }
        if (this.isShowDatePattern()) {
            line.add(this.createCell(MSG.columnDatePattern()));
        }
        if (this.isShowMinPerWk()) {
            CSVFile.CSVField c = this.createCell();
            ClassDurationType dtype = ClassDurationType.findDefaultType(sessionId, null);
            this.setText(c, dtype == null ? MSG.columnMinPerWk() : dtype.getLabel());
            line.add(c);
        }
        if (this.isShowTimePattern()) {
            line.add(this.createCell(MSG.columnTimePattern()));
        }
        if (this.isShowPreferences()) {
            for (int j = 0; j < this.PREFERENCE_COLUMN_ORDER.length + (this.getDisplayDistributionPrefs() ? 0 : -1); ++j) {
                line.add(this.createCell(this.PREFERENCE_COLUMN_ORDER[j] + LINE_SEPARATOR + MSG.columnPreferences()));
            }
        }
        if (this.isShowInstructor()) {
            line.add(this.createCell(MSG.columnInstructor()));
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            for (int j = 0; j < this.TIMETABLE_COLUMN_ORDER.length; ++j) {
                line.add(this.createCell(this.TIMETABLE_COLUMN_ORDER[j]));
            }
        }
        if (this.isShowTitle()) {
            line.add(this.createCell(MSG.columnTitle()));
        }
        if (this.isShowCredit()) {
            line.add(this.createCell(MSG.columnOfferingCredit()));
        }
        if (this.isShowSubpartCredit()) {
            line.add(this.createCell(MSG.columnSubpartCredit()));
        }
        if (this.isShowConsent()) {
            line.add(this.createCell(MSG.columnConsent()));
        }
        if (this.isShowSchedulePrintNote()) {
            line.add(this.createCell(MSG.columnSchedulePrintNote()));
        }
        if (this.isShowNote()) {
            line.add(this.createCell(MSG.columnNote()));
        }
        if (this.isShowExam()) {
            if (this.isShowExamName()) {
                line.add(this.createCell(MSG.columnExam() + LINE_SEPARATOR + MSG.columnExamName()));
            }
            if (this.isShowExamTimetable()) {
                line.add(this.createCell(MSG.columnExamPeriod()));
                line.add(this.createCell(MSG.columnExamRoom()));
            }
        }
        if (this.iFile.getHeader() == null && this.iFile.getLines() == null) {
            this.iFile.setHeader(line);
        } else {
            this.iFile.addLine(line);
        }
    }

    private CSVFile.CSVField csvSubjectAndCourseInfo(InstructionalOffering io, CourseOffering co) {
        InstructionalMethod im;
        CSVFile.CSVField cell = this.createCell(co != null ? co.getSubjectAreaAbbv() + " " + co.getCourseNbr() : "");
        InstructionalMethod instructionalMethod = im = co != null && co.getInstructionalOffering().getInstrOfferingConfigs().size() == 1 ? co.getInstructionalOffering().getInstrOfferingConfigs().iterator().next().getInstructionalMethod() : null;
        if (!co.isIsControl().booleanValue()) {
            String managedAs = MSG.crossListManagedAs(io.getControllingCourseOffering().getCourseName());
            if (im != null) {
                if (co.getCourseType() != null) {
                    this.addText(cell, " (" + managedAs + ", " + co.getCourseType().getReference() + ", " + im.getReference() + ")", false);
                } else {
                    this.addText(cell, " (" + managedAs + ", " + im.getReference() + ")", false);
                }
            } else if (co.getCourseType() != null) {
                this.addText(cell, " (" + managedAs + ", " + co.getCourseType().getReference() + ")", false);
            } else {
                this.addText(cell, " (" + managedAs + ")", false);
            }
        } else if (im != null) {
            if (co.getCourseType() != null) {
                this.addText(cell, " (" + co.getCourseType().getReference() + ", " + im.getReference() + ")", false);
            } else {
                this.addText(cell, " (" + im.getReference() + ")", false);
            }
        } else if (co.getCourseType() != null) {
            this.addText(cell, " (" + co.getCourseType().getReference() + ")", false);
        }
        for (CourseOffering tempCo : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
            this.addText(cell, indent + tempCo.getSubjectAreaAbbv() + " " + tempCo.getCourseNbr() + " " + (tempCo.getCourseType() != null ? " (" + tempCo.getCourseType().getReference() + ")" : ""), true);
        }
        return cell;
    }

    protected CSVFile.CSVField csvBuildPrefGroupLabel(CourseOffering co, PreferenceGroup prefGroup, String indentSpaces, boolean isEditable, String prevLabel) {
        String label = prefGroup.toString();
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            label = aClass.getClassLabel(co);
            if (aClass.isCancelled().booleanValue()) {
                label = label + " (" + MSG.statusCancelled() + ")";
            }
        }
        if (prevLabel != null && label.equals(prevLabel)) {
            label = "";
        }
        return this.createCell(indentSpaces + label);
    }

    protected CSVFile.CSVField csvBuildDatePatternCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Assignment a = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        DatePattern dp = a != null ? a.getDatePattern() : prefGroup.effectiveDatePattern();
        CSVFile.CSVField cell = this.createCell();
        if (dp != null) {
            this.setText(cell, dp.getName());
            if (dp.getType() == 4 && isEditable) {
                boolean hasReq = false;
                for (Preference pref : prefGroup.effectivePreferences(DatePatternPref.class)) {
                    if (!PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog())) continue;
                    hasReq = true;
                    break;
                }
                for (Preference pref : prefGroup.effectivePreferences(DatePatternPref.class)) {
                    if (hasReq && !PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog())) continue;
                    this.addText(cell, pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText(), true);
                }
            }
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildTimePatternCell(PreferenceGroup prefGroup, boolean isEditable) {
        CSVFile.CSVField cell = this.createCell();
        for (TimePattern tp : prefGroup.effectiveTimePatterns()) {
            this.addText(cell, tp.getName(), true);
        }
        if (prefGroup instanceof Class_ && prefGroup.effectiveTimePatterns().isEmpty()) {
            Class_ clazz = (Class_)prefGroup;
            DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            Integer ah = dm.getArrangedHours(clazz.getSchedulingSubpart().getMinutesPerWk(), clazz.effectiveDatePattern());
            if (ah == null) {
                this.addText(cell, "Arr Hrs", true);
            } else {
                this.addText(cell, "Arr " + ah + " Hrs", true);
            }
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildTimePrefCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Assignment a = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        CSVFile.CSVField cell = this.createCell();
        for (TimePref tp : prefGroup.effectivePreferences(TimePref.class)) {
            RequiredTimeTable rtt = tp.getRequiredTimeTable(a == null ? null : a.getTimeLocation());
            this.addText(cell, rtt.getModel().toString().replaceAll(", ", LINE_SEPARATOR), true);
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildPreferenceCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, Class prefType, boolean isEditable) {
        if (!isEditable) {
            return this.createCell();
        }
        if (TimePref.class.equals((Object)prefType)) {
            return this.csvBuildTimePrefCell(classAssignment, prefGroup, isEditable);
        }
        if (DistributionPref.class.equals((Object)prefType)) {
            CSVFile.CSVField cell = this.createCell();
            for (DistributionPref pref : prefGroup.effectivePreferences(prefType)) {
                this.addText(cell, pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText(true, true, " (", ", ", ")").replaceAll("&lt;", "<").replaceAll("&gt;", ">"), true);
            }
            return cell;
        }
        CSVFile.CSVField cell = this.createCell();
        for (Preference pref : prefGroup.effectivePreferences(prefType)) {
            this.addText(cell, pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText(), true);
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildPreferenceCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, Class[] prefTypes, boolean isEditable) {
        if (!isEditable) {
            return this.createCell();
        }
        CSVFile.CSVField cell = this.createCell();
        boolean noRoomPrefs = false;
        if (prefGroup instanceof Class_ && ((Class_)prefGroup).getNbrRooms() == 0) {
            noRoomPrefs = true;
        }
        if (prefGroup instanceof SchedulingSubpart && ((SchedulingSubpart)prefGroup).getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            noRoomPrefs = true;
        }
        for (int i = 0; i < prefTypes.length; ++i) {
            Class prefType = prefTypes[i];
            if (noRoomPrefs && (prefType.equals(RoomGroupPref.class) || prefType.equals(RoomFeaturePref.class) || prefType.equals(BuildingPref.class))) continue;
            for (Preference pref : prefGroup.effectivePreferences(prefType)) {
                this.addText(cell, pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText(), true);
            }
        }
        if (noRoomPrefs && cell.toString().isEmpty()) {
            this.addText(cell, "N/A", true);
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildPrefGroupDemand(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ c;
        if (prefGroup instanceof Class_ && StudentClassEnrollment.sessionHasEnrollments((c = (Class_)prefGroup).getSessionId())) {
            CSVFile.CSVField tc = this.createCell();
            if (c.getEnrollment() != null) {
                this.addText(tc, c.getEnrollment().toString());
            } else {
                this.addText(tc, "0");
            }
            return tc;
        }
        return this.createCell();
    }

    private CSVFile.CSVField csvBuildPrefGroupProjectedDemand(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ c;
        SectioningInfo i;
        CSVFile.CSVField cell = this.createCell();
        if (prefGroup instanceof Class_ && (i = (c = (Class_)prefGroup).getSectioningInfo()) != null && i.getNbrExpectedStudents() != null) {
            this.addText(cell, String.valueOf(Math.round(Math.max(0.0, (double)c.getEnrollment().intValue() + i.getNbrExpectedStudents()))));
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildLimit(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Class_ aClass;
        boolean unlimited;
        CSVFile.CSVField cell = this.createCell();
        if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart ss = (SchedulingSubpart)prefGroup;
            boolean unlimited2 = ss.getInstrOfferingConfig().isUnlimitedEnrollment();
            if (!unlimited2) {
                int maxExpCap;
                int limit = ss.getLimit() == null ? 0 : ss.getLimit();
                if (limit == (maxExpCap = ss.getMaxExpectedCapacity())) {
                    this.addText(cell, String.valueOf(limit), true);
                } else {
                    this.addText(cell, limit + "-" + maxExpCap, true);
                }
            }
        } else if (prefGroup instanceof Class_ && !(unlimited = (aClass = (Class_)prefGroup).getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue())) {
            String limitString = null;
            Assignment a = null;
            try {
                if (classAssignment != null) {
                    a = classAssignment.getAssignment(aClass);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (a == null) {
                if (aClass.getExpectedCapacity() != null) {
                    limitString = aClass.getExpectedCapacity().toString();
                    if (aClass.getMaxExpectedCapacity() != null && !aClass.getMaxExpectedCapacity().equals(aClass.getExpectedCapacity())) {
                        limitString = limitString + "-" + aClass.getMaxExpectedCapacity().toString();
                    }
                } else {
                    limitString = "0";
                    if (aClass.getMaxExpectedCapacity() != null && aClass.getMaxExpectedCapacity() != 0) {
                        limitString = limitString + "-" + aClass.getMaxExpectedCapacity().toString();
                    }
                }
            } else {
                limitString = "" + aClass.getClassLimit(classAssignment);
            }
            this.addText(cell, limitString, true);
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildDivisionSection(CourseOffering co, PreferenceGroup prefGroup, boolean isEditable) {
        Class_ aClass;
        String divSec;
        CSVFile.CSVField cell = this.createCell();
        if (prefGroup instanceof Class_ && (divSec = (aClass = (Class_)prefGroup).getClassSuffix(co)) != null) {
            this.addText(cell, divSec, true);
        }
        return cell;
    }

    protected CSVFile.CSVField csvBuildInstructor(PreferenceGroup prefGroup, boolean isEditable) {
        CSVFile.CSVField cell = this.createCell();
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            TreeSet<ClassInstructor> sortedInstructors = new TreeSet<ClassInstructor>(new InstructorComparator());
            sortedInstructors.addAll(aClass.getClassInstructors());
            for (ClassInstructor ci : sortedInstructors) {
                String label = ci.getInstructor().getName(this.getInstructorNameFormat());
                this.addText(cell, label, true);
            }
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildCredit(PreferenceGroup prefGroup, boolean isEditable) {
        SchedulingSubpart ss;
        CSVFile.CSVField cell = this.createCell();
        if (prefGroup instanceof SchedulingSubpart && (ss = (SchedulingSubpart)prefGroup).getCredit() != null) {
            this.addText(cell, ss.getCredit().creditAbbv(), true);
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildSchedulePrintNote(PreferenceGroup prefGroup, boolean isEditable, UserContext user) {
        Class_ c;
        CSVFile.CSVField cell = this.createCell();
        if (prefGroup instanceof Class_ && (c = (Class_)prefGroup).getSchedulePrintNote() != null) {
            this.addText(cell, c.getSchedulePrintNote(), true);
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildSchedulePrintNote(InstructionalOffering io, boolean isEditable, UserContext user) {
        CSVFile.CSVField cell = this.createCell();
        StringBuffer note = new StringBuffer("");
        Set<CourseOffering> s = io.getCourseOfferings();
        for (CourseOffering coI : s) {
            if (coI.getScheduleBookNote() == null || coI.getScheduleBookNote().trim().length() <= 0) continue;
            if (note.length() > 0) {
                note.append("\n");
            }
            note.append(coI.getScheduleBookNote());
        }
        this.addText(cell, note.toString(), true);
        return cell;
    }

    private CSVFile.CSVField csvBuildNote(PreferenceGroup prefGroup, boolean isEditable, UserContext user) {
        Class_ c;
        CSVFile.CSVField cell = this.createCell();
        if (prefGroup instanceof Class_ && (c = (Class_)prefGroup).getNotes() != null) {
            if (c.getNotes().length() <= 30 || user == null || CommonValues.NoteAsFullText.eq(user.getProperty(UserProperty.ManagerNoteDisplay))) {
                this.addText(cell, c.getNotes(), true);
            } else {
                this.addText(cell, c.getNotes().substring(0, 30) + "...", true);
            }
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildManager(PreferenceGroup prefGroup, boolean isEditable) {
        CSVFile.CSVField cell = this.createCell();
        Department managingDept = null;
        if (prefGroup instanceof Class_) {
            managingDept = ((Class_)prefGroup).getManagingDept();
        } else if (prefGroup instanceof SchedulingSubpart) {
            managingDept = ((SchedulingSubpart)prefGroup).getManagingDept();
        }
        if (managingDept != null) {
            this.addText(cell, managingDept.getShortLabel(), true);
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildMinPerWeek(PreferenceGroup prefGroup, boolean isEditable) {
        CSVFile.CSVField cell = this.createCell();
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            String suffix = "";
            ClassDurationType dtype = aClass.getSchedulingSubpart().getInstrOfferingConfig().getEffectiveDurationType();
            if (dtype != null && !dtype.equals(aClass.getSchedulingSubpart().getSession().getDefaultClassDurationType())) {
                suffix = " " + dtype.getAbbreviation();
            }
            this.addText(cell, aClass.getSchedulingSubpart().getMinutesPerWk() + suffix, true);
        } else if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart aSchedulingSubpart = (SchedulingSubpart)prefGroup;
            String suffix = "";
            ClassDurationType dtype = aSchedulingSubpart.getInstrOfferingConfig().getEffectiveDurationType();
            if (dtype != null && !dtype.equals(aSchedulingSubpart.getSession().getDefaultClassDurationType())) {
                suffix = " " + dtype.getAbbreviation();
            }
            this.addText(cell, aSchedulingSubpart.getMinutesPerWk() + suffix, true);
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildRoomLimit(PreferenceGroup prefGroup, boolean isEditable, boolean classLimitDisplayed) {
        CSVFile.CSVField cell = this.createCell();
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            if (aClass.getNbrRooms() != null && aClass.getNbrRooms() != 1) {
                if (aClass.getNbrRooms() == 0) {
                    this.addText(cell, "N/A", true);
                } else {
                    String text = aClass.getNbrRooms().toString();
                    text = text + " at ";
                    text = aClass.getRoomRatio() != null ? text + sRoomRatioFormat.format(aClass.getRoomRatio().floatValue()) : text + "0";
                    this.addText(cell, text, true);
                }
            } else if (aClass.getRoomRatio() != null) {
                if (classLimitDisplayed && aClass.getRoomRatio().equals(new Float(1.0))) {
                    this.addText(cell, "", true);
                } else {
                    this.addText(cell, sRoomRatioFormat.format(aClass.getRoomRatio().floatValue()), true);
                }
            } else if (aClass.getExpectedCapacity() == null) {
                this.addText(cell, "", true);
            } else {
                this.addText(cell, "0", true);
            }
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildAssignedTime(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        CSVFile.CSVField cell = this.createCell();
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            Assignment a = null;
            try {
                a = classAssignment.getAssignment(aClass);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                StringBuffer sb = new StringBuffer();
                TimeLocation.IntEnumeration e = a.getTimeLocation().getDays();
                while (e.hasMoreElements()) {
                    sb.append(CONSTANTS.shortDays()[(Integer)e.nextElement()]);
                }
                sb.append(" ");
                sb.append(a.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm()));
                sb.append("-");
                sb.append(a.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm()));
                this.addText(cell, sb.toString(), true);
            }
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildAssignedRoom(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        CSVFile.CSVField cell = this.createCell();
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            Assignment a = null;
            try {
                a = classAssignment.getAssignment(aClass);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                StringBuffer sb = new StringBuffer();
                Iterator<Location> it2 = a.getRooms().iterator();
                while (it2.hasNext()) {
                    Location room = it2.next();
                    sb.append(room.getLabel());
                    if (!it2.hasNext()) continue;
                    sb.append("\n");
                }
                this.addText(cell, sb.toString(), true);
            }
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildAssignedRoomCapacity(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        CSVFile.CSVField cell = this.createCell();
        if (classAssignment != null && prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            Assignment a = null;
            try {
                a = classAssignment.getAssignment(aClass);
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (a != null) {
                StringBuffer sb = new StringBuffer();
                Iterator<Location> it2 = a.getRooms().iterator();
                while (it2.hasNext()) {
                    sb.append(it2.next().getCapacity());
                    if (!it2.hasNext()) continue;
                    sb.append("\n");
                }
                this.addText(cell, sb.toString(), true);
            }
        }
        return cell;
    }

    private CSVFile.CSVField csvBuildExamName(TreeSet exams, boolean isEditable) {
        StringBuffer sb = new StringBuffer();
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            Exam exam = (Exam)i.next();
            sb.append(exam.getLabel());
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        CSVFile.CSVField cell = this.createCell();
        this.addText(cell, sb.toString(), true);
        return cell;
    }

    private CSVFile.CSVField csvBuildExamPeriod(ExamAssignmentProxy examAssignment, TreeSet exams, boolean isEditable) {
        StringBuffer sb = new StringBuffer();
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            Exam exam = (Exam)i.next();
            if (examAssignment != null && examAssignment.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
                ExamAssignment ea = examAssignment.getAssignment(exam.getUniqueId());
                if (ea == null && !this.isShowExamName()) continue;
                sb.append(ea == null ? "" : ea.getPeriodAbbreviation());
            } else {
                if (exam.getAssignedPeriod() == null && !this.isShowExamName()) continue;
                sb.append(exam.getAssignedPeriod() == null ? "" : exam.getAssignedPeriod().getAbbreviation());
            }
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        CSVFile.CSVField cell = this.createCell();
        this.addText(cell, sb.toString(), true);
        return cell;
    }

    private CSVFile.CSVField csvBuildExamRoom(ExamAssignmentProxy examAssignment, TreeSet exams, boolean isEditable) {
        StringBuffer sb = new StringBuffer();
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            Exam exam = (Exam)i.next();
            if (examAssignment != null && examAssignment.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
                ExamAssignment ea = examAssignment.getAssignment(exam.getUniqueId());
                if (ea == null && !this.isShowExamName()) continue;
                sb.append(ea == null ? "" : ea.getRoomsName(", "));
            } else {
                if (exam.getAssignedPeriod() == null && !this.isShowExamName()) continue;
                Iterator<Location> j = new TreeSet<Location>(exam.getAssignedRooms()).iterator();
                while (j.hasNext()) {
                    Location location = j.next();
                    sb.append(location.getLabel());
                    if (!j.hasNext()) continue;
                    sb.append(", ");
                }
            }
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        CSVFile.CSVField cell = this.createCell();
        this.addText(cell, sb.toString(), true);
        return cell;
    }

    protected void csvBuildClassOrSubpartRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, CourseOffering co, PreferenceGroup prefGroup, String indentSpaces, boolean isEditable, String prevLabel, SessionContext context) {
        int j;
        boolean classLimitDisplayed = false;
        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
        if (this.isShowLabel()) {
            line.add(this.csvBuildPrefGroupLabel(co, prefGroup, indentSpaces, isEditable, prevLabel));
        }
        if (this.isShowDivSec()) {
            line.add(this.csvBuildDivisionSection(co, prefGroup, isEditable));
        }
        if (this.isShowDemand()) {
            line.add(this.csvBuildPrefGroupDemand(prefGroup, isEditable));
        }
        if (this.isShowProjectedDemand()) {
            line.add(this.csvBuildPrefGroupProjectedDemand(prefGroup, isEditable));
        }
        if (this.isShowLimit()) {
            classLimitDisplayed = true;
            line.add(this.csvBuildLimit(classAssignment, prefGroup, isEditable));
        }
        if (this.isShowRoomRatio()) {
            line.add(this.csvBuildRoomLimit(prefGroup, isEditable, classLimitDisplayed));
        }
        if (this.isShowManager()) {
            line.add(this.csvBuildManager(prefGroup, isEditable));
        }
        if (this.isShowDatePattern()) {
            line.add(this.csvBuildDatePatternCell(classAssignment, prefGroup, isEditable));
        }
        if (this.isShowMinPerWk()) {
            line.add(this.csvBuildMinPerWeek(prefGroup, isEditable));
        }
        if (this.isShowTimePattern()) {
            line.add(this.csvBuildTimePatternCell(prefGroup, isEditable));
        }
        if (this.isShowPreferences()) {
            for (j = 0; j < this.PREFERENCE_COLUMN_ORDER.length; ++j) {
                if (this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnTimePref())) {
                    line.add(this.csvBuildPreferenceCell(classAssignment, prefGroup, TimePref.class, isEditable));
                    continue;
                }
                if (sAggregateRoomPrefs && this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnAllRoomPref())) {
                    line.add(this.csvBuildPreferenceCell(classAssignment, prefGroup, new Class[]{RoomPref.class, BuildingPref.class, RoomFeaturePref.class, RoomGroupPref.class}, isEditable));
                    continue;
                }
                if (this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnRoomPref())) {
                    line.add(this.csvBuildPreferenceCell(classAssignment, prefGroup, RoomPref.class, isEditable));
                    continue;
                }
                if (this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnBuildingPref())) {
                    line.add(this.csvBuildPreferenceCell(classAssignment, prefGroup, BuildingPref.class, isEditable));
                    continue;
                }
                if (this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnRoomFeaturePref())) {
                    line.add(this.csvBuildPreferenceCell(classAssignment, prefGroup, RoomFeaturePref.class, isEditable));
                    continue;
                }
                if (this.getDisplayDistributionPrefs() && this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnDistributionPref())) {
                    line.add(this.csvBuildPreferenceCell(classAssignment, prefGroup, DistributionPref.class, isEditable));
                    continue;
                }
                if (!this.PREFERENCE_COLUMN_ORDER[j].equals(MSG.columnRoomGroupPref())) continue;
                line.add(this.csvBuildPreferenceCell(classAssignment, prefGroup, RoomGroupPref.class, isEditable));
            }
        }
        if (this.isShowInstructor()) {
            line.add(this.csvBuildInstructor(prefGroup, isEditable));
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            for (j = 0; j < this.TIMETABLE_COLUMN_ORDER.length; ++j) {
                if (this.TIMETABLE_COLUMN_ORDER[j].equals(MSG.columnAssignedTime())) {
                    line.add(this.csvBuildAssignedTime(classAssignment, prefGroup, isEditable));
                    continue;
                }
                if (this.TIMETABLE_COLUMN_ORDER[j].equals(MSG.columnAssignedRoom())) {
                    line.add(this.csvBuildAssignedRoom(classAssignment, prefGroup, isEditable));
                    continue;
                }
                if (!this.TIMETABLE_COLUMN_ORDER[j].equals(MSG.columnAssignedRoomCapacity())) continue;
                line.add(this.csvBuildAssignedRoomCapacity(classAssignment, prefGroup, isEditable));
            }
        }
        if (this.isShowTitle()) {
            line.add(this.createCell());
        }
        if (this.isShowCredit()) {
            line.add(this.createCell());
        }
        if (this.isShowSubpartCredit()) {
            line.add(this.csvBuildCredit(prefGroup, isEditable));
        }
        if (this.isShowConsent()) {
            line.add(this.createCell());
        }
        if (this.isShowSchedulePrintNote()) {
            line.add(this.csvBuildSchedulePrintNote(prefGroup, isEditable, context.getUser()));
        }
        if (this.isShowNote()) {
            line.add(this.csvBuildNote(prefGroup, isEditable, context.getUser()));
        }
        if (this.isShowExam()) {
            TreeSet exams = new TreeSet();
            if (prefGroup instanceof Class_) {
                exams = this.getExams((Class_)prefGroup);
            }
            Iterator i = exams.iterator();
            while (i.hasNext()) {
                if (context.hasPermission(i.next(), Right.ExaminationView)) continue;
                i.remove();
            }
            if (this.isShowExamName()) {
                line.add(this.csvBuildExamName(exams, isEditable));
            }
            if (this.isShowExamTimetable()) {
                line.add(this.csvBuildExamPeriod(examAssignment, exams, isEditable));
                line.add(this.csvBuildExamRoom(examAssignment, exams, isEditable));
            }
        }
        this.iFile.addLine(line);
    }

    private void csvBuildSchedulingSubpartRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, CourseOffering co, SchedulingSubpart ss, String indentSpaces, SessionContext context) {
        boolean isEditable = context.hasPermission(ss, Right.SchedulingSubpartDetail);
        this.csvBuildClassOrSubpartRow(classAssignment, examAssignment, co, ss, indentSpaces, isEditable, null, context);
    }

    private void csvBuildSchedulingSubpartRows(Vector subpartIds, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, CourseOffering co, SchedulingSubpart ss, String indentSpaces, SessionContext context) {
        if (subpartIds != null) {
            subpartIds.add(ss.getUniqueId());
        }
        this.csvBuildSchedulingSubpartRow(classAssignment, examAssignment, co, ss, indentSpaces, context);
        Set<SchedulingSubpart> childSubparts = ss.getChildSubparts();
        if (childSubparts != null && !childSubparts.isEmpty()) {
            ArrayList<SchedulingSubpart> childSubpartList = new ArrayList<SchedulingSubpart>(childSubparts);
            Collections.sort(childSubpartList, new SchedulingSubpartComparator());
            Iterator<SchedulingSubpart> it = childSubpartList.iterator();
            SchedulingSubpart child = null;
            while (it.hasNext()) {
                child = it.next();
                this.csvBuildSchedulingSubpartRows(subpartIds, classAssignment, examAssignment, co, child, indentSpaces + indent, context);
            }
        }
    }

    protected void csvBuildClassRow(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, int ct, CourseOffering co, Class_ aClass, String indentSpaces, SessionContext context, String prevLabel) {
        boolean isEditable = context.hasPermission(aClass, Right.ClassDetail);
        this.csvBuildClassOrSubpartRow(classAssignment, examAssignment, co, aClass, indentSpaces, isEditable && aClass.isCancelled() == false, prevLabel, context);
    }

    private void csvBuildClassRows(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, int ct, CourseOffering co, Class_ aClass, String indentSpaces, SessionContext context, String prevLabel) {
        this.csvBuildClassRow(classAssignment, examAssignment, ct, co, aClass, indentSpaces, context, prevLabel);
        Set<Class_> childClasses = aClass.getChildClasses();
        if (childClasses != null && !childClasses.isEmpty()) {
            ArrayList<Class_> childClassesList = new ArrayList<Class_>(childClasses);
            Collections.sort(childClassesList, this.getClassComparator());
            Iterator<Class_> it = childClassesList.iterator();
            Class_ child = null;
            String previousLabel = aClass.htmlLabel();
            while (it.hasNext()) {
                child = it.next();
                this.csvBuildClassRows(classAssignment, examAssignment, ct, co, child, indentSpaces + indent, context, previousLabel);
            }
        }
    }

    protected void csvBuildConfigRow(Vector subpartIds, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, CourseOffering co, InstrOfferingConfig ioc, SessionContext context, boolean printConfigLine) {
        boolean isEditable = context.hasPermission(ioc.getInstructionalOffering(), Right.InstructionalOfferingDetail);
        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
        String configName = ioc.getName();
        boolean unlimited = ioc.isUnlimitedEnrollment();
        boolean hasConfig = false;
        if (printConfigLine) {
            CSVFile.CSVField cell;
            if (this.isShowLabel()) {
                if (configName == null || configName.trim().length() == 0) {
                    configName = ioc.getUniqueId().toString();
                }
                cell = this.createCell();
                this.addText(cell, indent + (ioc.getInstructionalMethod() == null ? MSG.labelConfiguration(configName) : MSG.labelConfigurationWithInstructionalMethod(configName, ioc.getInstructionalMethod().getReference())), true);
                line.add(cell);
            }
            if (this.isShowDivSec()) {
                line.add(this.createCell());
            }
            if (this.isShowDemand()) {
                line.add(this.createCell());
            }
            if (this.isShowProjectedDemand()) {
                line.add(this.createCell());
            }
            if (this.isShowLimit()) {
                cell = this.createCell();
                this.addText(cell, unlimited ? "inf" : ioc.getLimit().toString(), true);
                line.add(cell);
            }
            if (this.isShowRoomRatio()) {
                line.add(this.createCell());
            }
            if (this.isShowManager()) {
                line.add(this.createCell());
            }
            if (this.isShowDatePattern()) {
                line.add(this.createCell());
            }
            if (this.isShowMinPerWk()) {
                line.add(this.createCell());
            }
            if (this.isShowTimePattern()) {
                line.add(this.createCell());
            }
            if (this.isShowPreferences()) {
                for (int j = 0; j < this.PREFERENCE_COLUMN_ORDER.length + (this.getDisplayDistributionPrefs() ? 0 : -1); ++j) {
                    line.add(this.createCell());
                }
            }
            if (this.isShowInstructor()) {
                line.add(this.createCell());
            }
            if (this.getDisplayTimetable() && this.isShowTimetable()) {
                for (int j = 0; j < this.TIMETABLE_COLUMN_ORDER.length; ++j) {
                    line.add(this.createCell());
                }
            }
            if (this.isShowTitle()) {
                line.add(this.createCell());
            }
            if (this.isShowCredit()) {
                line.add(this.createCell());
            }
            if (this.isShowSubpartCredit()) {
                line.add(this.createCell());
            }
            if (this.isShowConsent()) {
                line.add(this.createCell());
            }
            if (this.isShowSchedulePrintNote()) {
                line.add(this.createCell());
            }
            if (this.isShowNote()) {
                line.add(this.createCell());
            }
            if (this.isShowExam()) {
                TreeSet exams = new TreeSet(Exam.findAll(2, ioc.getUniqueId()));
                if (this.isShowExamName()) {
                    line.add(this.csvBuildExamName(exams, isEditable));
                }
                Iterator i = exams.iterator();
                while (i.hasNext()) {
                    if (context.hasPermission(i.next(), Right.ExaminationView)) continue;
                    i.remove();
                }
                if (this.isShowExamTimetable()) {
                    line.add(this.csvBuildExamPeriod(examAssignment, exams, isEditable));
                    line.add(this.csvBuildExamRoom(examAssignment, exams, isEditable));
                }
            }
            hasConfig = true;
            this.iFile.addLine(line);
        }
        ArrayList<SchedulingSubpart> subpartList = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
        Collections.sort(subpartList, new SchedulingSubpartComparator());
        Iterator<SchedulingSubpart> it = subpartList.iterator();
        SchedulingSubpart ss = null;
        while (it.hasNext()) {
            ss = it.next();
            if (ss.getParentSubpart() != null) continue;
            this.csvBuildSchedulingSubpartRows(subpartIds, classAssignment, examAssignment, co, ss, hasConfig ? indent + indent : indent, context);
        }
        it = subpartList.iterator();
        int ct = 0;
        String prevLabel = null;
        while (it.hasNext()) {
            ss = it.next();
            if (ss.getParentSubpart() != null || ss.getClasses() == null) continue;
            Vector<Class_> classes = new Vector<Class_>(ss.getClasses());
            Collections.sort(classes, this.getClassComparator());
            Iterator<Class_> cIt = classes.iterator();
            Class_ c = null;
            while (cIt.hasNext()) {
                c = cIt.next();
                this.csvBuildClassRows(classAssignment, examAssignment, ++ct, co, c, indent, context, prevLabel);
                prevLabel = c.htmlLabel();
            }
        }
    }

    private void csvBuildConfigRows(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, CourseOffering co, Set instrOfferingConfigs, SessionContext context, boolean printConfigLine) {
        Iterator it = instrOfferingConfigs.iterator();
        InstrOfferingConfig ioc = null;
        while (it.hasNext()) {
            ioc = (InstrOfferingConfig)it.next();
            this.csvBuildConfigRow(null, classAssignment, examAssignment, co, ioc, context, printConfigLine && instrOfferingConfigs.size() > 1);
        }
    }

    private void csvAddInstrOffrRowsToTable(ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, InstructionalOffering io, Long subjectAreaId, SessionContext context) {
        CSVFile.CSVField cell;
        CourseOffering co = io.findSortCourseOfferingForSubjectArea(subjectAreaId);
        boolean isEditable = context.hasPermission(co.getInstructionalOffering(), Right.InstructionalOfferingDetail);
        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
        if (this.isShowLabel()) {
            line.add(this.csvSubjectAndCourseInfo(io, co));
        }
        if (this.isShowDivSec()) {
            line.add(this.createCell());
        }
        if (this.isShowDemand()) {
            cell = this.createCell();
            if (StudentClassEnrollment.sessionHasEnrollments(io.getSessionId())) {
                this.addText(cell, io.getEnrollment() != null ? io.getEnrollment().toString() : "0", true);
            } else {
                this.addText(cell, io.getDemand() != null ? io.getDemand().toString() : "0", true);
            }
            line.add(cell);
        }
        if (this.isShowProjectedDemand()) {
            cell = this.createCell();
            this.addText(cell, io.getProjectedDemand() != null ? io.getProjectedDemand().toString() : "0", true);
            line.add(cell);
        }
        if (this.isShowLimit()) {
            boolean unlimited = false;
            Iterator<InstrOfferingConfig> x = io.getInstrOfferingConfigs().iterator();
            while (!unlimited && x.hasNext()) {
                if (!x.next().isUnlimitedEnrollment().booleanValue()) continue;
                unlimited = true;
            }
            CSVFile.CSVField cell2 = this.createCell();
            this.addText(cell2, unlimited ? "inf" : (io.getLimit() == null ? "0" : io.getLimit().toString()), true);
            line.add(cell2);
        }
        int emptyCels = 0;
        if (this.isShowRoomRatio()) {
            ++emptyCels;
        }
        if (this.isShowManager()) {
            ++emptyCels;
        }
        if (this.isShowDatePattern()) {
            ++emptyCels;
        }
        if (this.isShowMinPerWk()) {
            ++emptyCels;
        }
        if (this.isShowTimePattern()) {
            ++emptyCels;
        }
        if (this.isShowPreferences()) {
            emptyCels += this.PREFERENCE_COLUMN_ORDER.length + (this.getDisplayDistributionPrefs() ? 0 : -1);
        }
        if (this.isShowInstructor()) {
            ++emptyCels;
        }
        if (this.getDisplayTimetable() && this.isShowTimetable()) {
            emptyCels += this.TIMETABLE_COLUMN_ORDER.length;
        }
        if (emptyCels > 0) {
            for (int i = 0; i < emptyCels; ++i) {
                line.add(this.createCell());
            }
        }
        if (this.isShowTitle()) {
            CSVFile.CSVField titleCell = this.createCell();
            this.addText(titleCell, co.getTitle() == null ? "" : co.getTitle(), true);
            for (CourseOffering x : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                this.addText(titleCell, x.getTitle() == null ? "" : x.getTitle(), true);
            }
            line.add(titleCell);
        }
        if (this.isShowCredit()) {
            CSVFile.CSVField cell3 = this.createCell();
            this.addText(cell3, co.getCredit() != null ? co.getCredit().creditAbbv() : "", true);
            for (CourseOffering x : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                this.addText(cell3, x.getCredit() != null ? x.getCredit().creditAbbv() : "", true);
            }
            line.add(cell3);
        }
        if (this.isShowSubpartCredit()) {
            line.add(this.createCell());
        }
        if (this.isShowConsent()) {
            CSVFile.CSVField cell4 = this.createCell();
            this.addText(cell4, co.getConsentType() != null ? co.getConsentType().getAbbv() : MSG.noConsentRequired(), true);
            for (CourseOffering x : io.courseOfferingsMinusSortCourseOfferingForSubjectArea(co.getSubjectArea().getUniqueId())) {
                this.addText(cell4, x.getConsentType() != null ? x.getConsentType().getAbbv() : MSG.noConsentRequired(), true);
            }
            line.add(cell4);
        }
        if (this.isShowSchedulePrintNote()) {
            line.add(this.csvBuildSchedulePrintNote(io, isEditable, context.getUser()));
        }
        if (this.isShowNote()) {
            line.add(this.createCell());
        }
        if (this.isShowExam()) {
            TreeSet exams = new TreeSet(Exam.findAll(0, io.getUniqueId()));
            for (CourseOffering cox : io.getCourseOfferings()) {
                exams.addAll(Exam.findAll(1, cox.getUniqueId()));
            }
            if (io.getInstrOfferingConfigs().size() == 1) {
                for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
                    exams.addAll(Exam.findAll(2, ioc.getUniqueId()));
                }
            }
            Iterator<Serializable> i = exams.iterator();
            while (i.hasNext()) {
                if (context.hasPermission(i.next(), Right.ExaminationView)) continue;
                i.remove();
            }
            if (this.isShowExamName()) {
                line.add(this.csvBuildExamName(exams, isEditable));
            }
            if (this.isShowExamTimetable()) {
                line.add(this.csvBuildExamPeriod(examAssignment, exams, isEditable));
                line.add(this.csvBuildExamRoom(examAssignment, exams, isEditable));
            }
        }
        this.iFile.addLine(line);
        if (io.getInstrOfferingConfigs() != null & !io.getInstrOfferingConfigs().isEmpty()) {
            TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(io.getControllingCourseOffering().getSubjectArea().getUniqueId()));
            configs.addAll(io.getInstrOfferingConfigs());
            this.csvBuildConfigRows(classAssignment, examAssignment, io.getControllingCourseOffering(), configs, context, true);
        }
    }

    protected void save(PrintWriter out) {
        if (this.iFile.getHeader() != null) {
            out.println(this.iFile.getHeader().toString());
        }
        if (this.iFile.getLines() != null) {
            for (CSVFile.CSVLine line : this.iFile.getLines()) {
                out.println(line.toString());
            }
        }
        out.flush();
    }

    public void csvTableForInstructionalOffering(PrintWriter out, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, Long instructionalOfferingId, SessionContext context, Comparator classComparator) throws Exception {
        if (instructionalOfferingId != null && context != null) {
            InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
            InstructionalOffering io = (InstructionalOffering)idao.get(instructionalOfferingId);
            Long subjectAreaId = io.getControllingCourseOffering().getSubjectArea().getUniqueId();
            TreeSet<InstructionalOffering> ts = new TreeSet<InstructionalOffering>();
            ts.add(io);
            WebInstructionalOfferingTableBuilder iotbl = new WebInstructionalOfferingTableBuilder();
            iotbl.setDisplayDistributionPrefs(false);
            this.setVisibleColumns(this.COLUMNS);
            this.csvTableForInstructionalOfferings(out, classAssignment, examAssignment, ts, subjectAreaId, context, false, false, classComparator);
        }
    }

    public void csvTableForInstructionalOfferings(PrintWriter out, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, InstructionalOfferingListForm form, String[] subjectAreaIds, SessionContext context, boolean displayHeader, boolean allCoursesAreGiven) throws Exception {
        this.setVisibleColumns(form);
        for (int i = 0; i < subjectAreaIds.length; ++i) {
            Long subjectAreaId = Long.valueOf(subjectAreaIds[i]);
            if (i > 0) {
                out.println();
                out.println();
            }
            this.csvTableForInstructionalOfferings(out, classAssignment, examAssignment, form.getInstructionalOfferings(subjectAreaId), subjectAreaId, context, displayHeader, allCoursesAreGiven, new ClassCourseComparator(form.getSortBy(), classAssignment, false));
        }
    }

    protected void csvTableForInstructionalOfferings(PrintWriter out, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, TreeSet insructionalOfferings, Long subjectAreaId, SessionContext context, boolean displayHeader, boolean allCoursesAreGiven, Comparator classComparator) throws Exception {
        if (insructionalOfferings == null) {
            return;
        }
        SubjectArea subjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(subjectAreaId);
        if (classComparator != null) {
            this.setClassComparator(classComparator);
        }
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                if (classAssignment instanceof CachedClassAssignmentProxy) {
                    Vector<Class_> allClasses = new Vector<Class_>();
                    Iterator i = insructionalOfferings.iterator();
                    while (!hasTimetable && i.hasNext()) {
                        InstructionalOffering io = (InstructionalOffering)i.next();
                        Iterator<InstrOfferingConfig> j = io.getInstrOfferingConfigs().iterator();
                        while (!hasTimetable && j.hasNext()) {
                            InstrOfferingConfig ioc = j.next();
                            Iterator<SchedulingSubpart> k = ioc.getSchedulingSubparts().iterator();
                            while (!hasTimetable && k.hasNext()) {
                                SchedulingSubpart ss = k.next();
                                for (Class_ clazz : ss.getClasses()) {
                                    allClasses.add(clazz);
                                }
                            }
                        }
                    }
                    ((CachedClassAssignmentProxy)classAssignment).setCache(allClasses);
                    hasTimetable = !classAssignment.getAssignmentTable(allClasses).isEmpty();
                } else {
                    Iterator i = insructionalOfferings.iterator();
                    while (!hasTimetable && i.hasNext()) {
                        InstructionalOffering io = (InstructionalOffering)i.next();
                        Iterator<InstrOfferingConfig> j = io.getInstrOfferingConfigs().iterator();
                        while (!hasTimetable && j.hasNext()) {
                            InstrOfferingConfig ioc = j.next();
                            Iterator<SchedulingSubpart> k = ioc.getSchedulingSubparts().iterator();
                            block6: while (!hasTimetable && k.hasNext()) {
                                SchedulingSubpart ss = k.next();
                                for (Class_ clazz : ss.getClasses()) {
                                    if (classAssignment.getAssignment(clazz) == null) continue;
                                    hasTimetable = true;
                                    continue block6;
                                }
                            }
                        }
                    }
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        if (this.isShowExam()) {
            this.setShowExamTimetable(examAssignment != null || Exam.hasTimetable(context.getUser().getCurrentAcademicSessionId()));
        }
        ArrayList<InstructionalOffering> notOfferedOfferings = new ArrayList<InstructionalOffering>();
        ArrayList<InstructionalOffering> offeredOfferings = new ArrayList<InstructionalOffering>();
        ArrayList<Long> offeringIds = new ArrayList<Long>();
        Iterator it = insructionalOfferings.iterator();
        InstructionalOffering io2 = null;
        boolean hasOfferedCourses = false;
        boolean hasNotOfferedCourses = false;
        this.setUserSettings(context.getUser());
        while (it.hasNext()) {
            io2 = (InstructionalOffering)it.next();
            if (io2.isNotOffered() == null || io2.isNotOffered().booleanValue()) {
                hasNotOfferedCourses = true;
                notOfferedOfferings.add(io2);
                continue;
            }
            hasOfferedCourses = true;
            offeredOfferings.add(io2);
        }
        this.iFile = new CSVFile();
        if (hasOfferedCourses || allCoursesAreGiven) {
            if (displayHeader) {
                this.iFile.addLine(MSG.labelOfferedCourses(subjectArea.getSubjectAreaAbbreviation()));
            }
            this.csvBuildTableHeader(context.getUser().getCurrentAcademicSessionId());
            if (hasOfferedCourses) {
                for (InstructionalOffering io2 : offeredOfferings) {
                    offeringIds.add(io2.getUniqueId());
                    this.csvAddInstrOffrRowsToTable(classAssignment, examAssignment, io2, subjectAreaId, context);
                }
            } else if (displayHeader) {
                this.iFile.addLine(MSG.errorNoCoursesOffered(subjectArea.getSubjectAreaAbbreviation()));
            }
        }
        if (hasNotOfferedCourses || allCoursesAreGiven) {
            if (displayHeader) {
                this.iFile.addLine();
                this.iFile.addLine(MSG.labelNotOfferedCourses(subjectArea.getSubjectAreaAbbreviation()));
            }
            this.csvBuildTableHeader(context.getUser().getCurrentAcademicSessionId());
            if (hasNotOfferedCourses) {
                for (InstructionalOffering io2 : notOfferedOfferings) {
                    offeringIds.add(io2.getUniqueId());
                    this.csvAddInstrOffrRowsToTable(classAssignment, examAssignment, io2, subjectAreaId, context);
                }
            } else if (displayHeader) {
                this.iFile.addLine(MSG.errorAllCoursesOffered(subjectArea.getSubjectAreaAbbreviation()));
            }
        }
        this.save(out);
    }
}

