/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.queue;

import java.io.File;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.log4j.Logger;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.UserContext;

public abstract class QueueItem
implements Log {
    protected static Logger iLogger;
    private Long iSessionId;
    private String iOwnerId;
    private String iOwnerName;
    private String iOwnerEmail;
    private File iOutput = null;
    private String iLog = "";
    private String iStatus = "Waiting...";
    private Date iCreated = new Date();
    private Date iStarted = null;
    private Date iFinished = null;
    private Throwable iException = null;
    private String iLocale = null;
    private Long iId = null;

    public QueueItem(Long sessionId, UserContext owner) {
        iLogger = Logger.getLogger(this.getClass());
        this.iSessionId = sessionId;
        this.iOwnerId = owner.getExternalUserId();
        this.iOwnerName = owner.getName();
        this.iOwnerEmail = owner.getEmail();
        this.iLocale = Localization.getLocale();
    }

    public QueueItem(Session session, UserContext owner) {
        this(session.getUniqueId(), owner);
    }

    public QueueItem(UserContext owner) {
        this(owner.getCurrentAcademicSessionId(), owner);
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public Session getSession() {
        return (Session)SessionDAO.getInstance().get(this.iSessionId);
    }

    public String getOwnerId() {
        return this.iOwnerId;
    }

    public String getOwnerName() {
        return this.iOwnerName;
    }

    public boolean hasOwnerEmail() {
        return this.iOwnerEmail != null && !this.iOwnerEmail.isEmpty();
    }

    public String getOwnerEmail() {
        return this.iOwnerEmail;
    }

    public String getLocale() {
        return this.iLocale;
    }

    public abstract String type();

    public abstract String name();

    public abstract double progress();

    protected abstract void execute() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeItem() {
        block6: {
            this.iStarted = new Date();
            ApplicationProperties.setSessionId(this.getSessionId());
            Localization.setLocale(this.getLocale());
            try {
                try {
                    this.execute();
                }
                catch (ThreadDeath e) {
                    this.fatal("Execution stopped.", e);
                    Object var3_2 = null;
                    ApplicationProperties.setSessionId(null);
                    _RootDAO.closeCurrentThreadSessions();
                    Localization.removeLocale();
                    break block6;
                }
                catch (Exception e) {
                    this.fatal("Execution failed.", e);
                    Object var3_3 = null;
                    ApplicationProperties.setSessionId(null);
                    _RootDAO.closeCurrentThreadSessions();
                    Localization.removeLocale();
                    break block6;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ApplicationProperties.setSessionId(null);
                _RootDAO.closeCurrentThreadSessions();
                Localization.removeLocale();
                throw throwable;
            }
            ApplicationProperties.setSessionId(null);
            _RootDAO.closeCurrentThreadSessions();
            Localization.removeLocale();
        }
        this.iFinished = new Date();
        this.iStatus = "All done.";
        if (this.iException == null) return;
        if (this.iException instanceof ThreadDeath) {
            this.iStatus = "Killed";
            return;
        }
        this.iStatus = "Failed (" + this.iException.getMessage() + ")";
    }

    public boolean hasOutput() {
        return this.iOutput != null && this.iOutput.exists() && this.iOutput.canRead();
    }

    public File output() {
        return this.iOutput;
    }

    public void setOutput(File output) {
        this.iOutput = output;
    }

    protected File createOutput(String prefix, String ext) {
        if (this.iOutput != null) {
            throw new RuntimeException("Output already created.");
        }
        this.iOutput = ApplicationProperties.getTempFile(prefix, ext);
        return this.iOutput;
    }

    public String log() {
        return this.iLog;
    }

    protected void log(String message) {
        if (this.iLog.length() > 0) {
            this.iLog = this.iLog + "<br>";
        }
        this.iLog = this.iLog + message;
    }

    protected void warn(String message) {
        if (this.iLog.length() > 0) {
            this.iLog = this.iLog + "<br>";
        }
        this.iLog = this.iLog + "<font color='orange'>" + message + "</font>";
    }

    protected void error(String message) {
        if (this.iLog.length() > 0) {
            this.iLog = this.iLog + "<br>";
        }
        this.iLog = this.iLog + "<font color='red'>" + message + "</font>";
    }

    protected void setStatus(String status) {
        this.iStatus = status;
        this.log("<i>" + this.iStatus + "</i>");
    }

    public String status() {
        return this.iStatus;
    }

    public boolean hasError() {
        return this.iException != null;
    }

    protected void setError(Throwable exception) {
        this.iException = exception;
    }

    public Throwable error() {
        return this.iException;
    }

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public Date created() {
        return this.iCreated;
    }

    public Date started() {
        return this.iStarted;
    }

    public Date finished() {
        return this.iFinished;
    }

    public void trace(Object message) {
        iLogger.trace(message);
    }

    public void trace(Object message, Throwable exception) {
        iLogger.trace(message, exception);
    }

    public void debug(Object message) {
        this.debug(message, null);
    }

    public void debug(Object message, Throwable exception) {
        iLogger.debug(message, exception);
        if (exception == null) {
            if (message != null) {
                this.log(message.toString());
            }
        } else if (message == null) {
            this.log(exception.getClass().getSimpleName() + ": " + exception.getMessage());
        } else {
            this.log(message + " (" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ")");
        }
    }

    public void warn(Object message) {
        this.warn(message, null);
    }

    public void warn(Object message, Throwable exception) {
        iLogger.warn(message, exception);
        if (exception == null) {
            if (message != null) {
                this.warn(message.toString());
            }
        } else if (message == null) {
            this.warn(exception.getClass().getSimpleName() + ": " + exception.getMessage());
        } else {
            this.warn(message + " (" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ")");
        }
    }

    public void info(Object message) {
        this.info(message, null);
    }

    public void info(Object message, Throwable exception) {
        iLogger.info(message, exception);
        if (exception == null) {
            if (message != null) {
                this.log(message.toString());
            }
        } else if (message == null) {
            this.log(exception.getClass().getSimpleName() + ": " + exception.getMessage());
        } else {
            this.log(message + " (" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ")");
        }
    }

    public void error(Object message) {
        this.error(message, null);
    }

    public void error(Object message, Throwable exception) {
        iLogger.error(message, exception);
        if (exception == null) {
            if (message != null) {
                this.error(message.toString());
            }
        } else if (message == null) {
            this.error(exception.getClass().getSimpleName() + ": " + exception.getMessage());
        } else {
            this.error(message + " (" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ")");
        }
    }

    public void fatal(Object message) {
        this.fatal(message, null);
    }

    public void fatal(Object message, Throwable exception) {
        iLogger.fatal(message, exception);
        if (exception == null) {
            if (message != null) {
                this.error(message.toString());
            }
        } else if (message == null) {
            this.error(exception.getClass().getSimpleName() + ": " + exception.getMessage());
        } else {
            this.error(message + " (" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ")");
        }
        if (exception != null) {
            this.setError(exception);
        }
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return true;
    }
}

