/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;

public class RoomAvailability {
    private static RoomAvailabilityInterface sInstance = null;

    public static RoomAvailabilityInterface getInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        if (ApplicationProperty.RoomAvailabilityImplementation.value() == null) {
            return null;
        }
        try {
            sInstance = (RoomAvailabilityInterface)Class.forName(ApplicationProperty.RoomAvailabilityImplementation.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
            return sInstance;
        }
        catch (Exception e) {
            Debug.error(e);
            return null;
        }
    }

    public static void setAvailabilityWarning(HttpServletRequest request, Session acadSession, Long examType, boolean checkSolver, boolean checkAvailability) {
        ExamSolverProxy solver;
        if (acadSession == null || examType == null || RoomAvailability.getInstance() == null) {
            return;
        }
        if (checkSolver && (solver = WebSolver.getExamSolver(request.getSession())) != null && solver.getExamTypeId().equals(examType)) {
            String ts = solver.getProperties().getProperty("RoomAvailability.TimeStamp");
            ExamType type = (ExamType)ExamTypeDAO.getInstance().get(examType);
            if (type == null) {
                return;
            }
            if (ts == null) {
                request.setAttribute("RqWarn", (Object)("Room availability is not available for " + type.getLabel().toLowerCase() + " examinations."));
            } else {
                request.setAttribute("RqMsg", (Object)("Room availability for " + type.getLabel().toLowerCase() + " examination solver was updated on " + ts + "."));
            }
            return;
        }
        if (checkAvailability) {
            Date[] bounds = ExamPeriod.getBounds(acadSession, examType);
            ExamType type = (ExamType)ExamTypeDAO.getInstance().get(examType);
            if (type == null) {
                return;
            }
            String exclude = type.getType() == 0 ? RoomAvailabilityInterface.sFinalExamType : RoomAvailabilityInterface.sMidtermExamType;
            String ts = RoomAvailability.getInstance().getTimeStamp(bounds[0], bounds[1], exclude);
            if (ts == null) {
                request.setAttribute("RqWarn", (Object)("Room availability is not available for " + type.getLabel().toLowerCase() + " examinations."));
            } else {
                request.setAttribute("RqMsg", (Object)("Room availability for " + type.getLabel().toLowerCase() + " examinations was updated on " + ts + "."));
            }
        }
    }

    public static void setAvailabilityWarning(HttpServletRequest request, Session acadSession, boolean checkSolver, boolean checkAvailability) {
        SolverProxy solver;
        if (acadSession == null || RoomAvailability.getInstance() == null) {
            return;
        }
        if (checkSolver && (solver = WebSolver.getSolver(request.getSession())) != null) {
            String ts = null;
            try {
                ts = solver.getProperties().getProperty("RoomAvailability.TimeStamp");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ts == null) {
                request.setAttribute("RqWarn", (Object)"Room availability is not available for classes.");
            } else {
                request.setAttribute("RqMsg", (Object)("Room availability for course timetabling solver was updated on " + ts + "."));
            }
            return;
        }
        if (checkAvailability) {
            Date[] bounds = DatePattern.getBounds(acadSession.getUniqueId());
            String ts = RoomAvailability.getInstance().getTimeStamp(bounds[0], bounds[1], RoomAvailabilityInterface.sClassType);
            if (ts == null) {
                request.setAttribute("RqWarn", (Object)"Room availability is not available for classes.");
            } else {
                request.setAttribute("RqMsg", (Object)("Room availability for classes was updated on " + ts + "."));
            }
        }
    }
}

