/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.hibernate.Query;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.solver.TimetableDatabaseLoader;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.util.duration.DurationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfWorksheet {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private boolean iUseCommitedAssignments = true;
    private static int sNrChars = 133;
    private static int sNrLines = 50;
    private OutputStream iOut = null;
    private Document iDoc = null;
    private TreeSet<SubjectArea> iSubjectAreas;
    private String iCourseNumber = null;
    private int iPageNo = 0;
    private int iLineNo = 0;
    private StringBuffer iBuffer = new StringBuffer();
    private CourseOffering iCourseOffering = null;
    private SubjectArea iCurrentSubjectArea = null;

    private PdfWorksheet(OutputStream out, Collection<SubjectArea> subjectAreas, String courseNumber) throws IOException, DocumentException {
        this.iUseCommitedAssignments = ApplicationProperty.WorksheetPdfUseCommittedAssignments.isTrue();
        this.iSubjectAreas = new TreeSet<SubjectArea>(new Comparator<SubjectArea>(){

            @Override
            public int compare(SubjectArea s1, SubjectArea s2) {
                return s1.getSubjectAreaAbbreviation().compareTo(s2.getSubjectAreaAbbreviation());
            }
        });
        this.iSubjectAreas.addAll(subjectAreas);
        this.iCourseNumber = courseNumber;
        if (this.iCourseNumber != null && (this.iCourseNumber.trim().length() == 0 || "*".equals(this.iCourseNumber.trim().length()))) {
            this.iCourseNumber = null;
        }
        this.iDoc = new Document(PageSize.LETTER.rotate());
        this.iOut = out;
        PdfWriter.getInstance((Document)this.iDoc, (OutputStream)this.iOut);
        String session = null;
        String subjects = "";
        for (SubjectArea sa : this.iSubjectAreas) {
            if (subjects.isEmpty()) {
                subjects = subjects + ", ";
            }
            subjects = subjects + sa.getSubjectAreaAbbreviation();
            if (session != null) continue;
            session = session + sa.getSession().getLabel();
        }
        this.iDoc.addTitle(subjects + (this.iCourseNumber == null ? "" : " " + this.iCourseNumber) + " Worksheet");
        this.iDoc.addAuthor(ApplicationProperty.WorksheetPdfAuthor.value().replace("%", Constants.getVersion()));
        this.iDoc.addSubject(subjects + (session == null ? "" : " -- " + session));
        this.iDoc.addCreator("UniTime " + Constants.getVersion() + ", www.unitime.org");
        if (!this.iSubjectAreas.isEmpty()) {
            this.iCurrentSubjectArea = this.iSubjectAreas.first();
        }
        this.iDoc.open();
        this.printHeader();
    }

    public static boolean print(OutputStream out, Collection<SubjectArea> subjectAreas) throws IOException, DocumentException {
        TreeSet courses = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                CourseOffering co1 = (CourseOffering)o1;
                CourseOffering co2 = (CourseOffering)o2;
                int cmp = co1.getCourseName().compareTo(co2.getCourseName());
                if (cmp != 0) {
                    return cmp;
                }
                return co1.getUniqueId().compareTo(co2.getUniqueId());
            }
        });
        String subjectIds = "";
        for (SubjectArea sa : subjectAreas) {
            subjectIds = subjectIds + (subjectIds.isEmpty() ? "" : ",") + sa.getUniqueId();
        }
        courses.addAll(SessionDAO.getInstance().getSession().createQuery("select co from CourseOffering co where  co.subjectArea.uniqueId in (" + subjectIds + ")").list());
        if (courses.isEmpty()) {
            return false;
        }
        PdfWorksheet w = new PdfWorksheet(out, subjectAreas, null);
        Iterator i = courses.iterator();
        while (i.hasNext()) {
            w.print((CourseOffering)i.next());
        }
        w.lastPage();
        w.close();
        return true;
    }

    public static boolean print(OutputStream out, Collection<SubjectArea> subjectAreas, String courseNumber) throws IOException, DocumentException {
        TreeSet courses = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                CourseOffering co1 = (CourseOffering)o1;
                CourseOffering co2 = (CourseOffering)o2;
                int cmp = co1.getCourseName().compareTo(co2.getCourseName());
                if (cmp != 0) {
                    return cmp;
                }
                return co1.getUniqueId().compareTo(co2.getUniqueId());
            }
        });
        ArrayList<Long> subjectIds = new ArrayList<Long>();
        for (SubjectArea sa : subjectAreas) {
            subjectIds.add(sa.getUniqueId());
        }
        String query = "select co from CourseOffering co where  co.subjectArea.uniqueId in :subjectIds";
        if (courseNumber != null && !courseNumber.trim().isEmpty()) {
            query = courseNumber.indexOf(42) >= 0 ? query + " and co.courseNbr like :courseNbr " : query + " and co.courseNbr = :courseNbr ";
        }
        Query q = new SessionDAO().getSession().createQuery(query);
        q.setParameterList("subjectIds", subjectIds);
        if (courseNumber != null && !courseNumber.trim().isEmpty()) {
            q.setParameter("courseNbr", (Object)(ApplicationProperty.CourseOfferingNumberUpperCase.isTrue() ? courseNumber.trim().replace('*', '%').toUpperCase() : courseNumber.trim().replace('*', '%')));
        }
        courses.addAll(q.list());
        if (courses.isEmpty()) {
            return false;
        }
        PdfWorksheet w = new PdfWorksheet(out, subjectAreas, courseNumber);
        Iterator i = courses.iterator();
        while (i.hasNext()) {
            w.print((CourseOffering)i.next());
        }
        w.lastPage();
        w.close();
        return true;
    }

    private String[] time(Class_ clazz) {
        Assignment assgn;
        String dpat = "";
        DatePattern dp = clazz.effectiveDatePattern();
        if (dp != null && !dp.isDefault()) {
            if (dp.getType() == 1) {
                dpat = " " + dp.getName();
            } else {
                SimpleDateFormat dpf = new SimpleDateFormat("MM/dd");
                dpat = ", " + dpf.format(dp.getStartDate()) + " - " + dpf.format(dp.getEndDate());
            }
        }
        Assignment assignment = assgn = this.iUseCommitedAssignments ? clazz.getCommittedAssignment() : null;
        if (assgn == null) {
            Set timePrefs = clazz.getEffectiveTimePreferences();
            if (timePrefs.isEmpty()) {
                DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
                Integer ah = dm.getArrangedHours(clazz.getSchedulingSubpart().getMinutesPerWk(), clazz.effectiveDatePattern());
                if (ah != null) {
                    return new String[]{"Arr " + ah + " Hrs" + dpat};
                }
                return new String[]{"Arr Hrs" + dpat};
            }
            boolean onlyOneReq = true;
            TimeLocation req = null;
            Iterator x = timePrefs.iterator();
            while (onlyOneReq && x.hasNext()) {
                TimePref tp = (TimePref)x.next();
                TimePatternModel model = tp.getTimePatternModel();
                if (model.isExactTime()) {
                    if (req != null) {
                        onlyOneReq = false;
                        continue;
                    }
                    DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
                    int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(clazz.getSchedulingSubpart().getMinutesPerWk(), clazz.effectiveDatePattern(), model.getExactDays());
                    int length = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
                    int breakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
                    req = new TimeLocation(model.getExactDays(), model.getExactStartSlot(), length, PreferenceLevel.sIntLevelNeutral, 0.0, dp.getUniqueId(), dp.getName(), dp.getPatternBitSet(), breakTime);
                    continue;
                }
                for (int d = 0; d < model.getNrDays(); ++d) {
                    for (int t = 0; onlyOneReq && t < model.getNrTimes(); ++t) {
                        if (!PreferenceLevel.sRequired.equals(model.getPreference(d, t))) continue;
                        if (req != null) {
                            onlyOneReq = false;
                            continue;
                        }
                        req = new TimeLocation(model.getDayCode(d), model.getStartSlot(t), model.getSlotsPerMtg(), PreferenceLevel.prolog2int(model.getPreference(d, t)), 0.0, dp.getUniqueId(), dp.getName(), dp.getPatternBitSet(), model.getBreakTime());
                    }
                }
            }
            if (onlyOneReq && req != null) {
                return new String[]{req.getDayHeader() + " " + req.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + req.getEndTimeHeader(CONSTANTS.useAmPm()) + dpat};
            }
            Vector<String> t = new Vector<String>();
            for (TimePref tp : timePrefs) {
                String tx = tp.getTimePatternModel().toString();
                StringTokenizer s = new StringTokenizer(tx, ",");
                while (s.hasMoreTokens()) {
                    t.add(s.nextToken().trim());
                }
            }
            String[] time = new String[t.size()];
            for (int x2 = 0; x2 < time.length; ++x2) {
                time[x2] = t.elementAt(x2) + dpat;
            }
            return time;
        }
        TimeLocation t = assgn.getTimeLocation();
        return new String[]{t.getDayHeader() + " " + t.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + t.getEndTimeHeader(CONSTANTS.useAmPm()) + dpat};
    }

    private String[] room(Class_ clazz) {
        Assignment assgn;
        Assignment assignment = assgn = this.iUseCommitedAssignments ? clazz.getCommittedAssignment() : null;
        if (assgn == null || assgn.getRoomLocations().isEmpty()) {
            List<RoomLocation> roomLocations = TimetableDatabaseLoader.computeRoomLocations(clazz);
            if (roomLocations.size() == clazz.getNbrRooms().intValue()) {
                String[] rooms = new String[roomLocations.size()];
                for (int x = 0; x < roomLocations.size(); ++x) {
                    RoomLocation r = roomLocations.get(x);
                    rooms[x] = r.getName();
                }
                return rooms;
            }
            Vector<String> roomPrefs = new Vector<String>();
            boolean allRoomReq = true;
            for (Preference pref : clazz.effectivePreferences(BuildingPref.class)) {
                roomPrefs.add(pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText());
                allRoomReq = false;
            }
            for (Preference pref : clazz.effectivePreferences(RoomPref.class)) {
                roomPrefs.add(pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText());
                if (PreferenceLevel.sRequired.equals(pref.getPrefLevel().getPrefProlog())) continue;
                allRoomReq = false;
            }
            for (Preference pref : clazz.effectivePreferences(RoomFeaturePref.class)) {
                roomPrefs.add(pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText());
                allRoomReq = false;
            }
            for (Preference pref : clazz.effectivePreferences(RoomGroupPref.class)) {
                roomPrefs.add(pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText());
                allRoomReq = false;
            }
            if (allRoomReq) {
                roomPrefs.clear();
                for (Preference pref : clazz.effectivePreferences(RoomPref.class)) {
                    roomPrefs.add(pref.preferenceText());
                }
            }
            String[] rooms = new String[roomPrefs.size()];
            for (int x = 0; x < roomPrefs.size(); ++x) {
                rooms[x] = roomPrefs.elementAt(x).toString();
            }
            return rooms;
        }
        String[] rooms = new String[assgn.getRoomLocations().size()];
        for (int x = 0; x < assgn.getRoomLocations().size(); ++x) {
            RoomLocation r = (RoomLocation)assgn.getRoomLocations().elementAt(x);
            rooms[x] = r.getName();
        }
        return rooms;
    }

    private String[] instructor(Class_ clazz) {
        List<DepartmentalInstructor> leads = clazz.getLeadInstructors();
        String[] instr = new String[leads.size()];
        for (int x = 0; x < clazz.getLeadInstructors().size(); ++x) {
            DepartmentalInstructor in = leads.get(x);
            instr[x] = in.nameShort();
        }
        return instr;
    }

    protected void print(CourseOffering co) throws DocumentException {
        if (!this.iCurrentSubjectArea.equals(co.getSubjectArea())) {
            this.lastPage();
            this.iCurrentSubjectArea = co.getSubjectArea();
            this.iDoc.newPage();
            this.printHeader();
        } else if (this.iLineNo + 5 >= sNrLines) {
            this.newPage();
        }
        this.iCourseOffering = co;
        int courseLimit = -1;
        InstructionalOffering offering = co.getInstructionalOffering();
        if (co.getReservation() != null) {
            courseLimit = co.getReservation();
        }
        if (courseLimit < 0 && offering.getCourseOfferings().size() == 1 && offering.getLimit() != null) {
            courseLimit = offering.getLimit();
        }
        boolean unlimited = false;
        String courseOrg = "";
        Iterator<InstrOfferingConfig> i = offering.getInstrOfferingConfigs().iterator();
        if (i.hasNext()) {
            InstrOfferingConfig config = i.next();
            if (config.isUnlimitedEnrollment().booleanValue()) {
                unlimited = true;
            }
            Hashtable<ItypeDesc, Integer> creditPerIType = new Hashtable<ItypeDesc, Integer>();
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                if (subpart.getMinutesPerWk() <= 0) continue;
                Integer credit = (Integer)creditPerIType.get(subpart.getItype());
                creditPerIType.put(subpart.getItype(), new Integer((credit == null ? 0 : credit) + subpart.getMinutesPerWk()));
            }
            TreeSet itypes = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    ItypeDesc i1 = (ItypeDesc)o1;
                    ItypeDesc i2 = (ItypeDesc)o2;
                    return i1.getItype().compareTo(i2.getItype());
                }
            });
            itypes.addAll(creditPerIType.keySet());
            for (ItypeDesc itype : itypes) {
                int minPerWeek = (Integer)creditPerIType.get(itype);
                if (courseOrg.length() > 0) {
                    courseOrg = courseOrg + ", ";
                }
                courseOrg = courseOrg + itype.getAbbv().trim() + " " + (minPerWeek + 49) / 50;
            }
        }
        int enrl = -1;
        String s1 = co.getSubjectArea().getSession().getAcademicTerm().substring(0, 1) + co.getSubjectArea().getSession().getAcademicYear().substring(2);
        String s2 = co.getSubjectArea().getSession().getAcademicTerm().substring(0, 1) + new DecimalFormat("00").format(Integer.parseInt(co.getSubjectArea().getSession().getAcademicYear().substring(2)) - 1);
        if (co.getProjectedDemand() != null) {
            enrl = co.getProjectedDemand();
        }
        int lastLikeEnrl = co.getCourseOfferingDemands().size();
        String title = co.getTitle();
        if (title == null) {
            title = "*** Title not set";
        }
        this.println("                                                                                              Proj  " + s2 + "                     ");
        this.println("Course     Title/Notes                           Credit Course Organization             Limit Enrl  Enrl  Consent    Cross List");
        this.println("---------- ------------------------------------- ------ ------------------------------- ----- ----- ----- ---------- ----------");
        this.println(this.rpad(co.getCourseName(), 10) + " " + this.rpad(title, 37) + (title.length() > 37 ? "-" : " ") + " " + this.rpad(co.getCredit() == null ? "" : co.getCredit().creditAbbv(), 5) + " " + this.rpad(courseOrg, 31) + " " + this.lpad(courseLimit <= 0 ? (unlimited ? "  inf" : "") : String.valueOf(courseLimit), 5) + " " + this.lpad(enrl <= 0 ? "" : String.valueOf(enrl), 5) + " " + this.lpad(lastLikeEnrl <= 0 ? "" : String.valueOf(lastLikeEnrl), 5) + " " + this.rpad(co.getConsentType() == null ? "" : co.getConsentType().getAbbv(), 10) + " " + this.rpad(offering.getCourseOfferings().size() > 1 ? offering.getCourseName() : "", 10));
        while (title.length() > 37) {
            title = title.substring(37);
            this.println("           " + this.rpad(title, 37) + (title.length() > 37 ? "-" : " "));
        }
        if (co.getScheduleBookNote() != null && co.getScheduleBookNote().trim().length() > 0) {
            String note = co.getScheduleBookNote();
            note = note.replaceAll("\\. ", "\\.\n");
            StringTokenizer s = new StringTokenizer(note, "\n\r");
            while (s.hasMoreTokens()) {
                String line = s.nextToken().trim();
                while (line.length() > sNrChars - 7) {
                    this.println("   " + line.substring(0, sNrChars - 7) + "-");
                    line = line.substring(sNrChars - 7);
                }
                this.println("   " + line);
            }
        }
        if (this.iLineNo + 5 >= sNrLines) {
            this.newPage();
        } else {
            this.println("");
        }
        this.println("        " + s1 + "   " + s2 + "  Proj | Type");
        this.println("Curr  Reqst  Enrl  Enrl | Instr Number Time                                     Limit Bldg-Room          Instructor            Mgr");
        this.println("----  -----  ----  ---- | ----- ------ ---------------------------------------- ----- ------------------ --------------------- ------");
        Vector rTable = new Vector();
        Vector<String> cTable = new Vector<String>();
        if (offering.isNotOffered().booleanValue()) {
            cTable.add(" ** Course not offered");
        }
        Vector<String> gTable = new Vector<String>();
        TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(null));
        configs.addAll(offering.getInstrOfferingConfigs());
        for (InstrOfferingConfig config : configs) {
            if (offering.getInstrOfferingConfigs().size() > 1) {
                cTable.add("** Configuration " + config.getName());
            }
            TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(new SchedulingSubpartComparator());
            subparts.addAll(config.getSchedulingSubparts());
            for (SchedulingSubpart subpart : subparts) {
                TreeSet<Class_> classes = new TreeSet<Class_>(new ClassComparator(5));
                classes.addAll(subpart.getClasses());
                String subpartLabel = subpart.getItype().getAbbv();
                boolean same = false;
                for (Class_ clazz : classes) {
                    String[] time = this.time(clazz);
                    String[] rooms = this.room(clazz);
                    String[] instr = this.instructor(clazz);
                    for (int x = 0; x < Math.max(Math.max(1, time.length), Math.max(instr.length, rooms.length)); ++x) {
                        cTable.add(this.rpad(same ? "" : (x == 0 ? subpartLabel : ""), 5) + " " + this.lpad(x == 0 ? clazz.getSectionNumberString() : "", 6) + " " + this.rpad(time != null && x < time.length ? time[x] : "", 40) + " " + this.lpad(x == 0 && clazz.getClassLimit() > 0 && clazz.getNbrRooms() > 0 ? (clazz.getNbrRooms() > 1 ? clazz.getNbrRooms() + "x" : "") + String.valueOf(clazz.getClassLimit()) : "", 5) + " " + this.rpad(rooms != null && x < rooms.length ? rooms[x] : "", 18) + " " + this.rpad(instr != null && x < instr.length ? instr[x] : "", 21) + " " + this.rpad(x == 0 ? clazz.getManagingDept().getShortLabel() : "", 6));
                    }
                    same = true;
                    if (clazz.getParentClass() == null || !clazz.getChildClasses().isEmpty()) continue;
                    String gr = clazz.getSchedulingSubpart().getItype().getAbbv().trim() + this.lpad(clazz.getSectionNumberString(), 4);
                    for (Class_ parent = clazz.getParentClass(); parent != null; parent = parent.getParentClass()) {
                        gr = parent.getSchedulingSubpart().getItype().getAbbv().trim() + this.lpad(parent.getSectionNumberString(), 4) + ", " + gr;
                    }
                    gTable.add(gr);
                }
            }
        }
        for (int i2 = 0; i2 < 1 + Math.max(rTable.size(), cTable.size()); ++i2) {
            String res = null;
            String cl = null;
            if (i2 < rTable.size()) {
                res = (String)rTable.elementAt(i2);
            }
            if (i2 < cTable.size()) {
                cl = (String)cTable.elementAt(i2);
            }
            this.println(this.rpad(res, 23) + " | " + (cl == null ? "" : cl));
        }
        if (!gTable.isEmpty()) {
            this.println(PdfWorksheet.rep('-', sNrChars));
            this.println("     Course groups:");
            int half = (gTable.size() + 1) / 2;
            for (int i3 = 0; i3 < half; ++i3) {
                String gr1 = (String)gTable.elementAt(i3);
                String gr2 = half + i3 < gTable.size() ? (String)gTable.elementAt(half + i3) : "";
                this.println("     " + this.rpad(gr1, 60) + " | " + this.rpad(gr2, 60));
            }
        }
        this.println(PdfWorksheet.rep('=', sNrChars));
        this.iCourseOffering = null;
    }

    private void out(String text) throws DocumentException {
        if (this.iBuffer.length() > 0) {
            this.iBuffer.append("\n");
        }
        this.iBuffer.append(text);
    }

    private static String rep(char ch, int cnt) {
        String ret = "";
        for (int i = 0; i < cnt; ++i) {
            ret = ret + ch;
        }
        return ret;
    }

    private void outln(char ch) throws DocumentException {
        this.out(PdfWorksheet.rep(ch, sNrChars));
    }

    private String lpad(String s, char ch, int len) {
        while (s.length() < len) {
            s = ch + s;
        }
        return s;
    }

    private String lpad(String s, int len) {
        if (s == null) {
            s = "";
        }
        if (s.length() > len) {
            return s.substring(0, len);
        }
        return this.lpad(s, ' ', len);
    }

    private String rpad(String s, char ch, int len) {
        while (s.length() < len) {
            s = s + ch;
        }
        return s;
    }

    private String rpad(String s, int len) {
        if (s == null) {
            s = "";
        }
        if (s.length() > len) {
            return s.substring(0, len);
        }
        return this.rpad(s, ' ', len);
    }

    private String mpad(String s1, String s2, char ch, int len) {
        String m = "";
        while ((s1 + m + s2).length() < len) {
            m = m + ch;
        }
        return s1 + m + s2;
    }

    private String render(String line, String s, int idx) {
        String a = line.length() <= idx ? this.rpad(line, ' ', idx) : line.substring(0, idx);
        String b = line.length() <= idx + s.length() ? "" : line.substring(idx + s.length());
        return a + s + b;
    }

    private String renderMiddle(String line, String s) {
        return this.render(line, s, (sNrChars - s.length()) / 2);
    }

    private String renderEnd(String line, String s) {
        return this.render(line, s, sNrChars - s.length());
    }

    protected void printHeader() throws DocumentException {
        this.out(this.renderMiddle(ApplicationProperty.WorksheetPdfAuthor.value().replace("%", Constants.getVersion()), ApplicationProperty.WorksheetPdfTitle.value()));
        this.out(this.mpad(new SimpleDateFormat("EEE MMM dd, yyyy").format(new Date()), this.iCurrentSubjectArea.getSession().getAcademicInitiative() + " " + this.iCurrentSubjectArea.getSession().getAcademicTerm() + " " + this.iCurrentSubjectArea.getSession().getAcademicYear(), ' ', sNrChars));
        this.outln('=');
        this.iLineNo = 0;
        if (this.iCourseOffering != null) {
            this.println("(" + this.iCourseOffering.getCourseName() + " Continued)");
        }
    }

    protected void printFooter() throws DocumentException {
        this.out("");
        this.out(this.renderEnd(this.renderMiddle("", "Page " + (this.iPageNo + 1)), "<" + this.iCurrentSubjectArea.getSubjectAreaAbbreviation() + (this.iCourseNumber != null ? " " + this.iCourseNumber : "") + ">  "));
        Paragraph p = new Paragraph(this.iBuffer.toString().replace("\n ", "\n  "), PdfFont.getFixedFont());
        p.setLeading(9.5f);
        this.iDoc.add((Element)p);
        this.iBuffer = new StringBuffer();
        ++this.iPageNo;
    }

    protected void lastPage() throws DocumentException {
        while (this.iLineNo < sNrLines) {
            this.out("");
            ++this.iLineNo;
        }
        this.printFooter();
    }

    protected void newPage() throws DocumentException {
        while (this.iLineNo < sNrLines) {
            this.out("");
            ++this.iLineNo;
        }
        this.printFooter();
        this.iDoc.newPage();
        this.printHeader();
    }

    protected void println(String text) throws DocumentException {
        this.out(text);
        ++this.iLineNo;
        if (this.iLineNo >= sNrLines) {
            this.newPage();
        }
    }

    private void close() throws IOException {
        this.iDoc.close();
    }

    public static void main(String[] args) {
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Long sessionId = Long.valueOf(ApplicationProperties.getProperty("tmtbl.pdf.worksheet.session", "165924"));
            Session session = (Session)new SessionDAO().get(sessionId);
            if (session == null) {
                System.err.println("Academic session " + sessionId + " not found, use property tmtbl.pdf.worksheet.session to set academic session.");
                System.exit(0);
            } else {
                System.out.println("Session: " + session);
            }
            TreeSet<SubjectArea> subjectAreas = null;
            if (args.length > 0) {
                subjectAreas = new TreeSet<SubjectArea>();
                for (int i = 0; i < args.length; ++i) {
                    SubjectArea sa = SubjectArea.findByAbbv(sessionId, args[i]);
                    if (sa == null) {
                        System.err.println("Subject area " + args[i] + " not found.");
                        continue;
                    }
                    subjectAreas.add(sa);
                }
            } else {
                subjectAreas = new TreeSet(SubjectArea.getSubjectAreaList(sessionId));
            }
            for (SubjectArea sa : subjectAreas) {
                System.out.println("Printing subject area " + sa.getSubjectAreaAbbreviation() + " ...");
                FileOutputStream out = new FileOutputStream(sa.getSubjectAreaAbbreviation() + ".pdf");
                ArrayList<SubjectArea> sas = new ArrayList<SubjectArea>();
                sas.add(sa);
                PdfWorksheet.print(out, sas);
                out.flush();
                out.close();
            }
            HibernateUtil.closeHibernate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

