/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formats {
    private static StudentSectioningConstants SCT_CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private static GwtConstants GWT_CONSTANTS = Localization.create(GwtConstants.class);
    private static final ThreadLocal<FormatBundle> sBundle = new ThreadLocal<FormatBundle>(){

        @Override
        protected FormatBundle initialValue() {
            return new FormatBundle();
        }
    };

    public static void removeFormats() {
        sBundle.remove();
    }

    public static FormatBundle getFormats() {
        return sBundle.get();
    }

    public static Format<Date> getDateFormat(final String pattern) {
        return new Format<Date>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String format(Date t) {
                return Formats.getFormats().getDateFormat(pattern).format(t);
            }

            @Override
            public Date parse(String source) throws ParseException {
                return Formats.getFormats().getDateFormat(pattern).parse(source);
            }

            @Override
            public String toPattern() {
                return pattern;
            }

            @Override
            public boolean isValid(String source) {
                try {
                    return this.parse(source) != null;
                }
                catch (Throwable t) {
                    return false;
                }
            }
        };
    }

    public static Format<Number> getNumberFormat(final String pattern) {
        return new Format<Number>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String format(Number t) {
                return Formats.getFormats().getNumberFormat(pattern).format(t);
            }

            @Override
            public Number parse(String source) throws ParseException {
                return Formats.getFormats().getNumberFormat(pattern).parse(source);
            }

            @Override
            public String toPattern() {
                return pattern;
            }

            @Override
            public boolean isValid(String source) {
                try {
                    return this.parse(source) != null;
                }
                catch (Throwable t) {
                    return false;
                }
            }
        };
    }

    public static Format<Date> getDateFormat(final Pattern pattern) {
        return new Format<Date>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String format(Date t) {
                return Formats.getFormats().getDateFormat(pattern).format(t);
            }

            @Override
            public Date parse(String source) throws ParseException {
                return Formats.getFormats().getDateFormat(pattern).parse(source);
            }

            @Override
            public String toPattern() {
                return pattern.toPattern();
            }

            @Override
            public boolean isValid(String source) {
                try {
                    return this.parse(source) != null;
                }
                catch (Throwable t) {
                    return false;
                }
            }
        };
    }

    public static Format<Number> getConcurrentNumberFormat(final Pattern pattern) {
        return new Format<Number>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String format(Number t) {
                return Formats.getFormats().getNumberFormat(pattern).format(t);
            }

            @Override
            public Number parse(String source) throws ParseException {
                return Formats.getFormats().getNumberFormat(pattern).parse(source);
            }

            @Override
            public String toPattern() {
                return pattern.toPattern();
            }

            @Override
            public boolean isValid(String source) {
                try {
                    return this.parse(source) != null;
                }
                catch (Throwable t) {
                    return false;
                }
            }
        };
    }

    protected static interface PatternHolder {
        public String getPattern();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Format<T>
    extends Serializable {
        public String format(T var1);

        public T parse(String var1) throws ParseException;

        public String toPattern();

        public boolean isValid(String var1);
    }

    public static class FormatBundle {
        private Map<String, DateFormat> iDateFormats = new Hashtable<String, DateFormat>();
        private Map<String, NumberFormat> iNumberFormats = new Hashtable<String, NumberFormat>();

        private FormatBundle() {
        }

        public DateFormat getDateFormat(String pattern) {
            DateFormat df = this.iDateFormats.get(pattern);
            if (df == null) {
                df = new SimpleDateFormat(pattern, Localization.getJavaLocale());
                this.iDateFormats.put(pattern, df);
            }
            return df;
        }

        public DateFormat getDateFormat(Pattern pattern) {
            return this.getDateFormat(pattern.toPattern());
        }

        public NumberFormat getNumberFormat(String pattern) {
            NumberFormat nf = this.iNumberFormats.get(pattern);
            if (nf == null) {
                nf = new DecimalFormat(pattern, new DecimalFormatSymbols(Localization.getJavaLocale()));
                this.iNumberFormats.put(pattern, nf);
            }
            return nf;
        }

        public NumberFormat getNumberFormat(Pattern pattern) {
            return this.getNumberFormat(pattern.toPattern());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Pattern implements Serializable
    {
        DATE_EXAM_PERIOD(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.examPeriodDateFormat();
            }
        }),
        DATE_EVENT(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.eventDateFormat();
            }
        }),
        DATE_EVENT_SHORT(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.eventDateFormatShort();
            }
        }),
        DATE_EVENT_LONG(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.eventDateFormatLong();
            }
        }),
        DATE_TIME_STAMP(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.timeStampFormat();
            }
        }),
        DATE_TIME_STAMP_SHORT(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.timeStampFormatShort();
            }
        }),
        DATE_REQUEST(new PatternHolder(){

            public String getPattern() {
                return SCT_CONSTANTS.requestDateFormat();
            }
        }),
        DATE_PATTERN(new PatternHolder(){

            public String getPattern() {
                return SCT_CONSTANTS.patternDateFormat();
            }
        }),
        DATE_DAY_OF_WEEK(new PatternHolder(){

            public String getPattern() {
                return "EEE";
            }
        }),
        DATE_MEETING(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.meetingDateFormat();
            }
        }),
        DATE_SHORT(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.dateFormatShort();
            }
        }),
        TIME_SHORT(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.timeFormatShort();
            }
        }),
        SESSION_DATE(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.sessionDateFormat();
            }
        }),
        DATE_ENTRY_FORMAT(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.dateEntryFormat();
            }
        }),
        FILTER_DATE(new PatternHolder(){

            public String getPattern() {
                return GWT_CONSTANTS.filterDateFormat();
            }
        });

        private PatternHolder iHolder;

        private Pattern(PatternHolder holder) {
            this.iHolder = holder;
        }

        public String toPattern() {
            return this.iHolder.getPattern();
        }

        protected PatternHolder holder() {
            return this.iHolder;
        }
    }
}

