/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jgroups.Address;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.RoomAvailability;

public abstract class AbstractSolverServer
implements SolverServer {
    protected static Log sLog = LogFactory.getLog(AbstractSolverServer.class);
    protected int iUsageBase = 0;
    protected Date iStartTime = new Date();
    protected boolean iActive = false;

    public void start() {
        this.iActive = true;
        sLog.info((Object)"Solver server is up and running.");
    }

    public void stop() {
        sLog.info((Object)"Solver server is going down...");
        this.iActive = false;
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isCoordinator() {
        return true;
    }

    public Address getAddress() {
        return null;
    }

    public Address getLocalAddress() {
        return this.getAddress();
    }

    public String getHost() {
        return "local";
    }

    public int getUsage() {
        int ret = this.iUsageBase;
        if (this.isLocal()) {
            ret += 500;
        }
        return ret;
    }

    public void setUsageBase(int base) {
        this.iUsageBase = base;
    }

    public long getAvailableMemory() {
        return Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
    }

    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public long getMemoryLimit() {
        return 0x100000L * Long.parseLong(ApplicationProperties.getProperty(ApplicationProperty.SolverMemoryLimit));
    }

    public String getVersion() {
        return Constants.getVersion();
    }

    public Date getStartTime() {
        return this.iStartTime;
    }

    public boolean isActive() {
        return this.iActive;
    }

    public boolean isAvailable() {
        if (!this.isActive()) {
            return false;
        }
        if (this.getMemoryLimit() > this.getAvailableMemory()) {
            System.gc();
        }
        return this.getMemoryLimit() <= this.getAvailableMemory();
    }

    public RoomAvailabilityInterface getRoomAvailability() {
        return RoomAvailability.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCourseSolution(Long ... solutionIds) {
        try {
            for (Long solutionId : solutionIds) {
                Solution.refreshSolution(solutionId);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            _RootDAO.closeCurrentThreadSessions();
            throw throwable;
        }
        _RootDAO.closeCurrentThreadSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshExamSolution(Long sessionId, Long examTypeId) {
        try {
            ExamType.refreshSolution(sessionId, examTypeId);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            _RootDAO.closeCurrentThreadSessions();
            throw throwable;
        }
        _RootDAO.closeCurrentThreadSessions();
    }

    public void setApplicationProperty(Long sessionId, String key, String value) {
        Properties properties;
        sLog.info((Object)("Set " + key + " to " + value + (sessionId == null ? "" : " (for session " + sessionId + ")")));
        Properties properties2 = properties = sessionId == null ? ApplicationProperties.getConfigProperties() : ApplicationProperties.getSessionProperties(sessionId);
        if (properties == null) {
            return;
        }
        if (value == null) {
            properties.remove(key);
        } else {
            properties.setProperty(key, value);
        }
    }

    public void setLoggingLevel(String name, Integer level) {
        Logger logger;
        sLog.info((Object)("Set logging level for " + (name == null ? "root" : name) + " to " + (level == null ? "null" : Level.toLevel((int)level))));
        Logger logger2 = logger = name == null ? Logger.getRootLogger() : Logger.getLogger((String)name);
        if (level == null) {
            logger.setLevel(null);
        } else {
            logger.setLevel(Level.toLevel((int)level));
        }
    }

    public void reset() {
    }
}

