/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.RoomDeptDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=RoomInterface.UpdateRoomGroupRequest.class)
public class UpdateRoomGroupBackend
implements GwtRpcImplementation<RoomInterface.UpdateRoomGroupRequest, RoomInterface.GroupInterface> {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public RoomInterface.GroupInterface execute(RoomInterface.UpdateRoomGroupRequest request, SessionContext context) {
        if (request.hasSessionId()) {
            context = new EventAction.EventContext(context, request.getSessionId());
        }
        Transaction tx = null;
        try {
            org.hibernate.Session hibSession = new RoomDeptDAO().getSession();
            tx = hibSession.beginTransaction();
            RoomGroup g = null;
            if (request.hasGroup()) {
                if (request.hasFutureSessions()) {
                    for (Long id : request.getFutureSessions()) {
                        this.createOrUpdateGroup(request.getGroup(), request.getAddLocations(), request.getDropLocations(), id, hibSession, new EventAction.EventContext(context, context.getUser(), id), true);
                    }
                }
                g = this.createOrUpdateGroup(request.getGroup(), request.getAddLocations(), request.getDropLocations(), context.getUser().getCurrentAcademicSessionId(), hibSession, context, false);
            } else if (request.getDeleteGroupId() != null) {
                if (request.hasFutureSessions()) {
                    for (Long id : request.getFutureSessions()) {
                        this.dropGroup(request.getDeleteGroupId(), id, hibSession, new EventAction.EventContext(context, context.getUser(), id), true);
                    }
                }
                this.dropGroup(request.getDeleteGroupId(), context.getUser().getCurrentAcademicSessionId(), hibSession, context, false);
            } else {
                throw new GwtRpcException("Bad request.");
            }
            RoomInterface.GroupInterface group = null;
            if (g != null) {
                group = new RoomInterface.GroupInterface(g.getUniqueId(), g.getAbbv(), g.getName());
                if (g.getDepartment() != null) {
                    group.setDepartment(RoomDetailsBackend.wrap(g.getDepartment(), null, null));
                    group.setTitle((g.getDescription() == null || g.getDescription().isEmpty() ? g.getName() : g.getDescription()) + " (" + g.getDepartment().getName() + ")");
                }
            }
            tx.commit();
            return group;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (tx != null) {
                tx.rollback();
            }
            if (e instanceof GwtRpcException) {
                throw (GwtRpcException)e;
            }
            throw new GwtRpcException(e.getMessage());
        }
    }

    protected Department lookuDepartment(org.hibernate.Session hibSession, RoomInterface.DepartmentInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (future) {
            return Department.findByDeptCode(original.getDeptCode(), sessionId, hibSession);
        }
        return (Department)DepartmentDAO.getInstance().get(original.getId(), hibSession);
    }

    protected RoomGroup lookupGroup(org.hibernate.Session hibSession, RoomInterface.GroupInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (future) {
            if (original.isDepartmental()) {
                return (RoomGroup)hibSession.createQuery("select g from RoomGroup g, RoomGroup o where o.uniqueId = :originalId and g.department.session.uniqueId = :sessionId and g.abbv = o.abbv and g.department.deptCode = o.department.deptCode and g.global = false").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return (RoomGroup)hibSession.createQuery("select g from RoomGroup g, RoomGroup o where o.uniqueId = :originalId and g.session.uniqueId = :sessionId and g.abbv = o.abbv and g.global = true").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (RoomGroup)RoomGroupDAO.getInstance().get(original.getId(), hibSession);
    }

    protected RoomGroup lookupGroup(org.hibernate.Session hibSession, Long groupId, boolean future, Long sessionId) {
        if (groupId == null) {
            return null;
        }
        if (future) {
            RoomGroup group = (RoomGroup)hibSession.createQuery("select g from RoomGroup g, RoomGroup o where o.uniqueId = :originalId and g.department.session.uniqueId = :sessionId and g.abbv = o.abbv and g.department.deptCode = o.department.deptCode and g.global = false").setLong("sessionId", sessionId.longValue()).setLong("originalId", groupId.longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
            if (group == null) {
                group = (RoomGroup)hibSession.createQuery("select g from RoomGroup g, RoomGroup o where o.uniqueId = :originalId and g.session.uniqueId = :sessionId and g.abbv = o.abbv and g.global = true").setLong("sessionId", sessionId.longValue()).setLong("originalId", groupId.longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return group;
        }
        return (RoomGroup)RoomGroupDAO.getInstance().get(groupId, hibSession);
    }

    protected Collection<Location> lookupLocations(org.hibernate.Session hibSession, List<Long> ids, boolean future, Long sessionId) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<Location>();
        }
        if (future) {
            return Location.lookupFutureLocations(hibSession, ids, sessionId);
        }
        return hibSession.createQuery("from Location where uniqueId in :ids").setParameterList("ids", ids).list();
    }

    protected RoomGroup createOrUpdateGroup(RoomInterface.GroupInterface group, List<Long> add, List<Long> drop, Long sessionId, org.hibernate.Session hibSession, SessionContext context, boolean future) {
        RoomGroup rg;
        Department d;
        Department department = d = group.isDepartmental() ? this.lookuDepartment(hibSession, group.getDepartment(), future, sessionId) : null;
        if (group.isDepartmental() && d == null) {
            return null;
        }
        RoomGroup roomGroup = rg = group.getId() == null ? null : this.lookupGroup(hibSession, group, future, sessionId);
        if (rg == null) {
            if (!future && group.getId() != null) {
                throw new GwtRpcException(MESSAGES.errorRoomGroupDoesNotExist(group.getId()));
            }
            if (d == null) {
                context.checkPermission(Right.GlobalRoomGroupAdd);
            } else {
                context.checkPermission(d, Right.DepartmentRoomGroupAdd);
            }
            rg = new RoomGroup();
            rg.setGlobal(d == null);
            rg.setDepartment(d);
            rg.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()));
            rg.setRooms(new HashSet<Location>());
            rg.setDefaultGroup(false);
        } else if (rg.isGlobal().booleanValue()) {
            context.checkPermission(rg, Right.GlobalRoomGroupEdit);
        } else {
            context.checkPermission(rg, Right.DepartmenalRoomGroupEdit);
            rg.setDepartment(d);
        }
        for (RoomGroup x : RoomGroup.getAllGlobalRoomGroups(sessionId)) {
            if (!x.getName().equalsIgnoreCase(group.getLabel()) && !x.getAbbv().equalsIgnoreCase(group.getAbbreviation()) || x.getUniqueId().equals(rg.getUniqueId())) continue;
            throw new GwtRpcException(MESSAGES.errorRoomGroupAlreadyExists(group.getLabel(), rg.getSession().getLabel()));
        }
        if (rg.getDepartment() != null) {
            for (RoomGroup x : RoomGroup.getAllDepartmentRoomGroups(rg.getDepartment())) {
                if (!x.getName().equalsIgnoreCase(group.getLabel()) && !x.getAbbv().equalsIgnoreCase(group.getAbbreviation()) || x.getUniqueId().equals(rg.getUniqueId())) continue;
                throw new GwtRpcException(MESSAGES.errorRoomGroupAlreadyExists(group.getLabel(), rg.getDepartment().getSession().getLabel()));
            }
        }
        rg.setAbbv(group.getAbbreviation());
        rg.setName(group.getLabel());
        rg.setDescription(group.getDescription());
        if (rg.isGlobal().booleanValue() && group.isDefault() && context.hasPermission(rg, Right.GlobalRoomGroupEditSetDefault)) {
            for (RoomGroup x : RoomGroup.getAllRoomGroupsForSession(rg.getSession())) {
                if (x.getUniqueId().equals(rg.getUniqueId()) || !x.isDefaultGroup().booleanValue()) continue;
                x.setDefaultGroup(false);
                hibSession.saveOrUpdate((Object)x);
            }
        }
        rg.setDefaultGroup(group.isDefault() && rg.isGlobal() != false);
        hibSession.saveOrUpdate((Object)rg);
        if (add != null && !add.isEmpty()) {
            for (Location location : this.lookupLocations(hibSession, add, future, sessionId)) {
                rg.getRooms().add(location);
                location.getRoomGroups().add(rg);
                hibSession.saveOrUpdate((Object)location);
            }
        }
        if (drop != null && !drop.isEmpty()) {
            for (Location location : this.lookupLocations(hibSession, drop, future, sessionId)) {
                rg.getRooms().remove(location);
                location.getRoomGroups().remove(rg);
                hibSession.saveOrUpdate((Object)location);
            }
        }
        hibSession.saveOrUpdate((Object)rg);
        ChangeLog.addChange(hibSession, context, rg, ChangeLog.Source.ROOM_GROUP_EDIT, group.getId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, rg.getDepartment());
        return rg;
    }

    protected boolean dropGroup(Long groupId, Long sessionId, org.hibernate.Session hibSession, SessionContext context, boolean future) {
        RoomGroup rg = this.lookupGroup(hibSession, groupId, future, sessionId);
        if (rg == null) {
            if (!future) {
                throw new GwtRpcException(MESSAGES.errorRoomGroupDoesNotExist(groupId));
            }
            return false;
        }
        if (rg.isGlobal().booleanValue()) {
            context.checkPermission(rg, Right.GlobalRoomGroupDelete);
        } else {
            context.checkPermission(rg, Right.DepartmenalRoomGroupDelete);
        }
        ChangeLog.addChange(hibSession, context, rg, ChangeLog.Source.ROOM_GROUP_EDIT, ChangeLog.Operation.DELETE, null, rg.getDepartment());
        for (Location location : rg.getRooms()) {
            location.getRoomGroups().remove(rg);
            hibSession.saveOrUpdate((Object)location);
        }
        for (RoomGroupPref p : hibSession.createQuery("from RoomGroupPref p where p.roomGroup.uniqueId = :id").setLong("id", rg.getUniqueId().longValue()).list()) {
            p.getOwner().getPreferences().remove(p);
            hibSession.delete((Object)p);
            hibSession.saveOrUpdate((Object)p.getOwner());
        }
        hibSession.delete((Object)rg);
        return true;
    }
}

