/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.Collections;
import java.util.HashMap;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.RoomFilterBackend;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=RoomInterface.SearchRoomFeaturesRequest.class)
public class RoomFeaturesBackend
implements GwtRpcImplementation<RoomInterface.SearchRoomFeaturesRequest, GwtRpcResponseList<RoomInterface.FeatureInterface>> {
    @Override
    public GwtRpcResponseList<RoomInterface.FeatureInterface> execute(RoomInterface.SearchRoomFeaturesRequest request, SessionContext context) {
        EventInterface.FilterRpcResponse.Entity e;
        RoomInterface.FeatureInterface feature;
        if (request.hasSessionId()) {
            context = new EventAction.EventContext(context, request.getSessionId());
        }
        if (context.isAuthenticated()) {
            request.getFilter().setOption("user", context.getUser().getExternalUserId());
        }
        context.checkPermission(Right.RoomFeatures);
        GwtRpcResponseList<RoomInterface.FeatureInterface> list = new GwtRpcResponseList<RoomInterface.FeatureInterface>();
        EventInterface.FilterRpcResponse filterResponse = new EventInterface.FilterRpcResponse();
        new RoomFilterBackend().enumarate(request.getFilter(), filterResponse, new EventAction.EventContext(context, context.getUser().getCurrentAcademicSessionId()));
        HashMap<Long, EventInterface.FilterRpcResponse.Entity> locations = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
        if (filterResponse.hasResults()) {
            for (EventInterface.FilterRpcResponse.Entity entity : filterResponse.getResults()) {
                locations.put(entity.getUniqueId(), entity);
            }
        }
        boolean filterDepartments = context.getUser() != null && !context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        for (GlobalRoomFeature globalRoomFeature : GlobalRoomFeature.getAllGlobalRoomFeatures(context.getUser().getCurrentAcademicSessionId())) {
            feature = new RoomInterface.FeatureInterface(globalRoomFeature.getUniqueId(), globalRoomFeature.getAbbv(), globalRoomFeature.getLabel());
            if (globalRoomFeature.getFeatureType() != null) {
                feature.setType(new RoomInterface.FeatureTypeInterface(globalRoomFeature.getFeatureType().getUniqueId(), globalRoomFeature.getFeatureType().getReference(), globalRoomFeature.getFeatureType().getLabel(), globalRoomFeature.getFeatureType().isShowInEventManagement()));
            }
            feature.setCanEdit(context.hasPermission(globalRoomFeature, Right.GlobalRoomFeatureEdit));
            feature.setCanDelete(context.hasPermission(globalRoomFeature, Right.GlobalRoomFeatureDelete));
            feature.setSessionId(globalRoomFeature.getSession().getUniqueId());
            feature.setSessionName(globalRoomFeature.getSession().getLabel());
            for (Location location : globalRoomFeature.getRooms()) {
                e = (EventInterface.FilterRpcResponse.Entity)locations.get(location.getUniqueId());
                if (e == null) continue;
                feature.addRoom(e);
            }
            if (feature.hasRooms()) {
                Collections.sort(feature.getRooms());
            }
            list.add(feature);
        }
        for (DepartmentRoomFeature departmentRoomFeature : DepartmentRoomFeature.getAllDepartmentRoomFeaturesInSession(context.getUser().getCurrentAcademicSessionId())) {
            if (filterDepartments && !context.getUser().getCurrentAuthority().hasQualifier(departmentRoomFeature.getDepartment())) continue;
            feature = new RoomInterface.FeatureInterface(departmentRoomFeature.getUniqueId(), departmentRoomFeature.getAbbv(), departmentRoomFeature.getLabel());
            if (departmentRoomFeature.getFeatureType() != null) {
                feature.setType(new RoomInterface.FeatureTypeInterface(departmentRoomFeature.getFeatureType().getUniqueId(), departmentRoomFeature.getFeatureType().getReference(), departmentRoomFeature.getFeatureType().getLabel(), departmentRoomFeature.getFeatureType().isShowInEventManagement()));
            }
            feature.setDepartment(RoomDetailsBackend.wrap(departmentRoomFeature.getDepartment(), null, null));
            feature.setCanEdit(context.hasPermission(departmentRoomFeature, Right.DepartmenalRoomFeatureEdit));
            feature.setCanDelete(context.hasPermission(departmentRoomFeature, Right.DepartmenalRoomFeatureDelete));
            feature.setSessionId(departmentRoomFeature.getDepartment().getSession().getUniqueId());
            feature.setSessionName(departmentRoomFeature.getDepartment().getSession().getLabel());
            for (Location location : departmentRoomFeature.getRooms()) {
                e = (EventInterface.FilterRpcResponse.Entity)locations.get(location.getUniqueId());
                if (e == null) continue;
                feature.addRoom(e);
            }
            if (feature.hasRooms()) {
                Collections.sort(feature.getRooms());
            }
            list.add(feature);
        }
        return list;
    }
}

