/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=eventStatus]")
public class EventStatuses
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageEventStatus(), MESSAGES.pageEventStatuses());
    }

    @PreAuthorize(value="checkPermission('EventStatuses')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> states = new ArrayList<SimpleEditInterface.ListItem>();
        for (RoomTypeOption.Status state : RoomTypeOption.Status.values()) {
            states.add(new SimpleEditInterface.ListItem(String.valueOf(state.ordinal()), state.toString()));
        }
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field("&otimes;", SimpleEditInterface.FieldType.parent, 50, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldDepartment() + "|" + MESSAGES.fieldType(), SimpleEditInterface.FieldType.text, 160, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldRoomType() + "|" + MESSAGES.fieldRoom(), SimpleEditInterface.FieldType.text, 100, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldEventStatus(), SimpleEditInterface.FieldType.list, 300, states, SimpleEditInterface.Flag.PARENT_NOT_EMPTY, SimpleEditInterface.Flag.SHOW_PARENT_IF_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldRoomNote(), SimpleEditInterface.FieldType.textarea, 50, 3, 2048, SimpleEditInterface.Flag.SHOW_PARENT_IF_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldBreakTime(), SimpleEditInterface.FieldType.number, 50, 10, SimpleEditInterface.Flag.SHOW_PARENT_IF_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldSortOrder(), SimpleEditInterface.FieldType.text, 80, 10, SimpleEditInterface.Flag.READ_ONLY, SimpleEditInterface.Flag.HIDDEN));
        data.setSortBy(6);
        data.setAddable(false);
        long id = 0L;
        for (Department department : Department.getUserDepartments(context.getUser())) {
            SimpleEditInterface.Record r;
            RoomTypeOption option;
            if (!department.isAllowEvents().booleanValue()) continue;
            for (RoomType roomType : hibSession.createQuery("select distinct t from Room r inner join r.roomType t where r.eventDepartment.uniqueId = :departmentId order by t.ord, t.label").setLong("departmentId", department.getUniqueId().longValue()).setCacheable(true).list()) {
                option = roomType.getOption(department);
                r = data.addRecord(--id, false);
                r.setField(0, "+", false);
                r.setField(1, department.getLabel(), false);
                r.setField(2, roomType.getLabel(), false);
                r.setField(3, String.valueOf(option.getStatus() == null ? RoomTypeOption.getDefaultStatus() : option.getStatus()));
                r.setField(4, option.getMessage() == null ? "" : option.getMessage());
                r.setField(5, option.getBreakTime() == null ? "0" : option.getBreakTime().toString());
                r.setField(6, department.getDeptCode() + ":" + roomType.getOrd());
                for (Location room : hibSession.createQuery("select r from Room r where r.roomType.uniqueId = :roomTypeId and r.eventDepartment.uniqueId = :departmentId order by r.building.abbreviation, r.roomNumber").setLong("departmentId", department.getUniqueId().longValue()).setLong("roomTypeId", roomType.getUniqueId().longValue()).setCacheable(true).list()) {
                    r = data.addRecord(room.getUniqueId(), false);
                    r.setField(0, String.valueOf(id));
                    r.setField(1, department.getDeptCode() + " " + roomType.getLabel(), false);
                    r.setField(2, ((Room)room).getLabel(), false);
                    r.setField(3, room.getEventStatus() == null ? "" : room.getEventStatus().toString());
                    r.setField(4, room.getNote() == null ? "" : room.getNote());
                    r.setField(5, room.getBreakTime() == null ? "" : room.getBreakTime().toString());
                    r.setField(6, department.getDeptCode() + ":" + roomType.getOrd() + ":" + ((Room)room).getLabel());
                }
            }
            for (RoomType roomType : hibSession.createQuery("select distinct t from NonUniversityLocation r inner join r.roomType t where r.eventDepartment.uniqueId = :departmentId order by t.ord, t.label").setLong("departmentId", department.getUniqueId().longValue()).setCacheable(true).list()) {
                option = roomType.getOption(department);
                r = data.addRecord(--id, false);
                r.setField(0, "+", false);
                r.setField(1, department.getLabel(), false);
                r.setField(2, roomType.getLabel(), false);
                r.setField(3, String.valueOf(option.getStatus() == null ? RoomTypeOption.getDefaultStatus() : option.getStatus()));
                r.setField(4, option.getMessage() == null ? "" : option.getMessage());
                r.setField(5, option.getBreakTime() == null ? "0" : option.getBreakTime().toString());
                r.setField(6, department.getDeptCode() + ":" + roomType.getOrd());
                for (Location room : hibSession.createQuery("select r from NonUniversityLocation r where r.roomType.uniqueId = :roomTypeId and r.eventDepartment.uniqueId = :departmentId order by r.name").setLong("departmentId", department.getUniqueId().longValue()).setLong("roomTypeId", roomType.getUniqueId().longValue()).setCacheable(true).list()) {
                    r = data.addRecord(room.getUniqueId(), false);
                    r.setField(0, String.valueOf(id));
                    r.setField(1, department.getDeptCode() + " " + roomType.getLabel(), false);
                    r.setField(2, ((NonUniversityLocation)room).getLabel(), false);
                    r.setField(3, room.getEventStatus() == null ? "" : room.getEventStatus().toString());
                    r.setField(4, room.getNote() == null ? "" : room.getNote());
                    r.setField(5, room.getBreakTime() == null ? "" : room.getBreakTime().toString());
                    r.setField(6, department.getDeptCode() + ":" + roomType.getOrd() + ":" + ((NonUniversityLocation)room).getLabel());
                }
            }
        }
        data.setEditable(context.hasPermission(Right.EventStatusEdit));
        return data;
    }

    @PreAuthorize(value="checkPermission('EventStatusEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (Department department : Department.getUserDepartments(context.getUser())) {
            boolean optionChanged;
            RoomTypeOption option;
            if (!department.isAllowEvents().booleanValue()) continue;
            for (RoomType roomType : hibSession.createQuery("select distinct t from Room r inner join r.roomType t where r.eventDepartment.uniqueId = :departmentId order by t.ord, t.label").setLong("departmentId", department.getUniqueId().longValue()).setCacheable(true).list()) {
                option = roomType.getOption(department);
                for (SimpleEditInterface.Record r : data.getRecords()) {
                    if (!r.getField(1).equals(department.getLabel()) || !r.getField(2).equals(roomType.getLabel())) continue;
                    optionChanged = !ToolBox.equals((Object)(option.getStatus() == null ? RoomTypeOption.getDefaultStatus() : option.getStatus()), (Object)Integer.valueOf(r.getField(3))) || !ToolBox.equals((Object)option.getMessage(), (Object)r.getField(4)) || !ToolBox.equals((Object)(option.getBreakTime() == null ? "0" : option.getBreakTime().toString()), (Object)r.getField(5));
                    option.setStatus(Integer.parseInt(r.getField(3)));
                    option.setMessage(r.getField(4));
                    try {
                        option.setBreakTime(Integer.parseInt(r.getField(5)));
                    }
                    catch (NumberFormatException e) {
                        option.setBreakTime(0);
                    }
                    hibSession.saveOrUpdate((Object)option);
                    if (!optionChanged) continue;
                    ChangeLog.addChange(hibSession, context, option.getRoomType(), option.getDepartment().getDeptCode() + " " + option.getRoomType().getLabel() + ": " + (Object)((Object)option.getEventStatus()), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, option.getDepartment());
                }
            }
            for (RoomType roomType : hibSession.createQuery("select distinct t from NonUniversityLocation r inner join r.roomType t where r.eventDepartment.uniqueId = :departmentId order by t.ord, t.label").setLong("departmentId", department.getUniqueId().longValue()).setCacheable(true).list()) {
                option = roomType.getOption(department);
                for (SimpleEditInterface.Record r : data.getRecords()) {
                    if (!r.getField(1).equals(department.getLabel()) || !r.getField(2).equals(roomType.getLabel())) continue;
                    optionChanged = !ToolBox.equals((Object)(option.getStatus() == null ? RoomTypeOption.getDefaultStatus() : option.getStatus()), (Object)Integer.valueOf(r.getField(3))) || !ToolBox.equals((Object)option.getMessage(), (Object)r.getField(4)) || !ToolBox.equals((Object)(option.getBreakTime() == null ? "0" : option.getBreakTime().toString()), (Object)r.getField(5));
                    option.setStatus(Integer.parseInt(r.getField(3)));
                    option.setMessage(r.getField(4));
                    try {
                        option.setBreakTime(Integer.parseInt(r.getField(5)));
                    }
                    catch (NumberFormatException e) {
                        option.setBreakTime(0);
                    }
                    hibSession.saveOrUpdate((Object)option);
                    if (!optionChanged) continue;
                    ChangeLog.addChange(hibSession, context, option.getRoomType(), option.getDepartment().getDeptCode() + " " + option.getRoomType().getLabel() + ": " + (Object)((Object)option.getEventStatus()), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, option.getDepartment());
                }
            }
            for (Location location : hibSession.createQuery("from Location where eventDepartment.uniqueId = :departmentId").setLong("departmentId", department.getUniqueId().longValue()).setCacheable(true).list()) {
                SimpleEditInterface.Record r = data.getRecord(location.getUniqueId());
                if (r == null) continue;
                this.update(location, r, context, hibSession);
            }
        }
    }

    @PreAuthorize(value="checkPermission('EventStatusEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        throw new GwtRpcException(MESSAGES.errorOperationNotSupported());
    }

    protected void update(Location location, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (location == null) {
            return;
        }
        Integer status = record.getField(3) == null || record.getField(3).isEmpty() ? null : Integer.valueOf(Integer.parseInt(record.getField(3)));
        String note = record.getField(4) == null || record.getField(4).isEmpty() ? null : record.getField(4);
        Integer breakTime = null;
        try {
            breakTime = record.getField(5) == null || record.getField(5).isEmpty() ? null : Integer.valueOf(Integer.parseInt(record.getField(5)));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (ToolBox.equals((Object)location.getEventStatus(), (Object)status) && ToolBox.equals((Object)location.getNote(), (Object)note) && ToolBox.equals((Object)location.getBreakTime(), (Object)breakTime)) {
            return;
        }
        boolean noteChanged = !ToolBox.equals((Object)location.getNote(), (Object)note);
        location.setEventStatus(status);
        location.setNote(note);
        location.setBreakTime(breakTime);
        hibSession.saveOrUpdate((Object)location);
        ChangeLog.addChange(hibSession, context, location, location.getLabel() + ": " + (Object)((Object)location.getEffectiveEventStatus()) + (location.getEventStatus() == null ? " (Default)" : ""), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, location.getEventDepartment());
        if (noteChanged) {
            ChangeLog.addChange(hibSession, context, location, location.getNote() == null || location.getNote().isEmpty() ? "-" : location.getNote(), ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.NOTE, null, location.getControllingDepartment());
        }
    }

    @PreAuthorize(value="checkPermission('EventStatusEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (record.getUniqueId() >= 0L) {
            this.update((Location)LocationDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
            return;
        }
        for (Department department : Department.getUserDepartments(context.getUser())) {
            if (!department.isAllowEvents().booleanValue() || !record.getField(1).equals(department.getLabel())) continue;
            for (RoomType roomType : hibSession.createQuery("select distinct t from Room r inner join r.roomType t where r.eventDepartment.uniqueId = :departmentId order by t.ord, t.label").setLong("departmentId", department.getUniqueId().longValue()).setCacheable(true).list()) {
                if (!record.getField(2).equals(roomType.getLabel())) continue;
                RoomTypeOption option = roomType.getOption(department);
                boolean optionChanged = !ToolBox.equals((Object)(option.getStatus() == null ? RoomTypeOption.getDefaultStatus() : option.getStatus()), (Object)Integer.valueOf(record.getField(3))) || !ToolBox.equals((Object)option.getMessage(), (Object)record.getField(4)) || !ToolBox.equals((Object)(option.getBreakTime() == null ? "0" : option.getBreakTime().toString()), (Object)record.getField(5));
                option.setStatus(Integer.parseInt(record.getField(3)));
                option.setMessage(record.getField(4));
                try {
                    option.setBreakTime(Integer.parseInt(record.getField(5)));
                }
                catch (NumberFormatException e) {
                    option.setBreakTime(0);
                }
                hibSession.saveOrUpdate((Object)option);
                if (optionChanged) {
                    ChangeLog.addChange(hibSession, context, option.getRoomType(), option.getDepartment().getDeptCode() + " " + option.getRoomType().getLabel() + ": " + (Object)((Object)option.getEventStatus()), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, option.getDepartment());
                }
                return;
            }
            for (RoomType roomType : hibSession.createQuery("select distinct t from NonUniversityLocation r inner join r.roomType t where r.eventDepartment.uniqueId = :departmentId order by t.ord, t.label").setLong("departmentId", department.getUniqueId().longValue()).setCacheable(true).list()) {
                if (!record.getField(2).equals(roomType.getLabel())) continue;
                RoomTypeOption option = roomType.getOption(department);
                boolean optionChanged = !ToolBox.equals((Object)(option.getStatus() == null ? RoomTypeOption.getDefaultStatus() : option.getStatus()), (Object)Integer.valueOf(record.getField(3))) || !ToolBox.equals((Object)option.getMessage(), (Object)record.getField(4)) || !ToolBox.equals((Object)(option.getBreakTime() == null ? "0" : option.getBreakTime().toString()), (Object)record.getField(5));
                option.setStatus(Integer.parseInt(record.getField(3)));
                option.setMessage(record.getField(4));
                try {
                    option.setBreakTime(Integer.parseInt(record.getField(5)));
                }
                catch (NumberFormatException e) {
                    option.setBreakTime(0);
                }
                hibSession.saveOrUpdate((Object)option);
                if (optionChanged) {
                    ChangeLog.addChange(hibSession, context, option.getRoomType(), option.getDepartment().getDeptCode() + " " + option.getRoomType().getLabel() + ": " + (Object)((Object)option.getEventStatus()), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, option.getDepartment());
                }
                return;
            }
        }
    }

    @PreAuthorize(value="checkPermission('EventStatusEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        throw new GwtRpcException(MESSAGES.errorOperationNotSupported());
    }
}

